/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.history;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.UIActionTitle;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.compare.TitleCompareRequest;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareData;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareXmlData;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.ReadDeletedTitleException;
import com.tandbergtv.cms.portal.content.client.title.view.HtmlorXmlDisplayHelper;
import com.tandbergtv.cms.portal.content.client.title.view.compare.ITitleCompareViewController;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareView;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.history.HistoryPanel;
import com.tandbergtv.cms.portal.content.client.title.view.history.ProgressItemDataProvider;
import com.tandbergtv.cms.portal.content.client.title.view.history.ProgressItemRecord;
import com.tandbergtv.cms.portal.content.client.title.view.history.TitleHistoryTab;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleValidationViewInput;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class ProgressHistoryPanel
extends HistoryPanel
implements ITitleCompareViewController {
    private List<Widget> offsettingWidgets = new ArrayList<Widget>();
    private ProgressItemDataProvider dataProvider;
    private Table<Long, ProgressItemRecord> table;
    private VerticalContainer mainContainer;
    private HorizontalContainer buttonContainer;
    private ScrollContainer scrollContainer;
    private ButtonWidget compareButton;
    private TitleCompareView compareView;
    private TitleCompareRequest lastRequest;
    private HandlerRegistration windowRegistration = null;
    private ITitleViewServiceAsync viewService = (ITitleViewServiceAsync)GWT.create(ITitleViewService.class);
    private static final String STYLE_LOADING_LABEL = "content-ProgressHistoryPanel-loadingMessage";
    private static final String STYLE_PROGRESS_TABLE = "content-ProgressHistoryPanel-progressTable";
    private static final String STYLE_PROGRESS = "progress";
    private static final String STYLE_HISTORY_PANEL = "content-HistoryPanel";
    private boolean isSeriesTitle = false;

    public ProgressHistoryPanel(TitleHistoryTab parent) {
        super(parent);
    }

    @Override
    protected void initialize() {
        this.dataProvider = new ProgressItemDataProvider(this);
        this.table = new Table((DataProvider)this.dataProvider);
        this.table.addRefreshListener(new Table.RefreshListener(){

            public void updated() {
                ProgressHistoryPanel.this.resizeScrollContainer();
            }
        });
        this.table.addStyleName(STYLE_PROGRESS_TABLE);
        this.scrollContainer = new ScrollContainer();
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setStylePrimaryName(STYLE_HISTORY_PANEL);
        this.mainContainer.addStyleDependentName(STYLE_PROGRESS);
        this.buttonContainer = new HorizontalContainer();
        String compareText = this.getTab().getViewMessages().compareButton();
        this.compareButton = new ButtonWidget(compareText);
        this.compareButton.removeStyleName("gwt-Button");
        this.compareButton.addStyleName("ebBtn");
        this.compareButton.addStyleName("ebBtn_color_green");
        this.compareButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ProgressHistoryPanel.this.compareClickedAction();
            }
        });
        this.buttonContainer.add((Widget)this.compareButton);
        this.scrollContainer.add(this.table);
        this.mainContainer.add((Widget)this.scrollContainer);
        this.mainContainer.add((Widget)this.buttonContainer);
        LabelWidget blankLabel = new LabelWidget("");
        this.setWidget((Widget)blankLabel);
    }

    public boolean isSeriesTitle() {
        return this.isSeriesTitle;
    }

    public void setSeriesTitle(boolean isSeriesTitle) {
        this.isSeriesTitle = isSeriesTitle;
    }

    public void addOffsettingWidget(Widget widget) {
        this.offsettingWidgets.add(widget);
    }

    private void showLoadingMessage() {
        String message = this.getTab().getViewMessages().historyLoading();
        LabelWidget label = new LabelWidget(message);
        label.addStyleName(STYLE_LOADING_LABEL);
        this.setWidget((Widget)label);
    }

    @Override
    public void refresh() {
        this.showLoadingMessage();
        if (!this.table.isInitialized()) {
            this.table.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                }

                public void onNeptuneSuccess(Void result) {
                    ProgressHistoryPanel.this.table.refresh();
                }
            });
        } else {
            this.table.refresh();
        }
    }

    protected void onLoad() {
        super.onLoad();
        this.offsettingWidgets.add(this.getTab().getTitleView().getMessageViewWidget());
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                ProgressHistoryPanel.this.resizeScrollContainer();
            }
        });
        this.resizeScrollContainer();
    }

    protected void onUnload() {
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        super.onUnload();
    }

    private void resizeScrollContainer() {
        if (this.scrollContainer == null) {
            return;
        }
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                int height = Window.getClientHeight() - 280;
                for (Widget w : ProgressHistoryPanel.this.offsettingWidgets) {
                    height -= w.getOffsetHeight();
                }
                ProgressHistoryPanel.this.scrollContainer.setHeight(String.valueOf(height) + "px");
            }
        });
    }

    void handleGetRecordsSuccess(UITitle title, int recordCount) {
        if (recordCount == 0) {
            String message = this.getTab().getViewMessages().historyNotPresent();
            LabelWidget label = new LabelWidget(message);
            this.setWidget((Widget)label);
        } else {
            this.setWidget((Widget)this.mainContainer);
        }
        this.getTab().updateTitleHeader(title.getOverview());
        this.getTab().hideBusyIndicator();
        this.getTab().markUpdated();
    }

    void handleGetRecordsFailure(Throwable caught) {
        if (caught instanceof ReadDeletedTitleException) {
            this.getTab().showSevereError(caught.getMessage());
        } else {
            TitleHistoryTab tab = this.getTab();
            String message = tab.getViewMessages().historyFetchFailure(caught.getMessage());
            tab.showErrorPanel(message);
        }
        this.getTab().hideBusyIndicator();
    }

    private void compareClickedAction() {
        Set<String> selectedVersions = this.dataProvider.getselectedRevisions();
        if (selectedVersions.size() > 2) {
            String message = this.getTab().getViewMessages().historyErrorMoreThanTwoRevisions();
            TitleValidationViewInput input = new TitleValidationViewInput();
            input.setErrorHeader(message);
            this.getTab().getTitleView().showMessage(input);
            this.resizeScrollContainer();
            return;
        }
        if (selectedVersions.size() < 2) {
            String message = this.getTab().getViewMessages().historyErrorLessThanTwoRevisions();
            TitleValidationViewInput input = new TitleValidationViewInput();
            input.setErrorHeader(message);
            this.getTab().getTitleView().showMessage(input);
            this.resizeScrollContainer();
            return;
        }
        Iterator<String> itr = selectedVersions.iterator();
        String revision1 = itr.next();
        String revision2 = itr.next();
        this.compare(revision1, revision2);
    }

    public void compare(String revision1, String revision2) {
        String header;
        this.getTab().getTitleView().showMessage(null);
        this.resizeScrollContainer();
        this.compareView = new TitleCompareView(this, !this.isSeriesTitle);
        UIActionTitle title1 = new UIActionTitle();
        title1.setTitleId(this.getTab().getViewInput().getTitleId());
        title1.setVersion(revision1);
        UIActionTitle title2 = new UIActionTitle();
        title2.setTitleId(this.getTab().getViewInput().getTitleId());
        title2.setVersion(revision2);
        TitleCompareViewInput input = new TitleCompareViewInput();
        input.specName = this.getTab().getViewInput().getSpecificationName();
        input.header = header = this.getTab().getViewMessages().titleCompareSummaryMessage(this.getTab().getViewMessages().compareRevisionHeading(revision1), this.getTab().getViewMessages().compareRevisionHeading(revision2));
        input.displayName1 = this.getTab().getViewMessages().compareRevisionName(revision1);
        input.displayName2 = this.getTab().getViewMessages().compareRevisionName(revision2);
        input.restrictedHeight = this.getTab().getUsedHeight();
        input.restrictedWidth = this.getTab().getUsedWidth();
        this.lastRequest = new TitleCompareRequest();
        this.lastRequest.title1 = title1;
        this.lastRequest.title2 = title2;
        this.lastRequest.specName = input.specName;
        this.lastRequest.specificationType = this.isSeriesTitle ? "SERIES" : "PACKAGE";
        this.compareView.setInput(input);
        this.compareDiff();
        this.setWidget((Widget)this.compareView);
    }

    public void compareDiff() {
        this.compareView.showBusyIndicator();
        this.viewService.compareTitles(this.lastRequest, (AsyncCallback<UITitleCompareData>)new NeptuneAsyncCallback<UITitleCompareData>(){

            public void onNeptuneFailure(Throwable caught) {
                ProgressHistoryPanel.this.compareView.showErrorView(caught);
                ProgressHistoryPanel.this.compareView.hideBusyIndicator();
            }

            public void onNeptuneSuccess(UITitleCompareData data) {
                ProgressHistoryPanel.this.setSpecName(data);
                ((ProgressHistoryPanel)ProgressHistoryPanel.this).compareView.getInput().compareData = data;
                ProgressHistoryPanel.this.compareView.showDiffView();
                ProgressHistoryPanel.this.compareView.hideBusyIndicator();
            }
        });
    }

    public void compareXml() {
        this.compareView.showBusyIndicator();
        this.viewService.compareTitlePreviews(this.lastRequest.title1, this.lastRequest.title2, this.lastRequest.specName, HtmlorXmlDisplayHelper.useHtml(), (AsyncCallback<UITitleCompareXmlData>)new NeptuneAsyncCallback<UITitleCompareXmlData>(){

            public void onNeptuneFailure(Throwable caught) {
                ProgressHistoryPanel.this.compareView.showErrorView(caught);
                ProgressHistoryPanel.this.compareView.hideBusyIndicator();
            }

            public void onNeptuneSuccess(UITitleCompareXmlData result) {
                ProgressHistoryPanel.this.compareView.showXmlView(result);
                ProgressHistoryPanel.this.compareView.hideBusyIndicator();
            }
        });
    }

    private void setSpecName(UITitleCompareData data) {
        List<UIAssetSpecificationListItem> specs;
        if (this.lastRequest != null && data != null && this.lastRequest.specName == null && (specs = data.getSpecifications()) != null && specs.size() > 0) {
            this.lastRequest.specName = specs.get(0).getName();
        }
    }

    private void handleViewCancelled() {
        this.setWidget((Widget)this.mainContainer);
    }

    @Override
    public void onCancel() {
        this.handleViewCancelled();
    }

    @Override
    public void onShowDifferences() {
        this.compareDiff();
    }

    @Override
    public void onShowXml() {
        this.compareXml();
    }

    @Override
    public void onSpecChanged(String newSpec) {
        this.lastRequest.specName = newSpec;
        this.compareView.getInput().specName = newSpec;
        this.compareXml();
    }
}

