/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.history;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.history.UIProgressItem;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.history.ProgressHistoryPanel;
import com.tandbergtv.cms.portal.content.client.title.view.history.ProgressItemColumn;
import com.tandbergtv.cms.portal.content.client.title.view.history.ProgressItemRecord;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleProgressService;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.InlineLabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

class ProgressItemDataProvider
implements DataProvider<Long, ProgressItemRecord> {
    private TitleViewMessages messages;
    private List<Column<?, ProgressItemRecord>> columns;
    private ProgressHistoryPanel parent;
    private List<String> titleRevisions = new ArrayList<String>();
    private Set<String> selectedRevisions = new TreeSet<String>();
    private String firstRevision;
    private String normalizedEventName;
    private List<String> updatedEventNames;
    public static final String USER_COLUMN_NAME = "sourceComponentName";
    public static final String DATE_COLUMN_NAME = "timestamp";
    public static final String ACTION_COLUMN_NAME = "name";
    public static final String REVISION_COLUMN_NAME = "titleVersion";
    public static final String DESCRIPTION_COLUMN_NAME = "description";

    public ProgressItemDataProvider(ProgressHistoryPanel parent) {
        this.parent = parent;
        this.messages = (TitleViewMessages)GWT.create(TitleViewMessages.class);
        this.initializeColumns();
    }

    private void initializeColumns() {
        this.columns = new ArrayList();
        String displayName = null;
        ProgressItemColumn column = null;
        this.columns.add(this.prepareSelectColumn());
        this.columns.add(this.prepareUserColumn());
        displayName = this.messages.progressTableActionColumn();
        column = new ProgressItemColumn(ACTION_COLUMN_NAME, displayName){

            @Override
            protected String getColumnText(ProgressItemRecord record) {
                return ProgressItemDataProvider.this.getActionValue(record.getProgressItem());
            }
        };
        column.setColumnWidth("15%");
        column.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, ProgressItemRecord>)column);
        this.columns.add(this.prepareDescriptionColumn());
        displayName = this.messages.progressTableDateColumn();
        column = new ProgressItemColumn(DATE_COLUMN_NAME, displayName){

            @Override
            protected String getColumnText(ProgressItemRecord record) {
                return ProgressItemDataProvider.this.getDateValue(record.getProgressItem());
            }
        };
        column.setColumnWidth("10%");
        column.setCellStyle("nwt-TableColumnPanel-dataCell-date");
        this.columns.add((Column<?, ProgressItemRecord>)column);
        this.columns.add(this.prepareRevisionColumn());
    }

    private Column<String, ProgressItemRecord> prepareSelectColumn() {
        ColumnBase<String, ProgressItemRecord> column = null;
        String displayName = "";
        column = new ColumnBase<String, ProgressItemRecord>(REVISION_COLUMN_NAME, displayName){

            public View<String> getView(ProgressItemRecord record) {
                final String revision = record.getProgressItem().getTitleRevision();
                final boolean isFirst = this.isFirstProgressTitleVersion(record);
                return new View<String>(){

                    public String getStyleName() {
                        return isFirst ? "table-data-checkbox" : null;
                    }

                    public Widget getWidget() {
                        if (isFirst) {
                            final CheckBoxWidget chkBox = new CheckBoxWidget();
                            if (ProgressItemDataProvider.this.selectedRevisions.contains(revision)) {
                                chkBox.setValue(Boolean.valueOf(true));
                            }
                            chkBox.addClickHandler(new ClickHandler(){

                                public void onClick(ClickEvent event) {
                                    boolean isCheck = chkBox.getValue();
                                    if (isCheck) {
                                        ProgressItemDataProvider.this.selectedRevisions.add(revision);
                                    } else {
                                        ProgressItemDataProvider.this.selectedRevisions.remove(revision);
                                    }
                                }
                            });
                            return chkBox;
                        }
                        return new LabelWidget("");
                    }

                    public void release() {
                    }
                };
            }

            private boolean isFirstProgressTitleVersion(ProgressItemRecord record) {
                boolean isFirst = false;
                String revision = record.getProgressItem().getTitleRevision();
                if (!ProgressItemDataProvider.this.titleRevisions.contains(revision)) {
                    isFirst = true;
                    ProgressItemDataProvider.this.titleRevisions.add(revision);
                }
                return isFirst;
            }

            public String getColumnWidth() {
                return "2%";
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell");
        return column;
    }

    private Column<String, ProgressItemRecord> prepareRevisionColumn() {
        ColumnBase<String, ProgressItemRecord> column = null;
        String displayName = this.messages.progressTableRevisionColumn();
        column = new ColumnBase<String, ProgressItemRecord>(REVISION_COLUMN_NAME, displayName){

            public View<String> getView(final ProgressItemRecord record) {
                final boolean isLatestVersion = this.isProgressTitleVersionLatest(record);
                return new View<String>(){

                    public String getStyleName() {
                        return !isLatestVersion ? "table-data-link" : null;
                    }

                    public Widget getWidget() {
                        LabelWidget label = new LabelWidget(ProgressItemDataProvider.this.getRevisionValue(record.getProgressItem()));
                        if (!isLatestVersion) {
                            label.addClickHandler(new ClickHandler(){

                                public void onClick(ClickEvent event) {
                                    String revision = record.getProgressItem().getTitleRevision();
                                    ProgressItemDataProvider.this.parent.getTab().showTitleRevision(revision);
                                }
                            });
                        }
                        return label;
                    }

                    public void release() {
                    }
                };
            }

            private boolean isProgressTitleVersionLatest(ProgressItemRecord record) {
                return record.getProgressItem().isLatestRevision();
            }

            public String getColumnWidth() {
                return "5%";
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-numeric");
        return column;
    }

    private Column<String, ProgressItemRecord> prepareUserColumn() {
        ColumnBase<String, ProgressItemRecord> column = null;
        String displayName = this.messages.progressTableUserColumn();
        column = new ColumnBase<String, ProgressItemRecord>(USER_COLUMN_NAME, displayName){

            public View<String> getView(final ProgressItemRecord record) {
                final ITitleProgressService.Hyperlink hl = ProgressItemDataProvider.this.getHyperlinkInfoFromAppropriateComponent(record.getProgressItem());
                return new View<String>(){

                    public String getStyleName() {
                        return hl != null && hl.getTargetHistoryToken() != null ? "table-data-link" : null;
                    }

                    public Widget getWidget() {
                        if (hl != null) {
                            if (hl.getTargetHistoryToken() != null) {
                                return new HyperlinkWidget(hl.getText(), hl.isAsHTML(), hl.getTargetHistoryToken());
                            }
                            return new LabelWidget(hl.getText());
                        }
                        return new LabelWidget(record.getProgressItem().getSourceComponentName());
                    }

                    public void release() {
                    }
                };
            }

            public String getColumnWidth() {
                return "15%";
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        return column;
    }

    private Column<String, ProgressItemRecord> prepareDescriptionColumn() {
        ColumnBase<String, ProgressItemRecord> column = null;
        String displayName = this.messages.progressTableDescriptionColumn();
        column = new ColumnBase<String, ProgressItemRecord>(DESCRIPTION_COLUMN_NAME, displayName){

            public View<String> getView(ProgressItemRecord record) {
                final String actionValue = ProgressItemDataProvider.this.getActionValue(record.getProgressItem());
                final String revision = record.getProgressItem().getTitleRevision();
                final String descValue = ProgressItemDataProvider.this.getDescriptionValue(record.getProgressItem());
                return new View<String>(){

                    public String getStyleName() {
                        return "table-data-text";
                    }

                    public Widget getWidget() {
                        String titleChangedMsg = null;
                        if (actionValue.equals(ProgressItemDataProvider.this.normalizedEventName)) {
                            titleChangedMsg = ProgressItemDataProvider.this.messages.titleNormalizedMessage();
                        } else if (ProgressItemDataProvider.this.updatedEventNames.contains(actionValue)) {
                            titleChangedMsg = ProgressItemDataProvider.this.messages.titleUpdatedMessage();
                        }
                        if (!revision.equals(ProgressItemDataProvider.this.firstRevision) && titleChangedMsg != null) {
                            InlineLabelWidget descriptionLabel = descValue != null ? new InlineLabelWidget(String.valueOf(descValue) + " " + titleChangedMsg + " - ") : new InlineLabelWidget(String.valueOf(titleChangedMsg) + " - ");
                            FlowPanel descriptionMessagePanel = new FlowPanel();
                            InlineLabelWidget viewChangeLabel = new InlineLabelWidget(ProgressItemDataProvider.this.messages.viewChangesMessage());
                            viewChangeLabel.addStyleName("table-data-link");
                            viewChangeLabel.addClickHandler(new ClickHandler(){

                                public void onClick(ClickEvent event) {
                                    ProgressItemDataProvider.this.handleViewChangesLabelClick(revision);
                                }
                            });
                            descriptionMessagePanel.add((Widget)descriptionLabel);
                            descriptionMessagePanel.add((Widget)viewChangeLabel);
                            return descriptionMessagePanel;
                        }
                        return new LabelWidget(descValue);
                    }

                    public void release() {
                    }
                };
            }

            public String getColumnWidth() {
                return "54%";
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        return column;
    }

    private String getPreviousRevision(String revision) {
        String prevRevision = null;
        int curIndex = this.titleRevisions.indexOf(revision);
        if (curIndex < this.titleRevisions.size() - 1) {
            prevRevision = this.titleRevisions.get(curIndex + 1);
        }
        return prevRevision;
    }

    private void handleViewChangesLabelClick(String revision) {
        String prevRevision = this.getPreviousRevision(revision);
        this.parent.compare(revision, prevRevision);
    }

    private ITitleProgressService.Hyperlink getHyperlinkInfoFromAppropriateComponent(UIProgressItem item) {
        ServiceLoader serviceLoader = NeptuneApplication.getApplication().getServiceLoader();
        List services = serviceLoader.loadServices(ITitleProgressService.class);
        for (ITitleProgressService service : services) {
            ITitleProgressService.Hyperlink hl = service.getLink(item.getSourceComponentName(), item.getSourceEntityName(), item.getSourceId(), item.getTitleRevision());
            if (hl == null) continue;
            return hl;
        }
        return null;
    }

    public List<Column<?, ProgressItemRecord>> getColumns() {
        return this.columns;
    }

    public ProgressItemColumn getColumn(String columnName) {
        ProgressItemColumn match = null;
        for (Column<?, ProgressItemRecord> column : this.columns) {
            if (!(column instanceof ProgressItemColumn) || !columnName.equals(column.getName())) continue;
            match = (ProgressItemColumn)column;
            break;
        }
        return match;
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public void getRecord(Long key, AsyncCallback<ProgressItemRecord> callback) {
        UIProgressItem progressItem = new UIProgressItem();
        progressItem.setId(key);
        callback.onSuccess((Object)new ProgressItemRecord(progressItem));
    }

    public void getRecords(final AsyncCallback<List<ProgressItemRecord>> callback) {
        this.titleRevisions.clear();
        this.parent.getTab().getViewInput().getHistory((AsyncCallback<UITitle>)new NeptuneAsyncCallback<UITitle>(){

            public void onNeptuneSuccess(UITitle result) {
                ArrayList<ProgressItemRecord> records = new ArrayList<ProgressItemRecord>();
                for (UIProgressItem progressItem : result.getHistory().getProgressItems()) {
                    records.add(new ProgressItemRecord(progressItem));
                }
                ProgressItemDataProvider.this.normalizedEventName = result.getHistory().getNormalizedName();
                ProgressItemDataProvider.this.updatedEventNames = result.getHistory().getUpdatedNames();
                ProgressItemDataProvider.this.parent.setSeriesTitle(result.getHistory().isSeriesTitle());
                int numRecs = records.size();
                if (numRecs > 0) {
                    ProgressItemDataProvider.this.firstRevision = ((ProgressItemRecord)records.get(numRecs - 1)).getProgressItem().getTitleRevision();
                }
                callback.onSuccess(records);
                ProgressItemDataProvider.this.parent.handleGetRecordsSuccess(result, records.size());
            }

            public void onNeptuneFailure(Throwable caught) {
                callback.onSuccess(new ArrayList());
                ProgressItemDataProvider.this.parent.handleGetRecordsFailure(caught);
            }
        });
    }

    public boolean isCheckboxEnabled() {
        return false;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    public Set<String> getselectedRevisions() {
        return this.selectedRevisions;
    }

    private String getActionValue(UIProgressItem progressItem) {
        return progressItem.getName();
    }

    private String getDescriptionValue(UIProgressItem progressItem) {
        return progressItem.getValue();
    }

    private String getDateValue(UIProgressItem progressItem) {
        return progressItem.getFormattedTimestamp();
    }

    private String getRevisionValue(UIProgressItem progressItem) {
        return progressItem.getTitleRevision();
    }
}

