/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.history;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.ContentComponent;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.UITitleOverview;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareView;
import com.tandbergtv.cms.portal.content.client.title.view.history.MetadataHistoryPanel;
import com.tandbergtv.cms.portal.content.client.title.view.history.ProgressHistoryPanel;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.UITitleInfo;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.RefreshWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.RefreshEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.RefreshHandler;

public class TitleHistoryTab
extends TitleViewTab {
    private RefreshWidget<ProgressHistoryPanel> progressHistoryPanel;
    private MetadataHistoryPanel metadataHistoryPanel;
    private static final int DEFAULT_REFRESH_RATE = 180;
    private static final int MINIMUM_REFRESH_RATE = 30;
    public static final String TAB_NAME = "History";

    public TitleHistoryTab(TitleView parent) {
        super(parent);
    }

    @Override
    protected void initialize() {
        this.getContainer().addStyleDependentName("history");
        final ProgressHistoryPanel panel = new ProgressHistoryPanel(this);
        this.progressHistoryPanel = new RefreshWidget((Widget)panel);
        this.progressHistoryPanel.setRefreshOnLoad(false);
        this.progressHistoryPanel.setRefreshPeriod(this.getRefreshPeriod());
        this.progressHistoryPanel.addRefreshHandler(new RefreshHandler(){

            public void onRefresh(RefreshEvent event) {
                Widget w = panel.getWidget();
                if (!(w instanceof TitleCompareView)) {
                    TitleHistoryTab.this.handleRefreshEvent(event);
                }
            }
        });
        this.metadataHistoryPanel = new MetadataHistoryPanel(this);
        this.getContainer().setWidget(this.progressHistoryPanel);
    }

    @Override
    public void refreshTab() {
        this.showBusyIndicator();
        this.getContainer().setWidget(this.progressHistoryPanel);
        ((ProgressHistoryPanel)this.progressHistoryPanel.getWidget()).refresh();
        this.metadataHistoryPanel.refresh();
    }

    @Override
    protected void markUpdated() {
        super.markUpdated();
    }

    private int getRefreshPeriod() {
        NeptuneApplication application = NeptuneApplication.getApplication();
        ContentComponent component = (ContentComponent)application.getComponent(ContentComponent.class);
        Integer refreshRateValue = component.getTitleHistoryViewRefreshRate();
        int refreshRate = 180;
        try {
            if (refreshRateValue != null && (refreshRate = refreshRateValue.intValue()) < 30) {
                refreshRate = 30;
            }
        }
        catch (Exception exception) {
            refreshRate = 180;
        }
        return refreshRate * 1000;
    }

    private void handleRefreshEvent(RefreshEvent event) {
        boolean visible = true;
        Widget widget = this.progressHistoryPanel;
        while (widget != null && visible) {
            visible &= widget.isVisible();
            widget = widget.getParent();
        }
        if (visible) {
            this.getViewInput().invalidateHistory();
            this.refresh();
        }
    }

    void showTitleRevision(final String titleRevision) {
        Long titleId = this.getViewInput().getTitleId();
        if (titleId == null) {
            return;
        }
        this.showBusyIndicator();
        this.getViewService().getTitleRevisionInfo(titleId, titleRevision, (AsyncCallback<UITitleInfo>)new NeptuneAsyncCallback<UITitleInfo>(){

            public void onNeptuneSuccess(UITitleInfo result) {
                TitleHistoryTab.this.handleGetTitleMetadataSuccess(titleRevision, result);
            }

            public void onNeptuneFailure(Throwable caught) {
                TitleHistoryTab.this.handleGetTitleMetadataFailure(titleRevision, caught);
            }
        });
    }

    private void handleGetTitleMetadataSuccess(String revision, UITitleInfo info) {
        this.metadataHistoryPanel.setInput(revision, info.getRevisionInfo().isDraft(), info.getSpecification(), info.getTitle().getMetadata(), this.titleView);
        this.getContainer().setWidget((Widget)this.metadataHistoryPanel);
        this.hideBusyIndicator();
    }

    private void handleGetTitleMetadataFailure(String revision, Throwable caught) {
        String error = caught.getLocalizedMessage();
        String message = this.getViewMessages().titleRevisionFetchError(revision, error);
        this.getViewInput().invalidateHistory();
        this.showErrorPanel(message);
        this.hideBusyIndicator();
    }

    void showProgressHistory(boolean titleUpdated, String infoMessage, boolean invalidateHistory) {
        this.getContainer().setWidget(this.progressHistoryPanel);
        if (titleUpdated) {
            UITitle title = new UITitle();
            title.setId(title.getId());
            this.onTitleUpdated(title);
        } else if (invalidateHistory) {
            this.getViewInput().invalidateHistory();
        }
        if (titleUpdated || invalidateHistory) {
            this.refresh();
        }
    }

    @Override
    protected void onTabUnselected() {
        this.markStale();
        this.getViewInput().invalidateHistory();
    }

    @Override
    protected String getTabName() {
        return TAB_NAME;
    }

    @Override
    public String getTabDisplayName() {
        return this.getViewMessages().historyTabName();
    }

    @Override
    protected void updateTitleHeader(UITitleOverview overview) {
        super.updateTitleHeader(overview);
    }

    @Override
    protected int getTabHeight() {
        return super.getTabHeight();
    }

    @Override
    protected int getTabWidth() {
        return super.getTabWidth();
    }

    @Override
    protected int getUsedHeight() {
        return super.getUsedHeight();
    }

    @Override
    protected int getUsedWidth() {
        return super.getUsedWidth();
    }

    @Override
    protected void showBusyIndicator() {
        super.showBusyIndicator();
    }

    @Override
    protected void hideBusyIndicator() {
        super.hideBusyIndicator();
    }

    @Override
    protected void showSevereError(String message) {
        super.showSevereError(message);
    }

    @Override
    protected void showErrorPanel(String message) {
        super.showErrorPanel(message);
    }
}

