/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.imageeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.lookupkey.model.UiLookupKey;
import com.tandbergtv.cms.portal.content.client.rpc.lookupkey.ILookupKeyService;
import com.tandbergtv.cms.portal.content.client.rpc.lookupkey.ILookupKeyServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.ImageEditorService;
import com.tandbergtv.cms.portal.content.client.title.service.ImageEditorServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.SaveImageRequest;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import java.util.List;

public class EditImageDialogBox
extends DialogBox {
    private final ImageEditorServiceAsync imageEditorService = (ImageEditorServiceAsync)GWT.create(ImageEditorService.class);
    private TitleViewMessages messages = (TitleViewMessages)GWT.create(TitleViewMessages.class);
    private static final String DEFAULT_FILE_EXTENSION = ".jpg";
    private String sourceFileName;
    private String sourceFileExtension = ".jpg";
    private String assetType;
    private String lookupKey;
    private Button saveButton;
    private Button cancelButton;
    private ILookupKeyServiceAsync lookupKeyService = (ILookupKeyServiceAsync)GWT.create(ILookupKeyService.class);
    private SaveImageRequest saveImageRequest;

    public EditImageDialogBox() {
    }

    public EditImageDialogBox(boolean autoHide) {
        super(autoHide);
    }

    public EditImageDialogBox(String sourceFileName, String assetType, String lookupKey, boolean autoHide, boolean modal) {
        super(autoHide, modal);
        this.sourceFileName = sourceFileName;
        if (sourceFileName.lastIndexOf(".") != -1) {
            this.sourceFileExtension = sourceFileName.substring(sourceFileName.lastIndexOf("."));
        }
        this.assetType = assetType;
        this.lookupKey = lookupKey;
        this.init();
    }

    public void init() {
        this.setText(this.messages.editImageDialogBoxCaption());
        VerticalPanel verticalPanel = new VerticalPanel();
        StringBuffer tmp = new StringBuffer("<div style=\"visibility:hidden\" id=\"imageeditor\">");
        tmp.append("<div id=\"container\" >");
        tmp.append("\r\n</div>");
        tmp.append("\r\n</div>");
        HTML imgEditorHTML = new HTML(tmp.toString());
        verticalPanel.add((Widget)imgEditorHTML);
        verticalPanel.addAttachHandler(new AttachEvent.Handler(){

            public void onAttachOrDetach(AttachEvent event) {
                if (event.isAttached()) {
                    EditImageDialogBox.initImageEditor();
                }
            }
        });
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        horizontalPanel.addStyleName("cms_button_container");
        horizontalPanel.setSpacing(5);
        Label label = new Label(this.messages.saveAsImageLabel());
        horizontalPanel.add((Widget)label);
        TextArea saveImageContent = new TextArea();
        saveImageContent.setVisible(false);
        horizontalPanel.add((Widget)saveImageContent);
        TextBox textBoxImageFileName = new TextBox();
        textBoxImageFileName.setText("custom_image1" + this.sourceFileExtension);
        horizontalPanel.add((Widget)textBoxImageFileName);
        Label labelLookupKey = new Label(this.messages.lookupKeyLabel());
        horizontalPanel.add((Widget)labelLookupKey);
        final ListBoxWidget lookupKeyListBox = new ListBoxWidget();
        horizontalPanel.add((Widget)lookupKeyListBox);
        lookupKeyListBox.addItem(null, null);
        this.lookupKeyService.getLookupKeysByAssetType(this.assetType, (AsyncCallback<List<UiLookupKey>>)new NeptuneAsyncCallback<List<UiLookupKey>>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(List<UiLookupKey> result) {
                for (UiLookupKey key : result) {
                    lookupKeyListBox.addItem(key.getName(), (Object)key.getName());
                }
                lookupKeyListBox.setSelectedItem((Object)EditImageDialogBox.this.lookupKey);
            }
        });
        horizontalPanel.add((Widget)this.initSaveButton(textBoxImageFileName, (ListBoxWidget<String>)lookupKeyListBox));
        horizontalPanel.add((Widget)this.initCancelButton());
        verticalPanel.add((Widget)horizontalPanel);
        this.setWidget((Widget)verticalPanel);
    }

    private Button initCancelButton() {
        this.cancelButton = new Button(this.messages.cancelButtonText());
        this.cancelButton.removeStyleName("gwt-Button");
        this.cancelButton.addStyleName("ebBtn");
        this.cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                EditImageDialogBox.cleanupImageEditor();
                EditImageDialogBox.this.hide(true);
            }
        });
        return this.cancelButton;
    }

    private Button initSaveButton(final TextBox textBoxImageFileName, final ListBoxWidget<String> lookupKeyListBox) {
        this.saveButton = new Button(this.messages.saveButtonText());
        this.saveButton.removeStyleName("gwt-Button");
        this.saveButton.addStyleName("ebBtn");
        this.saveButton.addStyleName("ebBtn_color_green");
        this.saveButton.addStyleName("save_button_icon");
        this.saveButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String validFileExtension;
                String inputFileExtension;
                EditImageDialogBox.this.setSavingState(true);
                String fileName = textBoxImageFileName.getText();
                if (fileName != null && !"".equals(fileName) && fileName.lastIndexOf(".") > -1 && !(inputFileExtension = fileName.substring(fileName.lastIndexOf("."))).equals(validFileExtension = EditImageDialogBox.this.getValidFileExtension())) {
                    Window.alert((String)("The file extension must be the same as the source file extension: " + validFileExtension));
                    EditImageDialogBox.this.setSavingState(false);
                    return;
                }
                String imageDataBase64 = EditImageDialogBox.getImageDataBase64();
                if (imageDataBase64 != null && !"".equals(imageDataBase64)) {
                    String lookupKey = (String)lookupKeyListBox.getSelectedItem();
                    if (EditImageDialogBox.this.saveImageRequest != null) {
                        EditImageDialogBox.this.saveImageRequest.setImageFileName(fileName);
                        EditImageDialogBox.this.saveImageRequest.setImageDataBase64(imageDataBase64);
                        EditImageDialogBox.this.saveImageRequest.setLookupKey(lookupKey);
                        EditImageDialogBox.this.imageEditorService.saveImage(EditImageDialogBox.this.saveImageRequest, new AsyncCallback<Void>(){

                            public void onFailure(Throwable caught) {
                                Window.alert((String)("Failed to save image : saveImage RPC Failure : " + caught.getMessage() + "\n Please try again with a new file name."));
                                EditImageDialogBox.this.setSavingState(false);
                            }

                            public void onSuccess(Void result) {
                                EditImageDialogBox.this.hide(true);
                                Window.Location.reload();
                            }
                        });
                    }
                }
            }
        });
        return this.saveButton;
    }

    private void setSavingState(boolean isSaving) {
        this.saveButton.setEnabled(!isSaving);
        this.cancelButton.setEnabled(!isSaving);
        if (isSaving) {
            this.saveButton.setText(this.messages.savingButtonText());
        } else {
            this.saveButton.setText(this.messages.saveButton());
        }
    }

    private String getValidFileExtension() {
        String fileExtension = this.sourceFileExtension;
        String imagingComponentFileName = EditImageDialogBox.getImageEditorFileName();
        if (imagingComponentFileName != null && !"".equals(imagingComponentFileName)) {
            fileExtension = imagingComponentFileName.substring(imagingComponentFileName.lastIndexOf("."));
        }
        return fileExtension;
    }

    public static native String getImageEditorFileName();

    public static native String getImageDataBase64();

    public SaveImageRequest getSaveImageRequest() {
        return this.saveImageRequest;
    }

    public void setSaveImageRequest(SaveImageRequest saveImageRequest) {
        this.saveImageRequest = saveImageRequest;
    }

    public static native void loadImageUrl(String var0, String var1);

    public static native void initImageEditor();

    public static native void cleanupImageEditor();
}

