/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.keyframes;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.tab.ErrorPanel;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UITimeField;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.keyframes.KeyframesPanelBase;
import com.tandbergtv.cms.portal.content.client.title.view.keyframes.LogicalClipPanel;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.Validator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class KeyframesLogicalClipPanel
extends KeyframesPanelBase {
    private LogicalClipPanel logicalClipPanel;
    private PopupPanel contextMenu;
    ErrorPanel errorMessagePanel;

    @Override
    public void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.addStyleName("KeyframesLogicalClipPanel");
        this.mainContainer.setSpacing(10);
        this.logicalClipPanel = new LogicalClipPanel();
        this.mainContainer.add((Widget)this.logicalClipPanel);
        this.errorMessagePanel = new ErrorPanel();
        this.errorMessagePanel.setVisible(false);
        this.mainContainer.add((Widget)this.errorMessagePanel);
        Button okButton = new Button("Done");
        okButton.removeStyleName("gwt-Button");
        okButton.addStyleName("ebBtn");
        okButton.addStyleName("ebBtn_color_green");
        okButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String markOutFrameTime;
                UIAsset logicalClipUIAsset = KeyframesLogicalClipPanel.this.assetInfo.getAsset();
                UIComplexField rootField = logicalClipUIAsset.getRootField();
                UIComplexField markField = (UIComplexField)rootField.getChildren().getField("Mark");
                UITimeField markInField = (UITimeField)markField.getChildren().getField("In");
                UITimeField markOutField = (UITimeField)markField.getChildren().getField("Out");
                Validator util = new Validator();
                String markInFrameTime = ((KeyframesLogicalClipPanel)KeyframesLogicalClipPanel.this).logicalClipPanel.clipStartTime.getText();
                if (!util.validateMarkInMarkOut(KeyframesPanelBase.FRAME_TIME_SEC_FORMAT, markInFrameTime, markOutFrameTime = ((KeyframesLogicalClipPanel)KeyframesLogicalClipPanel.this).logicalClipPanel.clipEndTime.getText())) {
                    KeyframesLogicalClipPanel.this.handleValidationError(util.getMessage());
                    return;
                }
                markInField.setValue(markInFrameTime);
                markOutField.setValue(markOutFrameTime);
                KeyframesLogicalClipPanel.this.assetPanel.redraw(KeyframesLogicalClipPanel.this.assetInfo);
            }
        });
        HorizontalPanel buttonsPanel = new HorizontalPanel();
        buttonsPanel.addStyleName("cms_button_container");
        buttonsPanel.add((Widget)okButton);
        Button cancelButton = new Button("Cancel");
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                KeyframesLogicalClipPanel.this.assetPanel.redraw();
            }
        });
        buttonsPanel.add((Widget)cancelButton);
        this.mainContainer.add((Widget)buttonsPanel);
        this.imagesTable = new FlexTable();
        this.mainContainer.add((Widget)this.imagesTable);
        this.setWidget((Widget)this.mainContainer);
    }

    void handleValidationError(String errMsg) {
        this.errorMessagePanel.setWidth("99%");
        this.errorMessagePanel.showErrorMessage(errMsg);
        this.errorMessagePanel.setVisible(true);
    }

    @Override
    public void setAssetInfo(AssetTree.AssetInfo assetInfo) {
        this.assetInfo = assetInfo;
        this.logicalClipPanel.reset();
        this.errorMessagePanel.setVisible(false);
        try {
            UIAsset logicalClipUIAsset = assetInfo.getAsset();
            UIComplexField rootField = logicalClipUIAsset.getRootField();
            UIComplexField markField = (UIComplexField)rootField.getChildren().getField("Mark");
            UITimeField markInField = (UITimeField)markField.getChildren().getField("In");
            UITimeField markOutField = (UITimeField)markField.getChildren().getField("Out");
            String markInTime = markInField.getDisplayValue();
            String markOutTime = markOutField.getDisplayValue();
            if (markInTime != null && !markInTime.isEmpty() && markOutTime != null && !markOutTime.isEmpty()) {
                this.logicalClipPanel.clipStartTime.setText(markInTime);
                this.logicalClipPanel.clipEndTime.setText(markOutTime);
            }
            UIAsset uiMovieAsset = assetInfo.getAsset().getParentAsset();
            Long uiMovieAssetId = uiMovieAsset.getId();
            Long titleId = assetInfo.getInput().getTitleId();
            this.refreshImagesTable(uiMovieAssetId, titleId);
        }
        catch (Exception exception) {}
    }

    @Override
    public void showContextMenu(MouseUpEvent event, Image image) {
        this.createContextMenu(image);
        NativeEvent nativeEvent = event.getNativeEvent();
        int x = nativeEvent.getClientX() + Window.getScrollLeft();
        int y = nativeEvent.getClientY() + Window.getScrollTop();
        this.contextMenu.setPopupPosition(x, y);
        this.contextMenu.show();
    }

    public void createContextMenu(Image image) {
        String imageUrl = image.getUrl();
        String milliSecTimeString = this.getFrameTimeString(imageUrl);
        int index = milliSecTimeString.lastIndexOf(".");
        String secTimeString = milliSecTimeString;
        if (index > 0) {
            secTimeString = milliSecTimeString.substring(0, index);
        }
        final String frameTimeString = secTimeString;
        MenuBar menuBar = new MenuBar(true);
        menuBar.addStyleName("context-menu-bar");
        Command setMarkInFrameCommand = new Command(){

            public void execute() {
                ((KeyframesLogicalClipPanel)KeyframesLogicalClipPanel.this).logicalClipPanel.clipStartTime.setText(frameTimeString);
                KeyframesLogicalClipPanel.this.contextMenu.hide();
            }
        };
        Command setMarkOutFrameCommand = new Command(){

            public void execute() {
                ((KeyframesLogicalClipPanel)KeyframesLogicalClipPanel.this).logicalClipPanel.clipEndTime.setText(frameTimeString);
                KeyframesLogicalClipPanel.this.contextMenu.hide();
            }
        };
        menuBar.addItem("Set Mark-in frame", (Scheduler.ScheduledCommand)setMarkInFrameCommand);
        menuBar.addItem("Set Mark-out frame", (Scheduler.ScheduledCommand)setMarkOutFrameCommand);
        this.contextMenu = new PopupPanel(true);
        this.contextMenu.add((Widget)menuBar);
    }

    public void validateMarkInMarkOut() {
    }
}

