/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.keyframes;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.UIKeyFrames;
import com.tandbergtv.cms.portal.content.client.title.service.KeyframesService;
import com.tandbergtv.cms.portal.content.client.title.service.KeyframesServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetPanel;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.event.PageNavigationEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.event.PageNavigationHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.event.PageResizeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.event.PageResizeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.PageFeatureWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class KeyframesPanelBase
extends SimpleContainer {
    protected VerticalContainer mainContainer;
    protected AssetPanel assetPanel;
    protected AssetTree.AssetInfo input;
    protected AssetTree.AssetInfo assetInfo;
    protected FlexTable imagesTable;
    protected PageFeature pageFeature = null;
    protected PageFeatureWidget featureWidget = null;
    protected List<Image> keyframeImagesList = new ArrayList<Image>();
    protected final KeyframesServiceAsync keyframesService = (KeyframesServiceAsync)GWT.create(KeyframesService.class);
    private static final String STYLE_KEYFRAMES_TIME_LABEL = "content-keyframe-time-label";
    private static final String STYLE_KEYFRAMES_IMAGE_PANEL = "content-keyframe-image-panel";
    protected static final String GET_IMAGE_JSP_PATH = "/portal/cms_contentmgmt_ui/jsps/get_image.jsp?fileURI=";
    private static final int NUM_IMAGES_IN_A_ROW = 5;
    private static final int DEFAULT_SECONDS_BETWEEN_FRAMES = 5;
    public static final DateTimeFormat FRAME_TIME_SEC_FORMAT = DateTimeFormat.getFormat((String)"HH:mm:ss");
    public static final DateTimeFormat FRAME_TIME_MILLISEC_FORMAT = DateTimeFormat.getFormat((String)"HH:mm:ss.SSS");
    private int milliSecondsBetweenFrames = 5000;

    public KeyframesPanelBase() {
        this.initWidgets();
    }

    public void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(10);
        Button okButton = new Button("Done");
        okButton.removeStyleName("gwt-Button");
        okButton.addStyleName("ebBtn");
        okButton.addStyleName("ebBtn_color_green");
        okButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                KeyframesPanelBase.this.assetPanel.redraw(KeyframesPanelBase.this.assetInfo);
            }
        });
        this.mainContainer.add((Widget)okButton);
        this.imagesTable = new FlexTable();
        this.mainContainer.add((Widget)this.imagesTable);
        this.setWidget((Widget)this.mainContainer);
    }

    public AssetPanel getAssetPanel() {
        return this.assetPanel;
    }

    public void setAssetPanel(AssetPanel assetPanel) {
        this.assetPanel = assetPanel;
        this.refreshImagesTable();
    }

    protected void refreshImagesTable() {
        Long assetId = null;
        Long titleId = null;
        this.refreshImagesTable(assetId, titleId);
    }

    public void refreshImagesTable(Long assetId, Long titleId) {
        if (assetId == null) {
            return;
        }
        if (this.featureWidget != null) {
            this.mainContainer.remove((Widget)this.featureWidget);
        }
        this.pageFeature = new PageFeatureImpl();
        int pageNum = 1;
        int pageSize = 10;
        this.pageFeature.setPageNumber(pageNum);
        this.pageFeature.setPageSize(pageSize);
        this.featureWidget = new PageFeatureWidget();
        ImageFramesPageNavigationHandler navHandler = new ImageFramesPageNavigationHandler(assetId, titleId);
        this.featureWidget.setInput(this.pageFeature);
        this.featureWidget.addPageNavigationHandler((PageNavigationHandler)navHandler);
        ImageFramesPageResizeHandler pgHandler = new ImageFramesPageResizeHandler(assetId, titleId);
        this.featureWidget.addPageResizeHandler((PageResizeHandler)pgHandler);
        this.mainContainer.add((Widget)this.featureWidget);
        this.refreshImagesTableForCurrentPage(assetId, titleId, 5, pageNum, pageSize);
    }

    public void refreshImagesTableForCurrentPage(Long assetId, Long titleId, int numCols, final int pageNum, final int pageSize) {
        if (assetId == null) {
            return;
        }
        final BusyIndicator busyIndictor = new BusyIndicator();
        busyIndictor.center();
        this.keyframesService.getPagedKeyframesImageURIs(assetId, titleId, numCols, pageNum, pageSize, new AsyncCallback<UIKeyFrames>(){

            public void onFailure(Throwable caught) {
                busyIndictor.hide();
                Window.alert((String)("getKeyFramesImages RPC Failure : " + caught));
            }

            public void onSuccess(UIKeyFrames result) {
                busyIndictor.hide();
                KeyframesPanelBase.this.keyframeImagesList.clear();
                String frameRateStr = result.getFramesPerSecond();
                if (frameRateStr != null && !frameRateStr.isEmpty()) {
                    float framesPerSecond = Float.parseFloat(frameRateStr);
                    KeyframesPanelBase.this.milliSecondsBetweenFrames = (int)(1000.0f / framesPerSecond);
                }
                List<String> keyFrameImageURIs = result.getKeyframesImageURIs();
                for (String imageFileUri : keyFrameImageURIs) {
                    String encodedImageFileUri = URL.encodeQueryString((String)imageFileUri);
                    String imageUrl = String.valueOf(Window.Location.getProtocol()) + "//" + Window.Location.getHost() + KeyframesPanelBase.GET_IMAGE_JSP_PATH + encodedImageFileUri;
                    Image image = new Image(imageUrl);
                    image.setWidth("200px");
                    image.setHeight("150px");
                    KeyframesPanelBase.this.keyframeImagesList.add(image);
                }
                if (keyFrameImageURIs.size() > 0) {
                    int totalNumber = result.getTotalNumberKeyFrames();
                    int recCount = totalNumber / 5;
                    int rem = totalNumber % 5;
                    if (rem > 0) {
                        ++recCount;
                    }
                    KeyframesPanelBase.this.pageFeature.setPageNumber(pageNum);
                    KeyframesPanelBase.this.pageFeature.setPageSize(pageSize);
                    KeyframesPanelBase.this.pageFeature.setRecordCount(recCount);
                    KeyframesPanelBase.this.featureWidget.setVisible(true);
                    KeyframesPanelBase.this.featureWidget.refresh();
                } else {
                    KeyframesPanelBase.this.featureWidget.setVisible(false);
                }
                KeyframesPanelBase.this.displayImages();
            }
        });
    }

    public int getFrameNumber(String s) {
        String strFrameNumber = s.substring(s.lastIndexOf("-") + 1, s.lastIndexOf("."));
        int frameNumber = -1;
        try {
            frameNumber = Integer.parseInt(strFrameNumber);
        }
        catch (NumberFormatException numberFormatException) {}
        return frameNumber;
    }

    public String getFrameTimeString(String imageUrl) {
        String frameTimeString = "";
        String strFrameNumber = imageUrl.substring(imageUrl.lastIndexOf("-") + 1, imageUrl.lastIndexOf("."));
        int frameNumber = Integer.parseInt(strFrameNumber);
        long frameTimeInMilliseconds = (frameNumber - 1) * this.milliSecondsBetweenFrames;
        Date frameDate = DateTimeFormat.getFormat((String)"HH:mm:ss").parse("00:00:00");
        frameDate.setTime(frameDate.getTime() + frameTimeInMilliseconds);
        frameTimeString = FRAME_TIME_MILLISEC_FORMAT.format(frameDate);
        return frameTimeString;
    }

    public void displayImages() {
        int row = 0;
        int column = 0;
        this.imagesTable.clear();
        for (final Image image : this.keyframeImagesList) {
            PushButton pushButton = new PushButton(image);
            final String imageUrl = image.getUrl();
            pushButton.addMouseUpHandler(new MouseUpHandler(){

                public void onMouseUp(MouseUpEvent event) {
                    KeyframesPanelBase.this.showContextMenu(event, image);
                }
            });
            pushButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    KeyframesPanelBase.this.onKeyframeImageClicked(event, imageUrl);
                }
            });
            String frameTimeString = this.getFrameTimeString(imageUrl);
            Label frameTimeLabel = new Label(frameTimeString);
            frameTimeLabel.addStyleName(STYLE_KEYFRAMES_TIME_LABEL);
            VerticalPanel keyFrameImagePanel = new VerticalPanel();
            keyFrameImagePanel.add((Widget)pushButton);
            keyFrameImagePanel.add((Widget)frameTimeLabel);
            keyFrameImagePanel.addStyleName(STYLE_KEYFRAMES_IMAGE_PANEL);
            this.imagesTable.setWidget(row, column, (Widget)keyFrameImagePanel);
            if (++column < 5) continue;
            column = 0;
            ++row;
        }
    }

    protected void showContextMenu(MouseUpEvent event, Image image) {
    }

    protected void onKeyframeImageClicked(ClickEvent event, String imageUrl) {
    }

    public AssetTree.AssetInfo getInput() {
        return this.input;
    }

    public void setInput(AssetTree.AssetInfo input) {
        this.input = input;
    }

    public AssetTree.AssetInfo getAssetInfo() {
        return this.assetInfo;
    }

    public void setAssetInfo(AssetTree.AssetInfo assetInfo) {
        this.assetInfo = assetInfo;
    }

    class ImageFramesPageNavigationHandler
    implements PageNavigationHandler {
        Long assetId;
        Long titleId;

        ImageFramesPageNavigationHandler(Long assetId, Long titleId) {
            this.assetId = assetId;
            this.titleId = titleId;
        }

        public void onPageNavigation(PageNavigationEvent event) {
            int pageNum = event.getNewPageNumber();
            int pageSize = event.getPageFeature().getPageSize();
            int numCols = 5;
            KeyframesPanelBase.this.refreshImagesTableForCurrentPage(this.assetId, this.titleId, numCols, pageNum, pageSize);
        }
    }

    class ImageFramesPageResizeHandler
    implements PageResizeHandler {
        Long assetId;
        Long titleId;

        ImageFramesPageResizeHandler(Long assetId, Long titleId) {
            this.assetId = assetId;
            this.titleId = titleId;
        }

        public void onPageResize(PageResizeEvent event) {
            int pageNum = 1;
            int pageSize = event.getNewPageSize();
            int numCols = 5;
            KeyframesPanelBase.this.refreshImagesTableForCurrentPage(this.assetId, this.titleId, numCols, pageNum, pageSize);
        }
    }
}

