/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.keyframes;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.ContentComponent;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.IUIAssetMap;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIStringField;
import com.tandbergtv.cms.portal.content.client.title.service.asset.IUIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetPanel;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.keyframes.KeyframesPanelBase;
import com.tandbergtv.cms.portal.content.client.title.view.keyframes.TitleImageWidget;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileFieldDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class KeyframesSetImagePanel
extends KeyframesPanelBase {
    private IUIAssetFactory assetFactory = new UIAssetFactory();
    private TitleImageWidget titleImageWidget;
    private ListBox moviesDropDown;
    private static final String FILE_URI_XPATH = "/Fields/Locator/Uri";
    private static final String FILE_TYPE_XPATH = "/Fields/Locator/Description/Text";
    private static final String FILE_LOOKUP_KEY_XPATH = "/Fields/CustomFields/CustomField[@name=LookupKey]/@value";
    private static final String FILE_TYPE_ORIGINAL = "ORIGINAL";
    private static final String FILE_TYPE_HISTORICAL = "HISTORICAL";

    public KeyframesSetImagePanel() {
        this.initWidgets();
    }

    @Override
    public void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(10);
        this.titleImageWidget = new TitleImageWidget();
        this.mainContainer.add((Widget)this.titleImageWidget);
        HorizontalPanel movieAssetSelectionPanel = new HorizontalPanel();
        movieAssetSelectionPanel.addStyleName("cms_button_container");
        movieAssetSelectionPanel.setSpacing(10);
        Label movieAssetSelectionLabel = new Label("Movie Asset Id : ");
        movieAssetSelectionPanel.add((Widget)movieAssetSelectionLabel);
        this.moviesDropDown = new ListBox();
        this.moviesDropDown.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                KeyframesSetImagePanel.this.refreshImagesTable();
            }
        });
        movieAssetSelectionPanel.add((Widget)this.moviesDropDown);
        Button okButton = new Button("Done");
        okButton.removeStyleName("gwt-Button");
        okButton.addStyleName("ebBtn");
        okButton.addStyleName("ebBtn_color_green");
        okButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                boolean hasUserPickedNonDefaultImage;
                String imageUrl = KeyframesSetImagePanel.this.titleImageWidget.getImageUrl();
                boolean bl = hasUserPickedNonDefaultImage = !imageUrl.contains(TitleImageWidget.getDefaultImageUrl());
                if (hasUserPickedNonDefaultImage) {
                    KeyframesSetImagePanel.this.updateAssetInfoImageUrl(imageUrl);
                    KeyframesSetImagePanel.this.assetPanel.redraw(KeyframesSetImagePanel.this.assetInfo);
                } else {
                    KeyframesSetImagePanel.this.assetPanel.redraw();
                }
            }
        });
        movieAssetSelectionPanel.add((Widget)okButton);
        this.mainContainer.add((Widget)movieAssetSelectionPanel);
        this.imagesTable = new FlexTable();
        this.mainContainer.add((Widget)this.imagesTable);
        this.setWidget((Widget)this.mainContainer);
    }

    @Override
    public void setAssetPanel(AssetPanel assetPanel) {
        this.assetPanel = assetPanel;
        AssetTree.AssetInfo input = assetPanel.getInput();
        UIAsset rootAsset = input.getAsset();
        if (rootAsset instanceof UIGroupAsset) {
            UIGroupAsset rootGrpAsset = (UIGroupAsset)rootAsset;
            IUIAssetMap uiAssetmap = rootGrpAsset.getChildren();
            NeptuneApplication application = NeptuneApplication.getApplication();
            ContentComponent component = (ContentComponent)application.getComponent(ContentComponent.class);
            List<String> videoAssetTypes = component.getVideoAssetTypes();
            ArrayList<UIGroupAsset> allVideoAssets = new ArrayList<UIGroupAsset>();
            for (String videoAssetType : videoAssetTypes) {
                List<UIGroupAsset> videoAssets = uiAssetmap.getGroups(videoAssetType);
                if (videoAssets == null || videoAssets.isEmpty()) continue;
                allVideoAssets.addAll(videoAssets);
            }
            this.moviesDropDown.clear();
            for (UIGroupAsset videoAsset : allVideoAssets) {
                Long videoAssetId = videoAsset.getId();
                this.moviesDropDown.addItem(String.valueOf(videoAssetId), String.valueOf(videoAssetId));
            }
        }
        this.refreshImagesTable();
    }

    @Override
    public void refreshImagesTable() {
        if (this.moviesDropDown.getItemCount() > 0) {
            int movieSelectedIndex = this.moviesDropDown.getSelectedIndex();
            if (movieSelectedIndex < 0) {
                movieSelectedIndex = 0;
            }
            String strMovieId = this.moviesDropDown.getItemText(movieSelectedIndex);
            Long assetId = null;
            try {
                assetId = Long.valueOf(strMovieId);
            }
            catch (NumberFormatException numberFormatException) {}
            Long titleId = this.assetInfo.getInput().getTitleId();
            this.refreshImagesTable(assetId, titleId);
        }
    }

    private void updateAssetInfoImageUrl(String imageUrl) {
        UIAsset asset = this.assetInfo.getAsset();
        List<UIAssetFile> assetFiles = asset.getFiles();
        UIAssetFileDefinition fileDefinition = this.assetInfo.getDefinition().getFileDefinition();
        String newFileLookupkey = FILE_TYPE_ORIGINAL;
        for (UIAssetFile assetFile : assetFiles) {
            UIAssetFileField filelookupKeyAssetFileField;
            UIAssetFileField fileTypeAssetFileField = assetFile.getFields().get(FILE_TYPE_XPATH);
            UIStringField stringField = (UIStringField)fileTypeAssetFileField.getField();
            String stringFieldValue = stringField.getDisplayValue();
            if (FILE_TYPE_ORIGINAL.equals(stringFieldValue)) {
                stringField.setValue(FILE_TYPE_HISTORICAL);
            }
            if (!newFileLookupkey.equals(stringFieldValue = (stringField = (UIStringField)(filelookupKeyAssetFileField = assetFile.getFields().get(FILE_LOOKUP_KEY_XPATH)).getField()).getDisplayValue())) continue;
            stringField.setValue("");
        }
        UIAssetFile newAssetFile = this.assetFactory.createAssetFile(fileDefinition);
        newAssetFile.setParentAsset(asset);
        for (UIAssetFileFieldDefinition fieldDefinition : fileDefinition.getFieldDefinitions()) {
            UIStringField stringField;
            UIAssetFileField value;
            if (fieldDefinition.getName().equals(FILE_TYPE_XPATH)) {
                value = this.assetFactory.createAssetFileField(fieldDefinition);
                stringField = new UIStringField();
                stringField.setName(FILE_TYPE_XPATH);
                stringField.setValue(FILE_TYPE_ORIGINAL);
                value.setField(stringField);
                newAssetFile.addField(value);
            }
            if (fieldDefinition.getName().equals(FILE_URI_XPATH)) {
                value = this.assetFactory.createAssetFileField(fieldDefinition);
                stringField = new UIStringField();
                stringField.setName(FILE_URI_XPATH);
                String encodedFileURI = imageUrl.substring(imageUrl.indexOf("fileURI=") + "fileURI=".length());
                String fileURI = URL.decodeQueryString((String)encodedFileURI);
                stringField.setValue(fileURI);
                value.setField(stringField);
                newAssetFile.addField(value);
            }
            if (!fieldDefinition.getName().equals(FILE_LOOKUP_KEY_XPATH)) continue;
            value = this.assetFactory.createAssetFileField(fieldDefinition);
            stringField = new UIStringField();
            stringField.setName(FILE_LOOKUP_KEY_XPATH);
            stringField.setValue(FILE_TYPE_ORIGINAL);
            value.setField(stringField);
            newAssetFile.addField(value);
        }
        assetFiles.add(newAssetFile);
    }

    @Override
    protected void onKeyframeImageClicked(ClickEvent event, String imageUrl) {
        this.titleImageWidget.setImageUrl(imageUrl);
    }
}

