/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.metadata;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessageType;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleMetadataTab;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleValidationViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class TitleValidationView
extends Composite {
    private SimpleContainer mainContainer;
    private LabelWidget blankLabel;
    private TitleViewMessages messages;
    private static final String WIDGET_STYLE_INFO = "content-TitleValidationViewInfo";
    private static final String WIDGET_STYLE_ERROR = "content-TitleValidationViewError";
    private static final String HEADING_MESSAGE_STYLE = "content-TitleValidationView-headingMessage";
    private static final String SECTION_HEADING_STYLE = "content-TitleValidationView-sectionHeading";
    private static final String ERROR_HEADING_STYLE = "content-TitleValidationView-sectionHeading-error";
    private static final String WARN_HEADING_STYLE = "content-TitleValidationView-sectionHeading-warning";
    private static final String INFO_HEADING_STYLE = "content-TitleValidationView-sectionHeading-information";
    private static final String MESSAGE_STYLE = "content-TitleValidationView-message";
    private static final String ERROR_MESSAGE_STYLE = "content-TitleValidationView-message-error";
    private static final String WARN_MESSAGE_STYLE = "content-TitleValidationView-message-warning";
    private static final String INFO_MESSAGE_STYLE = "content-TitleValidationView-message-information";
    private static final String FIELD_LINK_STYLE = "content-TitleValidationView-fieldLink";
    private static final String VALIDATION_WIDGET_STYLE = "content-TitleValidationView-messageWidget";

    public TitleValidationView() {
        this.initialize();
    }

    private void initialize() {
        this.messages = (TitleViewMessages)GWT.create(TitleViewMessages.class);
        this.mainContainer = new SimpleContainer();
        this.blankLabel = new LabelWidget("");
        this.mainContainer.setWidget((Widget)this.blankLabel);
        this.initWidget((Widget)this.mainContainer);
    }

    public void refresh(TitleValidationViewInput input) {
        int infoCount;
        int warningCount;
        this.setVisible(false);
        this.mainContainer.setWidget((Widget)new LabelWidget(""));
        if (input == null || !input.hasValidationMessages() && input.getMessageHeader() == null) {
            return;
        }
        VerticalContainer messagePanel = new VerticalContainer();
        ScrollPanel scrollPanel = new ScrollPanel((Widget)messagePanel);
        scrollPanel.setStyleName("TitleValidationViewScroll");
        LabelWidget headingMessageLabel = new LabelWidget();
        headingMessageLabel.addStyleName(HEADING_MESSAGE_STYLE);
        headingMessageLabel.setText(input.getMessageHeader());
        messagePanel.add((Widget)headingMessageLabel);
        this.filterTitleValidationMessages(input);
        int errorCount = input.getErrorMessageCount();
        if (errorCount > 0) {
            Widget widget;
            String sectionHeading = this.messages.titleValidationErrorHeading(errorCount);
            LabelWidget sectionLabel = new LabelWidget(sectionHeading);
            sectionLabel.addStyleName(SECTION_HEADING_STYLE);
            sectionLabel.addStyleName(ERROR_HEADING_STYLE);
            messagePanel.add((Widget)sectionLabel);
            for (AssetValidationMessage assetValidationMessage : input.getAssetValidationMessages()) {
                widget = this.buildMetadataValidationMessageWidget(assetValidationMessage, input.getMetadataTab());
                messagePanel.add(widget);
            }
            for (UITitleValidationMessage uITitleValidationMessage : input.getTitleValidationMessages()) {
                if (!UITitleValidationMessageType.Error.equals((Object)uITitleValidationMessage.getMessageType())) continue;
                widget = this.buildTitleValidationMessageWidget(uITitleValidationMessage);
                messagePanel.add(widget);
            }
        }
        if ((warningCount = input.getWarningMessageCount()) > 0) {
            String sectionHeading = this.messages.titleValidationWarningHeading(warningCount);
            LabelWidget labelWidget = new LabelWidget(sectionHeading);
            labelWidget.addStyleName(SECTION_HEADING_STYLE);
            labelWidget.addStyleName(WARN_HEADING_STYLE);
            messagePanel.add((Widget)labelWidget);
            for (UITitleValidationMessage message : input.getTitleValidationMessages()) {
                if (!UITitleValidationMessageType.Warning.equals((Object)message.getMessageType())) continue;
                Widget widget = this.buildTitleValidationMessageWidget(message);
                messagePanel.add(widget);
            }
        }
        if ((infoCount = input.getInformationMessageCount()) > 0) {
            String string = this.messages.titleValidationInformationHeading(infoCount);
            LabelWidget sectionLabel = new LabelWidget(string);
            sectionLabel.addStyleName(SECTION_HEADING_STYLE);
            sectionLabel.addStyleName(INFO_HEADING_STYLE);
            messagePanel.add((Widget)sectionLabel);
            for (UITitleValidationMessage message : input.getTitleValidationMessages()) {
                if (!UITitleValidationMessageType.Information.equals((Object)message.getMessageType())) continue;
                Widget widget = this.buildTitleValidationMessageWidget(message);
                messagePanel.add(widget);
            }
        }
        this.mainContainer.setWidget((Widget)scrollPanel);
        if (input.isInfoType()) {
            this.mainContainer.setStyleName(WIDGET_STYLE_INFO);
        } else {
            this.mainContainer.setStyleName(WIDGET_STYLE_ERROR);
        }
        this.setVisible(true);
    }

    private void filterTitleValidationMessages(TitleValidationViewInput input) {
        ArrayList<UITitleValidationMessage> messagesToDisplay = new ArrayList<UITitleValidationMessage>();
        for (UITitleValidationMessage message : input.getTitleValidationMessages()) {
            if (this.messageExists(message, messagesToDisplay)) continue;
            messagesToDisplay.add(message);
        }
        input.getTitleValidationMessages().clear();
        input.getTitleValidationMessages().addAll(messagesToDisplay);
    }

    private boolean messageExists(UITitleValidationMessage message, List<UITitleValidationMessage> messages) {
        for (UITitleValidationMessage m : messages) {
            if (!m.getMessage().equalsIgnoreCase(message.getMessage()) || m.getMessageType() != message.getMessageType()) continue;
            return true;
        }
        return false;
    }

    private Widget buildMetadataValidationMessageWidget(final AssetValidationMessage message, final TitleMetadataTab metadataTab) {
        HorizontalContainer widget = new HorizontalContainer();
        String assetType = message.getAsset().getDefinition().getDisplayName();
        String fieldName = message.getFieldName();
        String fieldText = this.messages.titleValidationMessageField(assetType, fieldName);
        LabelWidget fieldLabel = new LabelWidget(fieldText);
        fieldLabel.addStyleName(MESSAGE_STYLE);
        fieldLabel.addStyleName(ERROR_MESSAGE_STYLE);
        fieldLabel.addStyleName(FIELD_LINK_STYLE);
        fieldLabel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleValidationView.this.handleFieldLabelClicked(message, event, metadataTab);
            }
        });
        widget.add((Widget)fieldLabel);
        LabelWidget messageLabel = new LabelWidget(message.getMessage());
        messageLabel.addStyleName(MESSAGE_STYLE);
        messageLabel.addStyleName(ERROR_MESSAGE_STYLE);
        widget.add((Widget)messageLabel);
        widget.addStyleName(VALIDATION_WIDGET_STYLE);
        return widget;
    }

    private void handleFieldLabelClicked(AssetValidationMessage message, ClickEvent event, TitleMetadataTab metadataTab) {
        if (metadataTab != null) {
            metadataTab.showWidget(message);
        }
    }

    private Widget buildTitleValidationMessageWidget(UITitleValidationMessage message) {
        LabelWidget widget = new LabelWidget(message.getMessage());
        String styleName = null;
        switch (message.getMessageType()) {
            case Error: {
                styleName = ERROR_MESSAGE_STYLE;
                break;
            }
            case Warning: {
                styleName = WARN_MESSAGE_STYLE;
                break;
            }
            case Information: {
                styleName = INFO_MESSAGE_STYLE;
            }
        }
        widget.addStyleName(MESSAGE_STYLE);
        if (styleName != null) {
            widget.addStyleName(styleName);
        }
        widget.addStyleName(VALIDATION_WIDGET_STYLE);
        return widget;
    }
}

