/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.metadata;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessageType;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleMetadataTab;
import java.util.ArrayList;
import java.util.List;

public class TitleValidationViewInput {
    private ViewType type = ViewType.ERROR;
    private String headingMessage;
    private List<UITitleValidationMessage> titleValidationMessages = new ArrayList<UITitleValidationMessage>();
    private List<AssetValidationMessage> assetValidationMessages = new ArrayList<AssetValidationMessage>();
    private TitleMetadataTab metadataTab;

    public boolean isInfoType() {
        return this.type == ViewType.INFO;
    }

    public boolean isErrorType() {
        return this.type == ViewType.ERROR;
    }

    public void setMetadataTab(TitleMetadataTab tab) {
        this.metadataTab = tab;
    }

    public TitleMetadataTab getMetadataTab() {
        return this.metadataTab;
    }

    public String getMessageHeader() {
        return this.headingMessage;
    }

    public void setErrorHeader(String headingMessage) {
        this.type = ViewType.ERROR;
        this.headingMessage = headingMessage;
    }

    public void setInfoHeader(String headingMessage) {
        this.type = ViewType.INFO;
        this.headingMessage = headingMessage;
        this.titleValidationMessages.clear();
        this.assetValidationMessages.clear();
    }

    public List<UITitleValidationMessage> getTitleValidationMessages() {
        return this.titleValidationMessages;
    }

    public List<AssetValidationMessage> getAssetValidationMessages() {
        return this.assetValidationMessages;
    }

    public void clear() {
        this.titleValidationMessages.clear();
        this.assetValidationMessages.clear();
        this.headingMessage = null;
    }

    public boolean hasValidationMessages() {
        return this.titleValidationMessages.size() > 0 || this.assetValidationMessages.size() > 0;
    }

    public int getMessageCount() {
        return this.titleValidationMessages.size() + this.assetValidationMessages.size();
    }

    public int getErrorMessageCount() {
        int count = this.getMessageCount(UITitleValidationMessageType.Error);
        return count += this.assetValidationMessages.size();
    }

    public int getWarningMessageCount() {
        return this.getMessageCount(UITitleValidationMessageType.Warning);
    }

    public int getInformationMessageCount() {
        return this.getMessageCount(UITitleValidationMessageType.Information);
    }

    private int getMessageCount(UITitleValidationMessageType messageType) {
        int count = 0;
        for (UITitleValidationMessage message : this.titleValidationMessages) {
            if (!messageType.equals((Object)message.getMessageType())) continue;
            ++count;
        }
        return count;
    }

    private static enum ViewType {
        INFO,
        ERROR;

    }
}

