/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.mso;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UIRuleActionChange;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UiMso;
import com.tandbergtv.cms.portal.content.client.title.service.IRulesPreviewService;
import com.tandbergtv.cms.portal.content.client.title.service.IRulesPreviewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleValidationViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.rules.RulesPreviewTab;
import com.tandbergtv.cms.portal.ui.title.client.NormalizationActionConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import java.util.ArrayList;
import java.util.List;

public class MSORulesPreviewView
extends Composite {
    private FlexTable ruleTable;
    private String headerStyle = "mso-t-header";
    private HorizontalPanel contentPanel;
    private SimplePanel mainPanel;
    private ScrollPanel msoScroll;
    private ScrollPanel ruleScroll;
    private CellList<String> cellList;
    private IRulesPreviewServiceAsync rulesService = (IRulesPreviewServiceAsync)GWT.create(IRulesPreviewService.class);
    private NormalizationActionConstants actionConstants = (NormalizationActionConstants)GWT.create(NormalizationActionConstants.class);
    private List<UiMso> msoList = new ArrayList<UiMso>();
    private RulesPreviewTab rulesPreviewTab = null;
    private Long currentSiteTitleId;
    private Integer currentRuleSetId;

    public MSORulesPreviewView(RulesPreviewTab rulesPreviewTab) {
        this.rulesPreviewTab = rulesPreviewTab;
        this.mainPanel = new SimplePanel();
        this.contentPanel = new HorizontalPanel();
        this.msoScroll = new ScrollPanel();
        this.ruleScroll = new ScrollPanel();
        this.ruleTable = new FlexTable();
        TextCell textCell = new TextCell();
        this.cellList = new CellList((Cell)textCell);
        this.initWidget((Widget)this.mainPanel);
        this.buildTableHeader(this.ruleTable);
        this.addStyleName("ContentClassEditView");
        this.msoScroll.addStyleName("msoRulesleftScrollContainer");
        this.ruleScroll.addStyleName("MetadataTabContainer");
        this.msoScroll.add(this.cellList);
        this.msoScroll.setWidth("250px");
        this.ruleScroll.add((Widget)this.ruleTable);
        this.contentPanel.add((Widget)this.msoScroll);
        this.contentPanel.add((Widget)this.ruleScroll);
        this.contentPanel.setCellWidth((Widget)this.msoScroll, "250px");
        this.mainPanel.add((Widget)this.contentPanel);
        this.contentPanel.setCellHorizontalAlignment((Widget)this.msoScroll, HasHorizontalAlignment.ALIGN_LEFT);
        this.contentPanel.setCellHorizontalAlignment((Widget)this.ruleScroll, HasHorizontalAlignment.ALIGN_LEFT);
    }

    public void buildUI(List<UiMso> result) {
        this.msoList = result;
        if (this.msoList != null && !this.msoList.isEmpty()) {
            String defMso = this.msoList.get(0).getMsoName();
            this.updateRuleChangesPanel(defMso, this.msoList);
            this.cellList.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
            final SingleSelectionModel selectionModel = new SingleSelectionModel();
            this.cellList.setSelectionModel((SelectionModel)selectionModel);
            selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

                public void onSelectionChange(SelectionChangeEvent event) {
                    String selectedMso = (String)selectionModel.getSelectedObject();
                    if (selectedMso != null) {
                        MSORulesPreviewView.this.updateRuleChangesPanel(selectedMso, MSORulesPreviewView.this.msoList);
                    }
                }
            });
            this.cellList.setRowCount(this.msoList.size());
            this.cellList.setRowData(0, this.getMsoList(result));
            selectionModel.setSelected((Object)this.msoList.get(0).getMsoName(), true);
        }
    }

    private void updateRuleChangesPanel(String selectedMso, List<UiMso> msoList) {
        Integer msoId = this.getMsoId(selectedMso, msoList);
        this.rulesPreviewTab.getTitleView().showMessage(null);
        if (this.currentRuleSetId != null) {
            this.rulesService.getMsoRuleSet(this.currentSiteTitleId, this.currentRuleSetId, msoId, new AsyncCallback<List<UIRuleActionChange>>(){

                public void onFailure(Throwable caught) {
                    MSORulesPreviewView.this.showError(caught.getMessage());
                }

                public void onSuccess(List<UIRuleActionChange> result) {
                    if (result != null && !result.isEmpty()) {
                        MSORulesPreviewView.this.buildTable(result);
                    } else {
                        MSORulesPreviewView.this.showInfo("No overrides was found.");
                    }
                }
            });
        } else {
            this.rulesService.getAllMSORuleSets(this.currentSiteTitleId, msoId, new AsyncCallback<List<UIRuleActionChange>>(){

                public void onFailure(Throwable caught) {
                    MSORulesPreviewView.this.showError(caught.getMessage());
                }

                public void onSuccess(List<UIRuleActionChange> result) {
                    if (result != null && !result.isEmpty()) {
                        MSORulesPreviewView.this.buildTable(result);
                    } else {
                        MSORulesPreviewView.this.ruleTable.removeAllRows();
                        MSORulesPreviewView.this.buildTableHeader(MSORulesPreviewView.this.ruleTable);
                        MSORulesPreviewView.this.showInfo("No overrides was found.");
                    }
                }
            });
        }
    }

    private void buildTable(List<UIRuleActionChange> changeList) {
        this.refresh();
        int row = 1;
        this.ruleTable.removeAllRows();
        this.buildTableHeader(this.ruleTable);
        for (UIRuleActionChange change : changeList) {
            this.setTableRow(this.ruleTable, row, change);
            ++row;
        }
    }

    private void refresh() {
    }

    private void setTableRow(FlexTable ruleTable, int row, UIRuleActionChange change) {
        ruleTable.setWidget(row, 0, (Widget)new Hyperlink(change.getRuleSetName(), "Rules.MsoOverride?id=" + change.getRuleSetId()));
        ruleTable.setWidget(row, 1, (Widget)new Label(change.getFieldName()));
        ruleTable.setWidget(row, 2, (Widget)new Label(this.actionConstants.getString(change.getActionDisplayNameKey())));
        ruleTable.setWidget(row, 3, (Widget)new Label(change.getFrom()));
        ruleTable.setWidget(row, 4, (Widget)new Label(change.getTo()));
        ruleTable.getRowFormatter().setStyleName(row, "mso-t-body");
        int i = 0;
        while (i <= 4) {
            ruleTable.getCellFormatter().setHorizontalAlignment(row, i, HasHorizontalAlignment.ALIGN_CENTER);
            ++i;
        }
    }

    private Integer getMsoId(String selectedMso, List<UiMso> msoList) {
        if (msoList != null) {
            for (UiMso mso : msoList) {
                if (!mso.getMsoName().equalsIgnoreCase(selectedMso)) continue;
                return mso.getMsoId();
            }
        }
        return null;
    }

    private List<String> getMsoList(List<UiMso> result) {
        ArrayList<String> msos = new ArrayList<String>();
        if (result != null) {
            for (UiMso mso : result) {
                msos.add(mso.getMsoName());
            }
        }
        return msos;
    }

    private void buildTableHeader(FlexTable ruleTable) {
        ruleTable.setWidth("100%");
        ruleTable.setWidget(0, 0, (Widget)new LabelWidget("Rule Set Name"));
        ruleTable.setWidget(0, 1, (Widget)new LabelWidget("Field Name"));
        ruleTable.setWidget(0, 2, (Widget)new LabelWidget("Action"));
        ruleTable.setWidget(0, 3, (Widget)new LabelWidget("Original Value"));
        ruleTable.setWidget(0, 4, (Widget)new LabelWidget("Override Value"));
        ruleTable.getRowFormatter().addStyleName(0, this.headerStyle);
        int i = 0;
        while (i <= 4) {
            ruleTable.getCellFormatter().addStyleName(0, i, "content-AssetContentTable-cell");
            ruleTable.getCellFormatter().addStyleName(0, i, "content-AssetContentTable-cell-header");
            Widget widget = ruleTable.getWidget(0, i);
            if (widget instanceof LabelWidget) {
                widget.addStyleName("content-AssetContentTable-header-text");
            }
            ++i;
        }
        ruleTable.getRowFormatter().addStyleName(0, "content-AssetContentTable-row");
        ruleTable.getRowFormatter().addStyleName(0, "content-AssetContentTable-row-header");
    }

    public void setCurrentSiteTitleId(Long siteTitleId) {
        this.currentSiteTitleId = siteTitleId;
    }

    public void setCurrentRuleSetId(Integer ruleSetId) {
        this.currentRuleSetId = ruleSetId;
    }

    public void showError(String message) {
        TitleValidationViewInput input = new TitleValidationViewInput();
        input.setErrorHeader(message);
        this.rulesPreviewTab.getTitleView().showMessage(input);
    }

    public void showInfo(String message) {
        TitleValidationViewInput input = new TitleValidationViewInput();
        input.setInfoHeader(message);
        this.rulesPreviewTab.getTitleView().showMessage(input);
    }
}

