/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.msooverrideshistory;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleMSOOverridesHistoryService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleMSOOverridesHistoryServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.msooverrideshistory.MSOOverridesHistoryTab;
import com.tandbergtv.cms.portal.content.client.title.view.msooverrideshistory.OverridesHistoryListPanel;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.MSOsPanel;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.events.MSOSelectedEvent;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.events.MSOSelectedEventHandler;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import java.util.List;
import java.util.Map;

public class MSOOverridesHistoryPanel
extends Composite
implements MSOSelectedEventHandler {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    Label errorLabel;
    @UiField
    MSOsPanel msosPanel;
    @UiField
    OverridesHistoryListPanel overridesHistoryListPanel;
    private BusyIndicator busyIndicator;
    private ITitleMSOOverridesHistoryServiceAsync titleMSOOverridesHistoryService = (ITitleMSOOverridesHistoryServiceAsync)GWT.create(ITitleMSOOverridesHistoryService.class);
    private Long siteTitleId;

    public MSOOverridesHistoryPanel() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.msosPanel.setEventBus(MSOOverridesHistoryTab.getEventBus());
        MSOOverridesHistoryTab.getEventBus().addHandler(MSOSelectedEvent.TYPE, (EventHandler)this);
        this.busyIndicator = new BusyIndicator();
    }

    public MSOOverridesHistoryPanel(Map<String, String> info) {
        this();
    }

    public void refresh(final Long siteTitleId) {
        this.clearErrorMessage();
        this.showBusyIndicator();
        this.siteTitleId = siteTitleId;
        this.titleMSOOverridesHistoryService.getMSOs(siteTitleId, (AsyncCallback<List<UIMSO>>)new NeptuneAsyncCallback<List<UIMSO>>(){

            public void onNeptuneFailure(Throwable caught) {
                MSOOverridesHistoryPanel.this.hideBusyIndicator();
                String errMsg = "Exception occurred while getting MSOs for siteTitleId : " + siteTitleId + " : " + caught.getLocalizedMessage();
                MSOOverridesHistoryPanel.this.showErrorMessage(errMsg);
            }

            public void onNeptuneSuccess(List<UIMSO> result) {
                MSOOverridesHistoryPanel.this.setMSOs(result);
                MSOOverridesHistoryPanel.this.hideBusyIndicator();
            }
        });
    }

    public void msoSelected(MSOSelectedEvent event) {
        this.overridesHistoryListPanel.setUiMSO(event.getUiMSO());
        this.overridesHistoryListPanel.setSiteTitleId(this.siteTitleId);
        this.overridesHistoryListPanel.refresh(null);
    }

    public void setMSOs(List<UIMSO> uiMSOs) {
        this.msosPanel.setMSOs(uiMSOs);
    }

    void clearErrorMessage() {
        this.errorLabel.setText("");
    }

    void showErrorMessage(String errMsg) {
        this.errorLabel.setText(errMsg);
    }

    private void showBusyIndicator() {
        this.busyIndicator.center();
    }

    private void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    static interface MyUiBinder
    extends UiBinder<Widget, MSOOverridesHistoryPanel> {
    }
}

