/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.msooverrideshistory;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleMSOOverridesHistoryService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleMSOOverridesHistoryServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.msooverrideshistory.OverridesHistoryListPanel;
import com.tandbergtv.cms.portal.content.client.title.view.msooverrideshistory.UIMSOOverrideHistory;
import com.tandbergtv.cms.portal.content.client.title.view.msooverrideshistory.UIMSOOverrideHistoryRecord;
import com.tandbergtv.cms.portal.content.client.title.view.msooverrideshistory.UIMSOOverridesHistoryRequest;
import com.tandbergtv.cms.portal.content.client.title.view.msooverrideshistory.UIMSOOverridesHistoryResponse;
import com.tandbergtv.cms.portal.ui.title.client.NormalizationActionConstants;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.List;

public class OverridesHistoryListDataProvider
implements DataProvider<Long, UIMSOOverrideHistoryRecord> {
    private static final String FIELD_COLUMN = "fieldXPath";
    private static final String ACTION_COLUMN = "actionName";
    private static final String SEARCH_VALUE_COLUMN = "searchValue";
    private static final String REPLACEMENT_VALUE_COLUMN = "replacementValue";
    private static final String TIME_APPLIED_COLUMN = "timeApplied";
    private static final String DISTRIBUTED_VERSION_COLUMN = "distributedVersion";
    private OverridesHistoryListPanel view;
    private ITitleMSOOverridesHistoryServiceAsync titleMSOOverridesHistoryService = (ITitleMSOOverridesHistoryServiceAsync)GWT.create(ITitleMSOOverridesHistoryService.class);
    private TitleViewMessages messages = (TitleViewMessages)GWT.create(TitleViewMessages.class);
    private List<Column<?, UIMSOOverrideHistoryRecord>> columns;
    private ColumnBase<String, UIMSOOverrideHistoryRecord> fieldColumn;
    private ColumnBase<String, UIMSOOverrideHistoryRecord> actionColumn;
    private ColumnBase<String, UIMSOOverrideHistoryRecord> searchValueColumn;
    private ColumnBase<String, UIMSOOverrideHistoryRecord> replacementValueColumn;
    private ColumnBase<String, UIMSOOverrideHistoryRecord> timeAppliedColumn;
    private ColumnBase<String, UIMSOOverrideHistoryRecord> distributedVersionColumn;
    private PageFeatureImpl pageFeature;
    private SortFeatureImpl<Long, UIMSOOverrideHistoryRecord> sortFeature;
    private NormalizationActionConstants actionConstants = (NormalizationActionConstants)GWT.create(NormalizationActionConstants.class);

    public OverridesHistoryListDataProvider(OverridesHistoryListPanel view) {
        this.view = view;
        this.columns = new ArrayList();
        this.fieldColumn = new ColumnBase<String, UIMSOOverrideHistoryRecord>(FIELD_COLUMN, this.messages.fieldNameColumn()){

            public View<String> getView(UIMSOOverrideHistoryRecord record) {
                return new LabelStringView(record.getUiMSOOverrideHistory().getFieldDisplayName());
            }
        };
        this.fieldColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UIMSOOverrideHistoryRecord>)this.fieldColumn);
        this.actionColumn = new ColumnBase<String, UIMSOOverrideHistoryRecord>(ACTION_COLUMN, this.messages.action()){

            public View<String> getView(UIMSOOverrideHistoryRecord record) {
                return new LabelStringView(OverridesHistoryListDataProvider.this.actionConstants.getString(record.getUiMSOOverrideHistory().getActionName()));
            }
        };
        this.actionColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UIMSOOverrideHistoryRecord>)this.actionColumn);
        this.searchValueColumn = new ColumnBase<String, UIMSOOverrideHistoryRecord>(SEARCH_VALUE_COLUMN, this.messages.originalValueColumn()){

            public View<String> getView(UIMSOOverrideHistoryRecord record) {
                return new LabelStringView(record.getUiMSOOverrideHistory().getSearchValue());
            }
        };
        this.searchValueColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UIMSOOverrideHistoryRecord>)this.searchValueColumn);
        this.replacementValueColumn = new ColumnBase<String, UIMSOOverrideHistoryRecord>(REPLACEMENT_VALUE_COLUMN, this.messages.overrideValueColumn()){

            public View<String> getView(UIMSOOverrideHistoryRecord record) {
                return new LabelStringView(record.getUiMSOOverrideHistory().getReplacementValue());
            }
        };
        this.replacementValueColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UIMSOOverrideHistoryRecord>)this.replacementValueColumn);
        this.timeAppliedColumn = new ColumnBase<String, UIMSOOverrideHistoryRecord>(TIME_APPLIED_COLUMN, this.messages.timeAppliedColumn()){

            public View<String> getView(UIMSOOverrideHistoryRecord record) {
                return new LabelStringView(record.getUiMSOOverrideHistory().getTimeApplied());
            }
        };
        this.timeAppliedColumn.setCellStyle("nwt-TableColumnPanel-dataCell-date");
        this.columns.add((Column<?, UIMSOOverrideHistoryRecord>)this.timeAppliedColumn);
        this.distributedVersionColumn = new ColumnBase<String, UIMSOOverrideHistoryRecord>(DISTRIBUTED_VERSION_COLUMN, this.messages.distributedVersionColumn()){

            public View<String> getView(UIMSOOverrideHistoryRecord record) {
                return new LabelStringView(record.getUiMSOOverrideHistory().getDistributedVersion());
            }
        };
        this.distributedVersionColumn.setCellStyle("nwt-TableColumnPanel-dataCell-numeric");
        this.columns.add((Column<?, UIMSOOverrideHistoryRecord>)this.distributedVersionColumn);
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public List<Column<?, UIMSOOverrideHistoryRecord>> getColumns() {
        return this.columns;
    }

    public void getRecords(final AsyncCallback<List<UIMSOOverrideHistoryRecord>> callback) {
        Long siteTitleId = this.view.getSiteTitleId();
        UIMSO uiMSO = this.view.getUiMSO();
        if (siteTitleId != null && uiMSO != null) {
            this.view.handleGetRecordsRequest();
            UIMSOOverridesHistoryRequest uiMSOOverridesHistoryRequest = new UIMSOOverridesHistoryRequest();
            uiMSOOverridesHistoryRequest.setMsoId(uiMSO.getMsoId());
            uiMSOOverridesHistoryRequest.setSiteTitleId(siteTitleId);
            uiMSOOverridesHistoryRequest.setStartIndex((this.pageFeature.getPageNumber() - 1) * this.pageFeature.getPageSize());
            uiMSOOverridesHistoryRequest.setNumRecords(this.pageFeature.getPageSize());
            uiMSOOverridesHistoryRequest.setSortColumnName(this.sortFeature.getSortColumnName());
            uiMSOOverridesHistoryRequest.setAscending(this.sortFeature.isAscending());
            this.titleMSOOverridesHistoryService.getMSOOverridesHistory(uiMSOOverridesHistoryRequest, (AsyncCallback<UIMSOOverridesHistoryResponse>)new NeptuneAsyncCallback<UIMSOOverridesHistoryResponse>(){

                public void onNeptuneFailure(Throwable caught) {
                    OverridesHistoryListDataProvider.this.pageFeature.setRecordCount(-1);
                    callback.onFailure(caught);
                    OverridesHistoryListDataProvider.this.view.handleGetRecordsFailureResponse(caught);
                }

                public void onNeptuneSuccess(UIMSOOverridesHistoryResponse result) {
                    ArrayList<UIMSOOverrideHistoryRecord> records = null;
                    if (result != null) {
                        records = new ArrayList<UIMSOOverrideHistoryRecord>();
                        for (UIMSOOverrideHistory uiMSOOverrideHistory : result.getUiMSOOverrideHistories()) {
                            UIMSOOverrideHistoryRecord record = new UIMSOOverrideHistoryRecord(uiMSOOverrideHistory);
                            records.add(record);
                        }
                        OverridesHistoryListDataProvider.this.pageFeature.setRecordCount(result.getCount());
                    }
                    callback.onSuccess(records);
                    OverridesHistoryListDataProvider.this.view.handleGetRecordsSuccessResponse(records);
                }
            });
        }
    }

    public void getRecord(Long key, AsyncCallback<UIMSOOverrideHistoryRecord> callback) {
        throw new UnsupportedOperationException();
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    public boolean isCheckboxEnabled() {
        return false;
    }

    public void setPageFeature(PageFeatureImpl pageFeature) {
        this.pageFeature = pageFeature;
    }

    public ColumnBase<String, UIMSOOverrideHistoryRecord> getDefaultSortColumn() {
        return this.searchValueColumn;
    }

    public SortOrder getDefaultSortOrder() {
        return SortOrder.ASCENDING;
    }

    public List<Column<?, UIMSOOverrideHistoryRecord>> getSortableColumns() {
        ArrayList sortableColumns = new ArrayList();
        sortableColumns.add((Column<?, UIMSOOverrideHistoryRecord>)this.searchValueColumn);
        sortableColumns.add((Column<?, UIMSOOverrideHistoryRecord>)this.replacementValueColumn);
        sortableColumns.add((Column<?, UIMSOOverrideHistoryRecord>)this.timeAppliedColumn);
        sortableColumns.add((Column<?, UIMSOOverrideHistoryRecord>)this.distributedVersionColumn);
        return sortableColumns;
    }

    public void setSortFeature(SortFeatureImpl<Long, UIMSOOverrideHistoryRecord> sortFeature) {
        this.sortFeature = sortFeature;
    }
}

