/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.offers;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.cms.portal.content.client.model.UISearchResult;
import com.tandbergtv.cms.portal.content.client.model.UISearchResultRec;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.SearchResultTableColumn;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.service.IOffersTitleService;
import com.tandbergtv.cms.portal.content.client.title.service.IOffersTitleServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.offers.TitleOfferPanel;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.PushButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AnchorTokenizer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TitleOfferDataProvider
implements DataProvider<Long, TitleRecord> {
    private TitleOfferPanel parent;
    private List<Column<?, TitleRecord>> columns = new ArrayList();
    public static final String TITLE_ID_COLUMN_NAME = "titleId";
    public static final String DELETE_COLUMN_NAME = "deleteButton";
    public static final String CELL_DELETE_COLUMN_STYLE = "content-cell-body-delete";
    public static final String DELETE_BUTTON_ENABLE_STYLE = "delete-button-enable";
    public static final String DELETE_BUTTON_DISABLE_STYLE = "delete-button-disable";
    private IOffersTitleServiceAsync offersTitleService = (IOffersTitleServiceAsync)GWT.create(IOffersTitleService.class);
    private ITitleViewServiceAsync viewService = (ITitleViewServiceAsync)GWT.create(ITitleViewService.class);
    private ContentConstants displayConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private ContentMessages displayMessages = (ContentMessages)GWT.create(ContentMessages.class);
    private UITitle uiTitle;
    private Timer timer;

    public TitleOfferDataProvider(TitleOfferPanel parent, Timer timer) {
        this.parent = parent;
        this.timer = timer;
    }

    public void init(final AsyncCallback<Void> callback) {
        this.parent.getTab().showBusyIndicator();
        this.offersTitleService.getRefTitleSearchColumns((AsyncCallback<List<UiColumn>>)new NeptuneAsyncCallback<List<UiColumn>>(){

            public void onNeptuneFailure(Throwable caught) {
                TitleOfferDataProvider.this.parent.getTab().hideBusyIndicator();
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(List<UiColumn> result) {
                TitleOfferDataProvider.this.parent.getTab().hideBusyIndicator();
                TitleOfferDataProvider.this.initializeColumns(result);
                callback.onSuccess(null);
            }
        });
    }

    private void initializeColumns(List<UiColumn> searchResultsColumns) {
        this.columns.add(this.prepareTitleIdColumn());
        for (UiColumn uiColumn : searchResultsColumns) {
            SearchResultTableColumn column = new SearchResultTableColumn(uiColumn, null);
            column.setCellStyle(column.getColumnCellStyle());
            this.columns.add((Column<?, TitleRecord>)column);
        }
        this.columns.add(this.prepareDereferenceColumn());
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public List<Column<?, TitleRecord>> getColumns() {
        return this.columns;
    }

    public void getRecords(final AsyncCallback<List<TitleRecord>> callback) {
        Long titleId = this.getTitleId();
        this.parent.getTab().showBusyIndicator();
        this.viewService.getTitle(titleId, (AsyncCallback<UITitle>)new NeptuneAsyncCallback<UITitle>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
                Window.alert((String)caught.getMessage());
            }

            public void onNeptuneSuccess(UITitle result) {
                TitleOfferDataProvider.this.setUiTitle(result);
                boolean isSiteTitle = result.getOverview().isSiteTitle();
                TitleOfferDataProvider.this.offersTitleService.getOfferTitles(isSiteTitle, result.getId(), (AsyncCallback<UISearchResult>)new NeptuneAsyncCallback<UISearchResult>(){

                    public void onNeptuneFailure(Throwable caught) {
                        TitleOfferDataProvider.this.parent.getTab().hideBusyIndicator();
                        callback.onFailure(caught);
                        TitleOfferDataProvider.this.parent.handleGetRecordsFailure(caught);
                    }

                    public void onNeptuneSuccess(UISearchResult searchResult) {
                        TitleOfferDataProvider.this.parent.getTab().hideBusyIndicator();
                        ArrayList<TitleRecord> records = new ArrayList<TitleRecord>();
                        if (searchResult.getTitles() == null) {
                            return;
                        }
                        for (UISearchResultRec t : searchResult.getTitles()) {
                            records.add(new TitleRecord(t));
                        }
                        callback.onSuccess(records);
                        TitleOfferDataProvider.this.parent.handleGetRecordsSuccess(searchResult, records.size());
                    }
                });
            }
        });
    }

    public UITitle getUiTitle() {
        return this.uiTitle;
    }

    public void setUiTitle(UITitle uiTitle) {
        this.uiTitle = uiTitle;
    }

    protected Long getTitleId() {
        return this.parent.getTab().getViewInput().getTitleId();
    }

    public void getRecord(Long key, AsyncCallback<TitleRecord> callback) {
        throw new UnsupportedOperationException();
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    public boolean isCheckboxEnabled() {
        return false;
    }

    private Column<String, TitleRecord> prepareTitleIdColumn() {
        ColumnBase<String, TitleRecord> column = null;
        String displayName = "Title ID";
        column = new ColumnBase<String, TitleRecord>(TITLE_ID_COLUMN_NAME, displayName){

            public View<String> getView(TitleRecord record) {
                return new TitleHyperLinkView(record.getTitle().getId());
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        return column;
    }

    private Column<Widget, TitleRecord> prepareDereferenceColumn() {
        ColumnBase<Widget, TitleRecord> column = null;
        String displayName = this.parent.getTab().getViewMessages().dereferenceButtonText();
        column = new ColumnBase<Widget, TitleRecord>(null, displayName){

            public View<Widget> getView(TitleRecord record) {
                return new DereferenceButtonView(record.getKey());
            }
        };
        column.setCellStyle(CELL_DELETE_COLUMN_STYLE);
        return column;
    }

    public void setDisplayColumns(List<Column<?, TitleRecord>> columns) {
        this.columns = columns;
    }

    private Widget buildDereferenceButton(final Long offerTitleId) {
        boolean enabled = true;
        String styleName = DELETE_BUTTON_ENABLE_STYLE;
        ImageWidget deleteImage = new ImageWidget("cms_contentmgmt_ui/resources/images/title_metadata_delete.gif");
        if (this.getUiTitle().getOverview().isSiteTitle()) {
            deleteImage = new ImageWidget("cms_contentmgmt_ui/resources/images/title_metadata_delete_disable.gif");
            styleName = DELETE_BUTTON_DISABLE_STYLE;
            enabled = false;
        }
        deleteImage.addStyleName(styleName);
        PushButtonWidget button = new PushButtonWidget(deleteImage);
        button.addStyleName("content-AssetContent-deleteButton");
        button.setEnabled(enabled);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleOfferDataProvider.this.handleDereferenceOfferTitle(offerTitleId);
            }
        });
        return button;
    }

    private void handleDereferenceOfferTitle(final Long offerTitleId) {
        final PopupContainer confirmation = new PopupContainer(false, true);
        VerticalContainer popContainer = new VerticalContainer();
        popContainer.add((Widget)new LabelWidget(this.displayMessages.confirmationMessage(this.displayConstants.dereferencedAllConfirmation())));
        HorizontalContainer buttonContainer = new HorizontalContainer();
        buttonContainer.addStyleName("cms_button_container");
        ButtonWidget yesButton = new ButtonWidget(this.displayConstants.confirmationYes());
        yesButton.removeStyleName("gwt-Button");
        yesButton.addStyleName("ebBtn");
        yesButton.addStyleName("ebBtn_color_green");
        yesButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                confirmation.hide();
                TitleOfferDataProvider.this.parent.getTab().showBusyIndicator();
                TitleOfferDataProvider.this.offersTitleService.removeTitleFromOffer(TitleOfferDataProvider.this.getTitleId(), offerTitleId, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                    public void onNeptuneFailure(Throwable caught) {
                        TitleOfferDataProvider.this.parent.getTab().hideBusyIndicator();
                        TitleOfferDataProvider.this.parent.getTab().showErrorPanel(caught.getLocalizedMessage());
                    }

                    public void onNeptuneSuccess(Void result) {
                        TitleOfferDataProvider.this.timer.schedule(1000);
                    }
                });
            }
        });
        buttonContainer.add((Widget)yesButton);
        ButtonWidget noButton = new ButtonWidget(this.displayConstants.confirmationNo());
        noButton.removeStyleName("gwt-Button");
        noButton.addStyleName("ebBtn");
        noButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                confirmation.hide();
            }
        });
        buttonContainer.add((Widget)noButton);
        popContainer.add((Widget)buttonContainer);
        popContainer.setCellHorizontalAlignment((Widget)buttonContainer, HasHorizontalAlignment.ALIGN_CENTER);
        confirmation.add((Widget)popContainer);
        confirmation.center();
        confirmation.show();
    }

    private class DereferenceButtonView
    implements View<Widget> {
        Long titleId;

        public DereferenceButtonView(Long titleId) {
            this.titleId = titleId;
        }

        public Widget getWidget() {
            return TitleOfferDataProvider.this.buildDereferenceButton(this.titleId);
        }

        public String getStyleName() {
            return "content-AssetContent-deleteButton";
        }

        public void release() {
        }
    }

    private class TitleHyperLinkView
    implements View<String> {
        long titleId;

        public TitleHyperLinkView(long titleId) {
            this.titleId = titleId;
        }

        public Widget getWidget() {
            HashMap<String, String> anchorTokens = new HashMap<String, String>();
            anchorTokens.put("Id", String.valueOf(this.titleId));
            anchorTokens.put("returnAnchor", History.getToken());
            String token = "Content.Search." + new AnchorTokenizer().buildAnchor(anchorTokens);
            Hyperlink hyperlink = new Hyperlink(String.valueOf(this.titleId), token);
            return hyperlink;
        }

        public String getStyleName() {
            return "table-data-link";
        }

        public void release() {
        }
    }
}

