/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.offers;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UISearchResult;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.content.client.title.service.ReadDeletedTitleException;
import com.tandbergtv.cms.portal.content.client.title.view.offers.TitleOfferDataProvider;
import com.tandbergtv.cms.portal.content.client.title.view.offers.TitleOfferTab;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class TitleOfferPanel
extends SimpleContainer {
    TitleOfferDataProvider dataProvider;
    private TitleOfferTab parent;
    private Table<Long, TitleRecord> offerTitleTable;
    private ScrollContainer scrollContainer;
    private VerticalContainer mainContainer;
    private static final String STYLE_LOADING_LABEL = "content-TitleOfferPanel-loadingMessage";
    private static final String STYLE_OFFER_TABLE = "content-TitleOfferPanel-progressTable";
    private static final String STYLE_OFFER = "offer";
    private static final String STYLE_OFFER_PANEL = "content-TitleOfferPanel";
    private HandlerRegistration windowRegistration = null;
    private List<Widget> offsettingWidgets = new ArrayList<Widget>();
    private Timer timer;

    public TitleOfferPanel(TitleOfferTab parent) {
        this.parent = parent;
        this.timer = new Timer(){

            public void run() {
                TitleOfferPanel.this.refresh();
            }
        };
    }

    protected void initialize() {
        this.offerTitleTable = new Table((DataProvider)this.dataProvider);
        this.offerTitleTable.addRefreshListener(new Table.RefreshListener(){

            public void updated() {
                TitleOfferPanel.this.resizeScrollContainer();
            }
        });
        this.offerTitleTable.addStyleName(STYLE_OFFER_TABLE);
        this.scrollContainer = new ScrollContainer();
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setStylePrimaryName(STYLE_OFFER_PANEL);
        this.mainContainer.addStyleDependentName(STYLE_OFFER);
        this.scrollContainer.add(this.offerTitleTable);
        this.mainContainer.add((Widget)this.scrollContainer);
        LabelWidget blankLabel = new LabelWidget("");
        this.setWidget((Widget)blankLabel);
    }

    private void showLoadingMessage() {
        String message = this.getTab().getViewMessages().offerLoading();
        LabelWidget label = new LabelWidget(message);
        label.addStyleName(STYLE_LOADING_LABEL);
        this.setWidget((Widget)label);
    }

    public void refresh() {
        this.showLoadingMessage();
        if (!this.offerTitleTable.isInitialized()) {
            this.offerTitleTable.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                }

                public void onNeptuneSuccess(Void result) {
                    TitleOfferPanel.this.offerTitleTable.refresh();
                }
            });
        } else {
            this.offerTitleTable.refresh();
        }
    }

    public void initDataProvider() {
        this.dataProvider = new TitleOfferDataProvider(this, this.timer);
        this.dataProvider.init((AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)caught.getLocalizedMessage());
            }

            public void onNeptuneSuccess(Void result) {
                TitleOfferPanel.this.initialize();
            }
        });
    }

    public void addOffsettingWidget(Widget widget) {
        this.offsettingWidgets.add(widget);
    }

    protected void onLoad() {
        super.onLoad();
        this.offsettingWidgets.add(this.getTab().getTitleView().getMessageViewWidget());
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                TitleOfferPanel.this.resizeScrollContainer();
            }
        });
        this.resizeScrollContainer();
    }

    protected void onUnload() {
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        super.onUnload();
    }

    private void resizeScrollContainer() {
        if (this.scrollContainer == null) {
            return;
        }
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                int height = Window.getClientHeight() - 280;
                for (Widget w : TitleOfferPanel.this.offsettingWidgets) {
                    height -= w.getOffsetHeight();
                }
                TitleOfferPanel.this.scrollContainer.setHeight(String.valueOf(height) + "px");
            }
        });
    }

    void handleGetRecordsSuccess(UISearchResult result, int recordCount) {
        if (recordCount == 0) {
            String message = this.getTab().getViewMessages().offerNotPresent();
            LabelWidget label = new LabelWidget(message);
            this.setWidget((Widget)label);
        } else {
            this.setWidget((Widget)this.mainContainer);
        }
        this.getTab().updateTitleHeader(this.dataProvider.getUiTitle().getOverview());
        this.getTab().hideBusyIndicator();
        this.getTab().markUpdated();
    }

    void handleGetRecordsFailure(Throwable caught) {
        if (caught instanceof ReadDeletedTitleException) {
            this.getTab().showSevereError(caught.getMessage());
        } else {
            TitleOfferTab tab = this.getTab();
            String message = tab.getViewMessages().offerFetchFailure(caught.getMessage());
            tab.showErrorPanel(message);
        }
        this.getTab().hideBusyIndicator();
    }

    protected TitleOfferTab getTab() {
        return this.parent;
    }
}

