/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.preview;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.XMLParser;
import com.tandbergtv.cms.portal.content.client.title.model.UIActionTitle;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.HtmlorXmlDisplayHelper;
import com.tandbergtv.cms.portal.content.client.title.view.TitleErrorPanel;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.preview.TitlePreviewWidgetInput;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;
import com.tandbergtv.cms.portal.ui.title.client.service.specification.IUISpecificationManagerAsync;
import com.tandbergtv.cms.portal.ui.title.client.service.specification.UISpecificationClientManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.FrameWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HTMLWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DockContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.HasViewCancelHandlers;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelHandler;
import java.util.List;

public class TitlePreviewWidget
extends Composite
implements HasViewCancelHandlers {
    private final SimpleContainer container;
    private final TitleViewMessages messages;
    private DockContainer contents;
    private HorizontalContainer controlsContents;
    private ListBoxWidget<UIAssetSpecificationListItem> specificationBox;
    private LabelWidget descriptionLabel;
    private SimpleContainer previewResultContainer;
    private FrameWidget previewFrame;
    private HTMLWidget previewFrameIe;
    private SimpleContainer buttonsContents;
    private ButtonWidget cancelButton;
    private BusyIndicator busyIndicator;
    private ITitleViewServiceAsync service = null;
    private HandlerRegistration windowRegistration = null;
    private Command resizeCommand;
    private TitlePreviewWidgetInput input;
    private IUISpecificationManagerAsync specificationManager;
    private static final String STYLE_NAME = "content-TitlePreviewWidget";
    private static final String STYLE_CONTROLS_PANEL = "content-TitlePreviewWidget-controls";
    private static final String STYLE_BUTTONS_PANEL = "content-TitlePreviewWidget-buttons";
    private static final String STYLE_SPEC_LISTBOX = "content-TitlePreviewWidget-specificationListBox";
    private static final String STYLE_DESCRIPTION_LABEL = "content-TitlePreviewWidget-descriptionLabel";
    private static final String STYLE_PREVIEW_RESULT_CONTAINER = "content-TitlePreviewWidget-resultContainer";
    private static final String STYLE_PREVIEW_LOADING_LABEL = "content-TitlePreviewWidget-previewLoadingLabel";
    private static final String STYLE_PREVIEW_FRAME_HOLDER = "content-TitlePreviewWidget-frameContainer";
    private static final String STYLE_PREVIEW_FRAME = "content-TitlePreviewWidget-frame";
    private static final String STYLE_PREVIEW_FRAME_IE = "content-TitlePreviewWidget-frame-ie";

    public TitlePreviewWidget(TitleViewMessages messages) {
        this.messages = messages;
        this.container = new SimpleContainer();
        this.initWidget((Widget)this.container);
        this.initialize();
    }

    public TitlePreviewWidgetInput getInput() {
        return this.input;
    }

    public void setInput(TitlePreviewWidgetInput input) {
        this.input = input;
    }

    private void initialize() {
        this.service = (ITitleViewServiceAsync)GWT.create(ITitleViewService.class);
        this.specificationManager = UISpecificationClientManager.getInstance();
        this.addStyleName(STYLE_NAME);
        this.busyIndicator = new BusyIndicator();
        this.contents = new DockContainer();
        this.controlsContents = new HorizontalContainer();
        this.controlsContents.addStyleName(STYLE_CONTROLS_PANEL);
        this.contents.add((Widget)this.controlsContents, DockPanel.NORTH);
        this.specificationBox = new ListBoxWidget();
        this.specificationBox.addStyleName(STYLE_SPEC_LISTBOX);
        this.specificationBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TitlePreviewWidget.this.handleSpecificationChange();
            }
        });
        this.controlsContents.add(this.specificationBox);
        this.descriptionLabel = new LabelWidget();
        this.descriptionLabel.addStyleName(STYLE_DESCRIPTION_LABEL);
        this.controlsContents.add((Widget)this.descriptionLabel);
        this.previewResultContainer = new SimpleContainer();
        this.previewResultContainer.addStyleName(STYLE_PREVIEW_RESULT_CONTAINER);
        this.resizeCommand = new Command(){

            public void execute() {
                TitlePreviewWidget.this.resizeFrame();
            }
        };
        this.contents.add((Widget)this.previewResultContainer, DockPanel.CENTER);
        this.buttonsContents = new SimpleContainer();
        this.buttonsContents.addStyleName(STYLE_BUTTONS_PANEL);
        this.contents.add((Widget)this.buttonsContents, DockPanel.SOUTH);
        this.cancelButton = new ButtonWidget(this.messages.cancelButton());
        this.cancelButton.removeStyleName("gwt-Button");
        this.cancelButton.addStyleName("ebBtn");
        this.cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitlePreviewWidget.this.handleCancelButtonClick();
            }
        });
        this.buttonsContents.setWidget((Widget)this.cancelButton);
    }

    public void refresh() {
        this.container.clear();
        this.specificationBox.clear();
        this.descriptionLabel.setText("");
        this.hidePreviewFrame();
        if (this.getInput() == null) {
            return;
        }
        if (this.getInput().getSpecifications() != null) {
            this.handleGetAllSpecificationsSuccess(this.getInput().getSpecifications());
        } else {
            this.busyIndicator.center();
            this.specificationManager.getPreviewSpecs((AsyncCallback)new NeptuneAsyncCallback<List<UIAssetSpecificationListItem>>(){

                public void onNeptuneSuccess(List<UIAssetSpecificationListItem> result) {
                    TitlePreviewWidget.this.handleGetAllSpecificationsSuccess(result);
                }

                public void onNeptuneFailure(Throwable caught) {
                    TitlePreviewWidget.this.handleGetAllSpecificationsFailure(caught);
                }
            });
        }
    }

    private void handleGetAllSpecificationsSuccess(List<UIAssetSpecificationListItem> result) {
        this.getInput().setSpecifications(result);
        this.addSpecifications();
        this.updateDescriptionLabel();
        this.container.setWidget((Widget)this.contents);
        this.busyIndicator.hide();
        this.performPreviewAction();
    }

    private void addSpecifications() {
        List<UIAssetSpecificationListItem> specs = this.getInput().getSpecifications();
        String selectedSpecificationName = this.getInput().getSelectedSpecification();
        UIAssetSpecificationListItem selectedSpecification = null;
        for (UIAssetSpecificationListItem spec : specs) {
            if ("TTV".equalsIgnoreCase(spec.getName())) continue;
            this.specificationBox.addItem(spec.getDisplayName(), (Object)spec);
            if (!spec.getName().equals(selectedSpecificationName)) continue;
            selectedSpecification = spec;
        }
        if (selectedSpecification != null) {
            this.specificationBox.setSelectedItem(selectedSpecification);
        }
    }

    private void updateDescriptionLabel() {
        String version = this.getInput().getTitle().getVersion();
        String description = version == null ? this.messages.previewTitleDescriptionLabel() : this.messages.previewTitleVersionDescriptionLabel(version);
        this.descriptionLabel.setText(description);
    }

    private void handleGetAllSpecificationsFailure(Throwable error) {
        this.busyIndicator.hide();
        String msg = this.messages.specificationNamesFetchFailure(error.getLocalizedMessage());
        TitleErrorPanel errorPanel = new TitleErrorPanel(msg, true);
        errorPanel.addViewCancelHandler(new ViewCancelHandler(){

            public void onCancel(ViewCancelEvent event) {
                TitlePreviewWidget.this.handleCancelButtonClick();
            }
        });
        errorPanel.addEventListener(new TitleErrorPanel.EventListener(){

            @Override
            public void onRefreshClicked(TitleErrorPanel panel) {
                TitlePreviewWidget.this.refresh();
            }
        });
        this.container.setWidget((Widget)errorPanel);
    }

    private void performPreviewAction() {
        this.hidePreviewFrame();
        if (this.getInput() == null) {
            return;
        }
        LabelWidget previewLoadingLabel = new LabelWidget();
        previewLoadingLabel.addStyleName(STYLE_PREVIEW_LOADING_LABEL);
        previewLoadingLabel.setText(this.messages.previewTitleLoadingMessage());
        this.previewResultContainer.setWidget((Widget)previewLoadingLabel);
        UIActionTitle title = this.getInput().getTitle();
        UIAssetSpecificationListItem specification = (UIAssetSpecificationListItem)this.specificationBox.getSelectedItem();
        String name = specification != null ? specification.getName() : null;
        this.busyIndicator.center();
        this.service.previewTitle(title, name, HtmlorXmlDisplayHelper.useHtml(), (AsyncCallback<String>)new NeptuneAsyncCallback<String>(){

            public void onNeptuneFailure(Throwable caught) {
                TitlePreviewWidget.this.handlePreviewTitleFailure(caught);
            }

            public void onNeptuneSuccess(String result) {
                TitlePreviewWidget.this.handlePreviewTitleSuccess(result);
            }
        });
    }

    private void handlePreviewTitleSuccess(String url) {
        this.showPreviewFrame(url);
        this.updateFrameSize();
        this.busyIndicator.hide();
    }

    private void handlePreviewTitleFailure(Throwable caught) {
        String error = caught.getLocalizedMessage();
        String message = this.messages.previewError(error);
        TitleErrorPanel errorPanel = new TitleErrorPanel(message);
        errorPanel.addEventListener(new TitleErrorPanel.EventListener(){

            @Override
            public void onRefreshClicked(TitleErrorPanel panel) {
                TitlePreviewWidget.this.refresh();
            }
        });
        this.previewResultContainer.setWidget((Widget)errorPanel);
        this.busyIndicator.hide();
    }

    private void showPreviewFrame(String previewURL) {
        this.previewFrame = new FrameWidget();
        this.previewFrame.addStyleName(STYLE_PREVIEW_FRAME);
        this.previewFrameIe = new HTMLWidget();
        this.previewFrameIe.addStyleName(STYLE_PREVIEW_FRAME);
        this.previewFrameIe.addStyleName(STYLE_PREVIEW_FRAME_IE);
        SimpleContainer frameHolder = new SimpleContainer();
        frameHolder.addStyleName(STYLE_PREVIEW_FRAME_HOLDER);
        if (Window.Navigator.getUserAgent().toLowerCase().contains("trident") || Window.Navigator.getUserAgent().toLowerCase().contains("msie")) {
            try {
                RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, previewURL);
                requestBuilder.sendRequest(null, new RequestCallback(){

                    public void onError(Request request, Throwable exception) {
                        exception.printStackTrace();
                    }

                    public void onResponseReceived(Request request, Response response) {
                        String res = response.getText().replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "");
                        Document messageDom = XMLParser.parse((String)res);
                        Node rootNode = messageDom.getFirstChild();
                        TitlePreviewWidget.this.previewFrameIe.setText(TitlePreviewWidget.this.formatXML(rootNode, "  "));
                    }
                });
            }
            catch (Exception E) {
                E.printStackTrace();
            }
            frameHolder.setWidget((Widget)this.previewFrameIe);
        } else {
            this.previewFrame.setUrl(previewURL);
            frameHolder.setWidget((Widget)this.previewFrame);
        }
        this.previewResultContainer.setWidget((Widget)frameHolder);
    }

    private void hidePreviewFrame() {
        this.previewResultContainer.clear();
        this.previewFrame = null;
        this.previewFrameIe = null;
    }

    public String formatXML(Node node, String tab_str) {
        String formatted = "";
        if (node.getNodeType() == 1) {
            String attributes = "";
            int k = 0;
            while (k < node.getAttributes().getLength()) {
                attributes = String.valueOf(attributes) + " " + node.getAttributes().item(k).getNodeName() + "=\"" + node.getAttributes().item(k).getNodeValue() + "\"";
                ++k;
            }
            formatted = String.valueOf(tab_str) + "<" + node.getNodeName() + attributes;
            if (node.getChildNodes().getLength() > 0) {
                formatted = String.valueOf(formatted) + ">\n";
            }
            int i = 0;
            while (i < node.getChildNodes().getLength()) {
                formatted = String.valueOf(formatted) + this.formatXML(node.getChildNodes().item(i), String.valueOf(tab_str) + "  ");
                ++i;
            }
            formatted = node.getChildNodes().getLength() > 0 ? String.valueOf(formatted) + tab_str + "</" + node.getNodeName() + ">\n" : String.valueOf(formatted) + " />\n";
        } else if (node.toString().trim().length() > 0) {
            formatted = String.valueOf(tab_str) + node.toString() + "\n";
        }
        return formatted;
    }

    public HandlerRegistration addViewCancelHandler(ViewCancelHandler handler) {
        return this.addHandler((EventHandler)handler, ViewCancelEvent.getType());
    }

    protected void onLoad() {
        super.onLoad();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                TitlePreviewWidget.this.updateFrameSize();
            }
        });
    }

    protected void onUnload() {
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        this.busyIndicator.hide();
        super.onUnload();
    }

    private void handleSpecificationChange() {
        this.performPreviewAction();
    }

    private void updateFrameSize() {
        DeferredCommand.addCommand((Command)this.resizeCommand);
    }

    private void resizeFrame() {
        Object previewObj = Window.Navigator.getUserAgent().toLowerCase().contains("trident") || Window.Navigator.getUserAgent().toLowerCase().contains("msie") ? this.previewFrameIe : this.previewFrame;
        if (previewObj == null) {
            return;
        }
        int height = Window.getClientHeight() - this.getInput().getRestrictedHeight() - 10 - 20;
        previewObj.setHeight(String.valueOf(height -= this.buttonsContents.getOffsetHeight() + this.controlsContents.getOffsetHeight()) + "px");
    }

    private void handleCancelButtonClick() {
        this.fireEvent((GwtEvent)new ViewCancelEvent());
    }
}

