/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.props;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.contentclass.model.KeyValuePair;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.service.ITitlePropertyViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitlePropertyViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.ReadDeletedTitleException;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.cms.portal.content.client.title.view.props.TitlePropertiesPanel;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.List;

public class TitlePropertiesTab
extends TitleViewTab {
    public static final String TAB_NAME = "Properties";
    private ITitlePropertyViewServiceAsync service = (ITitlePropertyViewServiceAsync)GWT.create(ITitlePropertyViewService.class);
    private ITitleViewServiceAsync viewService = (ITitleViewServiceAsync)GWT.create(ITitleViewService.class);
    private TitlePropertiesPanel mainPanel;

    public TitlePropertiesTab(TitleView parent) {
        super(parent);
    }

    @Override
    protected String getTabName() {
        return TAB_NAME;
    }

    @Override
    public String getTabDisplayName() {
        return this.getViewMessages().propertiesTabName();
    }

    @Override
    protected void initialize() {
        this.mainPanel = new TitlePropertiesPanel();
        this.getContainer().setWidget((Widget)this.mainPanel);
    }

    @Override
    public void refreshTab() {
        this.showBusyIndicator();
        Long titleId = this.getViewInput().getTitleId();
        if (this.getViewInput().getTitle().getOverview() == null) {
            this.viewService.getTitle(titleId, (AsyncCallback<UITitle>)new NeptuneAsyncCallback<UITitle>(){

                public void onNeptuneFailure(Throwable caught) {
                }

                public void onNeptuneSuccess(UITitle result) {
                    TitlePropertiesTab.this.getViewInput().getTitle().setOverview(result.getOverview());
                    TitlePropertiesTab.this.updateTitleHeader(result.getOverview());
                }
            });
        }
        this.service.getTitlePropertiesByTitleId(titleId, (AsyncCallback<List<KeyValuePair>>)new NeptuneAsyncCallback<List<KeyValuePair>>(){

            public void onNeptuneSuccess(List<KeyValuePair> result) {
                TitlePropertiesTab.this.mainPanel.refresh(result);
                TitlePropertiesTab.this.getContainer().setWidget((Widget)TitlePropertiesTab.this.mainPanel);
                TitlePropertiesTab.this.hideBusyIndicator();
            }

            public void onNeptuneFailure(Throwable caught) {
                if (caught instanceof ReadDeletedTitleException) {
                    TitlePropertiesTab.this.showSevereError(caught.getMessage());
                } else {
                    String error = caught.getLocalizedMessage();
                    String message = TitlePropertiesTab.this.getViewMessages().propertiesFetchError(error);
                    TitlePropertiesTab.this.showErrorPanel(message);
                }
                TitlePropertiesTab.this.hideBusyIndicator();
            }
        });
    }
}

