/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.referencedtitles;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.cms.portal.content.client.model.UISearchResult;
import com.tandbergtv.cms.portal.content.client.model.UISearchResultRec;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessageType;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import com.tandbergtv.cms.portal.content.client.title.service.IOffersTitleService;
import com.tandbergtv.cms.portal.content.client.title.service.IOffersTitleServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeEvent;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.RefTitlesPanel;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import java.util.ArrayList;
import java.util.List;

public class RefTitleTableDataProvider
implements DataProvider<Long, TitleRecord> {
    private RefTitlesPanel view;
    private List<Column<?, TitleRecord>> columns = new ArrayList();
    private Long deleteTitle = null;
    private UIGroupAsset rootAsset;
    private List<UiColumn> uiColumns = new ArrayList<UiColumn>();
    private IOffersTitleServiceAsync offersTitleService = (IOffersTitleServiceAsync)GWT.create(IOffersTitleService.class);
    private ContentMessages contentMessages = (ContentMessages)GWT.create(ContentMessages.class);
    private UITitleValidationMessage message;
    private static final int REF_TITLES_LIMIT = 200;

    public RefTitleTableDataProvider(RefTitlesPanel view) {
        this.view = view;
    }

    public void init(final AsyncCallback<Void> callback) {
        this.view.showBusyIndicator();
        this.offersTitleService.getRefTitleSearchColumns((AsyncCallback<List<UiColumn>>)new NeptuneAsyncCallback<List<UiColumn>>(){

            public void onNeptuneFailure(Throwable caught) {
                RefTitleTableDataProvider.this.view.hideBusyIndicator();
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(List<UiColumn> result) {
                RefTitleTableDataProvider.this.view.hideBusyIndicator();
                RefTitleTableDataProvider.this.setUIColumns(result);
                callback.onSuccess(null);
            }
        });
    }

    public List<UiColumn> getUIColumns() {
        return this.uiColumns;
    }

    public void setUIColumns(List<UiColumn> uiColumns) {
        this.uiColumns = uiColumns;
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public List<Column<?, TitleRecord>> getColumns() {
        return this.columns;
    }

    public void getRecords(final AsyncCallback<List<TitleRecord>> callback) {
        AssetTree.AssetInfo input = this.view.getRootAssetInfo();
        this.rootAsset = (UIGroupAsset)input.getAsset();
        this.view.showBusyIndicator();
        this.checkAddTitlesToOffer((AsyncCallback<List<Long>>)new NeptuneAsyncCallback<List<Long>>(){

            public void onNeptuneFailure(Throwable caught) {
                RefTitleTableDataProvider.this.view.hideBusyIndicator();
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(List<Long> results) {
                List<Long> titleIds;
                RefTitleTableDataProvider.this.view.hideBusyIndicator();
                if (!results.isEmpty() && results != null) {
                    int numRefTitles = RefTitleTableDataProvider.this.rootAsset.getReferencedTitleIds().size();
                    if (RefTitleTableDataProvider.this.isOverLimit(results, numRefTitles).booleanValue()) {
                        RefTitleTableDataProvider.this.message = new UITitleValidationMessage(RefTitleTableDataProvider.this.contentMessages.notifyReferencedOverLimit(String.valueOf(200)), UITitleValidationMessageType.Error);
                        RefTitleTableDataProvider.this.view.showMessage(RefTitleTableDataProvider.this.message);
                    } else {
                        for (Long titleId : results) {
                            RefTitleTableDataProvider.this.rootAsset.addReferencedTitleId(titleId);
                        }
                        RefTitleTableDataProvider.this.view.fireEvent(new ViewChangeEvent());
                        RefTitleTableDataProvider.this.message = new UITitleValidationMessage(RefTitleTableDataProvider.this.contentMessages.notifySucceedAddReferenced(String.valueOf(results.size())), UITitleValidationMessageType.Succeed);
                        RefTitleTableDataProvider.this.view.showMessage(RefTitleTableDataProvider.this.message);
                    }
                }
                if ((titleIds = RefTitleTableDataProvider.this.rootAsset.getReferencedTitleIds()) == null || titleIds.isEmpty()) {
                    callback.onSuccess(new ArrayList());
                    return;
                }
                RefTitleTableDataProvider.this.view.showBusyIndicator();
                boolean isSiteTitle = true;
                if (RefTitleTableDataProvider.this.rootAsset.getOriginalAssetId() == null) {
                    isSiteTitle = false;
                }
                RefTitleTableDataProvider.this.offersTitleService.getReferenceTitles(isSiteTitle, titleIds, (AsyncCallback<UISearchResult>)new NeptuneAsyncCallback<UISearchResult>(){

                    public void onNeptuneFailure(Throwable caught) {
                        RefTitleTableDataProvider.this.view.hideBusyIndicator();
                        callback.onFailure(caught);
                    }

                    public void onNeptuneSuccess(UISearchResult result) {
                        RefTitleTableDataProvider.this.view.hideBusyIndicator();
                        ArrayList<TitleRecord> records = new ArrayList<TitleRecord>();
                        if (result.getTitles() == null) {
                            return;
                        }
                        for (UISearchResultRec t : result.getTitles()) {
                            records.add(new TitleRecord(t));
                        }
                        callback.onSuccess(records);
                    }
                });
            }
        });
        if (this.deleteTitle != null) {
            this.rootAsset.removeReferencedTitleId(this.deleteTitle);
            this.deleteTitle = null;
            this.view.fireEvent(new ViewChangeEvent());
        }
    }

    private Boolean isOverLimit(List<Long> refTitles, int numRefTitles) {
        int newCount = refTitles.size() + numRefTitles;
        if (newCount > 200) {
            return true;
        }
        return false;
    }

    private void checkAddTitlesToOffer(final AsyncCallback<List<Long>> callback) {
        this.offersTitleService.getSelectedAddingTitles((AsyncCallback<List<Long>>)new NeptuneAsyncCallback<List<Long>>(){

            public void onNeptuneFailure(Throwable error) {
                callback.onFailure(error);
            }

            public void onNeptuneSuccess(final List<Long> results) {
                if (!results.isEmpty()) {
                    RefTitleTableDataProvider.this.offersTitleService.clearSelectedAddingTitles((AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                        public void onNeptuneFailure(Throwable errorClear) {
                            callback.onFailure(errorClear);
                        }

                        public void onNeptuneSuccess(Void clearResult) {
                            callback.onSuccess((Object)results);
                        }
                    });
                } else {
                    callback.onSuccess(results);
                }
            }
        });
    }

    public void getRecord(Long key, AsyncCallback<TitleRecord> callback) {
        throw new UnsupportedOperationException();
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    public boolean isCheckboxEnabled() {
        return false;
    }

    public Long getDeleteTitle() {
        return this.deleteTitle;
    }

    public void setDeleteTitle(Long deleteTitle) {
        this.deleteTitle = deleteTitle;
    }
}

