/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.referencedtitles;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessageType;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class RefTitleValidationView
extends Composite {
    private SimpleContainer mainContainer;
    private LabelWidget blankLabel;
    private String message;
    private static final String ERROR_PANNEL_STYLE = "content-RefTitleValidationView-pannel-error";
    private static final String SUCCEED_PANNEL_STYLE = "content-RefTitleValidationView-pannel-succeed";
    private static final String WARNING_PANNEL_STYLE = "content-RefTitleValidationView-pannel-warning";
    private static final String HEADER_IMAGE_STYLE = "content-RefTitleValidationView-header-image";
    private static final String MESSAGE_STYLE = "content-RefTitleValidationView-message";

    public RefTitleValidationView() {
        this.initialize();
    }

    private void initialize() {
        this.mainContainer = new SimpleContainer();
        this.blankLabel = new LabelWidget("");
        this.mainContainer.setWidget((Widget)this.blankLabel);
        this.initWidget((Widget)this.mainContainer);
    }

    public void showMessage(UITitleValidationMessage message) {
        this.setVisible(false);
        this.mainContainer.setWidget((Widget)new LabelWidget(""));
        if (message == null || message.getMessage().isEmpty()) {
            return;
        }
        HorizontalContainer messagePanel = new HorizontalContainer();
        this.setMessage(message.getMessage());
        if (message.getMessageType().equals((Object)UITitleValidationMessageType.Error)) {
            ImageWidget errorImage = new ImageWidget("cms_contentmgmt_ui/resources/images/error.png");
            errorImage.addStyleName(HEADER_IMAGE_STYLE);
            messagePanel.add((Widget)errorImage);
            LabelWidget messageLabel = new LabelWidget(this.getMessage());
            messageLabel.addStyleName(MESSAGE_STYLE);
            messagePanel.add((Widget)messageLabel);
            this.mainContainer.setStylePrimaryName(ERROR_PANNEL_STYLE);
        } else if (message.getMessageType().equals((Object)UITitleValidationMessageType.Information)) {
            ImageWidget infoImage = new ImageWidget("cms_contentmgmt_ui/resources/images/info.png");
            infoImage.addStyleName(HEADER_IMAGE_STYLE);
            messagePanel.add((Widget)infoImage);
            LabelWidget messageLabel = new LabelWidget(this.getMessage());
            messageLabel.addStyleName(MESSAGE_STYLE);
            messagePanel.add((Widget)messageLabel);
            this.mainContainer.setStylePrimaryName(WARNING_PANNEL_STYLE);
        } else if (message.getMessageType().equals((Object)UITitleValidationMessageType.Succeed)) {
            ImageWidget tickImage = new ImageWidget("cms_contentmgmt_ui/resources/images/small_tick.png");
            tickImage.addStyleName(HEADER_IMAGE_STYLE);
            messagePanel.add((Widget)tickImage);
            LabelWidget messageLabel = new LabelWidget(this.getMessage());
            messageLabel.addStyleName(MESSAGE_STYLE);
            messagePanel.add((Widget)messageLabel);
            this.mainContainer.setStylePrimaryName(SUCCEED_PANNEL_STYLE);
        }
        this.mainContainer.setWidget((Widget)messagePanel);
        this.setVisible(true);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

