/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.referencedtitles;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessageType;
import com.tandbergtv.cms.portal.content.client.title.view.HasViewChangeHandlers;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeEvent;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeHandler;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetPanel;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.RefTitleTableDataProvider;
import com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.RefTitleValidationView;
import com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.RefTitlesTable;
import com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.quicksearch.SearchPopup;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class RefTitlesPanel
extends Composite
implements HasViewChangeHandlers {
    RefTitleTableDataProvider dataProvider;
    private VerticalContainer mainContainer;
    private SearchPopup searchPopup = new SearchPopup(this);
    private AssetPanel parentView;
    private RefTitlesTable refTitleTable;
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private final AssetTree.AssetInfo asset;
    private LabelWidget numRecordsLabel;
    private HorizontalContainer topPanel;
    public Integer totalRecordCount = null;
    protected RefTitleValidationView messageView;
    private HandlerRegistration windowRegistration;
    private ScrollPanel scrollPanel;
    private static final String STYLE_NAME = "content-AssetContent";
    private static final String REF_ASSET_PANEL_STYLE = "ref-AssetPanel";
    private static final String REF_BUTTON_CONTAINER_STYLE = "ref-AssetPanel-button-container";
    private static final String REF_SEARCH_BUTTON_STYLE = "ref-AssetPanel-search-button";
    private static final String REF_TABLE_COUNT_STYLE = "ref-OrdertableTable-count";
    private static final String REF_TABLE_COUNT_LABEL_STYLE = "ref-OrdertableTable-count-label";
    private ContentConstants displayConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private ContentMessages contentMessages = (ContentMessages)GWT.create(ContentMessages.class);

    public RefTitlesPanel(AssetTree.AssetInfo assetInfo, AssetPanel parentView) {
        this.asset = assetInfo;
        this.parentView = parentView;
    }

    private void initWidgets() {
        this.refTitleTable = new RefTitlesTable(this, this.dataProvider);
        this.messageView = new RefTitleValidationView();
        this.mainContainer = new VerticalContainer();
        this.mainContainer.addStyleName(STYLE_NAME);
        this.mainContainer.setWidth("100%");
        this.initWidget((Widget)this.mainContainer);
        this.initTopPanel();
        this.mainContainer.add((Widget)this.topPanel);
        this.scrollPanel = new ScrollPanel((Widget)this.refTitleTable);
        this.scrollPanel.setWidth("96%");
        this.scrollPanel.addStyleName(REF_ASSET_PANEL_STYLE);
        this.updateSize();
        this.mainContainer.add((Widget)this.scrollPanel);
        this.mainContainer.add(this.createItemsButtonPanel());
    }

    private void initTopPanel() {
        this.numRecordsLabel = new LabelWidget("");
        this.numRecordsLabel.setStyleName(REF_TABLE_COUNT_STYLE);
        Label numRecordsLabelFront = new Label(this.displayConstants.referencedTitlesCount());
        numRecordsLabelFront.setStyleName(REF_TABLE_COUNT_LABEL_STYLE);
        HorizontalContainer recordCountContainer = new HorizontalContainer();
        recordCountContainer.add((Widget)numRecordsLabelFront);
        recordCountContainer.add((Widget)this.numRecordsLabel);
        this.topPanel = new HorizontalContainer();
        this.topPanel.add((Widget)recordCountContainer);
        this.topPanel.add((Widget)this.messageView);
        this.topPanel.setStylePrimaryName("nwt-TableListViewPanel-recordCount");
    }

    public void showMessage(UITitleValidationMessage message) {
        this.messageView.showMessage(message);
    }

    public Integer getTotalRecordCount() {
        return this.totalRecordCount;
    }

    public void setTotalRecordCount(Integer recordCount) {
        if (recordCount == null || recordCount < 0) {
            this.resetTotalRecordCount();
        } else {
            this.totalRecordCount = recordCount;
            this.updateRecordCountLabel();
        }
    }

    private void updateRecordCountLabel() {
        if (this.totalRecordCount == null) {
            this.numRecordsLabel.setText("");
        } else {
            this.numRecordsLabel.setText("(" + this.totalRecordCount + ")");
        }
    }

    protected void resetTotalRecordCount() {
        this.totalRecordCount = null;
        this.updateRecordCountLabel();
    }

    private Widget createItemsButtonPanel() {
        SimplePanel buttonPanel = new SimplePanel();
        HorizontalContainer buttonContainer = new HorizontalContainer();
        buttonContainer.addStyleName(REF_BUTTON_CONTAINER_STYLE);
        buttonContainer.add(this.createQuickSearchButton());
        buttonContainer.add(this.createAdvancedSearchButton());
        buttonPanel.add((Widget)buttonContainer);
        return buttonPanel;
    }

    private Widget createAdvancedSearchButton() {
        ButtonWidget advanceSearchButton = new ButtonWidget(this.displayConstants.advanceSearch(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                History.newItem((String)("Content.Search?offerTitleId=" + RefTitlesPanel.this.asset.getInput().getTitleId()));
            }
        });
        advanceSearchButton.removeStyleName("gwt-Button");
        advanceSearchButton.addStyleName("ebBtn");
        advanceSearchButton.addStyleName("search_button_icon");
        advanceSearchButton.addStyleName(REF_SEARCH_BUTTON_STYLE);
        if (this.asset.getInput().getTitleId() == null || this.asset.getInput().isSiteTitle()) {
            advanceSearchButton.setEnabled(false);
        } else {
            advanceSearchButton.setEnabled(true);
        }
        return advanceSearchButton;
    }

    private Widget createQuickSearchButton() {
        ButtonWidget quickSearchButton = new ButtonWidget(this.displayConstants.quickSearchesLabel(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                RefTitlesPanel.this.searchPopup.reset();
                RefTitlesPanel.this.searchPopup.center();
                RefTitlesPanel.this.searchPopup.show();
            }
        });
        quickSearchButton.removeStyleName("gwt-Button");
        quickSearchButton.addStyleName("ebBtn");
        quickSearchButton.addStyleName("ebBtn_color_darkBlue");
        quickSearchButton.addStyleName("search_button_icon");
        quickSearchButton.addStyleName(REF_SEARCH_BUTTON_STYLE);
        if (this.asset.getInput().getTitleId() == null || this.asset.getInput().isSiteTitle()) {
            quickSearchButton.setEnabled(false);
        } else {
            quickSearchButton.setEnabled(true);
        }
        return quickSearchButton;
    }

    public void initDataProvider(final AsyncCallback<Void> callback) {
        this.dataProvider = new RefTitleTableDataProvider(this);
        this.dataProvider.init((AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)caught.getLocalizedMessage());
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(Void result) {
                RefTitlesPanel.this.initWidgets();
                RefTitlesPanel.this.searchPopup.initDataProvider((AsyncCallback<Void>)callback);
            }
        });
    }

    public void showBusyIndicator() {
        this.busyIndicator.center();
    }

    public void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    public void refresh() {
        if (this.messageView.getMessage() != null) {
            this.messageView.showMessage(null);
        }
        if (this.asset.getInput().getTitleId() == null) {
            UITitleValidationMessage message = new UITitleValidationMessage(this.contentMessages.notifySaveOfferFirst(), UITitleValidationMessageType.Information);
            this.showMessage(message);
        }
        if (this.refTitleTable == null) {
            return;
        }
        this.refTitleTable.setVisible(true);
        if (!this.refTitleTable.isInitialized()) {
            this.refTitleTable = new RefTitlesTable(this, this.dataProvider);
        } else {
            this.refTitleTable.refresh();
        }
    }

    public AssetTree.AssetInfo getRootAssetInfo() {
        return this.asset;
    }

    @Override
    public HandlerRegistration addViewChangeHandler(ViewChangeHandler handler) {
        return this.addHandler(handler, ViewChangeEvent.getType());
    }

    protected void onLoad() {
        super.onLoad();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                RefTitlesPanel.this.updateSize();
            }
        });
    }

    protected void onUnload() {
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        super.onUnload();
    }

    public void updateSize() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                if (RefTitlesPanel.this.searchPopup.isShowing()) {
                    RefTitlesPanel.this.searchPopup.center();
                }
                int height = RefTitlesPanel.this.parentView.getHeight() - 111;
                RefTitlesPanel.this.scrollPanel.setHeight(String.valueOf(height) + "px");
            }
        });
    }

    private class EventHandler
    implements ViewChangeHandler {
        private EventHandler() {
        }

        @Override
        public void onViewChange(ViewChangeEvent event) {
            RefTitlesPanel.this.fireEvent(event);
        }
    }
}

