/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.referencedtitles;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.SearchResultTableColumn;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeEvent;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.RefTitleTableDataProvider;
import com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.RefTitlesPanel;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.PushButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.orderabletable.OrderableTable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AnchorTokenizer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.dnd.TableRowBeforeMoveEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.dnd.TableRowMoveEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.dnd.TableRowMoveHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RefTitlesTable
extends Composite {
    OrderableTable table;
    private VerticalContainer mainPanel;
    private List<TitleRecord> records;
    private RefTitlesPanel view;
    private boolean initialized = false;
    private List<Column<?, TitleRecord>> visibleColumns;
    private RefTitleTableDataProvider dataProvider;
    public static final String CELL_DELETE_COLUMN_STYLE = "content-AssetContentTable-cell-body-delete";
    public static final String DELETE_BUTTON_ENABLE_STYLE = "delete-button-enable";
    public static final String DELETE_BUTTON_DISABLE_STYLE = "delete-button-disable";
    public static final String TITLE_ID_COLUMN_NAME = "titleId";
    public static final String DELETE_COLUMN_NAME = "deleteButton";
    public static final String REF_TABLE_STYLE_NAME = "ref-OrderableTable";
    private ContentConstants contentConstants = (ContentConstants)GWT.create(ContentConstants.class);

    public RefTitlesTable(RefTitlesPanel view, RefTitleTableDataProvider dataProvider) {
        this.view = view;
        this.dataProvider = dataProvider;
        this.visibleColumns = new ArrayList();
        this.records = new ArrayList<TitleRecord>();
        this.initializeWidget();
    }

    private void initializeWidget() {
        this.mainPanel = new VerticalContainer();
        this.mainPanel.setStylePrimaryName(REF_TABLE_STYLE_NAME);
        this.mainPanel.add((Widget)this.createTable());
        this.initWidget((Widget)this.mainPanel);
    }

    private void initializeColumns(List<UiColumn> searchResultsColumns) {
        this.visibleColumns.add(this.prepareTitleIdColumn());
        for (UiColumn uiColumn : searchResultsColumns) {
            SearchResultTableColumn column = new SearchResultTableColumn(uiColumn, null);
            column.setCellStyle(column.getColumnCellStyle());
            this.visibleColumns.add((Column<?, TitleRecord>)column);
        }
        this.visibleColumns.add(this.prepareDeleteColumn());
    }

    protected OrderableTable createTable() {
        this.table = new OrderableTable(TITLE_ID_COLUMN_NAME, true, false, 0);
        this.table.setWidth("100%");
        this.initializeColumns(this.dataProvider.getUIColumns());
        for (Column<?, TitleRecord> column : this.visibleColumns) {
            this.table.addColumn(column.getDisplayName(), column.getName());
        }
        this.table.removeStyleName("nwt-OrderableTable");
        this.table.addStyleName(REF_TABLE_STYLE_NAME);
        TableRowMoveHandler handler = new TableRowMoveHandler(){

            public void onBeforeRowMove(TableRowBeforeMoveEvent event) {
            }

            public void onRowMove(TableRowMoveEvent event) {
                if (RefTitlesTable.this.table.isDirty()) {
                    RefTitlesTable.this.view.fireEvent(new ViewChangeEvent());
                }
                int oldIndex = event.getOldRowIndex();
                int newIndex = event.getRowIndex();
                RefTitlesTable.this.saveListOrder(oldIndex, newIndex);
            }
        };
        this.table.addMoveHandler(handler);
        this.initialized = true;
        return this.table;
    }

    private void saveListOrder(int oldIndex, int newIndex) {
        --newIndex;
        AssetTree.AssetInfo input = this.view.getRootAssetInfo();
        UIGroupAsset rootAsset = (UIGroupAsset)input.getAsset();
        List<Long> list = rootAsset.getReferencedTitleIds();
        Long oldIndexValue = list.get(--oldIndex);
        list.remove(oldIndex);
        list.add(newIndex, oldIndexValue);
        rootAsset.setReferencedTitleIds(list);
    }

    protected void clearRecords() {
        this.table.clear();
        this.records.clear();
    }

    protected void populateTable(OrderableTable table, List<TitleRecord> result) {
        this.clearRecords();
        if (result != null) {
            this.records.addAll(result);
        }
        int i = 0;
        while (i < this.records.size()) {
            TitleRecord record = this.records.get(i);
            try {
                for (Column<?, TitleRecord> field : this.visibleColumns) {
                    View listView = field.getView((Record)record);
                    String viewStyleName = listView.getStyleName();
                    if (viewStyleName == null) {
                        viewStyleName = "table-data-text";
                    }
                    Widget widget = listView.getWidget();
                    widget.setStyleName(viewStyleName);
                    table.addItem(i, field.getName(), widget, viewStyleName);
                }
            }
            catch (Exception exception) {
                String msg = "Error populating table: ";
                Window.alert((String)msg);
            }
            ++i;
        }
    }

    protected ClickHandler getDetailHandler(final long titleId) {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                HashMap<String, String> anchorTokens = new HashMap<String, String>();
                anchorTokens.put("Id", String.valueOf(titleId));
                anchorTokens.put("returnAnchor", History.getToken());
                String token = "Content.Search." + new AnchorTokenizer().buildAnchor(anchorTokens);
                History.newItem((String)token);
            }
        };
    }

    public void refresh() {
        this.view.showBusyIndicator();
        this.dataProvider.getRecords((AsyncCallback<List<TitleRecord>>)new NeptuneAsyncCallback<List<TitleRecord>>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)caught.getLocalizedMessage());
                RefTitlesTable.this.view.hideBusyIndicator();
                RefTitlesTable.this.populateTable(RefTitlesTable.this.table, new ArrayList<TitleRecord>());
                RefTitlesTable.this.view.resetTotalRecordCount();
            }

            public void onNeptuneSuccess(List<TitleRecord> result) {
                RefTitlesTable.this.view.setTotalRecordCount(result != null ? result.size() : 0);
                RefTitlesTable.this.populateTable(RefTitlesTable.this.table, result);
                RefTitlesTable.this.view.hideBusyIndicator();
            }
        });
    }

    private Column<String, TitleRecord> prepareTitleIdColumn() {
        ColumnBase<String, TitleRecord> column = null;
        String displayName = "Title ID";
        column = new ColumnBase<String, TitleRecord>(TITLE_ID_COLUMN_NAME, displayName){

            public View<String> getView(TitleRecord record) {
                return new TitleHyperLinkView(record.getTitle().getId());
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        return column;
    }

    private Column<Widget, TitleRecord> prepareDeleteColumn() {
        ColumnBase<Widget, TitleRecord> column = null;
        String displayName = "";
        column = new ColumnBase<Widget, TitleRecord>(null, displayName){

            public View<Widget> getView(TitleRecord record) {
                return new DeleteButtonView(record.getKey());
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-icon");
        return column;
    }

    private Widget buildDeleteButton(final Long titleId) {
        boolean enabled = true;
        String styleName = DELETE_BUTTON_ENABLE_STYLE;
        ImageWidget deleteImage = new ImageWidget("cms_contentmgmt_ui/resources/images/remove_reference.png");
        deleteImage.setTitle(this.contentConstants.removeReferenceTitle());
        if (this.view.getRootAssetInfo().getInput().isSiteTitle()) {
            deleteImage = new ImageWidget("cms_contentmgmt_ui/resources/images/remove_reference.png");
            styleName = DELETE_BUTTON_DISABLE_STYLE;
            enabled = false;
        }
        deleteImage.addStyleName(styleName);
        PushButtonWidget button = new PushButtonWidget(deleteImage);
        button.addStyleName("content-AssetContent-deleteButton");
        button.setEnabled(enabled);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RefTitlesTable.this.dataProvider.setDeleteTitle(titleId);
                RefTitlesTable.this.view.refresh();
            }
        });
        return button;
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    private class DeleteButtonView
    implements View<Widget> {
        Long titleId;

        public DeleteButtonView(Long titleId) {
            this.titleId = titleId;
        }

        public Widget getWidget() {
            return RefTitlesTable.this.buildDeleteButton(this.titleId);
        }

        public String getStyleName() {
            return "content-AssetContent-deleteButton";
        }

        public void release() {
        }
    }

    private class TitleHyperLinkView
    implements View<String> {
        long titleId;

        public TitleHyperLinkView(long titleId) {
            this.titleId = titleId;
        }

        public Widget getWidget() {
            HashMap<String, String> anchorTokens = new HashMap<String, String>();
            anchorTokens.put("Id", String.valueOf(this.titleId));
            anchorTokens.put("returnAnchor", History.getToken());
            String token = "Content.Search." + new AnchorTokenizer().buildAnchor(anchorTokens);
            Hyperlink hyperlink = new Hyperlink(String.valueOf(this.titleId), token);
            return hyperlink;
        }

        public String getStyleName() {
            return "table-data-link";
        }

        public void release() {
        }
    }
}

