/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.quicksearch;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.quicksearch.SearchTableDataProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SimpleRHSValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SingleValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueTextBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.IRulesValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.StringValidator;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SelectionChangeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SelectionChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.CheckBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class GridColumnPanel<K, R extends Record<K>>
extends Composite {
    private final DataProvider<K, R> dataProvider;
    private final Grid grid;
    private int colIndex;
    private List<R> records;
    private CheckBox<R> headerRowCheckbox;
    private List<CheckBox<R>> dataRowsCheckBoxes;
    private List<Column<?, R>> visibleColumns;
    private Map<Column<?, R>, List<Widget>> visibleColumnToWidgetListMap;
    private Map<Widget, R> widgetToRecordMap;
    private Map<Column<?, R>, Label> visibleColumnToHeaderLabel;
    private Map<Column<?, R>, HorizontalPanel> visibleColumnToHeaderColPanel;
    private Map<Column<?, R>, Widget> visibleColumnToFilterWidget;
    private List<SelectionChangeHandler<K, R>> selectionChangeHandlers;
    public List<R> results;
    private static final String STYLE_IN_PLACE_SEARCH_FILTER_ROW = "popup-in-place-search-filter-row";
    private String STYLE_IN_PLACE_SEARCH_FILTER_COLUMN = "popup-in-place-search-filter-column";
    private static final String STYLE_IN_PLACE_SEARCH_FILTER_TEXTBOX = "popup-in-place-search-filter-textbox";
    public boolean fullUpdate = false;

    public GridColumnPanel(DataProvider<K, R> dataProvider) {
        SearchTableDataProvider searchTable = new SearchTableDataProvider();
        this.dataProvider = dataProvider;
        this.grid = new Grid(searchTable.getMaxPageSize() + 2, dataProvider.getColumns().size() + 1);
        this.selectionChangeHandlers = new ArrayList<SelectionChangeHandler<K, R>>();
        this.initializeWidget();
    }

    private void initializeWidget() {
        this.initWidget((Widget)this.grid);
        this.records = new ArrayList<R>();
        this.headerRowCheckbox = new CheckBox();
        this.dataRowsCheckBoxes = new ArrayList<CheckBox<R>>();
        this.visibleColumns = new ArrayList();
        this.visibleColumnToWidgetListMap = new HashMap();
        this.widgetToRecordMap = new HashMap<Widget, R>();
        this.visibleColumnToHeaderColPanel = new HashMap();
        this.visibleColumnToHeaderLabel = new HashMap();
        this.visibleColumnToFilterWidget = new HashMap();
        this.setStylePrimaryName("nwt-TableColumnPanel");
        this.grid.getRowFormatter().setStyleName(0, "table-header-row");
        this.colIndex = 0;
        if (this.dataProvider.isCheckboxEnabled()) {
            this.headerRowCheckbox.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    GridColumnPanel.this.handleHeaderCheckBoxClick(event);
                }
            });
            this.grid.getColumnFormatter().setWidth(this.colIndex, "2%");
            this.headerRowCheckbox.setStyleName("nwt-TableColumnPanel-dataCell-checkbox");
            this.grid.setWidget(0, this.colIndex++, this.headerRowCheckbox);
        }
        for (Column column : this.dataProvider.getColumns()) {
            this.addColumn(column);
        }
        this.colIndex = 1;
        this.grid.getRowFormatter().setStyleName(1, STYLE_IN_PLACE_SEARCH_FILTER_ROW);
        for (Column column : this.dataProvider.getColumns()) {
            this.addFilterColumn(column);
        }
    }

    private void addColumn(Column<?, R> column) {
        this.visibleColumns.add(column);
        HorizontalPanel headerColPanel = new HorizontalPanel();
        headerColPanel.setSpacing(3);
        headerColPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        Label headerLabel = new Label(column.getDisplayName());
        headerColPanel.add((Widget)headerLabel);
        headerLabel.setStyleName("table-header-nonSortable-text");
        if (column.getColumnWidth() != null) {
            this.grid.getColumnFormatter().setWidth(this.colIndex, column.getColumnWidth());
        }
        this.grid.setWidget(0, this.colIndex++, (Widget)headerColPanel);
        this.visibleColumnToHeaderLabel.put(column, headerLabel);
        this.visibleColumnToHeaderColPanel.put(column, headerColPanel);
    }

    private void addFilterColumn(Column<?, R> column) {
        if (column.getDisplayName().equalsIgnoreCase("Title Status")) {
            ListBoxWidget statusFilter = new ListBoxWidget();
            statusFilter.clear();
            statusFilter.addItem("", (Object)"");
            statusFilter.addStyleName(String.valueOf(this.STYLE_IN_PLACE_SEARCH_FILTER_COLUMN) + this.colIndex);
            for (UIValueOption item : PMMFieldProvider.getTitleStatusOptions()) {
                statusFilter.addItem(item.getName(), (Object)item.getValue());
            }
            this.grid.setWidget(1, this.colIndex++, (Widget)statusFilter);
            this.visibleColumnToFilterWidget.put(column, (Widget)statusFilter);
        } else if (!column.getDisplayName().startsWith("License")) {
            ValueTextBox stringTextBox = new ValueTextBox((IRulesValidator)new StringValidator());
            stringTextBox.addStyleName(STYLE_IN_PLACE_SEARCH_FILTER_TEXTBOX);
            stringTextBox.getWidget().addStyleName(String.valueOf(this.STYLE_IN_PLACE_SEARCH_FILTER_COLUMN) + this.colIndex);
            SimpleRHSValueWidget rhw = new SimpleRHSValueWidget((SingleValueWidget)stringTextBox);
            this.grid.setWidget(1, this.colIndex++, (Widget)rhw);
            this.visibleColumnToFilterWidget.put(column, (Widget)rhw);
        }
    }

    public void clearRecords() {
        this.records.clear();
        this.headerRowCheckbox.setValue(Boolean.valueOf(false));
        this.visibleColumnToWidgetListMap.clear();
        this.widgetToRecordMap.clear();
        this.dataRowsCheckBoxes.clear();
        int rowCount = this.grid.getRowCount();
        int columnCount = this.grid.getColumnCount();
        int columnIndex = 0;
        while (columnIndex < columnCount) {
            int rowIndex = rowCount - 1;
            while (rowIndex > 1) {
                String styleName;
                if (this.grid.getText(rowIndex, 1).isEmpty()) {
                    this.grid.clearCell(rowIndex, columnIndex);
                    styleName = rowIndex % 2 == 0 ? "table-data-even-row" : "table-data-odd-row";
                    this.grid.getCellFormatter().removeStyleName(rowIndex, columnIndex, "nwt-TableColumnPanel-dataCell");
                    this.grid.getRowFormatter().removeStyleName(rowIndex, styleName);
                    break;
                }
                this.grid.clearCell(rowIndex, columnIndex);
                styleName = rowIndex % 2 == 0 ? "table-data-even-row" : "table-data-odd-row";
                this.grid.getCellFormatter().removeStyleName(rowIndex, columnIndex, "nwt-TableColumnPanel-dataCell");
                this.grid.getRowFormatter().removeStyleName(rowIndex, styleName);
                --rowIndex;
            }
            ++columnIndex;
        }
    }

    public void updateRecords(List<R> result) {
        this.clearRecords();
        if (result != null) {
            this.records.addAll(result);
        }
        int rowIndex = 2;
        for (Record record : this.records) {
            String styleName = rowIndex % 2 == 0 ? "table-data-even-row" : "table-data-odd-row";
            this.grid.getRowFormatter().setStyleName(rowIndex, styleName);
            int colIndex = 0;
            if (this.dataProvider.isCheckboxEnabled()) {
                final CheckBox dataRowCheckBox = new CheckBox();
                dataRowCheckBox.setRecord(record);
                dataRowCheckBox.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        GridColumnPanel.this.handleDataCheckBoxClick(dataRowCheckBox, event);
                    }
                });
                this.dataRowsCheckBoxes.add(dataRowCheckBox);
                this.grid.setWidget(rowIndex, colIndex, (Widget)dataRowCheckBox);
                this.grid.getCellFormatter().addStyleName(rowIndex, colIndex, "nwt-TableColumnPanel-dataCell-checkbox");
                ++colIndex;
            }
            for (Column<?, R> field : this.visibleColumns) {
                View listView;
                String viewStyleName;
                this.grid.getCellFormatter().addStyleName(rowIndex, colIndex, "nwt-TableColumnPanel-dataCell");
                String cellStyle = field.getCellStyle();
                if (cellStyle != null) {
                    this.grid.getCellFormatter().addStyleName(rowIndex, colIndex, cellStyle);
                }
                if ((viewStyleName = (listView = field.getView(record)).getStyleName()) == null) {
                    viewStyleName = "table-data-text";
                }
                Widget widget = listView.getWidget();
                widget.setStyleName(viewStyleName);
                this.grid.setWidget(rowIndex, colIndex++, widget);
                this.getInitializedWidgetList(field).add(widget);
                this.widgetToRecordMap.put(widget, record);
            }
            ++rowIndex;
        }
    }

    private List<Widget> getInitializedWidgetList(Column<?, R> visibleColumn) {
        List<Widget> list = this.visibleColumnToWidgetListMap.get(visibleColumn);
        if (list == null) {
            list = new ArrayList<Widget>();
            this.visibleColumnToWidgetListMap.put(visibleColumn, list);
        }
        return list;
    }

    public List<Column<?, R>> listVisibleColumns() {
        return this.visibleColumns;
    }

    public List<Widget> listWidgetsForVisibleColumn(Column<?, R> column) {
        return this.visibleColumnToWidgetListMap.get(column);
    }

    public R getRecordForWidget(Widget widget) {
        return (R)((Record)this.widgetToRecordMap.get(widget));
    }

    public List<R> getRecords() {
        ArrayList<R> visibleRecords = new ArrayList<R>();
        visibleRecords.addAll(this.records);
        return visibleRecords;
    }

    public List<R> listSelectedRecords() {
        ArrayList<Record> records = new ArrayList<Record>();
        for (CheckBox<R> checkBox : this.dataRowsCheckBoxes) {
            if (!checkBox.getValue().booleanValue()) continue;
            records.add(checkBox.getRecord());
        }
        return records;
    }

    public int getDataRowCount() {
        return this.records.size();
    }

    public void addSelectionChangeHandler(SelectionChangeHandler<K, R> handler) {
        if (handler != null && !this.selectionChangeHandlers.contains(handler)) {
            this.selectionChangeHandlers.add(handler);
        }
    }

    public void removeSelectionChangeHandler(SelectionChangeHandler<K, R> handler) {
        this.selectionChangeHandlers.remove(handler);
    }

    public List<R> getResults() {
        return this.results;
    }

    public void setResults(List<R> results) {
        this.results = results;
    }

    private void handleHeaderCheckBoxClick(ClickEvent event) {
        Boolean headerValue = this.headerRowCheckbox.getValue();
        if (headerValue.booleanValue()) {
            this.updateRecords(this.getResults());
            this.headerRowCheckbox.setValue(Boolean.valueOf(true));
            this.setFullUpdateFlag(true);
        }
        for (CheckBox<R> dataRowCB : this.dataRowsCheckBoxes) {
            if (!dataRowCB.isEnabled()) continue;
            dataRowCB.setValue(headerValue);
        }
        this.notifySelectionChangeHandlers();
    }

    public void setFullUpdateFlag(boolean flag) {
        this.fullUpdate = flag;
    }

    private void handleDataCheckBoxClick(CheckBox<R> source, ClickEvent event) {
        if (this.headerRowCheckbox.getValue().booleanValue() && !source.getValue().booleanValue()) {
            this.headerRowCheckbox.setValue(Boolean.valueOf(false));
        }
        this.notifySelectionChangeHandlers();
    }

    private void notifySelectionChangeHandlers() {
        for (SelectionChangeHandler<K, R> handler : this.selectionChangeHandlers) {
            handler.onSelectionChange(new SelectionChangeEvent((Widget)this, this.listSelectedRecords()));
        }
    }

    public Widget getFilterColumnPanel(Column<?, R> column) {
        return this.visibleColumnToFilterWidget.get(column);
    }

    public HorizontalPanel getHeaderColumnPanel(Column<?, R> column) {
        return this.visibleColumnToHeaderColPanel.get(column);
    }

    public Label getHeaderColumnLabel(Column<?, R> column) {
        return this.visibleColumnToHeaderLabel.get(column);
    }

    public CheckBox<R> getHeaderRowCheckBox() {
        return this.headerRowCheckbox;
    }

    public List<CheckBox<R>> getDataRowsCheckBoxes() {
        return this.dataRowsCheckBoxes;
    }
}

