/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.quicksearch;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.quicksearch.GridColumnPanel;
import com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.quicksearch.SearchPopup;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SelectionChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.CheckBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

class GridListViewPanel<K, R extends Record<K>>
extends Composite {
    private final DataProvider<K, R> dataProvider;
    private GridColumnPanel<K, R> columnPanel;
    private List<Listener> listeners;
    private VerticalContainer mainContainer;
    private Integer totalRecordCount = null;
    private static final String STYLE_IN_PLACE_SEARCH_LIST_VIEW = "popup-in-place-search-list-view";

    public GridListViewPanel(DataProvider<K, R> dataProvider) {
        this.dataProvider = dataProvider;
        this.initializeWidget();
    }

    private void initializeWidget() {
        this.listeners = new ArrayList<Listener>();
        this.mainContainer = new VerticalContainer();
        this.columnPanel = new GridColumnPanel<K, R>(this.dataProvider);
        this.mainContainer.setStylePrimaryName("nwt-TableListViewPanel");
        this.mainContainer.addStyleName(STYLE_IN_PLACE_SEARCH_LIST_VIEW);
        this.mainContainer.setSpacing(3);
        this.mainContainer.add(this.columnPanel);
        this.initWidget((Widget)this.mainContainer);
    }

    public HorizontalPanel getHeaderColPanelForColumn(Column<?, R> column) {
        return this.columnPanel.getHeaderColumnPanel(column);
    }

    public Label getHeaderLabelForColumn(Column<?, R> column) {
        return this.columnPanel.getHeaderColumnLabel(column);
    }

    public Widget getFilterForColumn(Column<?, R> column) {
        return this.columnPanel.getFilterColumnPanel(column);
    }

    public void refresh() {
        this.dataProvider.getRecords((AsyncCallback)new NeptuneAsyncCallback<List<R>>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)caught.getLocalizedMessage());
                GridListViewPanel.this.resetTotalRecordCount();
                GridListViewPanel.this.columnPanel.updateRecords(new ArrayList());
                GridListViewPanel.this.notifyAllListeners();
            }

            public void onNeptuneSuccess(List<R> result) {
                GridListViewPanel.this.setTotalRecordCount(result != null ? result.size() : 0);
                GridListViewPanel.this.columnPanel.setResults(result);
                GridListViewPanel.this.columnPanel.updateRecords(result);
                GridListViewPanel.this.notifyAllListeners();
            }
        });
    }

    public void quickRefresh() {
        this.dataProvider.getRecords((AsyncCallback)new NeptuneAsyncCallback<List<R>>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)caught.getLocalizedMessage());
                GridListViewPanel.this.resetTotalRecordCount();
                GridListViewPanel.this.columnPanel.updateRecords(new ArrayList());
                GridListViewPanel.this.notifyAllListeners();
            }

            public void onNeptuneSuccess(List<R> result) {
                GridListViewPanel.this.setTotalRecordCount(result != null ? result.size() : 0);
                GridListViewPanel.this.columnPanel.setResults(result);
                if (result.size() > 10) {
                    result = result.subList(0, 9);
                }
                GridListViewPanel.this.columnPanel.updateRecords(result);
                GridListViewPanel.this.columnPanel.setFullUpdateFlag(false);
                GridListViewPanel.this.notifyAllListeners();
            }
        });
    }

    public void clearResults() {
        this.columnPanel.setResults(new ArrayList());
    }

    public void clearRecords() {
        this.resetTotalRecordCount();
        this.columnPanel.clearRecords();
    }

    public Integer getTotalRecordCount() {
        return this.totalRecordCount;
    }

    public void setTotalRecordCount(Integer recordCount) {
        if (recordCount == null || recordCount < 0) {
            this.resetTotalRecordCount();
        } else {
            this.totalRecordCount = recordCount;
            this.updateRecordCountLabel();
        }
    }

    private void resetTotalRecordCount() {
        this.totalRecordCount = null;
        this.updateRecordCountLabel();
    }

    private void updateRecordCountLabel() {
        if (this.totalRecordCount == null) {
            SearchPopup.numRecordsLabel.setText("");
        } else {
            SearchPopup.numRecordsLabel.setText(this.totalRecordCount + " titles found.");
        }
    }

    public List<Column<?, R>> listVisibleColumns() {
        return this.columnPanel.listVisibleColumns();
    }

    public List<Widget> listWidgetsForVisibleColumn(Column<?, R> visibleColumn) {
        return this.columnPanel.listWidgetsForVisibleColumn(visibleColumn);
    }

    public R getRecordForWidget(Widget widget) {
        return this.columnPanel.getRecordForWidget(widget);
    }

    public List<CheckBox<R>> getDataRowsCheckBoxes() {
        return this.columnPanel.getDataRowsCheckBoxes();
    }

    public CheckBox<R> getHeaderRowCheckBox() {
        return this.columnPanel.getHeaderRowCheckBox();
    }

    public List<R> getRecords() {
        return this.columnPanel.getRecords();
    }

    public List<R> getSelectedRecords() {
        return this.columnPanel.listSelectedRecords();
    }

    public int getDataRowCount() {
        return this.columnPanel.getDataRowCount();
    }

    public void addListener(Listener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void notifyAllListeners() {
        for (Listener listener : this.listeners) {
            listener.updated();
        }
    }

    public void addSelectionChangeHandler(SelectionChangeHandler<K, R> handler) {
        this.columnPanel.addSelectionChangeHandler(handler);
    }

    public void removeSelectionChangeHandler(SelectionChangeHandler<K, R> handler) {
        this.columnPanel.removeSelectionChangeHandler(handler);
    }

    public GridColumnPanel<K, R> getTableColumnPanel() {
        return this.columnPanel;
    }

    public static interface Listener {
        public void updated();
    }
}

