/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.quicksearch;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.ScrollEvent;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.exception.BasicSearchFieldValidationException;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleBasicSearchFieldProvider;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleBasicSearchFieldProviderAsync;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessageType;
import com.tandbergtv.cms.portal.content.client.title.service.IOffersTitleService;
import com.tandbergtv.cms.portal.content.client.title.service.IOffersTitleServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.RefTitlesPanel;
import com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.quicksearch.SearchPopupTable;
import com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.quicksearch.SearchTableDataProvider;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UiBasicSearchField;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.RHSDateRangeWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.RHSValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SimpleRHSValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UISearchLicenseOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterValueNode;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SelectionChangeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SelectionChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchPopup
extends PopupPanel
implements HasHandlers {
    private static final String STYLE_IN_PLACE_SEARCH = "popup-in-place-search";
    private static final String STYLE_IN_PLACE_SEARCH_GRID = "popup-in-place-search-grid";
    private static final String STYLE_IN_PLACE_SEARCHBOX = "popup-in-place-searchbox";
    private static final String STYLE_IN_PLACE_SEARCH_LABEL = "popup-in-place-search-label";
    private static final String SEARCH_BUTTON_CONTAINER_STYLE = "popup-in-place-search-button-container";
    private static final String QUICK_SEARCH_LABEL_STYLE = "popup-quick-search-label";
    private static final String SEARCH_COUNT_LABEL_STYLE = "popup-quick-search-count-label";
    private static final String QUICK_SEARCH_LICENSE_OPERATOR = "popup-quick-search-license-operator";
    private static final String QUICK_SEARCH_LICENSE_CONTAINER = "popup-quick-search-license-container";
    private static final String QUICK_SEARCH_LICENSE_DATEBOX = "popup-quick-search-license-datebox";
    private static final int popUpWidth = 1250;
    private static final int popUpHeight = 400;
    public static LabelWidget numRecordsLabel;
    public static LabelWidget validateMessage;
    private RefTitlesPanel view;
    private VerticalPanel mainPanel = new VerticalPanel();
    private HorizontalPanel searchPanel = new HorizontalPanel();
    private SearchPopupTable<Long, TitleRecord> searchResultTable;
    private SearchTableDataProvider searchDataProvider;
    private boolean fullRefresh = false;
    private ScrollPanel assetScrollPanel = new ScrollPanel();
    private HorizontalContainer topPanel;
    private HorizontalContainer buttonContainer;
    private ButtonWidget addButton;
    private ButtonWidget cancelButton;
    private List<UiBasicSearchField> searchFieldsCache = null;
    private Map<UiBasicSearchField, RHSValueWidget> filtersMap = new HashMap<UiBasicSearchField, RHSValueWidget>();
    private RHSDateRangeWidget licenseDateBox;
    private Timer timer;
    private TextBox quickSearchBox;
    private LabelWidget tipLabelWidget;
    private ListBoxWidget<String> statusFilter = new ListBoxWidget();
    private ListBoxWidget<String> licenseOperator = new ListBoxWidget();
    private RHSValueWidget titleIDFilter;
    private String lastQuery = "";
    private List<Long> selectedIds = new ArrayList<Long>();
    private List<Column<?, TitleRecord>> columns;
    private UiBasicSearchField lws;
    private UiBasicSearchField lwe;
    private String currentLicenseOperator;
    private boolean searchTrigger = false;
    private IOffersTitleServiceAsync offerTitleService = (IOffersTitleServiceAsync)GWT.create(IOffersTitleService.class);
    private TitleConstants titleConstants = (TitleConstants)GWT.create(TitleConstants.class);
    private ContentConstants contentConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private static final String SHOW_ALL = "*";
    private static final String BLANK = "";
    private static final String DATE_FORMAT = "yyyy-MM-ddTHH:mm:ss.SSSZZZZ";
    private DateTimeFormat dateFormater = DateTimeFormat.getFormat((String)"yyyy-MM-ddTHH:mm:ss.SSSZZZZ");

    public SearchPopup(RefTitlesPanel view) {
        super(true);
        this.view = view;
        this.timer = new Timer(){

            public void run() {
                SearchPopup.this.quickRefresh();
                SearchPopup.this.fullRefresh = false;
            }
        };
    }

    public void initDataProvider(final AsyncCallback<Void> callback) {
        this.searchDataProvider = new SearchTableDataProvider();
        this.searchDataProvider.init((AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)caught.getLocalizedMessage());
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(Void result) {
                SearchPopup.this.initWidgets();
                callback.onSuccess(null);
            }
        });
    }

    public void initWidgets() {
        this.searchResultTable = new SearchPopupTable<Long, TitleRecord>(this.searchDataProvider);
        this.searchResultTable.addStyleName(STYLE_IN_PLACE_SEARCH_GRID);
        this.searchResultTable.addSelectionChangeHandler(new SelectionChangeHandler<Long, TitleRecord>(){

            public void onSelectionChange(SelectionChangeEvent<Long, TitleRecord> event) {
                SearchPopup.this.handleSelectionChangeEvent((SelectionChangeEvent<Long, TitleRecord>)event);
            }
        });
        this.searchResultTable.addRefreshListener(new Table.RefreshListener(){

            public void updated() {
                if (SearchPopup.this.searchResultTable.getTotalRecordCount() > 10) {
                    SearchPopup.this.enableScrollBar(true);
                } else {
                    SearchPopup.this.enableScrollBar(false);
                }
            }
        });
        SortFeatureImpl sortFeature = new SortFeatureImpl(this.searchDataProvider.getDefaultSortColumn(), SortOrder.DESCENDING);
        for (Column<?, TitleRecord> sortableCol : this.searchDataProvider.getSortableColumns()) {
            sortFeature.addSortableColumn(sortableCol);
        }
        this.searchDataProvider.setSortFeature(sortFeature);
        this.searchResultTable.addSortFeature((SortFeature<Long, TitleRecord>)sortFeature);
        ITitleBasicSearchFieldProviderAsync sfp = (ITitleBasicSearchFieldProviderAsync)GWT.create(ITitleBasicSearchFieldProvider.class);
        sfp.getInPlaceSearchFields((AsyncCallback<List<UiBasicSearchField>>)new NeptuneAsyncCallback<List<UiBasicSearchField>>(){

            public void onNeptuneFailure(Throwable caught) {
                if (caught instanceof BasicSearchFieldValidationException) {
                    SearchPopup.this.buildUI();
                    Window.alert((String)caught.getMessage());
                } else {
                    Window.alert((String)caught.getMessage());
                }
            }

            public void onNeptuneSuccess(List<UiBasicSearchField> result) {
                SearchPopup.this.searchFieldsCache = result;
                SearchPopup.this.buildUI();
                SearchPopup.this.getFiltersFromColumns();
            }
        });
    }

    public void buildUI() {
        this.addCloseHandler();
        this.initTopPanel();
        this.addButtons();
        this.assetScrollPanel.setWidget(this.searchResultTable);
        this.searchPanel.setWidth("100%");
        this.enableScrollBar(false);
        this.assetScrollPanel.setWidth("100%");
        this.assetScrollPanel.addScrollHandler(new ScrollHandler(){

            public void onScroll(ScrollEvent event) {
                if (SearchPopup.this.searchResultTable.getHeaderRowCheckBox().getValue().booleanValue()) {
                    SearchPopup.this.fullRefresh = true;
                }
                if (!SearchPopup.this.fullRefresh) {
                    SearchPopup.this.refresh();
                    SearchPopup.this.fullRefresh = true;
                }
            }
        });
        this.searchPanel.add((Widget)this.buildQuickSearchBox());
        this.searchPanel.add(this.buildLicensingFilters());
        this.mainPanel.add((Widget)this.topPanel);
        this.mainPanel.add((Widget)this.searchPanel);
        this.mainPanel.add((Widget)this.assetScrollPanel);
        this.mainPanel.setHeight("400px");
        this.mainPanel.setWidth("1250px");
        this.buttonContainer = new HorizontalContainer();
        this.buttonContainer.add((Widget)this.addButton);
        this.buttonContainer.add((Widget)this.cancelButton);
        this.buttonContainer.addStyleName(SEARCH_BUTTON_CONTAINER_STYLE);
        this.assetScrollPanel.setHeight(String.valueOf(400 - this.searchPanel.getOffsetHeight() - this.topPanel.getOffsetHeight() - this.buttonContainer.getOffsetHeight()) + "px");
        this.mainPanel.add((Widget)this.buttonContainer);
        this.mainPanel.setStyleName(STYLE_IN_PLACE_SEARCH, true);
        this.setGlassEnabled(true);
        this.setAutoHideEnabled(false);
        this.setWidget((Widget)this.mainPanel);
    }

    private void enableScrollBar(boolean enable) {
        if (enable) {
            this.assetScrollPanel.getElement().getStyle().setOverflow(Style.Overflow.AUTO);
        } else {
            this.assetScrollPanel.getElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
        }
    }

    private void addHelperWidgetToTopPanel() {
        this.topPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        ImageWidget imageWidgetHelp = new ImageWidget("cms_contentmgmt_ui/resources/images/information_black_16px.svg");
        imageWidgetHelp.setVisible(true);
        this.tipLabelWidget = new LabelWidget(this.contentConstants.inPlaceSearchTip());
        this.tipLabelWidget.setStyleName("popup-in-place-search-helper-message");
        this.tipLabelWidget.setVisible(false);
        imageWidgetHelp.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (SearchPopup.this.tipLabelWidget.isVisible()) {
                    SearchPopup.this.tipLabelWidget.setVisible(false);
                } else {
                    SearchPopup.this.tipLabelWidget.setVisible(true);
                }
            }
        });
        this.topPanel.add((Widget)imageWidgetHelp);
        this.topPanel.add((Widget)this.tipLabelWidget);
    }

    private Widget buildLicensingFilters() {
        HorizontalPanel licensingContainer = new HorizontalPanel();
        licensingContainer.addStyleName(QUICK_SEARCH_LICENSE_CONTAINER);
        Label licenseLabel = new Label("License Window");
        licenseLabel.addStyleName(STYLE_IN_PLACE_SEARCH_LABEL);
        licensingContainer.add((Widget)licenseLabel);
        this.licenseOperator.clear();
        UISearchLicenseOperator[] uISearchLicenseOperatorArray = UISearchLicenseOperator.values();
        int n = uISearchLicenseOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            UISearchLicenseOperator item = uISearchLicenseOperatorArray[n2];
            this.licenseOperator.addItem(this.contentConstants.getString(item.name().toLowerCase()), (Object)item.name());
            ++n2;
        }
        this.licenseOperator.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                SearchPopup.this.executeQuickSearch();
            }
        });
        licensingContainer.add(this.licenseOperator);
        this.licenseOperator.addStyleName(QUICK_SEARCH_LICENSE_OPERATOR);
        this.licenseDateBox = new RHSDateRangeWidget();
        this.licenseDateBox.addStyleName(QUICK_SEARCH_LICENSE_DATEBOX);
        this.licenseDateBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                SearchPopup.this.executeQuickSearch();
            }
        });
        this.licenseDateBox.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                SearchPopup.this.executeQuickSearch();
            }
        });
        licensingContainer.add((Widget)this.licenseDateBox);
        return licensingContainer;
    }

    private void initTopPanel() {
        numRecordsLabel = new LabelWidget(BLANK);
        numRecordsLabel.setStyleName(SEARCH_COUNT_LABEL_STYLE);
        this.searchResultTable.getDataRowCount();
        Label quickSearchLabelFront = new Label(this.contentConstants.quickSearchesLabel());
        quickSearchLabelFront.setStyleName(QUICK_SEARCH_LABEL_STYLE);
        validateMessage = new LabelWidget(BLANK);
        validateMessage.setStyleName("red-txt");
        validateMessage.addStyleName(SEARCH_COUNT_LABEL_STYLE);
        this.topPanel = new HorizontalContainer();
        this.topPanel.add((Widget)quickSearchLabelFront);
        this.addHelperWidgetToTopPanel();
        this.topPanel.add((Widget)numRecordsLabel);
        this.topPanel.add((Widget)validateMessage);
        this.topPanel.setStylePrimaryName("nwt-TableListViewPanel-recordCount");
    }

    public LabelWidget getValidateMessage() {
        return validateMessage;
    }

    public void setValidateMessage(String message) {
        validateMessage.setText(message);
    }

    private void handleSelectionChangeEvent(SelectionChangeEvent<Long, TitleRecord> event) {
        this.selectedIds = new ArrayList<Long>();
        List titleRecords = event.getSelectedRecords();
        for (TitleRecord record : titleRecords) {
            this.selectedIds.add(record.getKey());
        }
    }

    private TextBox buildQuickSearchBox() {
        this.quickSearchBox = new TextBox();
        this.quickSearchBox.setStyleName(STYLE_IN_PLACE_SEARCHBOX);
        this.quickSearchBox.setWidth("575px");
        this.quickSearchBox.setMaxLength(1000);
        this.quickSearchBox.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                SearchPopup.this.executeQuickSearch();
                SearchPopup.this.setFocus();
            }
        });
        return this.quickSearchBox;
    }

    public void setFocus() {
        this.quickSearchBox.setFocus(true);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                SearchPopup.this.quickSearchBox.setFocus(true);
            }
        });
    }

    private void addCloseHandler() {
        this.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                event.isAutoClosed();
            }
        });
    }

    private void addButtons() {
        this.addButton = new ButtonWidget(this.contentConstants.addTitlesButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SearchPopup.this.hide(false);
                if (!SearchPopup.this.selectedIds.isEmpty()) {
                    SearchPopup.this.view.showBusyIndicator();
                    SearchPopup.this.offerTitleService.parseSelectedTitlesToOfferMetadata(SearchPopup.this.selectedIds, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                        public void onNeptuneFailure(Throwable caught) {
                            SearchPopup.this.view.hideBusyIndicator();
                            Window.alert((String)caught.getLocalizedMessage());
                        }

                        public void onNeptuneSuccess(Void result) {
                            SearchPopup.this.view.hideBusyIndicator();
                            SearchPopup.this.view.refresh();
                        }
                    });
                } else {
                    UITitleValidationMessage message = new UITitleValidationMessage(SearchPopup.this.contentConstants.addTitleToOfferNoSelectionError(), UITitleValidationMessageType.Error);
                    SearchPopup.this.view.showMessage(message);
                }
            }
        });
        this.addButton.removeStyleName("gwt-Button");
        this.addButton.addStyleName("ebBtn");
        this.addButton.addStyleName("ebBtn_color_green");
        this.addButton.addStyleName("create_button_icon");
        this.cancelButton = new ButtonWidget(this.contentConstants.cancelButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SearchPopup.this.hide(true);
            }
        });
        this.cancelButton.removeStyleName("gwt-Button");
        this.cancelButton.addStyleName("ebBtn");
    }

    public void executeQuickSearch() {
        this.setValidateMessage(BLANK);
        this.licenseDateBox.removeHightlight();
        this.assetScrollPanel.scrollToTop();
        String currentQuery = this.quickSearchBox.getText();
        this.searchDataProvider.setQuery(currentQuery);
        this.searchDataProvider.setFilterNodeList(this.getFiltersValue());
        if (!this.searchTrigger) {
            this.searchDataProvider.setQuery(BLANK);
            this.searchResultTable.clearResults();
            this.timer.schedule(0);
        } else if (currentQuery.isEmpty() && this.searchTrigger) {
            this.searchDataProvider.setQuery(SHOW_ALL);
            this.timer.schedule(0);
        } else if (currentQuery.length() > this.lastQuery.length() + 2) {
            this.lastQuery = currentQuery;
            this.timer.schedule(200);
        } else {
            this.timer.schedule(500);
        }
    }

    public void refresh() {
        if (this.searchResultTable == null) {
            return;
        }
        this.searchResultTable.setVisible(true);
        if (!this.searchResultTable.isInitialized()) {
            this.searchResultTable.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                }

                public void onNeptuneSuccess(Void result) {
                    SearchPopup.this.searchResultTable.refresh();
                }
            });
        } else {
            this.searchResultTable.refresh();
        }
    }

    public void quickRefresh() {
        if (this.searchResultTable == null) {
            return;
        }
        this.searchResultTable.setVisible(true);
        if (!this.searchResultTable.isInitialized()) {
            this.searchResultTable.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                }

                public void onNeptuneSuccess(Void result) {
                    SearchPopup.this.searchResultTable.quickRefresh();
                }
            });
        } else {
            this.searchResultTable.quickRefresh();
        }
    }

    private void getFiltersFromColumns() {
        this.columns = this.searchResultTable.getColumns();
        for (Column<?, TitleRecord> column : this.columns) {
            if (column.getName().equals("status")) {
                this.statusFilter = (ListBoxWidget)this.searchResultTable.getFilterWidgetForColumn(column);
                this.statusFilter.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        SearchPopup.this.executeQuickSearch();
                    }
                });
                continue;
            }
            if (column.getName().equals("id")) {
                this.titleIDFilter = (RHSValueWidget)this.searchResultTable.getFilterWidgetForColumn(column);
                ((SimpleRHSValueWidget)this.titleIDFilter).addBlurHandler(new BlurHandler(){

                    public void onBlur(BlurEvent event) {
                        SearchPopup.this.executeQuickSearch();
                    }
                });
                continue;
            }
            for (UiBasicSearchField sf : this.searchFieldsCache) {
                if (sf.getDisplayName().equals(column.getDisplayName()) && !column.getDisplayName().startsWith("License")) {
                    RHSValueWidget rhw = (RHSValueWidget)this.searchResultTable.getFilterWidgetForColumn(column);
                    this.filtersMap.put(sf, rhw);
                    ((SimpleRHSValueWidget)rhw).addBlurHandler(new BlurHandler(){

                        public void onBlur(BlurEvent event) {
                            SearchPopup.this.executeQuickSearch();
                        }
                    });
                    continue;
                }
                if (sf.getDisplayName().endsWith("Start")) {
                    this.lws = sf;
                    this.filtersMap.put(this.lws, null);
                }
                if (!sf.getDisplayName().endsWith("End")) continue;
                this.lwe = sf;
                this.filtersMap.put(this.lwe, null);
            }
        }
    }

    public void getLicenseOperator() {
        this.currentLicenseOperator = (String)this.licenseOperator.getSelectedItem();
        if (this.currentLicenseOperator.equals(UISearchLicenseOperator.ACTIVE_BETWEEN.toString())) {
            this.filtersMap.put(this.lws, (RHSValueWidget)this.licenseDateBox);
            this.filtersMap.put(this.lwe, (RHSValueWidget)this.licenseDateBox);
        } else if (this.currentLicenseOperator.equals(UISearchLicenseOperator.START_BETWEEN.toString())) {
            this.filtersMap.put(this.lws, (RHSValueWidget)this.licenseDateBox);
            this.filtersMap.put(this.lwe, null);
        } else if (this.currentLicenseOperator.equals(UISearchLicenseOperator.END_BETWEEN.toString())) {
            this.filtersMap.put(this.lws, null);
            this.filtersMap.put(this.lwe, (RHSValueWidget)this.licenseDateBox);
        }
    }

    public List<IUITitleFilterNode> getFiltersValue() {
        UITitleFilterValueNode rootNode;
        this.getLicenseOperator();
        ArrayList<IUITitleFilterNode> listNode = new ArrayList<IUITitleFilterNode>();
        List pmmFields = PMMFieldProvider.getBasicSearchFields((UiCriteriaMode)UiCriteriaMode.EPISODE);
        for (UiBasicSearchField sf : pmmFields) {
            if (!sf.getDisplayName().equals(this.titleConstants.titleStatus()) && !sf.getDisplayName().equals(this.titleConstants.contentClass()) && !sf.getDisplayName().equals(this.titleConstants.TitleId()) || (rootNode = this.getValueNode(sf)) == null) continue;
            listNode.add((IUITitleFilterNode)rootNode);
            this.searchTrigger = true;
        }
        for (UiBasicSearchField sf : this.searchFieldsCache) {
            rootNode = this.getValueNode(sf);
            if (rootNode == null) continue;
            listNode.add((IUITitleFilterNode)this.getValueNode(sf));
            this.searchTrigger = true;
        }
        if (listNode.size() <= 1 && this.quickSearchBox.getText().isEmpty()) {
            this.searchTrigger = false;
        }
        return listNode;
    }

    public UITitleFilterValueNode getValueNode(UiBasicSearchField filter) {
        RHSValueWidget filterWidget = null;
        UIDataType dataType = filter.getDatatype();
        BaseOperator operator = filter.getDefaultOperator();
        List<Object> value = new ArrayList<String>();
        if (filter.getDisplayName().equals(this.titleConstants.titleStatus())) {
            value.add(this.getStatusFilter());
        } else if (filter.getDisplayName().equals(this.titleConstants.TitleId())) {
            filterWidget = this.titleIDFilter;
            value = this.getTitleIdFilter();
        } else {
            if (filter.getDisplayName().equals(this.titleConstants.contentClass())) {
                value.add(PMMFieldProvider.getOfferContentClass());
                value.add(PMMFieldProvider.getCategoryContentClass());
                return new UITitleFilterValueNode(filter.getXpath(), filter.getAssetType(), filter.getFieldType(), BaseOperator.IN, value, BaseOperator.IN.getParamType(), false, true, dataType, BLANK, BLANK, BLANK);
            }
            if (!filter.getAssetType().equals("PMM_TITLE")) {
                filterWidget = this.filtersMap.get(filter);
                if (filterWidget == null) {
                    return null;
                }
                value = filterWidget.getValues();
            }
        }
        if (value.size() > 1) {
            Date endDate;
            if (((String)value.get(0)).isEmpty() && ((String)value.get(1)).isEmpty()) {
                return null;
            }
            if (!filterWidget.validate()) {
                this.setValidateMessage(this.titleConstants.ruleValidationBadCriteria());
                this.searchTrigger = false;
                return null;
            }
            Date startDate = this.dateFormater.parse((String)value.get(0));
            if (startDate.after(endDate = this.dateFormater.parse((String)value.get(1)))) {
                this.setValidateMessage(this.contentConstants.invalidLicenseDateRange());
                this.searchTrigger = false;
                return null;
            }
            if (this.currentLicenseOperator.equals(UISearchLicenseOperator.ACTIVE_BETWEEN.toString())) {
                if (filter.equals((Object)this.lws)) {
                    return new UITitleFilterValueNode(filter.getXpath(), filter.getAssetType(), filter.getFieldType(), BaseOperator.LESSTHANEQUAL, Arrays.asList((String)value.get(1)), filter.getDefaultOperator().getParamType(), false, false, dataType, BLANK, BLANK, BLANK);
                }
                if (filter.equals((Object)this.lwe)) {
                    return new UITitleFilterValueNode(filter.getXpath(), filter.getAssetType(), filter.getFieldType(), BaseOperator.GREATERTHANEQUAL, Arrays.asList((String)value.get(0)), filter.getDefaultOperator().getParamType(), false, false, dataType, BLANK, BLANK, BLANK);
                }
            }
        }
        if (((String)value.get(0)).isEmpty()) {
            return null;
        }
        return new UITitleFilterValueNode(filter.getXpath(), filter.getAssetType(), filter.getFieldType(), operator, value, filter.getDefaultOperator().getParamType(), false, false, dataType, BLANK, BLANK, BLANK);
    }

    public String getStatusFilter() {
        if (this.statusFilter.getSelectedItem() == null) {
            return BLANK;
        }
        return (String)this.statusFilter.getSelectedItem();
    }

    public List<String> getTitleIdFilter() {
        return this.titleIDFilter.getValues();
    }

    public void clearSearchBox() {
        if (this.quickSearchBox != null) {
            this.quickSearchBox.setText(null);
        }
        this.searchDataProvider.setQuery(BLANK);
        this.lastQuery = BLANK;
    }

    public void clearFilters() {
        this.setValidateMessage(BLANK);
        this.titleIDFilter.setValues(BLANK);
        this.licenseDateBox.setValues(BLANK);
        if (!this.filtersMap.isEmpty()) {
            for (Map.Entry<UiBasicSearchField, RHSValueWidget> me : this.filtersMap.entrySet()) {
                RHSValueWidget rhs = me.getValue();
                if (rhs == null) continue;
                rhs.setValues(BLANK);
                me.setValue(rhs);
            }
        }
        this.statusFilter.setSelectedIndex(0);
        this.licenseOperator.setSelectedIndex(0);
    }

    public void clearSelectionId() {
        if (!this.selectedIds.isEmpty()) {
            this.selectedIds.clear();
        }
    }

    public void reset() {
        this.tipLabelWidget.setVisible(false);
        this.enableScrollBar(false);
        this.clearSearchBox();
        this.clearFilters();
        this.clearSelectionId();
        this.refresh();
    }
}

