/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.quicksearch;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UISearchResult;
import com.tandbergtv.cms.portal.content.client.model.UISearchResultRec;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchService;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchServiceAsync;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.SearchResultTableColumn;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TableColumnNameHelper;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.content.client.title.service.IOffersTitleService;
import com.tandbergtv.cms.portal.content.client.title.service.IOffersTitleServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.referencedtitles.quicksearch.SearchPopup;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UISortOrder;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterQuickSearchListNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiPageInfo;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AnchorTokenizer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SearchTableDataProvider
implements DataProvider<Long, TitleRecord> {
    private List<Column<?, TitleRecord>> columns = new ArrayList();
    private String query = null;
    private int MAX_PAGE_SIZE = 100;
    private Column<?, TitleRecord> defaultSortColumn;
    private List<Column<?, TitleRecord>> sortableColumns = new ArrayList();
    private SortFeatureImpl<?, TitleRecord> sortFeature;
    List<UiColumn> UiColumns = new ArrayList<UiColumn>();
    public static final String TITLE_ID_COLUMN_NAME = "id";
    public static final String CHECKBOX_COLUMN_STYLE = "content-AssetContentTable-cell-body-checkbox";
    public static final String CHECKBOX_FIELD_STYLE = "content-AssetContent-checkbox";
    private List<IUITitleFilterNode> filterNodeList = new ArrayList<IUITitleFilterNode>();
    private TitleSearchServiceAsync searchService = (TitleSearchServiceAsync)GWT.create(TitleSearchService.class);
    private IOffersTitleServiceAsync offersTitleService = (IOffersTitleServiceAsync)GWT.create(IOffersTitleService.class);

    public void init(final AsyncCallback<Void> callback) {
        this.offersTitleService.getInPlaceSearchColumns((AsyncCallback<List<UiColumn>>)new NeptuneAsyncCallback<List<UiColumn>>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(List<UiColumn> result) {
                SearchTableDataProvider.this.UiColumns = result;
                SearchTableDataProvider.this.initializeColumns(result);
                callback.onSuccess(null);
            }
        });
    }

    private void initializeColumns(List<UiColumn> searchResultsColumns) {
        this.columns.add(this.prepareTitleIdColumn());
        for (UiColumn uiColumn : searchResultsColumns) {
            SearchResultTableColumn column = new SearchResultTableColumn(uiColumn, null);
            column.setCellStyle(column.getColumnCellStyle());
            this.columns.add((Column<?, TitleRecord>)column);
        }
        this.sortableColumns = this.columns;
    }

    private Column<String, TitleRecord> prepareTitleIdColumn() {
        ColumnBase<String, TitleRecord> column = null;
        String displayName = "Title ID";
        column = new ColumnBase<String, TitleRecord>(TITLE_ID_COLUMN_NAME, displayName){

            public View<String> getView(TitleRecord record) {
                return new TitleHyperLinkView(record.getTitle().getId());
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.setDefaultSortColumn(column);
        return column;
    }

    public int getMaxPageSize() {
        return this.MAX_PAGE_SIZE;
    }

    public void setDisplayColumns(List<Column<?, TitleRecord>> columns) {
        this.columns = columns;
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public List<Column<?, TitleRecord>> getColumns() {
        return this.columns;
    }

    protected UITitleFilter quickSearchStandFilter(UITitleFilterQuickSearchListNode quickFilter) {
        return new UITitleFilter((IUITitleFilterNode)quickFilter, TITLE_ID_COLUMN_NAME, "PMM_TITLE", UISortOrder.DESCENDING, UIFieldType.PMM_TITLE, UiCriteriaMode.EPISODE);
    }

    protected List<UiColumn> getUIColumns() {
        return this.UiColumns;
    }

    public void getRecords(final AsyncCallback<List<TitleRecord>> callback) {
        if (this.getQuery() == null || this.getQuery().isEmpty()) {
            callback.onSuccess(new ArrayList());
            SearchPopup.numRecordsLabel.setText("");
        } else {
            UITitleFilterQuickSearchListNode quickSearch = new UITitleFilterQuickSearchListNode(this.processInput(this.getQuery()));
            quickSearch.setList(this.getFilterNodeList());
            UITitleFilter titleFilter = this.quickSearchStandFilter(quickSearch);
            if (TableColumnNameHelper.isMetdataField(this.sortFeature.getSortColumnName())) {
                titleFilter.getSortInfo().setSortFieldType(UIFieldType.ASSET);
                String columnName = TableColumnNameHelper.getColumnName(this.sortFeature.getSortColumnName());
                titleFilter.getSortInfo().setSortColumnName(columnName);
                String colSection = TableColumnNameHelper.getSectionName(this.sortFeature.getSortColumnName()).toUpperCase();
                titleFilter.getSortInfo().setSortColumnSection(colSection);
            } else {
                titleFilter.getSortInfo().setSortFieldType(UIFieldType.PMM_TITLE);
                titleFilter.getSortInfo().setSortColumnName(this.sortFeature.getSortColumnName());
            }
            UISortOrder order = UISortOrder.DESCENDING;
            if (this.sortFeature.isAscending()) {
                order = UISortOrder.ASCENDING;
            }
            titleFilter.getSortInfo().setSortOrder(order);
            titleFilter.setPageInfo(new UiPageInfo(0, this.MAX_PAGE_SIZE));
            titleFilter.setIncludeCount(false);
            this.searchService.getTitles(titleFilter, this.getUIColumns(), (AsyncCallback<UISearchResult>)new NeptuneAsyncCallback<UISearchResult>(){

                public void onNeptuneFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onNeptuneSuccess(UISearchResult result) {
                    ArrayList<TitleRecord> records = new ArrayList<TitleRecord>();
                    if (result.getTitles() == null) {
                        return;
                    }
                    for (UISearchResultRec t : result.getTitles()) {
                        records.add(new TitleRecord(t));
                    }
                    callback.onSuccess(records);
                }
            });
        }
    }

    public String processInput(String text) {
        if ((text = text.trim()).isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        String[] tokens = text.split("\\s");
        int i = 0;
        while (i < tokens.length) {
            if (i != tokens.length - 1) {
                builder.append("+\"");
                builder.append(tokens[i]);
                builder.append("\"");
            } else {
                builder.append("+");
                builder.append(tokens[i]);
                builder.append("*");
            }
            ++i;
        }
        return builder.toString();
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void getRecord(Long key, AsyncCallback<TitleRecord> callback) {
        throw new UnsupportedOperationException();
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public List<IUITitleFilterNode> getFilterNodeList() {
        return this.filterNodeList;
    }

    public void setFilterNodeList(List<IUITitleFilterNode> list) {
        this.filterNodeList = list;
    }

    private void setDefaultSortColumn(ColumnBase<String, TitleRecord> column) {
        this.defaultSortColumn = column;
    }

    public Column<?, TitleRecord> getDefaultSortColumn() {
        return this.defaultSortColumn;
    }

    public List<Column<?, TitleRecord>> getSortableColumns() {
        return this.sortableColumns;
    }

    public void setSortFeature(SortFeatureImpl<?, TitleRecord> sortFeature) {
        this.sortFeature = sortFeature;
    }

    private class TitleHyperLinkView
    implements View<String> {
        long titleId;

        public TitleHyperLinkView(long titleId) {
            this.titleId = titleId;
        }

        public Widget getWidget() {
            HashMap<String, String> anchorTokens = new HashMap<String, String>();
            anchorTokens.put("Id", String.valueOf(this.titleId));
            anchorTokens.put("returnAnchor", History.getToken());
            String token = "Content.Search." + new AnchorTokenizer().buildAnchor(anchorTokens);
            Hyperlink hyperlink = new Hyperlink(String.valueOf(this.titleId), token);
            return hyperlink;
        }

        public String getStyleName() {
            return "table-data-link";
        }

        public void release() {
        }
    }
}

