/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.rules;

import com.ericsson.cms.me.client.model.DeconflictMode;
import com.ericsson.cms.me.client.view.metadatadeconflict.MetadataDeconflictCallback;
import com.ericsson.cms.me.client.view.metadatadeconflict.MetadataDeconflictWidget;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareData;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewInitData;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewRequest;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewResponse;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UIMsoRuleSet;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UiMso;
import com.tandbergtv.cms.portal.content.client.title.service.IRulesPreviewService;
import com.tandbergtv.cms.portal.content.client.title.service.IRulesPreviewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.HtmlorXmlDisplayHelper;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.cms.portal.content.client.title.view.compare.ITitleCompareViewController;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareView;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleValidationViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.mso.MSORulesPreviewView;
import com.tandbergtv.cms.portal.content.client.title.view.rules.IRulesPreviewController;
import com.tandbergtv.cms.portal.content.client.title.view.rules.MasterTitleFormPanel;
import com.tandbergtv.cms.portal.content.client.title.view.rules.RulesPreviewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.rules.SiteTitleFormPanel;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.List;

public class RulesPreviewTab
extends TitleViewTab
implements IRulesPreviewController,
ITitleCompareViewController {
    public static final String TAB_NAME = "RulesPreview";
    private RulesPreviewMessages messages = (RulesPreviewMessages)GWT.create(RulesPreviewMessages.class);
    private IRulesPreviewServiceAsync rulesService = (IRulesPreviewServiceAsync)GWT.create(IRulesPreviewService.class);
    private ITitleViewServiceAsync viewService = (ITitleViewServiceAsync)GWT.create(ITitleViewService.class);
    private MasterTitleFormPanel masterTitleFormPanel;
    private SiteTitleFormPanel siteTitleFormPanel;
    private MSORulesPreviewView msoRulesPreviewView;
    private TitleCompareView compareView;
    private RulePreviewRequest lastRequest;
    private Widget goBackWidget = null;

    public RulesPreviewTab(TitleView parent) {
        super(parent);
    }

    private void setSpecName(UITitleCompareData data) {
        List<UIAssetSpecificationListItem> specs;
        if (this.lastRequest != null && data != null && this.lastRequest.specName == null && (specs = data.getSpecifications()) != null && specs.size() > 0) {
            this.lastRequest.specName = specs.get(0).getName();
        }
    }

    @Override
    protected String getTabName() {
        return TAB_NAME;
    }

    @Override
    protected void initialize() {
        this.masterTitleFormPanel = new MasterTitleFormPanel();
        this.masterTitleFormPanel.setController(this);
        this.siteTitleFormPanel = new SiteTitleFormPanel();
        this.siteTitleFormPanel.setController(this);
    }

    private void setGoBackWidget(Widget w) {
        this.goBackWidget = w;
    }

    @Override
    public void refreshTab() {
        this.showBusyIndicator();
        Long titleId = this.getViewInput().getTitleId();
        if (this.getViewInput().getTitle().getOverview() == null) {
            this.viewService.getTitle(titleId, (AsyncCallback<UITitle>)new NeptuneAsyncCallback<UITitle>(){

                public void onNeptuneFailure(Throwable caught) {
                }

                public void onNeptuneSuccess(UITitle result) {
                    RulesPreviewTab.this.getViewInput().getTitle().setOverview(result.getOverview());
                    RulesPreviewTab.this.updateTitleHeader(result.getOverview());
                }
            });
        }
        this.rulesService.getInitData(this.getViewInput().getTitleId(), (AsyncCallback<RulePreviewInitData>)new NeptuneAsyncCallback<RulePreviewInitData>(){

            public void onNeptuneSuccess(RulePreviewInitData result) {
                if (result.isSiteTitle) {
                    RulesPreviewTab.this.getContainer().setWidget((Widget)RulesPreviewTab.this.siteTitleFormPanel);
                    RulesPreviewTab.this.setGoBackWidget((Widget)RulesPreviewTab.this.siteTitleFormPanel);
                    RulesPreviewTab.this.siteTitleFormPanel.refresh(result);
                    RulesPreviewTab.this.setMsoRulesData(result.siteId);
                } else {
                    RulesPreviewTab.this.getContainer().setWidget((Widget)RulesPreviewTab.this.masterTitleFormPanel);
                    RulesPreviewTab.this.setGoBackWidget((Widget)RulesPreviewTab.this.masterTitleFormPanel);
                    RulesPreviewTab.this.masterTitleFormPanel.refresh(result);
                }
                RulesPreviewTab.this.hideBusyIndicator();
            }

            public void onNeptuneFailure(Throwable caught) {
                RulesPreviewTab.this.showSevereError(caught.getMessage());
                RulesPreviewTab.this.hideBusyIndicator();
            }
        });
    }

    private void setMsoRulesData(final int siteId) {
        this.rulesService.getAllShallowMsoRuleSets((AsyncCallback<List<UIMsoRuleSet>>)new NeptuneAsyncCallback<List<UIMsoRuleSet>>(){

            public void onNeptuneFailure(Throwable caught) {
                RulesPreviewTab.this.showSevereError(caught.getMessage());
            }

            public void onNeptuneSuccess(List<UIMsoRuleSet> result) {
                try {
                    RulesPreviewTab.this.checkMPDistributionType(siteId, result);
                }
                catch (NeptuneException e) {
                    RulesPreviewTab.this.showSevereError(e.getMessage());
                }
            }
        });
    }

    private void checkMPDistributionType(int siteId, final List<UIMsoRuleSet> result) throws NeptuneException {
        this.rulesService.isMediaPathSiteTitle(siteId, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

            public void onNeptuneFailure(Throwable caught) {
                RulesPreviewTab.this.showSevereError(caught.getMessage());
            }

            public void onNeptuneSuccess(Boolean check) {
                RulesPreviewTab.this.siteTitleFormPanel.setMsoRulesData(result, check);
            }
        });
    }

    @Override
    public void previewGlobalRule(Integer ruleSetId, String ruleDisplayName, boolean enhance) {
        this.compareView = new TitleCompareView(this);
        TitleCompareViewInput input = new TitleCompareViewInput();
        input.restrictedHeight = this.getUsedHeight();
        input.restrictedWidth = this.getUsedWidth();
        input.header = this.messages.globalRulePreviewHeaderMessage(ruleDisplayName);
        input.displayName1 = this.messages.rulePreviewBeforeNormalization();
        input.displayName2 = this.messages.rulePreviewAfterNormalization();
        this.compareView.setInput(input);
        this.lastRequest = new RulePreviewRequest();
        this.lastRequest.ruleSetId = ruleSetId;
        this.lastRequest.titleId = this.getViewInput().getTitleId();
        this.lastRequest.specName = this.getViewInput().getSpecificationName();
        this.lastRequest.enhance = enhance;
        this.compareDiff();
        this.getContainer().setWidget((Widget)this.compareView);
    }

    @Override
    public void previewSiteRules(Integer siteId, String siteDisplayName, boolean enhance) {
        this.compareView = new TitleCompareView(this);
        TitleCompareViewInput input = new TitleCompareViewInput();
        input.restrictedHeight = this.getUsedHeight();
        input.restrictedWidth = this.getUsedWidth();
        input.header = this.messages.allSiteRulesPreviewHeaderMessage(siteDisplayName);
        input.displayName1 = this.messages.rulePreviewBeforeNormalization();
        input.displayName2 = this.messages.rulePreviewAfterNormalization();
        this.compareView.setInput(input);
        this.lastRequest = new RulePreviewRequest();
        this.lastRequest.siteId = siteId;
        this.lastRequest.titleId = this.getViewInput().getTitleId();
        this.lastRequest.specName = this.getViewInput().getSpecificationName();
        this.lastRequest.enhance = enhance;
        this.compareDiff();
        this.getContainer().setWidget((Widget)this.compareView);
    }

    @Override
    public void previewSiteRule(Integer siteId, Integer ruleId, String siteDisplayName, boolean enhance) {
        this.compareView = new TitleCompareView(this);
        this.lastRequest = new RulePreviewRequest();
        this.lastRequest.siteId = siteId;
        this.lastRequest.ruleSetId = ruleId;
        this.lastRequest.titleId = this.getViewInput().getTitleId();
        this.lastRequest.specName = this.getViewInput().getSpecificationName();
        this.lastRequest.enhance = enhance;
        TitleCompareViewInput input = new TitleCompareViewInput();
        input.restrictedHeight = this.getUsedHeight();
        input.restrictedWidth = this.getUsedWidth();
        input.header = this.messages.siteRulePreviewHeaderMessage(siteDisplayName);
        input.displayName1 = this.messages.rulePreviewBeforeNormalization();
        input.displayName2 = this.messages.rulePreviewAfterNormalization();
        this.compareView.setInput(input);
        this.compareDiff();
    }

    @Override
    public void previewMsoRules(Integer ruleSetId) {
        Long siteTitleId = this.titleView.getInput().getTitleId();
        if (ruleSetId == -1) {
            ruleSetId = null;
        }
        this.msoRulesPreviewView = new MSORulesPreviewView(this);
        this.msoRulesPreviewView.setCurrentSiteTitleId(siteTitleId);
        this.msoRulesPreviewView.setCurrentRuleSetId(ruleSetId);
        this.rulesService.getMsos(siteTitleId, ruleSetId, (AsyncCallback<List<UiMso>>)new NeptuneAsyncCallback<List<UiMso>>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(List<UiMso> result) {
                RulesPreviewTab.this.msoRulesPreviewView.buildUI(result);
                RulesPreviewTab.this.getContainer().setWidget((Widget)RulesPreviewTab.this.msoRulesPreviewView);
            }
        });
    }

    @Override
    public String getTabDisplayName() {
        return this.getViewMessages().rulesPreviewTabName();
    }

    public void compareXml() {
        this.compareView.showBusyIndicator();
        this.rulesService.previewRuleSpec(this.lastRequest, HtmlorXmlDisplayHelper.useHtml(), (AsyncCallback<RulePreviewResponse>)new NeptuneAsyncCallback<RulePreviewResponse>(){

            public void onNeptuneFailure(Throwable caught) {
                RulesPreviewTab.this.compareView.showErrorView(caught);
                RulesPreviewTab.this.compareView.hideBusyIndicator();
            }

            public void onNeptuneSuccess(RulePreviewResponse resp) {
                RulesPreviewTab.this.compareView.showXmlView(resp.xmlData);
                RulesPreviewTab.this.compareView.hideBusyIndicator();
            }
        });
    }

    public void compareDiff() {
        this.showBusyIndicator();
        this.rulesService.previewRule(this.lastRequest, (AsyncCallback<RulePreviewResponse>)new NeptuneAsyncCallback<RulePreviewResponse>(){

            public void onNeptuneFailure(Throwable caught) {
                RulesPreviewTab.this.getContainer().setWidget((Widget)RulesPreviewTab.this.compareView);
                RulesPreviewTab.this.compareView.showErrorView(caught);
                RulesPreviewTab.this.hideBusyIndicator();
            }

            public void onNeptuneSuccess(RulePreviewResponse resp) {
                ((RulesPreviewTab)RulesPreviewTab.this).lastRequest.meRequestKey = resp.meRequestKey;
                if (resp.meMultipleMatches) {
                    RulesPreviewTab.this.hideBusyIndicator();
                    RulesPreviewTab.this.showDeconflictPanel(resp.meRequestKey);
                } else {
                    RulesPreviewTab.this.getContainer().setWidget((Widget)RulesPreviewTab.this.compareView);
                    RulesPreviewTab.this.setSpecName(resp.diffData);
                    ((RulesPreviewTab)RulesPreviewTab.this).compareView.getInput().compareData = resp.diffData;
                    RulesPreviewTab.this.compareView.showDiffView();
                    RulesPreviewTab.this.hideBusyIndicator();
                }
            }
        });
    }

    private void showDeconflictPanel(final String meRequestKey) {
        MetadataDeconflictCallback meCallback = new MetadataDeconflictCallback(){

            public void saveWithEnhancement() {
                ((RulesPreviewTab)RulesPreviewTab.this).lastRequest.meRequestKey = meRequestKey;
                RulesPreviewTab.this.compareDiff();
            }

            public void saveWithoutEnhancement() {
            }

            public void normalizeAndPreviewTitle() {
            }

            public void cancelSave() {
                RulesPreviewTab.this.getContainer().setWidget(RulesPreviewTab.this.goBackWidget);
            }

            public int getFrameRestrictedWidth() {
                return RulesPreviewTab.this.getUsedWidth();
            }

            public int getFrameRestrictedHeight() {
                return RulesPreviewTab.this.getUsedHeight();
            }

            public void showMessage(String msg, boolean isError) {
                TitleValidationViewInput validationViewInput = new TitleValidationViewInput();
                if (isError) {
                    validationViewInput.setErrorHeader(msg);
                } else {
                    validationViewInput.setInfoHeader(msg);
                }
                RulesPreviewTab.this.titleView.showMessage(validationViewInput);
            }

            public void clearMessage() {
                RulesPreviewTab.this.getTitleView().showMessage(null);
            }
        };
        MetadataDeconflictWidget meWidget = new MetadataDeconflictWidget(meRequestKey, meCallback, DeconflictMode.RULES_PREVIEW);
        this.getContainer().setWidget((Widget)meWidget);
    }

    @Override
    public void onCancel() {
        this.getContainer().setWidget(this.goBackWidget);
    }

    @Override
    public void onShowDifferences() {
        this.compareDiff();
    }

    @Override
    public void onShowXml() {
        this.compareXml();
    }

    @Override
    public void onSpecChanged(String newSpec) {
        this.lastRequest.specName = newSpec;
        this.compareView.getInput().specName = newSpec;
        this.compareXml();
    }
}

