/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.rules;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.NameValuePair;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewInitData;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UIMsoRuleSet;
import com.tandbergtv.cms.portal.content.client.title.view.rules.IRulesPreviewController;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import java.util.List;

public class SiteTitleFormPanel
extends SimplePanel {
    private static final String CRITERIA_PANEL_CONTAINER_STYLE = "criteria-panel-container";
    private static final String CRITERIA_PANEL_STYLE = "criteria-panel";
    private IRulesPreviewController controller = null;
    private int siteId;
    private ListBox lbRules;
    private ListBox msoRules;
    private CheckBox cbEnhance = null;
    private VerticalPanel rulesPanel = new VerticalPanel();
    private VerticalPanel normalizationPanel = new VerticalPanel();
    private VerticalPanel msoPanel = new VerticalPanel();

    public SiteTitleFormPanel() {
        TextBoxWidget normalizationRulesHeader = new TextBoxWidget("Site Rules");
        TextBoxWidget msoRulesHeader = new TextBoxWidget("MSO Override");
        SimpleContainer normalizationRulesHeaderContainer = new SimpleContainer();
        SimpleContainer msoRulesHeaderContainer = new SimpleContainer();
        normalizationRulesHeaderContainer.setStyleName("rule-order-pos");
        msoRulesHeaderContainer.setStyleName("rule-order-pos");
        normalizationRulesHeader.setStyleName("rule-order-noneditable-header");
        msoRulesHeader.setStyleName("rule-order-noneditable-header");
        FlexTable table = new FlexTable();
        table.setCellSpacing(10);
        this.lbRules = new ListBox();
        table.setWidget(0, 0, (Widget)new Label("Site Normalization Rules:"));
        table.setWidget(0, 1, (Widget)this.lbRules);
        Button btnRulePreview = new Button("Preview", new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (SiteTitleFormPanel.this.controller == null) {
                    return;
                }
                String displayName = SiteTitleFormPanel.this.lbRules.getItemText(SiteTitleFormPanel.this.lbRules.getSelectedIndex());
                String strRuleId = SiteTitleFormPanel.this.lbRules.getValue(SiteTitleFormPanel.this.lbRules.getSelectedIndex());
                Integer ruleSetId = Integer.valueOf(strRuleId);
                boolean enhance = SiteTitleFormPanel.this.cbEnhance == null ? false : SiteTitleFormPanel.this.cbEnhance.getValue();
                SiteTitleFormPanel.this.controller.previewSiteRule(SiteTitleFormPanel.this.siteId, ruleSetId, displayName, enhance);
            }
        });
        btnRulePreview.removeStyleName("gwt-Button");
        btnRulePreview.addStyleName("ebBtn");
        btnRulePreview.addStyleName("preview_button_icon");
        table.setWidget(0, 2, (Widget)btnRulePreview);
        NeptuneSecurity security = NeptuneApplication.getApplication().getSecurity();
        boolean hasMetadataEnhancementPermission = security.isUserInRole("MetadataEnhancement_Enhance");
        if (hasMetadataEnhancementPermission) {
            this.cbEnhance = new CheckBox();
            this.cbEnhance.setValue(Boolean.valueOf(false));
            table.setWidget(2, 0, (Widget)new Label("Enhance on Preview:"));
            table.setWidget(2, 1, (Widget)this.cbEnhance);
        }
        normalizationRulesHeaderContainer.add((Widget)normalizationRulesHeader);
        msoRulesHeaderContainer.add((Widget)msoRulesHeader);
        this.normalizationPanel.add((Widget)normalizationRulesHeaderContainer);
        this.normalizationPanel.add((Widget)table);
        this.normalizationPanel.setStyleName(CRITERIA_PANEL_STYLE);
        this.msoPanel.add((Widget)msoRulesHeaderContainer);
        this.msoPanel.add(this.getMsoTable());
        this.msoPanel.setStyleName(CRITERIA_PANEL_STYLE);
        this.rulesPanel.add((Widget)this.normalizationPanel);
        this.rulesPanel.add((Widget)this.msoPanel);
        this.add((Widget)this.rulesPanel);
    }

    private Widget getMsoTable() {
        FlexTable table = new FlexTable();
        table.setCellSpacing(10);
        this.msoRules = new ListBox();
        table.setWidget(0, 0, (Widget)new Label("MSO Override Rules:"));
        table.setWidget(0, 1, (Widget)this.msoRules);
        Button btnRulePreview = new Button("Preview", new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (SiteTitleFormPanel.this.controller == null) {
                    return;
                }
                String strRuleId = SiteTitleFormPanel.this.msoRules.getValue(SiteTitleFormPanel.this.msoRules.getSelectedIndex());
                Integer ruleSetId = Integer.valueOf(strRuleId);
                SiteTitleFormPanel.this.controller.previewMsoRules(ruleSetId);
            }
        });
        btnRulePreview.removeStyleName("gwt-Button");
        btnRulePreview.addStyleName("ebBtn");
        btnRulePreview.addStyleName("preview_button_icon");
        table.setWidget(0, 2, (Widget)btnRulePreview);
        return table;
    }

    public void setController(IRulesPreviewController controller) {
        this.controller = controller;
    }

    public void refresh(RulePreviewInitData data) {
        this.siteId = data.siteId;
        this.lbRules.clear();
        this.lbRules.addItem("*** All Active Rules ***", "-1");
        for (NameValuePair nvp : data.rules) {
            this.lbRules.addItem(nvp.getName(), nvp.getValue());
        }
    }

    public void setMsoRulesData(List<UIMsoRuleSet> result, Boolean mpCheck) {
        if (!mpCheck.booleanValue()) {
            this.msoPanel.setVisible(false);
        } else {
            this.msoRules.clear();
            this.msoRules.addItem("*** All Active Rules ***", "-1");
            for (UIMsoRuleSet ruleSet : result) {
                this.msoRules.addItem(ruleSet.getRuleSetDisplayName(), ruleSet.getRuleSetId().toString());
            }
        }
    }
}

