/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.series;

import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UISearchResultRec;
import com.tandbergtv.cms.portal.content.client.model.UiField;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TableColumnNameHelper;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.content.client.title.view.series.EpisodesPanel;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

public class EpisodeTableColumn
extends ColumnBase<String, TitleRecord> {
    private UiColumn uiColumn;
    private EpisodesPanel panel;

    public EpisodeTableColumn(UiColumn uiColumn, EpisodesPanel panel) {
        super(uiColumn.getInternalName(), uiColumn.getDisplayName());
        this.uiColumn = uiColumn;
        this.panel = panel;
    }

    public View<String> getView(TitleRecord record) {
        UISearchResultRec t = record.getTitle();
        for (UiField f : t.getFields()) {
            String colInternalName = TableColumnNameHelper.getColumnName(f.getName(), f.getParentAssetType());
            LabelStringView view = null;
            if (!colInternalName.equals(this.getName())) continue;
            if (this.getName().equalsIgnoreCase("status")) {
                return new ImageView(f.getValue());
            }
            view = new LabelStringView(f.getValue());
            return view;
        }
        return new LabelStringView("ERROR: Value not available");
    }

    public String getColumnCellStyle() {
        String style = "nwt-TableColumnPanel-dataCell-general";
        if (this.uiColumn.getDataType() != null) {
            switch (this.uiColumn.getDataType()) {
                case BOOLEAN: 
                case STRING: {
                    if (this.uiColumn.getName().equalsIgnoreCase("status")) {
                        style = "nwt-TableColumnPanel-dataCell-icon";
                        break;
                    }
                    style = "nwt-TableColumnPanel-dataCell-text";
                    break;
                }
                case FLOAT: 
                case INTEGER: {
                    style = "nwt-TableColumnPanel-dataCell-numeric";
                    break;
                }
                case DATE: 
                case TIME: {
                    style = "nwt-TableColumnPanel-dataCell-date";
                }
            }
        }
        return style;
    }

    private class ImageView
    implements View<String> {
        String status;

        public ImageView(String status) {
            this.status = status;
        }

        public Widget getWidget() {
            ImageWidget statusImage = new ImageWidget();
            TitleClientBundle bundle = new TitleClientBundle();
            bundle.updateTitleStatusIcon((Image)statusImage, this.status, Boolean.valueOf(false));
            return statusImage;
        }

        public void release() {
        }

        public String getStyleName() {
            return null;
        }
    }
}

