/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.series;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UISearchResult;
import com.tandbergtv.cms.portal.content.client.model.UISearchResultRec;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.service.ISeriesTitleService;
import com.tandbergtv.cms.portal.content.client.title.service.ISeriesTitleServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.series.EpisodeTableColumn;
import com.tandbergtv.cms.portal.content.client.title.view.series.EpisodesPanel;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AnchorTokenizer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EpisodeTitleTableDataProvider
implements DataProvider<Long, TitleRecord> {
    private EpisodesPanel view;
    private List<Column<?, TitleRecord>> columns = new ArrayList();
    public static final String TITLE_ID_COLUMN_NAME = "titleId";
    private ISeriesTitleServiceAsync seriesTitleService = (ISeriesTitleServiceAsync)GWT.create(ISeriesTitleService.class);

    public EpisodeTitleTableDataProvider(EpisodesPanel view) {
        this.view = view;
    }

    public void init(final AsyncCallback<Void> callback) {
        this.view.showBusyIndicator();
        this.seriesTitleService.getEpisodeSearchColumns((AsyncCallback<List<UiColumn>>)new NeptuneAsyncCallback<List<UiColumn>>(){

            public void onNeptuneFailure(Throwable caught) {
                EpisodeTitleTableDataProvider.this.view.hideBusyIndicator();
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(List<UiColumn> result) {
                EpisodeTitleTableDataProvider.this.view.hideBusyIndicator();
                EpisodeTitleTableDataProvider.this.initializeColumns(result);
                callback.onSuccess(null);
            }
        });
    }

    private void initializeColumns(List<UiColumn> searchResultsColumns) {
        this.columns.add(this.prepareTitleIdColumn());
        for (UiColumn uiColumn : searchResultsColumns) {
            EpisodeTableColumn column = new EpisodeTableColumn(uiColumn, this.view);
            column.setCellStyle(column.getColumnCellStyle());
            this.columns.add((Column<?, TitleRecord>)column);
        }
    }

    private Column<String, TitleRecord> prepareTitleIdColumn() {
        ColumnBase<String, TitleRecord> column = null;
        String displayName = this.view.getTitleViewMessages().episodesTableTitleIdColumn();
        column = new ColumnBase<String, TitleRecord>(TITLE_ID_COLUMN_NAME, displayName){

            public View<String> getView(TitleRecord record) {
                return new TitleHyperLinkView(record.getTitle().getId());
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        return column;
    }

    public void setDisplayColumns(List<Column<?, TitleRecord>> columns) {
        this.columns = columns;
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public List<Column<?, TitleRecord>> getColumns() {
        return this.columns;
    }

    public void getRecords(final AsyncCallback<List<TitleRecord>> callback) {
        Long seriesDocumentId = null;
        Long seasonAssetId = null;
        AssetTree.AssetInfo input = this.view.getRootAssetInfo();
        UIAsset rootAsset = input.getAsset();
        UIAsset selectedAsset = this.view.getSelectedAssetInfo().getAsset();
        seriesDocumentId = rootAsset.getId();
        if (selectedAsset.getAssetType().equalsIgnoreCase("SEASON") && (seasonAssetId = selectedAsset.getId()) == null) {
            seriesDocumentId = null;
        }
        if (seriesDocumentId == null) {
            callback.onSuccess(new ArrayList());
            return;
        }
        this.view.showBusyIndicator();
        this.seriesTitleService.getEpisodeTitles(seriesDocumentId, seasonAssetId, (AsyncCallback<UISearchResult>)new NeptuneAsyncCallback<UISearchResult>(){

            public void onNeptuneFailure(Throwable caught) {
                EpisodeTitleTableDataProvider.this.view.hideBusyIndicator();
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(UISearchResult result) {
                EpisodeTitleTableDataProvider.this.view.hideBusyIndicator();
                ArrayList<TitleRecord> records = new ArrayList<TitleRecord>();
                if (result.getTitles() == null) {
                    return;
                }
                for (UISearchResultRec t : result.getTitles()) {
                    records.add(new TitleRecord(t));
                }
                callback.onSuccess(records);
            }
        });
    }

    public void getRecord(Long key, AsyncCallback<TitleRecord> callback) {
        throw new UnsupportedOperationException();
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    public boolean isCheckboxEnabled() {
        return false;
    }

    private class TitleHyperLinkView
    implements View<String> {
        long titleId;

        public TitleHyperLinkView(long titleId) {
            this.titleId = titleId;
        }

        public Widget getWidget() {
            HashMap<String, String> anchorTokens = new HashMap<String, String>();
            anchorTokens.put("Id", String.valueOf(this.titleId));
            anchorTokens.put("returnAnchor", History.getToken());
            String token = "Content.Search." + new AnchorTokenizer().buildAnchor(anchorTokens);
            Hyperlink hyperlink = new Hyperlink(String.valueOf(this.titleId), token);
            return hyperlink;
        }

        public String getStyleName() {
            return "table-data-link";
        }

        public void release() {
        }
    }
}

