/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.series;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.tab.SucessPanel;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.series.EpisodeTitleTableDataProvider;
import com.tandbergtv.cms.portal.content.client.title.view.series.TitleEpisodesTab;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class EpisodesPanel
extends Composite {
    private TitleEpisodesTab parent;
    EpisodeTitleTableDataProvider dataProvider;
    private SimpleContainer rootContainer;
    private VerticalContainer mainContainer;
    private Table<Long, TitleRecord> episodeTable;
    private HeaderPanel header;
    private SucessPanel infoMessagePanel;
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private static final String STYLE_NAME = "content-AssetContent";

    public EpisodesPanel(TitleEpisodesTab parent) {
        this.parent = parent;
    }

    protected TitleEpisodesTab getTab() {
        return this.parent;
    }

    private void initWidgets() {
        this.episodeTable = new Table((DataProvider)this.dataProvider);
        this.rootContainer = new SimpleContainer();
        this.rootContainer.addStyleName(STYLE_NAME);
        this.mainContainer = new VerticalContainer();
        this.rootContainer.setWidget((Widget)this.mainContainer);
        this.initWidget((Widget)this.rootContainer);
        this.header = new HeaderPanel("");
        this.infoMessagePanel = new SucessPanel();
        String message = "..Please select a Series or Season asset";
        this.infoMessagePanel.addSuccessMessage(message);
        this.infoMessagePanel.setVisible(false);
        this.mainContainer.add((Widget)this.header);
        this.mainContainer.add((Widget)this.infoMessagePanel);
        this.mainContainer.add(this.episodeTable);
    }

    public void initDataProvider() {
        this.dataProvider = new EpisodeTitleTableDataProvider(this);
        this.dataProvider.init((AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(Void result) {
                EpisodesPanel.this.initWidgets();
                EpisodesPanel.this.parent.handleGetColumnRecordsSuccess();
            }
        });
    }

    public void showBusyIndicator() {
        this.busyIndicator.center();
    }

    public void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    public void refresh() {
        if (this.episodeTable == null) {
            return;
        }
        UIAsset selectedAsset = this.getSelectedAssetInfo().getAsset();
        if (!selectedAsset.getAssetType().equalsIgnoreCase("SERIES") && !selectedAsset.getAssetType().equalsIgnoreCase("SEASON")) {
            this.infoMessagePanel.setVisible(true);
            this.episodeTable.setVisible(false);
            return;
        }
        this.infoMessagePanel.setVisible(false);
        this.episodeTable.setVisible(true);
        if (!this.episodeTable.isInitialized()) {
            this.episodeTable.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                }

                public void onNeptuneSuccess(Void result) {
                    EpisodesPanel.this.episodeTable.refresh();
                }
            });
        } else {
            this.episodeTable.refresh();
        }
    }

    public AssetTree.AssetInfo getSelectedAssetInfo() {
        return this.parent.getSelectedAssetInfo();
    }

    public AssetTree.AssetInfo getRootAssetInfo() {
        return this.parent.getRootAssetInfo();
    }

    public TitleViewMessages getTitleViewMessages() {
        return this.parent.getViewMessages();
    }
}

