/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.series;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.series.UISeasonListItem;
import com.tandbergtv.cms.portal.content.client.title.model.series.UISeriesInfo;
import com.tandbergtv.cms.portal.content.client.title.model.series.UISeriesListItem;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleValidationViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.series.TitleSeriesTab;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;

public class SeriesPanel
extends SimpleContainer {
    TitleSeriesTab parent;
    private VerticalContainer mainContainer;
    private HorizontalContainer selContainer;
    private HorizontalContainer butContainer;
    private ListBoxWidget<UISeriesListItem> seriesListBox;
    private ListBoxWidget<String> seasonListBox;
    private ButtonWidget associateButton;
    private ButtonWidget disassociateButton;
    private UISeriesInfo curInfo;
    private static final String STYLE_NAME = "content-TitleListsPanel";
    private static final int SPACING = 4;

    public SeriesPanel(TitleSeriesTab parent) {
        this.parent = parent;
        this.initWidgets();
    }

    private void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(4);
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        this.selContainer = new HorizontalContainer();
        this.selContainer.setSpacing(4);
        LabelWidget seriesLabel = new LabelWidget(this.parent.getViewMessages().seriesLabelName());
        this.selContainer.add((Widget)seriesLabel);
        this.seriesListBox = new ListBoxWidget(false);
        this.seriesListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                SeriesPanel.this.clearSeasons();
                String seriesDocId = ((UISeriesListItem)((SeriesPanel)SeriesPanel.this).seriesListBox.getSelectedItem()).seriesDocId;
                SeriesPanel.this.parent.updateSeasons(seriesDocId);
            }
        });
        this.selContainer.add(this.seriesListBox);
        LabelWidget seasonLabel = new LabelWidget("  " + this.parent.getViewMessages().seasonLabelName());
        this.selContainer.add((Widget)seasonLabel);
        this.seasonListBox = new ListBoxWidget(false);
        this.seasonListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
            }
        });
        this.selContainer.add(this.seasonListBox);
        this.mainContainer.add((Widget)this.selContainer);
        String assocText = this.parent.getViewMessages().associateButtonText();
        this.associateButton = new ButtonWidget(assocText);
        this.associateButton.removeStyleName("gwt-Button");
        this.associateButton.addStyleName("ebBtn");
        this.associateButton.addStyleName("associate_button_icon");
        this.associateButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SeriesPanel.this.asscociateClickedAction();
            }
        });
        this.associateButton.setVisible(true);
        this.associateButton.setEnabled(true);
        String disassocText = this.parent.getViewMessages().disassociateButtonText();
        this.disassociateButton = new ButtonWidget(disassocText);
        this.disassociateButton.removeStyleName("gwt-Button");
        this.disassociateButton.addStyleName("ebBtn");
        this.disassociateButton.addStyleName("disassociate_button_icon");
        this.disassociateButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SeriesPanel.this.disasscociateClickedAction();
            }
        });
        this.disassociateButton.setVisible(true);
        this.disassociateButton.setEnabled(true);
        this.butContainer = new HorizontalContainer();
        this.butContainer.setSpacing(4);
        this.butContainer.add((Widget)this.associateButton);
        this.butContainer.add((Widget)this.disassociateButton);
        this.mainContainer.add((Widget)this.butContainer);
        this.setWidget((Widget)this.mainContainer);
    }

    public void refresh(UISeriesInfo curInfo) {
        this.curInfo = curInfo;
        this.populateSeries();
        if (this.curInfo != null) {
            this.refreshSeasons(this.curInfo.seasonList);
        }
        this.refreshButtons();
        this.clearMessagePanel();
    }

    public void refreshAfterAssociation(long seriesTitleId, Long seriesDocumentId, Long seasonAssetId) {
        this.curInfo.associatedSeriesTitleId = seriesTitleId;
        this.curInfo.associatedSeriesDocId = seriesDocumentId == null ? null : "" + seriesDocumentId;
        this.curInfo.associatedSeasonAssetId = seasonAssetId == null ? null : "" + seasonAssetId;
        this.refreshButtons();
    }

    public void refreshAfterDissociation() {
        this.curInfo.associatedSeriesTitleId = null;
        this.curInfo.associatedSeriesDocId = null;
        this.curInfo.associatedSeasonAssetId = null;
        this.refreshButtons();
        this.seriesListBox.setItemSelected(0, true);
        this.clearSeasons();
    }

    private void clearMessagePanel() {
        this.parent.getTitleView().showMessage(null);
    }

    private void refreshButtons() {
        if (this.curInfo.seriesList.isEmpty()) {
            this.associateButton.setVisible(false);
        } else {
            this.associateButton.setVisible(true);
        }
        if (this.curInfo.associatedSeriesDocId == null) {
            this.disassociateButton.setVisible(false);
        } else {
            this.disassociateButton.setVisible(true);
            this.associateButton.setVisible(false);
        }
    }

    public void refreshAssociateMessage(Long seriesTitleId) {
        TitleValidationViewInput input = new TitleValidationViewInput();
        input.setInfoHeader(String.valueOf(this.parent.getViewMessages().associateSuccessfulMessage()) + seriesTitleId);
        this.parent.getTitleView().showMessage(input);
    }

    public void refreshDisassociateMessage(Long assocSeriesTitleId) {
        TitleValidationViewInput input = new TitleValidationViewInput();
        input.setInfoHeader(String.valueOf(this.parent.getViewMessages().disassociateSuccessfulMessage()) + assocSeriesTitleId);
        this.parent.getTitleView().showMessage(input);
    }

    private void populateSeries() {
        this.seriesListBox.clear();
        this.seriesListBox.setVisibleItemCount(1);
        this.clearSeasons();
        String curSelection = this.curInfo.associatedSeriesDocId;
        this.seriesListBox.addItem("", (Object)new UISeriesListItem());
        for (UISeriesListItem item : this.curInfo.seriesList) {
            this.seriesListBox.addItem(item.label, (Object)item);
            if (curSelection == null || !curSelection.equals(item.seriesDocId)) continue;
            this.seriesListBox.setItemSelected(this.seriesListBox.getItemCount() - 1, true);
            this.curInfo.associatedSeriesTitleId = item.seriesTitleId;
        }
    }

    private void clearSeasons() {
        String none = "";
        this.seasonListBox.clear();
        this.seasonListBox.setVisibleItemCount(1);
        this.seasonListBox.addItem(none, (Object)none);
    }

    public void refreshSeasons(List<UISeasonListItem> list) {
        this.clearSeasons();
        if (list == null || list.isEmpty()) {
            return;
        }
        String curSelection = this.curInfo.associatedSeasonAssetId;
        for (UISeasonListItem item : list) {
            this.seasonListBox.addItem(item.label, (Object)item.seasonId);
            if (curSelection == null || !curSelection.equals(item.seasonId)) continue;
            this.seasonListBox.setItemSelected(this.seasonListBox.getItemCount() - 1, true);
        }
    }

    private void asscociateClickedAction() {
        UISeriesListItem selectedItem = (UISeriesListItem)this.seriesListBox.getSelectedItem();
        Long seriesDocId = null;
        try {
            seriesDocId = Long.parseLong(selectedItem.seriesDocId);
        }
        catch (Exception exception) {}
        if (seriesDocId == null) {
            TitleValidationViewInput input = new TitleValidationViewInput();
            input.setErrorHeader(this.parent.getViewMessages().selectSeriesNameMessage());
            this.parent.getTitleView().showMessage(input);
            return;
        }
        Long seasonAssetId = null;
        try {
            String str = (String)this.seasonListBox.getSelectedItem();
            seasonAssetId = Long.parseLong(str);
        }
        catch (Exception exception) {}
        this.parent.asscociateEpisodeToSeries(selectedItem.seriesTitleId, seriesDocId, seasonAssetId);
    }

    private void disasscociateClickedAction() {
        this.parent.disasscociateEpisodeFromSeries(this.curInfo.associatedSeriesTitleId);
    }
}

