/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.series;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleMetadata;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.service.ReadDeletedTitleException;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.UITitleInfo;
import com.tandbergtv.cms.portal.content.client.title.view.series.EpisodesPanel;
import com.tandbergtv.cms.portal.content.client.title.view.series.SeriesAssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.series.SeriesTitleMetadataTab;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class TitleEpisodesTab
extends TitleViewTab {
    private Scheduler.ScheduledCommand resizeCommand;
    private HandlerRegistration windowRegistration = null;
    private AssetTree.AssetInfo rootAssetInfo;
    private SeriesTitleMetadataTab metadataTab;
    private SimpleContainer container;
    private Grid splitContainer;
    private AssetTree assetTree;
    private ScrollPanel scrollPanel;
    private EpisodesPanel epPanel;
    private static final String STYLE_NAME = "content-AssetPanel";
    private static final String STYLE_SCROLL_CONTAINER = "content-TitleMetadataTab-scrollContainer";
    private static final String STYLE_SPLIT_CONTAINER = "content-AssetPanel-splitContainer";
    private static final String STYLE_TREE_CELL = "content-AssetPanel-splitContainer-treeCell";
    private static final String STYLE_CONTENT_CELL = "content-AssetPanel-splitContainer-contentCell";
    protected static final String STYLE_LOADING_LABEL = "content-TitleMetadataTab-loadingMessage";
    public static final String TAB_NAME = "Episodes";

    public TitleEpisodesTab(TitleView parent, SeriesTitleMetadataTab metadataTab) {
        super(parent);
        this.metadataTab = metadataTab;
    }

    void initWidgets() {
        this.epPanel = new EpisodesPanel(this);
        this.epPanel.initDataProvider();
    }

    public void handleGetColumnRecordsSuccess() {
        this.resizeCommand = new Scheduler.ScheduledCommand(){

            public void execute() {
                TitleEpisodesTab.this.resizeScrollContainer();
            }
        };
        this.container = new SimpleContainer();
        this.container.setStyleName(STYLE_NAME);
        this.scrollPanel = new ScrollContainer();
        this.scrollPanel.addStyleName(STYLE_SCROLL_CONTAINER);
        this.scrollPanel.setPixelSize(0, 0);
        this.scrollPanel.setWidget((Widget)this.epPanel);
        this.splitContainer = new Grid(1, 2);
        this.splitContainer.setStyleName(STYLE_SPLIT_CONTAINER);
        this.assetTree = new SeriesAssetTree(this.rootAssetInfo);
        this.assetTree.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                TitleEpisodesTab.this.refreshEpisodeTitles();
            }
        });
        this.splitContainer.setWidget(0, 0, (Widget)this.assetTree);
        this.splitContainer.getCellFormatter().setStyleName(0, 0, STYLE_TREE_CELL);
        this.splitContainer.setWidget(0, 1, (Widget)this.scrollPanel);
        this.splitContainer.getCellFormatter().setStyleName(0, 1, STYLE_CONTENT_CELL);
        this.container.setWidget((Widget)this.splitContainer);
        this.getContainer().setWidget((Widget)this.container);
        this.updateScrollContainerSize();
        if (this.getSelectedAssetInfo() == null) {
            if (this.metadataTab.getAssetInfo() != null) {
                String metadataTabSelectedAssetType = this.metadataTab.getSelectedAssetInfo().getAsset().getAssetType();
                if (metadataTabSelectedAssetType.equalsIgnoreCase("SERIES") || metadataTabSelectedAssetType.equalsIgnoreCase("SEASON")) {
                    this.assetTree.setSelectedAssetInfo(this.metadataTab.getSelectedAssetInfo());
                } else {
                    this.assetTree.setSelectedAssetInfo(this.rootAssetInfo);
                }
            } else {
                this.setSelectedNode();
            }
        }
    }

    protected void onLoad() {
        super.onLoad();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                TitleEpisodesTab.this.updateScrollContainerSize();
            }
        });
    }

    protected void onUnload() {
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        super.onUnload();
    }

    private void updateScrollContainerSize() {
        Scheduler.get().scheduleDeferred(this.resizeCommand);
    }

    private void resizeScrollContainer() {
        int width = this.getTabWidth();
        int height = this.getTabHeight();
        this.scrollPanel.setPixelSize(width -= 167, height -= 70);
    }

    @Override
    public void refreshTab() {
        if (this.metadataTab.getAssetInfo() == null) {
            this.refreshWithNewTitleMetadata();
        } else {
            this.rootAssetInfo = this.metadataTab.getAssetInfo();
            this.initWidgets();
        }
    }

    @Override
    protected String getTabName() {
        return TAB_NAME;
    }

    @Override
    protected void onTabSelected() {
        super.onTabSelected();
        this.updateScrollContainerSize();
    }

    @Override
    protected void onTabUnselected() {
        super.onTabUnselected();
        this.container.remove((Widget)this.splitContainer);
        this.getContainer().remove((Widget)this.container);
    }

    public AssetTree.AssetInfo getSelectedAssetInfo() {
        if (this.assetTree == null) {
            return null;
        }
        return this.assetTree.getSelectedAssetInfo();
    }

    public AssetTree.AssetInfo getRootAssetInfo() {
        return this.rootAssetInfo;
    }

    private void refreshEpisodeTitles() {
        if (this.getSelectedAssetInfo() == null) {
            return;
        }
        AssetTree.AssetInfo selectedNode = this.getSelectedAssetInfo();
        if (selectedNode.getAsset().getAssetType().equalsIgnoreCase("SEASON")) {
            this.getViewInput().setSelectedAssetId(selectedNode.getAsset().getId());
        } else {
            this.getViewInput().setSelectedAssetId(null);
        }
        this.titleView.fireViewAnchorChange();
        this.epPanel.refresh();
    }

    @Override
    protected void initialize() {
    }

    private void handleGetTitleMetadataSuccess(UITitleInfo info) {
        UIAssetSpecification currentSpecification = info.getSpecification();
        UITitleMetadata metadata = info.getTitle().getMetadata();
        UIAssetDefinition definition = currentSpecification.getAssetDefinition(metadata.getRootAsset().getAssetType());
        boolean isBulkEdit = this.titleView.getInput().isBulkEdit();
        if (isBulkEdit) {
            UIAsset asset = new UIAssetFactory().createAsset(info.getSpecification(), true);
            this.rootAssetInfo = new AssetTree.AssetInfo(this.titleView.getInput(), asset, definition, isBulkEdit);
        } else {
            UIAsset asset = metadata.getRootAsset();
            this.rootAssetInfo = new AssetTree.AssetInfo(this.titleView.getInput(), asset, definition, isBulkEdit);
        }
        this.updateTitleHeader(info.getTitle().getOverview());
    }

    private void handleGetTitleMetadataFailure(Throwable caught) {
        if (caught instanceof ReadDeletedTitleException) {
            this.showSevereError(caught.getMessage());
        } else {
            String error = caught.getLocalizedMessage();
            String message = this.getViewMessages().metadataFetchError(error);
            this.showErrorPanel(message);
        }
    }

    private void refreshWithNewTitleMetadata() {
        this.showBusyIndicator();
        this.getViewInput().getMetadata((AsyncCallback<UITitleInfo>)new NeptuneAsyncCallback<UITitleInfo>(){

            public void onNeptuneSuccess(UITitleInfo result) {
                TitleEpisodesTab.this.hideBusyIndicator();
                TitleEpisodesTab.this.handleGetTitleMetadataSuccess(result);
                TitleEpisodesTab.this.initWidgets();
            }

            public void onNeptuneFailure(Throwable caught) {
                TitleEpisodesTab.this.hideBusyIndicator();
                TitleEpisodesTab.this.handleGetTitleMetadataFailure(caught);
            }
        });
    }

    private void setSelectedNode() {
        TitleViewInput input = this.getViewInput();
        Long seasonAssetId = input.getSelectedAssetId();
        AssetTree.AssetInfo selectedNodeAssetInfo = this.getRootAssetInfo();
        if (seasonAssetId != null) {
            TreeItem parentTreeItem = this.assetTree.getItem(0);
            int index = 0;
            while (index < parentTreeItem.getChildCount()) {
                TreeItem childTreeItem = parentTreeItem.getChild(index);
                AssetTree.AssetInfo nodeAssetInfo = this.assetTree.getAssetInfo(childTreeItem);
                Long assetId = nodeAssetInfo.getAsset().getId();
                if (assetId != null && assetId.longValue() == seasonAssetId.longValue()) {
                    selectedNodeAssetInfo = nodeAssetInfo;
                }
                ++index;
            }
        }
        this.assetTree.setSelectedAssetInfo(selectedNodeAssetInfo);
    }

    @Override
    public String getTabDisplayName() {
        return this.getViewMessages().episodesTabName();
    }
}

