/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.series;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.series.UISeasonListItem;
import com.tandbergtv.cms.portal.content.client.title.model.series.UISeriesInfo;
import com.tandbergtv.cms.portal.content.client.title.service.ISeriesTitleService;
import com.tandbergtv.cms.portal.content.client.title.service.ISeriesTitleServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.ReadDeletedTitleException;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.cms.portal.content.client.title.view.series.SeriesPanel;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.List;

public class TitleSeriesTab
extends TitleViewTab {
    public static final String TAB_NAME = "Series";
    private SeriesPanel mainPanel;
    private ISeriesTitleServiceAsync seriesTitleService = (ISeriesTitleServiceAsync)GWT.create(ISeriesTitleService.class);

    public TitleSeriesTab(TitleView parent) {
        super(parent);
    }

    @Override
    protected void initialize() {
        this.mainPanel = new SeriesPanel(this);
        this.getContainer().setWidget((Widget)this.mainPanel);
    }

    @Override
    public void refreshTab() {
        this.showBusyIndicator();
        Long titleId = this.getViewInput().getTitleId();
        this.seriesTitleService.getSeriesTitleInfos(titleId, (AsyncCallback<UISeriesInfo>)new NeptuneAsyncCallback<UISeriesInfo>(){

            public void onNeptuneSuccess(UISeriesInfo result) {
                TitleSeriesTab.this.mainPanel.refresh(result);
                TitleSeriesTab.this.getContainer().setWidget((Widget)TitleSeriesTab.this.mainPanel);
                TitleSeriesTab.this.updateTitleHeader(result.titleOverView);
                TitleSeriesTab.this.hideBusyIndicator();
            }

            public void onNeptuneFailure(Throwable caught) {
                if (caught instanceof ReadDeletedTitleException) {
                    TitleSeriesTab.this.showSevereError(caught.getMessage());
                } else {
                    String error = caught.getLocalizedMessage();
                    String message = TitleSeriesTab.this.getViewMessages().propertiesFetchError(error);
                    TitleSeriesTab.this.showErrorPanel(message);
                }
                TitleSeriesTab.this.hideBusyIndicator();
            }
        });
    }

    @Override
    protected String getTabName() {
        return TAB_NAME;
    }

    public void updateSeasons(String seriesDocId) {
        this.showBusyIndicator();
        this.seriesTitleService.getSeasonList(seriesDocId, (AsyncCallback<List<UISeasonListItem>>)new NeptuneAsyncCallback<List<UISeasonListItem>>(){

            public void onNeptuneSuccess(List<UISeasonListItem> result) {
                TitleSeriesTab.this.mainPanel.refreshSeasons(result);
                TitleSeriesTab.this.hideBusyIndicator();
            }

            public void onNeptuneFailure(Throwable caught) {
                TitleSeriesTab.this.showSevereError(caught.getMessage());
                TitleSeriesTab.this.hideBusyIndicator();
            }
        });
    }

    public void asscociateEpisodeToSeries(final long seriesTitleId, final Long seriesDocumentId, final Long seasonAssetId) {
        this.showBusyIndicator();
        Long episodeTitleId = this.getViewInput().getTitleId();
        this.seriesTitleService.associateTitleToSeries(episodeTitleId, seriesDocumentId, seasonAssetId, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneSuccess(Void ignore) {
                TitleSeriesTab.this.mainPanel.refreshAfterAssociation(seriesTitleId, seriesDocumentId, seasonAssetId);
                TitleSeriesTab.this.mainPanel.refreshAssociateMessage(seriesTitleId);
                TitleSeriesTab.this.getContainer().setWidget((Widget)TitleSeriesTab.this.mainPanel);
                TitleSeriesTab.this.hideBusyIndicator();
            }

            public void onNeptuneFailure(Throwable caught) {
                if (caught instanceof ReadDeletedTitleException) {
                    TitleSeriesTab.this.showSevereError(caught.getMessage());
                } else {
                    String error = caught.getLocalizedMessage();
                    String message = TitleSeriesTab.this.getViewMessages().propertiesFetchError(error);
                    TitleSeriesTab.this.showErrorPanel(message);
                }
                TitleSeriesTab.this.hideBusyIndicator();
            }
        });
    }

    public void disasscociateEpisodeFromSeries(final Long assocSeriesTitleId) {
        this.showBusyIndicator();
        Long episodeTitleId = this.getViewInput().getTitleId();
        this.seriesTitleService.disassociateTitleFromSeries(episodeTitleId, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneSuccess(Void ignore) {
                TitleSeriesTab.this.mainPanel.refreshAfterDissociation();
                TitleSeriesTab.this.mainPanel.refreshDisassociateMessage(assocSeriesTitleId);
                TitleSeriesTab.this.getContainer().setWidget((Widget)TitleSeriesTab.this.mainPanel);
                TitleSeriesTab.this.hideBusyIndicator();
            }

            public void onNeptuneFailure(Throwable caught) {
                if (caught instanceof ReadDeletedTitleException) {
                    TitleSeriesTab.this.showSevereError(caught.getMessage());
                } else {
                    String error = caught.getLocalizedMessage();
                    String message = TitleSeriesTab.this.getViewMessages().propertiesFetchError(error);
                    TitleSeriesTab.this.showErrorPanel(message);
                }
                TitleSeriesTab.this.hideBusyIndicator();
            }
        });
    }

    @Override
    public String getTabDisplayName() {
        return this.getViewMessages().seriesTabName();
    }
}

