/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.sites;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UIDistributionSiteItem;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UITitleSites;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.sites.DistributionSiteItemRecord;
import com.tandbergtv.cms.portal.content.client.title.view.sites.SitesPanel;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import java.util.ArrayList;
import java.util.List;

class DistributionSiteItemDataProvider
implements DataProvider<UIDistributionSiteItem, DistributionSiteItemRecord> {
    private TitleViewMessages messages;
    private List<Column<?, DistributionSiteItemRecord>> columns;
    private SitesPanel parent;
    private TitleClientBundle bundle = new TitleClientBundle();
    public static final String DISTRIBUTION_SITE_COLUMN_NAME = "distributionSiteName";
    public static final String TITLE_ID_COLUMN_NAME = "titleId";
    public static final String STATUS_COLUMN_NAME = "status";
    public static final String DIFF_MASTER_COLUMN_NAME = "differentFromMaster";
    public static final String DIFF_DISTRIBUTED_COLUMN_NAME = "differentFromDistributed";
    private static String HREF_TITLE_ID = "Content.Search.Id=";
    private static String HREF_SITE_ID = "Sites.View?id=";
    private static final String STYLE_ICON = "content-TitleOverviewWidget-icon";
    private static final String STYLE_ORIGINAL_DIFF_ICON = "content-TitleViewHeaderWidget-orginalCompareIcon";
    private static final String STYLE_ORIGINAL_DIFF_ICON_DIFFERENT = "content-TitleViewHeaderWidget-orginalCompareIcon-different";
    private static final String STYLE_SITE_DIFF_ICON = "content-TitleViewHeaderWidget-siteCompareIcon";
    private static final String STYLE_SITE_DIFF_ICON_DIFFERENT = "content-TitleViewHeaderWidget-siteCompareIcon-different";
    private static final String STYLE_STATUS_TABLE = "content-DistributionSiteItem-statusTable";

    public DistributionSiteItemDataProvider(SitesPanel parent) {
        this.parent = parent;
        this.messages = (TitleViewMessages)GWT.create(TitleViewMessages.class);
        this.initializeColumns();
    }

    private void initializeColumns() {
        this.columns = new ArrayList();
        this.columns.add(this.prepareDistributionStatusColumn());
        this.columns.add(this.prepareDistributionSiteColumn());
        this.columns.add(this.prepareTitleIdColumn());
    }

    private Column<String, DistributionSiteItemRecord> prepareDistributionStatusColumn() {
        ColumnBase<String, DistributionSiteItemRecord> column = null;
        String displayName = this.messages.distributionSitesTableStatusColumn();
        column = new ColumnBase<String, DistributionSiteItemRecord>(DIFF_DISTRIBUTED_COLUMN_NAME, displayName){

            public View<String> getView(final DistributionSiteItemRecord record) {
                final String status = DistributionSiteItemDataProvider.this.getStatusValue(record.getDistSiteItem());
                return new View<String>(){

                    public String getStyleName() {
                        return DistributionSiteItemDataProvider.STYLE_STATUS_TABLE;
                    }

                    public Widget getWidget() {
                        HorizontalContainer container = new HorizontalContainer();
                        ImageWidget statusImage = DistributionSiteItemDataProvider.this.getDistributionStatusImage(status);
                        if (status.equalsIgnoreCase(UIDistributionSiteItem.DistributionStatus_FAILED)) {
                            if (record.getDistSiteItem().getStatusDetail() == UIDistributionSiteItem.LIC_LIMIT_EXCEEDED) {
                                statusImage.setTitle(DistributionSiteItemDataProvider.this.messages.distLimitExceeded());
                            } else if (record.getDistSiteItem().getStatusDetail() == UIDistributionSiteItem.DIST_DEPENDENCY_TIMEOUT) {
                                statusImage.setTitle(DistributionSiteItemDataProvider.this.messages.distDependencyTimeout());
                            }
                        }
                        boolean isDifferentFromMaster = record.getDistSiteItem().getIsDifferentFromMaster();
                        boolean isOffer = DistributionSiteItemDataProvider.this.parent.getTab().getViewInput().isOffer();
                        ImageWidget imagMasterDifferent = DistributionSiteItemDataProvider.this.getIsMasterDifferentImage(isDifferentFromMaster, isOffer);
                        if (isDifferentFromMaster) {
                            imagMasterDifferent.addClickHandler(new ClickHandler(){

                                public void onClick(ClickEvent event) {
                                    Long id = record.getDistSiteItem().getMasterTitleId();
                                    String version = record.getDistSiteItem().getMasterTargetedVersion();
                                    DistributionSiteItemDataProvider.this.parent.getTab().showMasterTitleComparison(id, version);
                                }
                            });
                        }
                        boolean isDifferentFromDistributed = record.getDistSiteItem().getIsDifferentFromDistributed();
                        ImageWidget imagDistributedDifferent = DistributionSiteItemDataProvider.this.getIsDistributedDifferentImage(isDifferentFromDistributed, isOffer);
                        if (isDifferentFromDistributed) {
                            imagDistributedDifferent.addClickHandler(new ClickHandler(){

                                public void onClick(ClickEvent event) {
                                    Long id = record.getDistSiteItem().getTitleId();
                                    String version = record.getDistSiteItem().getDistributedVersion();
                                    DistributionSiteItemDataProvider.this.parent.getTab().showDistributedTitleComparison(id, version);
                                }
                            });
                        }
                        container.add((Widget)statusImage);
                        container.add((Widget)imagMasterDifferent);
                        container.add((Widget)imagDistributedDifferent);
                        return container;
                    }

                    public void release() {
                    }
                };
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-icon");
        return column;
    }

    private Column<String, DistributionSiteItemRecord> prepareDistributionSiteColumn() {
        ColumnBase<String, DistributionSiteItemRecord> column = null;
        String displayName = this.messages.distributionSitesTableNameColumn();
        column = new ColumnBase<String, DistributionSiteItemRecord>(DISTRIBUTION_SITE_COLUMN_NAME, displayName){

            public View<String> getView(final DistributionSiteItemRecord record) {
                return new View<String>(){

                    public String getStyleName() {
                        return "table-data-link";
                    }

                    public Widget getWidget() {
                        String distributionSiteName = DistributionSiteItemDataProvider.this.getDistributionSiteValue(record.getDistSiteItem());
                        String siteId = DistributionSiteItemDataProvider.this.getSiteIdValue(record.getDistSiteItem());
                        HyperlinkWidget anchor = new HyperlinkWidget(distributionSiteName, String.valueOf(HREF_SITE_ID) + siteId);
                        return anchor;
                    }

                    public void release() {
                    }
                };
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        return column;
    }

    private Column<String, DistributionSiteItemRecord> prepareTitleIdColumn() {
        ColumnBase<String, DistributionSiteItemRecord> column = null;
        String displayName = this.messages.distributionSitesTableTitleIdColumn();
        column = new ColumnBase<String, DistributionSiteItemRecord>(TITLE_ID_COLUMN_NAME, displayName){

            public View<String> getView(final DistributionSiteItemRecord record) {
                return new View<String>(){

                    public String getStyleName() {
                        return "table-data-link";
                    }

                    public Widget getWidget() {
                        String titleId = DistributionSiteItemDataProvider.this.getTitleIdValue(record.getDistSiteItem());
                        HyperlinkWidget anchor = new HyperlinkWidget(titleId, String.valueOf(HREF_TITLE_ID) + titleId);
                        anchor.setStyleName("table-data-link");
                        return anchor;
                    }

                    public void release() {
                    }
                };
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        return column;
    }

    public List<Column<?, DistributionSiteItemRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(UIDistributionSiteItem key, AsyncCallback<DistributionSiteItemRecord> callback) {
        callback.onSuccess((Object)new DistributionSiteItemRecord(key));
    }

    public void getRecords(AsyncCallback<List<DistributionSiteItemRecord>> callback) {
        UITitleSites result = this.parent.getUITitleSites();
        ArrayList<DistributionSiteItemRecord> records = new ArrayList<DistributionSiteItemRecord>();
        for (UIDistributionSiteItem distSiteItem : result.getDistributionSiteItems()) {
            records.add(new DistributionSiteItemRecord(distSiteItem));
        }
        callback.onSuccess(records);
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return false;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    private ImageWidget getIsMasterDifferentImage(boolean isDifferent, boolean isOffer) {
        ImageWidget masterDifferenceImage = new ImageWidget();
        masterDifferenceImage.addStyleName(STYLE_ICON);
        if (isDifferent) {
            masterDifferenceImage.addStyleName(STYLE_ORIGINAL_DIFF_ICON_DIFFERENT);
        } else {
            masterDifferenceImage.addStyleName(STYLE_ORIGINAL_DIFF_ICON);
        }
        String iconName = "";
        iconName = isOffer ? (isDifferent ? "originalOfferDifferent" : "originalOfferNotDifferent") : (isDifferent ? "originalTitleDifferent" : "originalTitleNotDifferent");
        this.bundle.updateIcon((Image)masterDifferenceImage, iconName);
        return masterDifferenceImage;
    }

    private ImageWidget getIsDistributedDifferentImage(boolean isDifferent, boolean isOffer) {
        ImageWidget distributedDifferenceImage = new ImageWidget();
        distributedDifferenceImage.addStyleName(STYLE_ICON);
        if (isDifferent) {
            distributedDifferenceImage.addStyleName(STYLE_SITE_DIFF_ICON_DIFFERENT);
        } else {
            distributedDifferenceImage.addStyleName(STYLE_SITE_DIFF_ICON);
        }
        String iconName = "";
        iconName = isOffer ? (isDifferent ? "distributedOfferDifferent" : "distributedOfferNotDifferent") : (isDifferent ? "distributedTitleDifferent" : "distributedTitleNotDifferent");
        this.bundle.updateIcon((Image)distributedDifferenceImage, iconName);
        return distributedDifferenceImage;
    }

    private ImageWidget getDistributionStatusImage(String status) {
        ImageWidget distStatusImage = new ImageWidget();
        distStatusImage.addStyleName(STYLE_ICON);
        this.bundle.updateDistributionStatusIcon((Image)distStatusImage, status);
        return distStatusImage;
    }

    private String getDistributionSiteValue(UIDistributionSiteItem distSiteItem) {
        return distSiteItem.getName();
    }

    private String getSiteIdValue(UIDistributionSiteItem distSiteItem) {
        return distSiteItem.getSiteId().toString();
    }

    private String getTitleIdValue(UIDistributionSiteItem distSiteItem) {
        return distSiteItem.getTitleId().toString();
    }

    private String getStatusValue(UIDistributionSiteItem distSiteItem) {
        return distSiteItem.getStatus().toString();
    }
}

