/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.sites;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UIDistributionSiteItem;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UILocalTitleSites;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UITrackingSiteItem;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.sites.LocalTrackingSiteItemDataProvider;
import com.tandbergtv.cms.portal.content.client.title.view.sites.TitleSitesTab;
import com.tandbergtv.cms.portal.content.client.title.view.sites.TrackingSiteItemRecord;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

class LocalTitleSitesPanel
extends SimpleContainer {
    private TitleSitesTab parent;
    private VerticalContainer mainContainer;
    private HorizontalContainer masterTitleIdContainer;
    private HorizontalContainer masterTitleVersionContainer;
    private HorizontalContainer siteIdContainer;
    private VerticalContainer distSiteContainer;
    private HorizontalContainer diffFromMasterContainer;
    private HorizontalContainer diffFromLocalContainer;
    private HorizontalContainer distStatusContainer;
    private LocalTrackingSiteItemDataProvider dataProviderTrackingSites;
    private Table<UITrackingSiteItem, TrackingSiteItemRecord> tableTrackingSites;
    private PageFeature pageFeature;
    private LabelWidget masterTitleIdLabel;
    private LabelWidget masterTitleVersionLabel;
    private HyperlinkWidget masterTitleIdAnchor;
    private LabelWidget masterTitleVersionNumber;
    private LabelWidget distributionSiteLabel;
    private HyperlinkWidget siteIdAnchor;
    private LabelWidget distributionStatusLabel;
    private LabelWidget diffFromMasterLabel;
    private LabelWidget diffFromLocalLabel;
    ImageWidget masterDifferenceImage;
    ImageWidget distributedDifferenceImage;
    ImageWidget distributionStatusImage;
    private TitleClientBundle bundle = new TitleClientBundle();
    private TitleViewMessages messages;
    private UILocalTitleSites sites = null;
    private static final int DISTRIBUTION_TRACKING_SPACING = 10;
    private static String HREF_TITLE_ID = "Content.Search.Id=";
    private static String HREF_SITE_ID = "Sites.View?id=";
    private static final String STYLE_ICON = "content-TitleOverviewWidget-icon";
    private static final String STYLE_ORIGINAL_DIFF_ICON = "content-TitleViewHeaderWidget-orginalCompareIcon";
    private static final String STYLE_ORIGINAL_DIFF_ICON_DIFFERENT = "content-TitleViewHeaderWidget-orginalCompareIcon-different";
    private static final String STYLE_SITE_DIFF_ICON = "content-TitleViewHeaderWidget-siteCompareIcon";
    private static final String STYLE_SITE_DIFF_ICON_DIFFERENT = "content-TitleViewHeaderWidget-siteCompareIcon-different";
    private static final String STYLE_TITLE_VIEW_SITE_HEADER = "title-view-site-header";

    public LocalTitleSitesPanel(TitleSitesTab parent) {
        this.parent = parent;
        this.dataProviderTrackingSites = new LocalTrackingSiteItemDataProvider(this);
        this.init();
    }

    private void init() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(10);
        this.masterTitleIdContainer = new HorizontalContainer();
        this.masterTitleVersionContainer = new HorizontalContainer();
        this.distSiteContainer = new VerticalContainer();
        this.siteIdContainer = new HorizontalContainer();
        this.distStatusContainer = new HorizontalContainer();
        this.diffFromMasterContainer = new HorizontalContainer();
        this.diffFromLocalContainer = new HorizontalContainer();
        this.masterTitleIdLabel = new LabelWidget();
        this.masterTitleIdAnchor = new HyperlinkWidget();
        this.masterTitleVersionLabel = new LabelWidget();
        this.masterTitleVersionNumber = new LabelWidget();
        this.distributionSiteLabel = new LabelWidget(this.parent.getViewMessages().distributionSiteLabel());
        this.siteIdAnchor = new HyperlinkWidget();
        this.distributionStatusImage = new ImageWidget();
        this.distributionStatusLabel = new LabelWidget(this.parent.getViewMessages().distributionStatusLabel());
        this.distStatusContainer.add((Widget)this.distributionStatusLabel);
        this.distStatusContainer.add((Widget)this.distributionStatusImage);
        this.masterDifferenceImage = new ImageWidget();
        this.diffFromMasterLabel = new LabelWidget(this.parent.getViewMessages().differentFromMasterLabel());
        this.diffFromMasterContainer.add((Widget)this.diffFromMasterLabel);
        this.diffFromMasterContainer.add((Widget)this.masterDifferenceImage);
        this.diffFromLocalLabel = new LabelWidget(this.parent.getViewMessages().differentFromLocalLabel());
        this.distributedDifferenceImage = new ImageWidget();
        this.diffFromLocalContainer.add((Widget)this.diffFromLocalLabel);
        this.diffFromLocalContainer.add((Widget)this.distributedDifferenceImage);
        this.masterTitleIdContainer.add((Widget)this.masterTitleIdLabel);
        this.masterTitleIdContainer.add((Widget)this.masterTitleIdAnchor);
        this.masterTitleVersionContainer.add((Widget)this.masterTitleVersionLabel);
        this.masterTitleVersionContainer.add((Widget)this.masterTitleVersionNumber);
        this.distSiteContainer.add((Widget)this.masterTitleIdContainer);
        this.distSiteContainer.add((Widget)this.masterTitleVersionContainer);
        this.siteIdContainer.add((Widget)this.distributionSiteLabel);
        this.siteIdContainer.add((Widget)this.siteIdAnchor);
        this.distSiteContainer.add((Widget)this.siteIdContainer);
        this.distSiteContainer.add((Widget)this.distStatusContainer);
        this.distSiteContainer.add((Widget)this.diffFromMasterContainer);
        this.distSiteContainer.add((Widget)this.diffFromLocalContainer);
        this.distSiteContainer.addStyleName(STYLE_TITLE_VIEW_SITE_HEADER);
        this.tableTrackingSites = new Table((DataProvider)this.dataProviderTrackingSites);
        this.pageFeature = new PageFeatureImpl();
        this.dataProviderTrackingSites.setParentPageFeature(this.pageFeature);
        this.tableTrackingSites.addPageFeature(this.pageFeature);
        this.mainContainer.add((Widget)this.distSiteContainer);
        this.mainContainer.add(this.tableTrackingSites);
        this.messages = (TitleViewMessages)GWT.create(TitleViewMessages.class);
        LabelWidget blankLabel = new LabelWidget("");
        this.setWidget((Widget)blankLabel);
    }

    protected TitleSitesTab getTab() {
        return this.parent;
    }

    void handleGetTitleSiteRecordsSuccess(UILocalTitleSites sites) {
        this.sites = sites;
        this.refreshDistributionSitesLabels();
        boolean hasTrackingSiteItems = sites.getTrackingSiteItems().size() > 0;
        this.tableTrackingSites.setVisible(hasTrackingSiteItems);
        this.refreshTrackingSitesTable();
        this.getTab().hideBusyIndicator();
        this.getTab().markUpdated();
        if (this.getWidget() != this.mainContainer) {
            this.setWidget((Widget)this.mainContainer);
        }
    }

    UILocalTitleSites getUILocalTitleSite() {
        return this.sites;
    }

    private void refreshDistributionSitesLabels() {
        Widget w;
        this.masterTitleIdLabel.setText(this.parent.getViewMessages().masterTitleIdLabel());
        this.masterTitleVersionLabel.setText(this.parent.getViewMessages().masterTitleVersionLabel());
        this.masterTitleIdAnchor.setText(this.sites.getMasterTitleId().toString());
        this.masterTitleVersionNumber.setText(this.sites.getDistributionSiteItem().getMasterTargetedVersion());
        this.masterTitleIdAnchor.setTargetHistoryToken(String.valueOf(HREF_TITLE_ID) + this.sites.getMasterTitleId());
        this.siteIdAnchor.setText(this.sites.getDistributionSiteItem().getName());
        this.siteIdAnchor.setTargetHistoryToken(String.valueOf(HREF_SITE_ID) + this.sites.getDistributionSiteItem().getSiteId());
        UIDistributionSiteItem item = this.sites.getDistributionSiteItem();
        this.bundle.updateDistributionStatusIcon((Image)this.distributionStatusImage, item.getStatus());
        if (item.getStatus().equalsIgnoreCase(UIDistributionSiteItem.DistributionStatus_FAILED)) {
            if (item.getStatusDetail() == UIDistributionSiteItem.LIC_LIMIT_EXCEEDED) {
                this.distributionStatusImage.setTitle(this.messages.distLimitExceeded());
            } else if (item.getStatusDetail() == UIDistributionSiteItem.DIST_DEPENDENCY_TIMEOUT) {
                this.distributionStatusImage.setTitle(this.messages.distDependencyTimeout());
            }
        }
        if ((w = this.diffFromMasterContainer.getWidget(1)) != null) {
            this.diffFromMasterContainer.remove(1);
        }
        this.diffFromMasterContainer.add((Widget)this.getIsMasterDifferentImage(this.sites.getDistributionSiteItem().getIsDifferentFromMaster()));
        w = this.diffFromLocalContainer.getWidget(1);
        if (w != null) {
            this.diffFromLocalContainer.remove(1);
        }
        this.diffFromLocalContainer.add((Widget)this.getIsDistributedDifferentImage(this.sites.getDistributionSiteItem().getIsDifferentFromDistributed()));
    }

    private void refreshTrackingSitesTable() {
        if (!this.tableTrackingSites.isInitialized()) {
            this.tableTrackingSites.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                }

                public void onNeptuneSuccess(Void result) {
                    LocalTitleSitesPanel.this.tableTrackingSites.refresh();
                }
            });
        } else {
            this.tableTrackingSites.refresh();
        }
    }

    private ImageWidget getIsMasterDifferentImage(boolean isDifferent) {
        ImageWidget image = new ImageWidget();
        image.addStyleName(STYLE_ICON);
        if (isDifferent) {
            image.addStyleName(STYLE_ORIGINAL_DIFF_ICON_DIFFERENT);
        } else {
            image.addStyleName(STYLE_ORIGINAL_DIFF_ICON);
        }
        boolean isOffer = this.parent.getViewInput().isOffer();
        String iconName = "";
        iconName = isOffer ? (isDifferent ? "originalOfferDifferent" : "originalOfferNotDifferent") : (isDifferent ? "originalTitleDifferent" : "originalTitleNotDifferent");
        this.bundle.updateIcon((Image)image, iconName);
        if (isDifferent) {
            image.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    LocalTitleSitesPanel.this.handleMasterDifferenceLabelClick();
                }
            });
        }
        return image;
    }

    private ImageWidget getIsDistributedDifferentImage(boolean isDifferent) {
        ImageWidget image = new ImageWidget();
        image.addStyleName(STYLE_ICON);
        if (isDifferent) {
            image.addStyleName(STYLE_SITE_DIFF_ICON_DIFFERENT);
        } else {
            image.addStyleName(STYLE_SITE_DIFF_ICON);
        }
        boolean isOffer = this.parent.getViewInput().isOffer();
        String iconName = "";
        iconName = isOffer ? (isDifferent ? "distributedOfferDifferent" : "distributedOfferNotDifferent") : (isDifferent ? "distributedTitleDifferent" : "distributedTitleNotDifferent");
        this.bundle.updateIcon((Image)image, iconName);
        if (isDifferent) {
            image.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    LocalTitleSitesPanel.this.handleLocalDifferenceLabelClick();
                }
            });
        }
        return image;
    }

    private void handleMasterDifferenceLabelClick() {
        UIDistributionSiteItem siteItem;
        UIDistributionSiteItem uIDistributionSiteItem = siteItem = this.sites != null ? this.sites.getDistributionSiteItem() : null;
        if (siteItem == null || !siteItem.getIsDifferentFromMaster()) {
            return;
        }
        Long titleId = siteItem.getMasterTitleId();
        String version = siteItem.getMasterTargetedVersion();
        this.getTab().showMasterTitleComparison(titleId, version);
    }

    private void handleLocalDifferenceLabelClick() {
        UIDistributionSiteItem siteItem;
        UIDistributionSiteItem uIDistributionSiteItem = siteItem = this.sites != null ? this.sites.getDistributionSiteItem() : null;
        if (siteItem == null || !siteItem.getIsDifferentFromDistributed()) {
            return;
        }
        Long titleId = siteItem.getTitleId();
        String version = siteItem.getDistributedVersion();
        this.getTab().showDistributedTitleComparison(titleId, version);
    }
}

