/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.sites;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.tab.ErrorPanel;
import com.tandbergtv.cms.portal.content.client.tab.SucessPanel;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UIActiveDistributionSiteItem;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UIDistributionSiteItem;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UITitleSites;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UITrackingSiteItem;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleValidationViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.sites.DistributionSiteItemDataProvider;
import com.tandbergtv.cms.portal.content.client.title.view.sites.DistributionSiteItemRecord;
import com.tandbergtv.cms.portal.content.client.title.view.sites.TargetClickListener;
import com.tandbergtv.cms.portal.content.client.title.view.sites.TitleSitesTab;
import com.tandbergtv.cms.portal.content.client.title.view.sites.TrackingSiteItemDataProvider;
import com.tandbergtv.cms.portal.content.client.title.view.sites.TrackingSiteItemRecord;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.InlineLabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class SitesPanel
extends SimpleContainer {
    private TitleSitesTab parent;
    private VerticalContainer mainContainer;
    private DisclosureContainer statusDisclosureContainer;
    private SimpleContainer targetingFeaturePanel;
    private DisclosureContainer targetingDisclosureContainer;
    private VerticalContainer statusDisclosureContents;
    private VerticalContainer targetingDisclosureContents;
    private ListBoxWidget<String> filterListBox;
    private HorizontalContainer filterListContainer;
    private DistributionSiteItemDataProvider dataProviderDistributionSites;
    private Table<UIDistributionSiteItem, DistributionSiteItemRecord> tableDistributionSites;
    private TrackingSiteItemDataProvider dataProviderTrackingSites;
    private Table<UITrackingSiteItem, TrackingSiteItemRecord> tableTrackingSites;
    private PageFeature pageFeature;
    private HeaderPanel header;
    private SucessPanel getSitesSuccessMessagePanel;
    private ErrorPanel targetingErrorMessagePanel;
    private FlowPanel targetingSuccessMessagePanel;
    private ListBoxWidget<String> activeDistributionSiteListBox;
    private LabelWidget sitesSelectionLabel;
    private RadioButtonWidget useRulesRadioButton;
    private RadioButtonWidget selectSitesRadioButton;
    private ButtonWidget targetButton;
    private HorizontalContainer targetOptionsContainer;
    private HorizontalContainer activeDistributionSiteListContainer;
    private Map<String, Integer> siteIdLookup = new HashMap<String, Integer>();
    private String siteFilter;
    private Set<String> selectedSites = new TreeSet<String>();
    boolean targetSelectSitesOption = true;
    private UITitleSites sites = null;
    private static final int SPACING = 2;
    private static final int VISIBLE_ITEMS = 5;
    private static final String STYLE_NAME = "content-TitleListsPanel";
    private static final String STYLE_DISCLOSURE_CONTAINER = "content-FileView-disclosureContainer";
    private String SUCCESS_MESSAGE_STYLE1 = "content-TitleView-feedbackPopup";
    private String SUCCESS_MESSAGE_STYLE2 = "content-TitleView-feedbackLabel";

    public SitesPanel(TitleSitesTab parent) {
        this.parent = parent;
        this.dataProviderDistributionSites = new DistributionSiteItemDataProvider(this);
        this.dataProviderTrackingSites = new TrackingSiteItemDataProvider(this);
        this.init();
    }

    protected TitleSitesTab getTab() {
        return this.parent;
    }

    private void init() {
        this.initWidgets();
        this.setContainers();
    }

    private void setContainers() {
        this.statusDisclosureContents.add((Widget)this.getSitesSuccessMessagePanel);
        this.statusDisclosureContents.add(this.tableDistributionSites);
        this.statusDisclosureContents.add((Widget)this.header);
        this.statusDisclosureContents.add((Widget)this.filterListContainer);
        this.statusDisclosureContents.add(this.tableTrackingSites);
        this.statusDisclosureContainer.setContent((Widget)this.statusDisclosureContents);
        this.targetingDisclosureContents.add((Widget)this.targetingErrorMessagePanel);
        this.targetingDisclosureContents.add((Widget)this.targetingSuccessMessagePanel);
        this.targetingDisclosureContents.add((Widget)this.targetOptionsContainer);
        this.targetingDisclosureContents.add((Widget)this.activeDistributionSiteListContainer);
        this.targetingDisclosureContainer.setContent((Widget)this.targetingDisclosureContents);
        this.mainContainer.add((Widget)this.statusDisclosureContainer);
        this.mainContainer.add((Widget)this.targetingFeaturePanel);
        LabelWidget blankLabel = new LabelWidget("");
        this.setWidget((Widget)blankLabel);
    }

    private void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(2);
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        this.statusDisclosureContainer = new RoundedDisclosureContainer(this.getTab().getViewMessages().sitesStatusDisclosurePanelName(), true);
        this.statusDisclosureContainer.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        this.statusDisclosureContents = new VerticalContainer();
        this.targetingFeaturePanel = new SimpleContainer();
        this.targetingDisclosureContainer = new RoundedDisclosureContainer(this.getTab().getViewMessages().sitesManualTargetingDisclosurePanelName(), true);
        this.targetingDisclosureContainer.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        this.targetingDisclosureContents = new VerticalContainer();
        this.targetingDisclosureContents.setSpacing(2);
        this.header = new HeaderPanel("");
        this.getSitesSuccessMessagePanel = new SucessPanel();
        this.getSitesSuccessMessagePanel.setVisible(false);
        this.tableDistributionSites = new Table((DataProvider)this.dataProviderDistributionSites);
        this.buildFilterListWidget();
        this.tableTrackingSites = new Table((DataProvider)this.dataProviderTrackingSites);
        this.pageFeature = new PageFeatureImpl();
        this.dataProviderTrackingSites.setParentPageFeature(this.pageFeature);
        this.tableTrackingSites.addPageFeature(this.pageFeature);
        this.targetingErrorMessagePanel = new ErrorPanel();
        this.targetingErrorMessagePanel.setVisible(false);
        this.targetingErrorMessagePanel.setWidth("99%");
        this.targetingSuccessMessagePanel = new FlowPanel();
        InlineLabelWidget activityViewLabel = new InlineLabelWidget(this.getTab().getViewMessages().activityTabName());
        activityViewLabel.addStyleName("table-data-link");
        activityViewLabel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SitesPanel.this.handleActivityViewLabelClick();
            }
        });
        InlineLabelWidget targetingInitiatedLabel1 = new InlineLabelWidget(this.getTab().getViewMessages().targetInitiatedMessage());
        this.addSuccessStyleForLabel(targetingInitiatedLabel1);
        this.addSuccessStyleForLabel(activityViewLabel);
        this.targetingSuccessMessagePanel.add((Widget)targetingInitiatedLabel1);
        this.targetingSuccessMessagePanel.add((Widget)activityViewLabel);
        this.targetingSuccessMessagePanel.setVisible(false);
        this.buildTargetingOptionRadioButtonWidget();
        this.buildActiveDistributionSiteListWidget();
        this.sitesSelectionLabel.setVisible(true);
        this.activeDistributionSiteListBox.setVisible(true);
    }

    private void addSuccessStyleForLabel(InlineLabelWidget labelWidget) {
        labelWidget.addStyleName(this.SUCCESS_MESSAGE_STYLE1);
        labelWidget.addStyleName(this.SUCCESS_MESSAGE_STYLE2);
    }

    private void handleActivityViewLabelClick() {
        this.parent.getTitleView().showTab("Activity");
    }

    private void buildFilterListWidget() {
        this.filterListContainer = new HorizontalContainer();
        this.filterListContainer.setSpacing(2);
        String message = this.getTab().getViewMessages().distributionSiteFilterLabel();
        LabelWidget filterLabel = new LabelWidget(message);
        this.filterListBox = new ListBoxWidget(false);
        this.filterListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                SitesPanel.this.refreshTrackingSitesTable();
            }
        });
        this.filterListContainer.add((Widget)filterLabel);
        this.filterListContainer.add(this.filterListBox);
    }

    private void buildTargetingOptionRadioButtonWidget() {
        this.targetOptionsContainer = new HorizontalContainer();
        this.targetOptionsContainer.setSpacing(2);
        String message = this.getTab().getViewMessages().targetingOptionLabel();
        new LabelWidget(message);
        String rulesOption = this.getTab().getViewMessages().usingRulesOption();
        String selectSitesOption = this.getTab().getViewMessages().selectSitesOption();
        this.useRulesRadioButton = new RadioButtonWidget("TargetOptions", rulesOption);
        this.selectSitesRadioButton = new RadioButtonWidget("TargetOptions", selectSitesOption);
        this.useRulesRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (SitesPanel.this.sitesSelectionLabel.isVisible()) {
                    SitesPanel.this.sitesSelectionLabel.setVisible(false);
                }
                if (SitesPanel.this.activeDistributionSiteListBox.isVisible()) {
                    SitesPanel.this.activeDistributionSiteListBox.setVisible(false);
                }
            }
        });
        this.selectSitesRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!SitesPanel.this.sitesSelectionLabel.isVisible()) {
                    SitesPanel.this.sitesSelectionLabel.setVisible(true);
                }
                if (!SitesPanel.this.activeDistributionSiteListBox.isVisible()) {
                    SitesPanel.this.activeDistributionSiteListBox.setVisible(true);
                }
            }
        });
        if (this.targetSelectSitesOption) {
            this.selectSitesRadioButton.setValue(Boolean.valueOf(true));
        } else {
            this.selectSitesRadioButton.setValue(Boolean.valueOf(false));
        }
        VerticalContainer vc = new VerticalContainer();
        vc.add((Widget)this.useRulesRadioButton);
        vc.add((Widget)this.selectSitesRadioButton);
        this.targetOptionsContainer.add((Widget)vc);
    }

    private void buildActiveDistributionSiteListWidget() {
        this.activeDistributionSiteListContainer = new HorizontalContainer();
        this.activeDistributionSiteListContainer.setSpacing(2);
        String message = this.getTab().getViewMessages().sitesSelectionLabel();
        this.sitesSelectionLabel = new LabelWidget(message);
        this.activeDistributionSiteListBox = new ListBoxWidget(true);
        this.activeDistributionSiteListBox.setVisibleItemCount(5);
        this.targetButton = new ButtonWidget(this.getTab().getViewMessages().manualTargetingButton());
        this.targetButton.addClickHandler((ClickHandler)new TargetClickListener(this));
        this.targetButton.removeStyleName("gwt-Button");
        this.targetButton.addStyleName("ebBtn");
        this.targetButton.addStyleName("ebBtn_color_green");
        this.activeDistributionSiteListContainer.add((Widget)this.sitesSelectionLabel);
        this.activeDistributionSiteListContainer.add(this.activeDistributionSiteListBox);
        this.targetOptionsContainer.add((Widget)this.targetButton);
    }

    private void populateFilterListBox(List<UIDistributionSiteItem> distSiteItems) {
        this.filterListBox.clear();
        this.filterListBox.setVisibleItemCount(1);
        String allItems = this.getTab().getViewMessages().distributionSiteFilterForAll();
        this.filterListBox.addItem(allItems, (Object)allItems);
        if (this.siteFilter == null || this.siteFilter.isEmpty()) {
            this.siteFilter = allItems;
        }
        for (UIDistributionSiteItem item : distSiteItems) {
            this.filterListBox.addItem(item.getName(), (Object)item.getName());
            if (!this.siteFilter.equals(item.getName())) continue;
            this.filterListBox.setItemSelected(this.filterListBox.getIndex((Object)item.getName()), true);
        }
        int i = 0;
        int l = this.filterListBox.getItemCount();
        while (i < l) {
            String siteName = this.filterListBox.getItemText(i);
            if (siteName.equals(this.siteFilter)) {
                this.filterListBox.setItemSelected(i, true);
            }
            ++i;
        }
    }

    String getSelectedDistributionSiteInFilter() {
        String selectedItem = (String)this.filterListBox.getSelectedItem();
        if (selectedItem == null) {
            return null;
        }
        String allItems = this.getTab().getViewMessages().distributionSiteFilterForAll();
        if (selectedItem.equals(allItems)) {
            return null;
        }
        return selectedItem;
    }

    private void populateActiveDistributionSiteList(List<UIActiveDistributionSiteItem> activeDistSiteItems) {
        this.activeDistributionSiteListBox.clear();
        this.siteIdLookup.clear();
        for (UIActiveDistributionSiteItem item : activeDistSiteItems) {
            this.activeDistributionSiteListBox.addItem(item.getName(), (Object)item.getSiteId().toString());
            this.siteIdLookup.put(item.getName(), new Integer(item.getSiteId()));
        }
        int i = 0;
        int l = this.activeDistributionSiteListBox.getItemCount();
        while (i < l) {
            String activeSiteName = this.activeDistributionSiteListBox.getItemText(i);
            if (this.selectedSites.contains(activeSiteName)) {
                this.activeDistributionSiteListBox.setItemSelected(i, true);
            }
            ++i;
        }
    }

    boolean isSelectSites() {
        return this.selectSitesRadioButton.getValue() != false;
    }

    List<Integer> getSelectedSiteIds() {
        ArrayList<Integer> siteIds = new ArrayList<Integer>();
        int i = 0;
        int l = this.activeDistributionSiteListBox.getItemCount();
        while (i < l) {
            if (this.activeDistributionSiteListBox.isItemSelected(i)) {
                String siteName = this.activeDistributionSiteListBox.getItemText(i);
                siteIds.add(this.siteIdLookup.get(siteName));
            }
            ++i;
        }
        return siteIds;
    }

    void setPreviousSelections() {
        String selectedItem;
        this.siteFilter = selectedItem = (String)this.filterListBox.getSelectedItem();
        this.targetSelectSitesOption = this.selectSitesRadioButton.getValue() != false;
        this.selectedSites.clear();
        int i = 0;
        int l = this.activeDistributionSiteListBox.getItemCount();
        while (i < l) {
            if (this.activeDistributionSiteListBox.isItemSelected(i)) {
                String siteName = this.activeDistributionSiteListBox.getItemText(i);
                this.selectedSites.add(siteName);
            }
            ++i;
        }
    }

    private void refreshDistributionSitesTable() {
        if (!this.tableDistributionSites.isInitialized()) {
            this.tableDistributionSites.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                }

                public void onNeptuneSuccess(Void result) {
                    SitesPanel.this.tableDistributionSites.refresh();
                }
            });
        } else {
            this.tableDistributionSites.refresh();
        }
    }

    private void refreshTrackingSitesTable() {
        if (!this.tableTrackingSites.isInitialized()) {
            this.tableTrackingSites.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                }

                public void onNeptuneSuccess(Void result) {
                    SitesPanel.this.tableTrackingSites.refresh();
                }
            });
        } else {
            this.tableTrackingSites.refresh();
        }
    }

    UITitleSites getUITitleSites() {
        return this.sites;
    }

    void handleGetTitleSiteRecordsSuccess(UITitleSites sites) {
        this.sites = sites;
        if (sites.getDistributionSiteItems().size() == 0) {
            String message = this.getTab().getViewMessages().distributionSitesNotPresent();
            this.tableDistributionSites.setVisible(false);
            this.filterListContainer.setVisible(false);
            this.tableTrackingSites.setVisible(false);
            this.getSitesSuccessMessagePanel.setVisible(true);
            this.getSitesSuccessMessagePanel.showSuccessMessage(message);
        } else {
            this.getSitesSuccessMessagePanel.reset();
            this.getSitesSuccessMessagePanel.setVisible(false);
            this.tableDistributionSites.setVisible(true);
            this.filterListContainer.setVisible(true);
            this.tableTrackingSites.setVisible(true);
            this.populateFilterListBox(sites.getDistributionSiteItems());
        }
        this.refreshDistributionSitesTable();
        this.refreshTrackingSitesTable();
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Target"})) {
            this.targetingFeaturePanel.setWidget((Widget)this.targetingDisclosureContainer);
        } else {
            this.targetingFeaturePanel.clear();
        }
        this.populateActiveDistributionSiteList(sites.getActiveDistributionSiteItems());
        this.activeDistributionSiteListBox.setVisible(this.isSelectSites());
        this.targetingSuccessMessagePanel.setVisible(false);
        this.targetingErrorMessagePanel.setVisible(false);
        if (this.getWidget() != this.mainContainer) {
            this.setWidget((Widget)this.mainContainer);
        }
    }

    void showTargetingInitiatedMessage() {
        this.targetingSuccessMessagePanel.setVisible(true);
        this.targetingErrorMessagePanel.setVisible(false);
    }

    void reportNoSitesTargeted() {
        this.targetingErrorMessagePanel.setWidth("99%");
        this.targetingErrorMessagePanel.showErrorMessage(this.getTab().getViewMessages().targetRulesNoSiteTargetedMessage());
        this.targetingErrorMessagePanel.setVisible(true);
        this.targetingSuccessMessagePanel.setVisible(false);
    }

    void reportFailure(String errMsg) {
        TitleValidationViewInput input = new TitleValidationViewInput();
        input.setErrorHeader(errMsg);
        this.getTab().getTitleView().showMessage(input);
    }
}

