/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.sites;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.ContentComponent;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.title.model.UIActionTitle;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.compare.TitleCompareRequest;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareData;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareXmlData;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UITitleSites;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleSitesService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleSitesServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.ReadDeletedTitleException;
import com.tandbergtv.cms.portal.content.client.title.view.HtmlorXmlDisplayHelper;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.cms.portal.content.client.title.view.compare.ITitleCompareViewController;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareView;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.series.SeriesTitleView;
import com.tandbergtv.cms.portal.content.client.title.view.sites.LocalTitleSitesPanel;
import com.tandbergtv.cms.portal.content.client.title.view.sites.SitesPanel;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.RefreshWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.RefreshEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.RefreshHandler;
import java.util.List;

public class TitleSitesTab
extends TitleViewTab
implements ITitleCompareViewController {
    private static final int DEFAULT_REFRESH_RATE = 180;
    private static final int MINIMUM_REFRESH_RATE = 30;
    private static final String STYLE_LOADING_LABEL = "content-TitleMetadataTab-loadingMessage";
    private RefreshWidget<LocalTitleSitesPanel> localSitesPanel;
    private RefreshWidget<SitesPanel> masterSitesPanel;
    private TitleCompareView compareView;
    private TitleCompareRequest lastRequest;
    private ITitleSitesServiceAsync titleSitesService = (ITitleSitesServiceAsync)GWT.create(ITitleSitesService.class);
    private ITitleViewServiceAsync viewService = (ITitleViewServiceAsync)GWT.create(ITitleViewService.class);
    private ContentConstants dispConstants = (ContentConstants)GWT.create(ContentConstants.class);
    public static final String TAB_NAME = "Sites";

    public TitleSitesTab(TitleView parent) {
        super(parent);
    }

    @Override
    protected void initialize() {
        this.getContainer().addStyleDependentName("sites");
        LocalTitleSitesPanel panel = new LocalTitleSitesPanel(this);
        this.localSitesPanel = new RefreshWidget((Widget)panel);
        this.localSitesPanel.setRefreshOnLoad(false);
        this.localSitesPanel.setRefreshPeriod(this.getRefreshPeriod());
        this.localSitesPanel.addRefreshHandler(new RefreshHandler(){

            public void onRefresh(RefreshEvent event) {
                TitleSitesTab.this.handleRefreshEvent(event);
            }
        });
        SitesPanel masterPanel = new SitesPanel(this);
        this.masterSitesPanel = new RefreshWidget((Widget)masterPanel);
        this.masterSitesPanel.setRefreshOnLoad(false);
        this.masterSitesPanel.setRefreshPeriod(this.getRefreshPeriod());
        this.masterSitesPanel.addRefreshHandler(new RefreshHandler(){

            public void onRefresh(RefreshEvent event) {
                TitleSitesTab.this.handleRefreshEvent(event);
            }
        });
    }

    private void showLoadingMessage() {
        String message = this.getViewMessages().sitesLoading();
        LabelWidget label = new LabelWidget(message);
        label.addStyleName(STYLE_LOADING_LABEL);
        this.getContainer().setWidget((Widget)label);
    }

    @Override
    protected String getTabName() {
        return TAB_NAME;
    }

    @Override
    public String getTabDisplayName() {
        return this.getViewMessages().sitesTabName();
    }

    @Override
    public void refreshTab() {
        this.showBusyIndicator();
        this.showLoadingMessage();
        this.refreshTitleSites();
    }

    private void refreshTitleSites() {
        this.getTitleView().showMessage(null);
        Long titleId = this.getViewInput().getTitleId();
        this.titleSitesService.getTitleSites(titleId, (AsyncCallback<UITitle>)new NeptuneAsyncCallback<UITitle>(){

            public void onNeptuneSuccess(UITitle title) {
                UITitleSites result = title.getSites();
                if (result.getLocal() != null) {
                    ((LocalTitleSitesPanel)TitleSitesTab.this.localSitesPanel.getWidget()).handleGetTitleSiteRecordsSuccess(result.getLocal());
                    TitleSitesTab.this.getContainer().setWidget((Widget)TitleSitesTab.this.localSitesPanel);
                } else {
                    ((SitesPanel)TitleSitesTab.this.masterSitesPanel.getWidget()).handleGetTitleSiteRecordsSuccess(result);
                    TitleSitesTab.this.getContainer().setWidget((Widget)TitleSitesTab.this.masterSitesPanel);
                }
                TitleSitesTab.this.updateTitleHeader(title.getOverview());
                TitleSitesTab.this.hideBusyIndicator();
            }

            public void onNeptuneFailure(Throwable caught) {
                if (caught instanceof ReadDeletedTitleException) {
                    TitleSitesTab.this.showSevereError(caught.getMessage());
                } else {
                    String error = caught.getLocalizedMessage();
                    String message = TitleSitesTab.this.getViewMessages().sitesFetchFailure(error);
                    TitleSitesTab.this.showErrorPanel(message);
                }
                TitleSitesTab.this.hideBusyIndicator();
            }
        });
    }

    void targetWithRules() {
        Long titleId = this.getViewInput().getTitleId();
        this.titleSitesService.targetWithRules(titleId, (AsyncCallback<UITitle>)new NeptuneAsyncCallback<UITitle>(){

            public void onNeptuneSuccess(UITitle result) {
                ((SitesPanel)TitleSitesTab.this.masterSitesPanel.getWidget()).handleGetTitleSiteRecordsSuccess(result.getSites());
                if (result.getSites().getActiveSiteNames().size() == 0) {
                    ((SitesPanel)TitleSitesTab.this.masterSitesPanel.getWidget()).reportNoSitesTargeted();
                } else {
                    ((SitesPanel)TitleSitesTab.this.masterSitesPanel.getWidget()).showTargetingInitiatedMessage();
                }
                TitleSitesTab.this.updateTitleHeader(result.getOverview());
            }

            public void onNeptuneFailure(Throwable caught) {
                ((SitesPanel)TitleSitesTab.this.masterSitesPanel.getWidget()).reportFailure(caught.getMessage());
            }
        });
    }

    void target(List<Integer> siteIds) {
        Long titleId = this.getViewInput().getTitleId();
        this.titleSitesService.target(titleId, siteIds, (AsyncCallback<UITitle>)new NeptuneAsyncCallback<UITitle>(){

            public void onNeptuneSuccess(UITitle result) {
                ((SitesPanel)TitleSitesTab.this.masterSitesPanel.getWidget()).handleGetTitleSiteRecordsSuccess(result.getSites());
                ((SitesPanel)TitleSitesTab.this.masterSitesPanel.getWidget()).showTargetingInitiatedMessage();
                TitleSitesTab.this.updateTitleHeader(result.getOverview());
            }

            public void onNeptuneFailure(Throwable caught) {
                ((SitesPanel)TitleSitesTab.this.masterSitesPanel.getWidget()).reportFailure(caught.getMessage());
            }
        });
    }

    void getAreAllDependencySitesSelected(final List<Integer> selectedSiteIds) {
        this.titleSitesService.getAreAllDependencySitesSelected(selectedSiteIds, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

            public void onNeptuneSuccess(Boolean result) {
                TitleSitesTab.this.getManualTargetingConfirmation(selectedSiteIds, result);
            }

            public void onNeptuneFailure(Throwable caught) {
                ((SitesPanel)TitleSitesTab.this.masterSitesPanel.getWidget()).reportFailure(caught.getMessage());
            }
        });
    }

    void getManualTargetingConfirmation(final List<Integer> siteIds, Boolean result) {
        final PopupContainer confirmation = new PopupContainer(false, true);
        VerticalContainer popContainer = new VerticalContainer();
        if (!result.booleanValue()) {
            popContainer.add((Widget)new LabelWidget(this.getViewMessages().targetConfirmationMessageWithSiteDependency()));
        } else {
            popContainer.add((Widget)new LabelWidget(this.getViewMessages().targetConfirmationMessage()));
        }
        HorizontalContainer buttonContainer = new HorizontalContainer();
        buttonContainer.addStyleName("cms_button_container");
        ButtonWidget yesButton = new ButtonWidget(this.dispConstants.confirmationYes());
        yesButton.removeStyleName("gwt-Button");
        yesButton.addStyleName("ebBtn");
        yesButton.addStyleName("ebBtn_color_green");
        yesButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                confirmation.hide();
                TitleSitesTab.this.target(siteIds);
            }
        });
        buttonContainer.add((Widget)yesButton);
        ButtonWidget noButton = new ButtonWidget(this.dispConstants.confirmationNo());
        noButton.removeStyleName("gwt-Button");
        noButton.addStyleName("ebBtn");
        noButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                confirmation.hide();
            }
        });
        buttonContainer.add((Widget)noButton);
        popContainer.add((Widget)buttonContainer);
        popContainer.setCellHorizontalAlignment((Widget)buttonContainer, HasHorizontalAlignment.ALIGN_CENTER);
        confirmation.add((Widget)popContainer);
        confirmation.center();
        confirmation.show();
    }

    private int getRefreshPeriod() {
        NeptuneApplication application = NeptuneApplication.getApplication();
        ContentComponent component = (ContentComponent)application.getComponent(ContentComponent.class);
        Integer refreshRateValue = component.getTitleSitesViewRefreshRate();
        int refreshRate = 180;
        try {
            if (refreshRateValue != null && (refreshRate = refreshRateValue.intValue()) < 30) {
                refreshRate = 30;
            }
        }
        catch (Exception exception) {
            refreshRate = 180;
        }
        return refreshRate * 1000;
    }

    private void handleRefreshEvent(RefreshEvent event) {
        boolean visible = true;
        Widget widget = this.getContainer().getWidget();
        while (widget != null && visible) {
            visible &= widget.isVisible();
            widget = widget.getParent();
        }
        if (visible) {
            this.refresh();
        }
    }

    public void showMasterTitleComparison(Long masterTitleId, String targetedVersion) {
        this.compareView = new TitleCompareView(this);
        String heading = this.getViewMessages().compareTitleHeading();
        if (!masterTitleId.equals(this.getViewInput().getTitleId())) {
            heading = this.getViewMessages().compareMasterTitleHeading();
        }
        TitleCompareViewInput input = this.buildCompareInput(masterTitleId, targetedVersion, heading);
        this.compareView.setInput(input);
        UIActionTitle title1 = new UIActionTitle();
        title1.setTitleId(masterTitleId);
        UIActionTitle title2 = new UIActionTitle();
        title2.setTitleId(masterTitleId);
        title2.setVersion(targetedVersion);
        this.lastRequest = new TitleCompareRequest();
        this.lastRequest.title1 = title1;
        this.lastRequest.title2 = title2;
        this.lastRequest.specName = input.specName;
        this.lastRequest.specificationType = this.titleView instanceof SeriesTitleView ? "SERIES" : "PACKAGE";
        this.compareDiff();
    }

    public void showDistributedTitleComparison(Long titleId, String distributedVersion) {
        this.compareView = new TitleCompareView(this);
        String heading = this.getViewMessages().compareTitleHeading();
        if (!titleId.equals(this.getViewInput().getTitleId())) {
            heading = this.getViewMessages().compareSiteTitleHeading();
        }
        TitleCompareViewInput input = this.buildCompareInput(titleId, distributedVersion, heading);
        this.compareView.setInput(input);
        UIActionTitle title1 = new UIActionTitle();
        title1.setTitleId(titleId);
        UIActionTitle title2 = new UIActionTitle();
        title2.setTitleId(titleId);
        title2.setVersion(distributedVersion);
        this.lastRequest = new TitleCompareRequest();
        this.lastRequest.title1 = title1;
        this.lastRequest.title2 = title2;
        this.lastRequest.specName = input.specName;
        this.lastRequest.specificationType = this.titleView instanceof SeriesTitleView ? "SERIES" : "PACKAGE";
        this.compareDiff();
    }

    private TitleCompareViewInput buildCompareInput(Long titleId, String version, String heading) {
        TitleCompareViewInput input = new TitleCompareViewInput();
        input.specName = this.getViewInput().getSpecificationName();
        input.restrictedHeight = this.getUsedHeight();
        input.restrictedWidth = this.getUsedWidth();
        input.header = this.getViewMessages().titleCompareSummaryMessage(heading, this.getViewMessages().compareRevisionHeading(version));
        input.displayName1 = this.getViewMessages().compareCurrentRevisionName();
        input.displayName2 = this.getViewMessages().compareRevisionName(version);
        return input;
    }

    public void compareXml() {
        this.compareView.showBusyIndicator();
        this.viewService.compareTitlePreviews(this.lastRequest.title1, this.lastRequest.title2, this.lastRequest.specName, HtmlorXmlDisplayHelper.useHtml(), (AsyncCallback<UITitleCompareXmlData>)new NeptuneAsyncCallback<UITitleCompareXmlData>(){

            public void onNeptuneFailure(Throwable caught) {
                TitleSitesTab.this.compareView.showErrorView(caught);
                TitleSitesTab.this.compareView.hideBusyIndicator();
            }

            public void onNeptuneSuccess(UITitleCompareXmlData result) {
                TitleSitesTab.this.compareView.showXmlView(result);
                TitleSitesTab.this.compareView.hideBusyIndicator();
            }
        });
    }

    public void compareDiff() {
        this.compareView.showBusyIndicator();
        this.viewService.compareTitles(this.lastRequest, (AsyncCallback<UITitleCompareData>)new NeptuneAsyncCallback<UITitleCompareData>(){

            public void onNeptuneFailure(Throwable caught) {
                TitleSitesTab.this.compareView.showErrorView(caught);
                TitleSitesTab.this.compareView.hideBusyIndicator();
            }

            public void onNeptuneSuccess(UITitleCompareData data) {
                TitleSitesTab.this.setSpecName(data);
                ((TitleSitesTab)TitleSitesTab.this).compareView.getInput().compareData = data;
                TitleSitesTab.this.compareView.showDiffView();
                TitleSitesTab.this.compareView.hideBusyIndicator();
            }
        });
        this.getContainer().setWidget((Widget)this.compareView);
        this.markUpdated();
    }

    private void setSpecName(UITitleCompareData data) {
        List<UIAssetSpecificationListItem> specs;
        if (this.lastRequest != null && data != null && this.lastRequest.specName == null && (specs = data.getSpecifications()) != null && specs.size() > 0) {
            this.lastRequest.specName = specs.get(0).getName();
        }
    }

    @Override
    public TitleView getTitleView() {
        return super.getTitleView();
    }

    @Override
    protected void onTabUnselected() {
        ((SitesPanel)this.masterSitesPanel.getWidget()).setPreviousSelections();
        this.markStale();
    }

    @Override
    protected int getTabHeight() {
        return super.getTabHeight();
    }

    @Override
    protected int getTabWidth() {
        return super.getTabWidth();
    }

    @Override
    protected void showBusyIndicator() {
        super.showBusyIndicator();
    }

    @Override
    protected void markUpdated() {
        super.markUpdated();
    }

    @Override
    protected void hideBusyIndicator() {
        super.hideBusyIndicator();
    }

    @Override
    public void onCancel() {
        this.refresh();
    }

    @Override
    public void onShowDifferences() {
        this.compareDiff();
    }

    @Override
    public void onShowXml() {
        this.compareXml();
    }

    @Override
    public void onSpecChanged(String newSpec) {
        this.lastRequest.specName = newSpec;
        this.compareView.getInput().specName = newSpec;
        this.compareXml();
    }
}

