/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.sites;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UITitleSites;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UITrackingSiteItem;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.sites.SitesPanel;
import com.tandbergtv.cms.portal.content.client.title.view.sites.TrackingSiteItemRecord;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import java.util.ArrayList;
import java.util.List;

class TrackingSiteItemDataProvider
implements DataProvider<UITrackingSiteItem, TrackingSiteItemRecord> {
    private TitleViewMessages messages;
    private List<Column<?, TrackingSiteItemRecord>> columns;
    private SitesPanel parent;
    private PageFeature parentPageFeature;
    private TitleClientBundle bundle = new TitleClientBundle();
    public static final String TRACKING_SITE_COLUMN_NAME = "trackingSiteName";
    public static final String TITLE_ID_COLUMN_NAME = "titleId";
    public static final String STATUS_COLUMN_NAME = "status";
    public static final String DISTRIBUTION_SITE_COLUMN_NAME = "distributionSiteName";
    private static final String STYLE_ICON = "content-TitleOverviewWidget-icon";
    private static String HREF_TITLE_ID = "Content.Search.Id=";
    private static String HREF_SITE_ID = "Sites.View?id=";

    public TrackingSiteItemDataProvider(SitesPanel parent) {
        this.parent = parent;
        this.messages = (TitleViewMessages)GWT.create(TitleViewMessages.class);
        this.initializeColumns();
    }

    private void initializeColumns() {
        this.columns = new ArrayList();
        this.columns.add(this.prepareTrackingStatusColumn());
        this.columns.add(this.prepareTrackingSiteColumn());
        this.columns.add(this.prepareTitleIdColumn());
        this.columns.add(this.prepareDistributionSiteColumn());
    }

    private Column<String, TrackingSiteItemRecord> prepareTrackingStatusColumn() {
        ColumnBase<String, TrackingSiteItemRecord> column = null;
        String displayName = this.messages.trackingSitesTableStatusColumn();
        column = new ColumnBase<String, TrackingSiteItemRecord>(STATUS_COLUMN_NAME, displayName){

            public View<String> getView(final TrackingSiteItemRecord record) {
                return new View<String>(){

                    public String getStyleName() {
                        return "";
                    }

                    public Widget getWidget() {
                        String status = TrackingSiteItemDataProvider.this.getStatusValue(record.getTrackingSiteItem());
                        ImageWidget statusImage = TrackingSiteItemDataProvider.this.getTrackingStatusImage(status);
                        return statusImage;
                    }

                    public void release() {
                    }
                };
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-icon");
        return column;
    }

    private Column<String, TrackingSiteItemRecord> prepareTrackingSiteColumn() {
        ColumnBase<String, TrackingSiteItemRecord> column = null;
        String displayName = this.messages.trackingSitesTableNameColumn();
        column = new ColumnBase<String, TrackingSiteItemRecord>(TRACKING_SITE_COLUMN_NAME, displayName){

            public View<String> getView(final TrackingSiteItemRecord record) {
                return new View<String>(){

                    public String getStyleName() {
                        return "table-data-link";
                    }

                    public Widget getWidget() {
                        String trackingSite = TrackingSiteItemDataProvider.this.getTrackingSiteValue(record.getTrackingSiteItem());
                        String trackingSiteId = TrackingSiteItemDataProvider.this.getTrackingSiteIdValue(record.getTrackingSiteItem());
                        HyperlinkWidget anchor = new HyperlinkWidget(trackingSite, String.valueOf(HREF_SITE_ID) + trackingSiteId);
                        return anchor;
                    }

                    public void release() {
                    }
                };
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        return column;
    }

    private Column<String, TrackingSiteItemRecord> prepareTitleIdColumn() {
        ColumnBase<String, TrackingSiteItemRecord> column = null;
        String displayName = this.messages.trackingSitesTableTitleIdColumn();
        column = new ColumnBase<String, TrackingSiteItemRecord>(TITLE_ID_COLUMN_NAME, displayName){

            public View<String> getView(final TrackingSiteItemRecord record) {
                return new View<String>(){

                    public String getStyleName() {
                        return "table-data-link";
                    }

                    public Widget getWidget() {
                        String titleId = TrackingSiteItemDataProvider.this.getTitleIdValue(record.getTrackingSiteItem());
                        HyperlinkWidget anchor = new HyperlinkWidget(titleId, String.valueOf(HREF_TITLE_ID) + titleId);
                        return anchor;
                    }

                    public void release() {
                    }
                };
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        return column;
    }

    private Column<String, TrackingSiteItemRecord> prepareDistributionSiteColumn() {
        ColumnBase<String, TrackingSiteItemRecord> column = null;
        String displayName = this.messages.trackingSitesTableParentNameColumn();
        column = new ColumnBase<String, TrackingSiteItemRecord>(DISTRIBUTION_SITE_COLUMN_NAME, displayName){

            public View<String> getView(final TrackingSiteItemRecord record) {
                return new View<String>(){

                    public String getStyleName() {
                        return "table-data-link";
                    }

                    public Widget getWidget() {
                        String distributionSite = TrackingSiteItemDataProvider.this.getDistributionSiteValue(record.getTrackingSiteItem());
                        String distributionSiteId = TrackingSiteItemDataProvider.this.getDistributionSiteIdValue(record.getTrackingSiteItem());
                        HyperlinkWidget anchor = new HyperlinkWidget(distributionSite, String.valueOf(HREF_SITE_ID) + distributionSiteId);
                        return anchor;
                    }

                    public void release() {
                    }
                };
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        return column;
    }

    public List<Column<?, TrackingSiteItemRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(UITrackingSiteItem key, AsyncCallback<TrackingSiteItemRecord> callback) {
        callback.onSuccess((Object)new TrackingSiteItemRecord(key));
    }

    public void getRecords(AsyncCallback<List<TrackingSiteItemRecord>> callback) {
        int length = this.getParentPageFeature().getPageSize();
        int start = (this.getParentPageFeature().getPageNumber() - 1) * length;
        String selectedDistributionSite = this.parent.getSelectedDistributionSiteInFilter();
        UITitleSites result = this.parent.getUITitleSites();
        int recCount = result.getTotalTrackingSites(selectedDistributionSite);
        this.getParentPageFeature().setRecordCount(recCount);
        List<UITrackingSiteItem> trackingSiteItemList = result.getPagedTrackingSiteItems(selectedDistributionSite, start, length);
        ArrayList<TrackingSiteItemRecord> records = new ArrayList<TrackingSiteItemRecord>();
        for (UITrackingSiteItem trackingSiteItem : trackingSiteItemList) {
            records.add(new TrackingSiteItemRecord(trackingSiteItem));
        }
        callback.onSuccess(records);
    }

    public PageFeature getParentPageFeature() {
        return this.parentPageFeature;
    }

    public void setParentPageFeature(PageFeature parentPageFeature) {
        this.parentPageFeature = parentPageFeature;
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return false;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    private ImageWidget getTrackingStatusImage(String status) {
        ImageWidget trackStatusImage = new ImageWidget();
        trackStatusImage.addStyleName(STYLE_ICON);
        this.bundle.updateTrackingStatusIcon((Image)trackStatusImage, status);
        return trackStatusImage;
    }

    private String getTrackingSiteValue(UITrackingSiteItem trackingSiteItem) {
        return trackingSiteItem.getName();
    }

    private String getTrackingSiteIdValue(UITrackingSiteItem trackingSiteItem) {
        return trackingSiteItem.getSiteId().toString();
    }

    private String getTitleIdValue(UITrackingSiteItem trackingSiteItem) {
        return trackingSiteItem.getTitleId().toString();
    }

    private String getStatusValue(UITrackingSiteItem trackingSiteItem) {
        return trackingSiteItem.getStatus().toString();
    }

    private String getDistributionSiteValue(UITrackingSiteItem trackingSiteItem) {
        return trackingSiteItem.getDistributionSite();
    }

    private String getDistributionSiteIdValue(UITrackingSiteItem trackingSiteItem) {
        return trackingSiteItem.getDistributionSiteId().toString();
    }
}

