/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.videoplayer;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.user.client.Window;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.JW6Widget;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.VideoFfwdAndAudioControlPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JWPlayerWidget
extends JW6Widget {
    protected static Map<String, JWPlayerWidget> players = new HashMap<String, JWPlayerWidget>();
    private String playerId;
    private String curPosition;
    private VideoFfwdAndAudioControlPanel controlPanel = null;
    private int rate = 1;
    public static final int DEFAULT_WIDTH = 470;
    public static final int DEFAULT_HEIGHT = 290;
    public static final String VAR_SUPPORTED_FORMATS = "supportedformats";
    public static final String VAR_VLC_SUPPORTED_FORMATS = "extraVlcSupportedFormats";
    public static final String VAR_WIDTH = "width";
    public static final String VAR_HEIGHT = "height";
    public static final String VAR_SWFFILE = "swffile";
    public static final String VAR_MINFLASHVERSION = "minflashversion";
    public static final String VAR_STREAMER = "streamer";
    public static final String FLASH_VAR_AUTOSTART = "autostart";
    public static final String FLASH_VAR_STRETCHING = "stretching";
    public static final String FLASH_VAR_FRONT_COLOR = "frontcolor";
    public static final String FLASH_VAR_BACK_COLOR = "backcolor";
    public static final String FLASH_VAR_LIGHT_COLOR = "lightcolor";
    public static final String PARAM_VAR_ALLOWFULLSCREEN = "allowfullscreen";
    public static final String PARAM_VAR_ALLOWSCRIPTACCESS = "allowscriptaccess";
    public static final String PARAM_VAR_VMODE = "wmode";
    public static final String STATE_PAUSED = "PAUSED";
    public static final String STATE_PLAYING = "PLAYING";
    public static final String STATE_BUFFERING = "BUFFERING";
    public static final String STATE_IDLE = "IDLE";
    public static final String STATE_ENDED = "ENDED";
    static final List<String> playableFormats = new ArrayList<String>();
    static final List<String> vlcPlayableFormats = new ArrayList<String>();

    public static void loadPlayableFormats(Map<String, String> basicVars) {
        String format;
        int n;
        int n2;
        String[] stringArray;
        String[] encodeFormats;
        playableFormats.clear();
        String varString = basicVars.get(VAR_SUPPORTED_FORMATS);
        if (varString != null) {
            stringArray = encodeFormats = varString.split(",");
            n2 = encodeFormats.length;
            n = 0;
            while (n < n2) {
                format = stringArray[n];
                playableFormats.add(format);
                ++n;
            }
        }
        if ((varString = basicVars.get(VAR_VLC_SUPPORTED_FORMATS)) != null) {
            stringArray = encodeFormats = varString.split(",");
            n2 = encodeFormats.length;
            n = 0;
            while (n < n2) {
                format = stringArray[n];
                vlcPlayableFormats.add(format);
                ++n;
            }
        }
    }

    public static boolean isPlayableFormatsLoaded() {
        return !playableFormats.isEmpty();
    }

    public static boolean isPlayable(String fileEncodeFormat) {
        if (playableFormats.contains(fileEncodeFormat.trim().toLowerCase())) {
            return true;
        }
        return JWPlayerWidget.isVLCAvailable() && vlcPlayableFormats.contains(fileEncodeFormat.trim().toLowerCase());
    }

    public static native JsArrayString _onPositionChanged(JavaScriptObject var0);

    public static native JsArrayString _onStateChanged(JavaScriptObject var0);

    public native String setEventHandlers(String var1);

    public void handleOnReady() {
    }

    public void handleOnTime(JavaScriptObject jObject) {
        if (this.isVLC() && this.controlPanel != null) {
            this.controlPanel.updateVideoOptions();
        }
    }

    public void handleOnError(JavaScriptObject jObject) {
        if (this.isVLC()) {
            Window.alert((String)"Unable to play video... Check the log for details.");
        }
    }

    public void handleOnState(JavaScriptObject jObject, int i) {
        String oldstate = "Doesn't Matter";
        if (!this.isVLC()) {
            JsArrayString arr = JWPlayerWidget._onStateChanged(jObject);
            oldstate = arr.get(0);
        }
        String newstate = "NOIDEA";
        if (i == 1) {
            newstate = STATE_PLAYING;
        } else if (i == 2) {
            newstate = STATE_PAUSED;
        } else if (i == 3) {
            newstate = STATE_IDLE;
        } else if (i == 4) {
            newstate = STATE_BUFFERING;
        } else if (i == 5) {
            newstate = STATE_ENDED;
        }
        if (this.isVLC() && this.controlPanel != null) {
            this.controlPanel.updateVideoFFControls(newstate);
        }
        this.handleStateChanged(oldstate, newstate);
    }

    public native String setVLCEventHandlers(String var1);

    private static native String _getVLCState(String var0);

    private static native String _getVlcTimePos(String var0);

    private static native float _getVlcPos(String var0);

    private static native JsArrayString _getAudioTracks(String var0);

    private static native int _getAudioTrack();

    private static native boolean _getMute();

    private static native String _setAudioTrack(int var0);

    private static native String _setPlay(String var0);

    private static native String _ff(int var0);

    private static native String _reset();

    private static native String _getState(String var0);

    private static native String _getPosition(String var0);

    private static native void _load(String var0, String var1);

    private static native void _stop(String var0);

    private static native void _remove(String var0);

    public static JWPlayerWidget getInstance(String p_Id) {
        return players.get(p_Id);
    }

    public JWPlayerWidget(int width, int height, String flashVersionString, Map<String, String> flashVars, Map<String, String> basicVars) {
        super(470, 290);
        this.setMinPlayerVersion(flashVersionString);
        this.initialize(flashVars, basicVars);
    }

    public JWPlayerWidget(Map<String, String> flashVars, Map<String, String> basicVars) {
        super(470, 290);
        this.initialize(flashVars, basicVars);
    }

    private void initialize(Map<String, String> flashVars, Map<String, String> basicVars) {
        Object[] keys = flashVars.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            if (!((String)keys[i]).equalsIgnoreCase(VAR_STREAMER)) {
                this.addFlashVar((String)keys[i], flashVars.get(keys[i]));
            }
            ++i;
        }
        if (flashVars.get(FLASH_VAR_AUTOSTART) == null) {
            this.addFlashVar(FLASH_VAR_AUTOSTART, "false");
        }
        if (flashVars.get(FLASH_VAR_STRETCHING) == null) {
            this.addFlashVar(FLASH_VAR_STRETCHING, "fill");
        }
        if (flashVars.get(PARAM_VAR_ALLOWFULLSCREEN) == null) {
            this.addFlashVar(PARAM_VAR_ALLOWFULLSCREEN, "false");
        }
        if (flashVars.get(PARAM_VAR_ALLOWSCRIPTACCESS) == null) {
            this.addFlashVar(PARAM_VAR_ALLOWSCRIPTACCESS, "always");
        }
        if (flashVars.get(PARAM_VAR_VMODE) == null) {
            this.addFlashVar(PARAM_VAR_VMODE, "opaque");
        }
        keys = basicVars.keySet().toArray();
        i = 0;
        while (i < keys.length) {
            this.addBasicVar((String)keys[i], basicVars.get(keys[i]));
            ++i;
        }
    }

    @Override
    protected void onLoad() {
        this.playerId = "JW_" + this.getJw6Id();
        super.onLoad();
        if (this.isVLC()) {
            this.setVLCEventHandlers(this.getJw6Id());
        } else {
            this.setEventHandlers(this.getJw6Id());
        }
        players.put(this.playerId, this);
    }

    public void close() {
        try {
            JWPlayerWidget._stop(this.getJw6Id());
        }
        catch (Exception exception) {}
    }

    public void remove() {
        try {
            JWPlayerWidget._remove(this.getJw6Id());
        }
        catch (Exception exception) {}
    }

    @Override
    protected void onUnload() {
        players.remove(this.playerId);
        this.remove();
        super.onUnload();
    }

    public String getPosition() {
        if (this.isVLC()) {
            return JWPlayerWidget._getVlcTimePos(this.getJw6Id());
        }
        return JWPlayerWidget._getPosition(this.getJw6Id());
    }

    public float getVLCPos() {
        if (this.isVLC()) {
            return JWPlayerWidget._getVlcPos(this.getJw6Id());
        }
        return 0.0f;
    }

    public void handleStateChanged(String oldState, String newState) {
    }

    public String getState() {
        if (this.isVLC()) {
            String state = JWPlayerWidget._getVLCState(this.getJw6Id());
            switch (Integer.valueOf(state)) {
                case 0: {
                    state = STATE_IDLE;
                    break;
                }
                case 2: {
                    state = STATE_BUFFERING;
                    break;
                }
                case 3: {
                    state = STATE_PLAYING;
                    break;
                }
                case 4: {
                    state = STATE_PAUSED;
                    break;
                }
                default: {
                    state = "NOIDEA";
                }
            }
            return state;
        }
        return JWPlayerWidget._getState(this.getJw6Id());
    }

    public List<String> getAudioTracks() {
        ArrayList<String> audioList = null;
        if (this.isVLC()) {
            audioList = new ArrayList<String>();
            JsArrayString arr = JWPlayerWidget._getAudioTracks(this.getJw6Id());
            int i = 0;
            while (i < arr.length()) {
                audioList.add(new String(arr.get(i)));
                ++i;
            }
        }
        return audioList;
    }

    public int getPlayingTrack() {
        if (this.isVLC()) {
            return JWPlayerWidget._getAudioTrack();
        }
        return 0;
    }

    public boolean getMute() {
        if (this.isVLC()) {
            return JWPlayerWidget._getMute();
        }
        return false;
    }

    public void selectAudioTrack(int track) {
        if (this.isVLC()) {
            JWPlayerWidget._setAudioTrack(track);
        }
    }

    public void selectPlay() {
        if (this.isVLC()) {
            JWPlayerWidget._setPlay(this.getJw6Id());
            this.rate = 1;
        }
    }

    public int ff() {
        if (this.isVLC()) {
            ++this.rate;
            JWPlayerWidget._ff(this.rate);
        }
        return this.rate;
    }

    public void reset() {
        if (this.isVLC()) {
            this.rate = 1;
            JWPlayerWidget._reset();
        }
    }

    public void reLoad(String flashVarString) {
        JWPlayerWidget._load(this.getJw6Id(), flashVarString);
    }

    public void addVlcCallbackHandler(VideoFfwdAndAudioControlPanel videoControlPanel) {
        this.controlPanel = videoControlPanel;
    }
}

