/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.videoplayer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.tandbergtv.cms.portal.content.client.title.model.UIStillImage;
import com.tandbergtv.cms.portal.content.client.title.service.IVideoPlayerService;
import com.tandbergtv.cms.portal.content.client.title.service.IVideoPlayerServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.keyframes.KeyframesSetImagePanel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SetVideoImagePanel
extends KeyframesSetImagePanel {
    private Map<String, String> positionLookup = new HashMap<String, String>();
    protected IVideoPlayerServiceAsync videoPlayerService = (IVideoPlayerServiceAsync)GWT.create(IVideoPlayerService.class);

    @Override
    public void refreshImagesTable(Long assetId, Long titleId) {
        if (assetId == null) {
            return;
        }
        this.videoPlayerService.getStillImageURIs(assetId, titleId, new AsyncCallback<List<UIStillImage>>(){

            public void onFailure(Throwable caught) {
                Window.alert((String)("getSnapshotImageURIs RPC Failure : " + caught));
            }

            public void onSuccess(List<UIStillImage> imageInfos) {
                SetVideoImagePanel.this.keyframeImagesList.clear();
                SetVideoImagePanel.this.positionLookup.clear();
                for (UIStillImage imageInfo : imageInfos) {
                    String encodedImageFileUri = URL.encodeQueryString((String)imageInfo.getImageURI());
                    String imageUrl = String.valueOf(Window.Location.getProtocol()) + "//" + Window.Location.getHost() + "/portal/cms_contentmgmt_ui/jsps/get_image.jsp?fileURI=" + encodedImageFileUri;
                    Image image = new Image(imageUrl);
                    image.setWidth("200px");
                    image.setHeight("150px");
                    SetVideoImagePanel.this.keyframeImagesList.add(image);
                    SetVideoImagePanel.this.positionLookup.put(imageUrl, imageInfo.getTimelinePosition());
                }
                SetVideoImagePanel.this.displayImages();
            }
        });
    }

    @Override
    public String getFrameTimeString(String imageUrl) {
        String frameTimeString = "";
        String seekToPosition = this.positionLookup.get(imageUrl);
        if (seekToPosition != null && !seekToPosition.isEmpty()) {
            frameTimeString = seekToPosition;
        }
        return frameTimeString;
    }
}

