/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.videoplayer;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.tab.ErrorPanel;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIStringField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UITimeField;
import com.tandbergtv.cms.portal.content.client.title.service.asset.IUIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.JWPlayerWidget;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.TimeCodePlayer;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.VideoFfwdAndAudioControlPanel;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.VideoPanel;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UITimeFieldDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class VideoAvailTimeCodePanel
extends VideoPanel {
    ButtonWidget timeCodeOneButton;
    ButtonWidget timeCodeTwoButton;
    ButtonWidget timeCodeThreeButton;
    ButtonWidget timeCodeFourButton;
    TextBoxWidget timeCodeOneTextBox;
    TextBoxWidget timeCodeTwoTextBox;
    TextBoxWidget timeCodeThreeTextBox;
    TextBoxWidget timeCodeFourTextBox;
    ErrorPanel errorMessagePanel;
    IUIAssetFactory factory = new UIAssetFactory();
    int frameRate = 0;
    protected static final DateTimeFormat TIME_DATE_FORMAT_AVAIL_TIME_CODE = DateTimeFormat.getFormat((String)"HH:mm:ss:");

    @Override
    void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.addStyleName("VideoAvailTimeCodePanel");
        this.mainContainer.setSpacing(10);
        this.fileListBox = this.createListBoxWidget();
        this.errorMessagePanel = new ErrorPanel();
        this.errorMessagePanel.setVisible(false);
        Grid grid = new Grid(4, 3);
        grid.addStyleName("TimeCodeGrid");
        grid.setCellSpacing(5);
        this.timeCodeOneTextBox = new TextBoxWidget();
        this.timeCodeTwoTextBox = new TextBoxWidget();
        this.timeCodeThreeTextBox = new TextBoxWidget();
        this.timeCodeFourTextBox = new TextBoxWidget();
        this.timeCodeOneButton = new ButtonWidget("Time Code One");
        this.timeCodeOneButton.removeStyleName("gwt-Button");
        this.timeCodeOneButton.addStyleName("ebBtn");
        this.timeCodeOneButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String formattedTime = VideoAvailTimeCodePanel.this.getElapsedTimeHoursMinutesSecondsString(VideoAvailTimeCodePanel.this.getPlayerPosition());
                VideoAvailTimeCodePanel.this.timeCodeOneTextBox.setText(formattedTime);
            }
        });
        this.timeCodeTwoButton = new ButtonWidget("Time Code Two");
        this.timeCodeTwoButton.removeStyleName("gwt-Button");
        this.timeCodeTwoButton.addStyleName("ebBtn");
        this.timeCodeTwoButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String formattedTime = VideoAvailTimeCodePanel.this.getElapsedTimeHoursMinutesSecondsString(VideoAvailTimeCodePanel.this.getPlayerPosition());
                VideoAvailTimeCodePanel.this.timeCodeTwoTextBox.setText(formattedTime);
            }
        });
        this.timeCodeThreeButton = new ButtonWidget("Time Code Three");
        this.timeCodeThreeButton.removeStyleName("gwt-Button");
        this.timeCodeThreeButton.addStyleName("ebBtn");
        this.timeCodeThreeButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String formattedTime = VideoAvailTimeCodePanel.this.getElapsedTimeHoursMinutesSecondsString(VideoAvailTimeCodePanel.this.getPlayerPosition());
                VideoAvailTimeCodePanel.this.timeCodeThreeTextBox.setText(formattedTime);
            }
        });
        this.timeCodeFourButton = new ButtonWidget("Time Code Four");
        this.timeCodeFourButton.removeStyleName("gwt-Button");
        this.timeCodeFourButton.addStyleName("ebBtn");
        this.timeCodeFourButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String formattedTime = VideoAvailTimeCodePanel.this.getElapsedTimeHoursMinutesSecondsString(VideoAvailTimeCodePanel.this.getPlayerPosition());
                VideoAvailTimeCodePanel.this.timeCodeFourTextBox.setText(formattedTime);
            }
        });
        grid.setWidget(0, 0, (Widget)this.timeCodeOneButton);
        grid.setWidget(0, 1, (Widget)new LabelWidget(":"));
        grid.setWidget(0, 2, (Widget)this.timeCodeOneTextBox);
        grid.setWidget(1, 0, (Widget)this.timeCodeTwoButton);
        grid.setWidget(1, 1, (Widget)new LabelWidget(":"));
        grid.setWidget(1, 2, (Widget)this.timeCodeTwoTextBox);
        grid.setWidget(2, 0, (Widget)this.timeCodeThreeButton);
        grid.setWidget(2, 1, (Widget)new LabelWidget(":"));
        grid.setWidget(2, 2, (Widget)this.timeCodeThreeTextBox);
        grid.setWidget(3, 0, (Widget)this.timeCodeFourButton);
        grid.setWidget(3, 1, (Widget)new LabelWidget(":"));
        grid.setWidget(3, 2, (Widget)this.timeCodeFourTextBox);
        Button okButton = new Button("Done");
        okButton.removeStyleName("gwt-Button");
        okButton.addStyleName("ebBtn");
        okButton.addStyleName("ebBtn_color_green");
        okButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UIAsset videoAsset = VideoAvailTimeCodePanel.this.assetInfo.getAsset();
                UIComplexField rootField = videoAsset.getRootField();
                UIComplexFieldDefinition definition = VideoAvailTimeCodePanel.this.assetInfo.getDefinition().getRootFieldDefinition();
                UIComplexFieldDefinition availsDefn = (UIComplexFieldDefinition)VideoAvailTimeCodePanel.this.getFieldDefinition(definition, "Avails");
                UIComplexField availsField = (UIComplexField)VideoAvailTimeCodePanel.this.getChildField(rootField, "Avails", (UIFieldDefinition)availsDefn);
                UIComplexFieldDefinition availDefn = (UIComplexFieldDefinition)VideoAvailTimeCodePanel.this.getFieldDefinition(availsDefn, "Avail");
                UIComplexField availField = (UIComplexField)VideoAvailTimeCodePanel.this.getChildField(availsField, "Avail", (UIFieldDefinition)availDefn);
                UITimeFieldDefinition code1Defn = (UITimeFieldDefinition)VideoAvailTimeCodePanel.this.getFieldDefinition(availDefn, "TimeCodeOne");
                UITimeField code1Field = (UITimeField)VideoAvailTimeCodePanel.this.getChildField(availField, "TimeCodeOne", (UIFieldDefinition)code1Defn);
                UITimeFieldDefinition code2Defn = (UITimeFieldDefinition)VideoAvailTimeCodePanel.this.getFieldDefinition(availDefn, "TimeCodeTwo");
                UITimeField code2Field = (UITimeField)VideoAvailTimeCodePanel.this.getChildField(availField, "TimeCodeTwo", (UIFieldDefinition)code2Defn);
                UITimeFieldDefinition code3Defn = (UITimeFieldDefinition)VideoAvailTimeCodePanel.this.getFieldDefinition(availDefn, "TimeCodeThree");
                UITimeField code3Field = (UITimeField)VideoAvailTimeCodePanel.this.getChildField(availField, "TimeCodeThree", (UIFieldDefinition)code3Defn);
                UITimeFieldDefinition code4Defn = (UITimeFieldDefinition)VideoAvailTimeCodePanel.this.getFieldDefinition(availDefn, "TimeCodeFour");
                UITimeField code4Field = (UITimeField)VideoAvailTimeCodePanel.this.getChildField(availField, "TimeCodeFour", (UIFieldDefinition)code4Defn);
                String timeCodeOneFrameTime = VideoAvailTimeCodePanel.this.timeCodeOneTextBox.getText();
                String timeCodeTwoFrameTime = VideoAvailTimeCodePanel.this.timeCodeTwoTextBox.getText();
                String timeCodeThreeFrameTime = VideoAvailTimeCodePanel.this.timeCodeThreeTextBox.getText();
                String timeCodeFourFrameTime = VideoAvailTimeCodePanel.this.timeCodeFourTextBox.getText();
                VideoAvailTimeCodePanel.this.setFieldValue(code1Field, timeCodeOneFrameTime);
                VideoAvailTimeCodePanel.this.setFieldValue(code2Field, timeCodeTwoFrameTime);
                VideoAvailTimeCodePanel.this.setFieldValue(code3Field, timeCodeThreeFrameTime);
                VideoAvailTimeCodePanel.this.setFieldValue(code4Field, timeCodeFourFrameTime);
                VideoAvailTimeCodePanel.this.playerWidget.close();
                VideoAvailTimeCodePanel.this.assetPanel.redraw(VideoAvailTimeCodePanel.this.assetInfo);
            }
        });
        HorizontalPanel buttonsPanel = new HorizontalPanel();
        buttonsPanel.addStyleName("cms_button_container");
        buttonsPanel.add((Widget)okButton);
        Button cancelButton = new Button("Cancel");
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                VideoAvailTimeCodePanel.this.playerWidget.close();
                VideoAvailTimeCodePanel.this.assetPanel.redraw();
            }
        });
        buttonsPanel.add((Widget)cancelButton);
        this.playerWidget = this.createPlayerWidget("");
        this.mainContainer.add((Widget)this.fileListBox);
        this.mainContainer.add((Widget)this.playerWidget);
        this.mainContainer.add((Widget)this.errorMessagePanel);
        if (JWPlayerWidget.isVLCAvailable()) {
            this.videoControls = new VideoFfwdAndAudioControlPanel(this.playerWidget, 0);
            this.mainContainer.add((Widget)this.videoControls);
        }
        this.mainContainer.add((Widget)grid);
        this.mainContainer.add((Widget)buttonsPanel);
        this.setWidget((Widget)this.mainContainer);
    }

    @Override
    protected JWPlayerWidget newPlayerInstance(int width, int height, String flashVersionString, Map<String, String> flashVars, Map<String, String> basicVars) {
        TimeCodePlayer player = new TimeCodePlayer(width, height, flashVersionString, flashVars, basicVars);
        ArrayList<ButtonWidget> buttons = new ArrayList<ButtonWidget>();
        buttons.add(this.timeCodeOneButton);
        buttons.add(this.timeCodeTwoButton);
        buttons.add(this.timeCodeThreeButton);
        buttons.add(this.timeCodeFourButton);
        player.setButtons(buttons);
        return player;
    }

    void handleValidationError(String errMsg) {
        this.errorMessagePanel.setWidth("99%");
        this.errorMessagePanel.showErrorMessage(errMsg);
        this.errorMessagePanel.setVisible(true);
    }

    public void setAssetInfo(AssetTree.AssetInfo assetInfo) {
        this.assetInfo = assetInfo;
        if (!this.initialized) {
            this.initialize();
        } else {
            this.refreshView();
        }
    }

    @Override
    void refreshView() {
        UIComplexField contentField;
        UIStringField frameRateField;
        String code4Time;
        this.errorMessagePanel.setVisible(false);
        if (this.assetInfo == null) {
            return;
        }
        UIAsset uiMovieAsset = this.assetInfo.getAsset();
        this.fileListBox.clear();
        this.fileListBox.setWidth("500px");
        for (UIAssetFile file : uiMovieAsset.getFiles()) {
            UIAssetFileField field;
            String fieldValue;
            UIStringField stringField;
            String stringFieldValue;
            UIAssetFileField fileTypeField;
            UIAssetFileField encodeFormatField = file.getFields().get("/Fields/CustomFields/CustomField[@name=EncodeFormat]/@value");
            String encodeFormatFieldValue = null;
            if (encodeFormatField != null && encodeFormatField.getField() != null) {
                encodeFormatFieldValue = encodeFormatField.getField().getDisplayValue();
            }
            if ((fileTypeField = file.getFields().get("/Fields/Locator/Description/Text")) == null || String.valueOf(fileTypeField).isEmpty() || (stringFieldValue = (stringField = (UIStringField)fileTypeField.getField()).getDisplayValue()).equalsIgnoreCase("HISTORICAL") || (fieldValue = (field = file.getFields().get("/Fields/Locator/Uri")).getField().getDisplayValue()) == null || String.valueOf(fieldValue).isEmpty()) continue;
            String fileURI = String.valueOf(fieldValue);
            String fileEncodeFormat = "";
            fileEncodeFormat = encodeFormatFieldValue != null && !String.valueOf(encodeFormatFieldValue).isEmpty() ? String.valueOf(encodeFormatFieldValue) : fileURI.substring(fileURI.lastIndexOf(".") + 1);
            if (!JWPlayerWidget.isPlayable(fileEncodeFormat)) continue;
            this.fileListBox.addItem(String.valueOf(fileEncodeFormat.trim()) + ":" + fileURI);
        }
        if (this.fileListBox.getItemCount() > 0) {
            this.fileListBox.setSelectedIndex(0);
            this.refreshPlayer(this.fileListBox.getValue(0));
        }
        UIAsset videoAsset = this.assetInfo.getAsset();
        UIComplexField rootField = videoAsset.getRootField();
        UIComplexField availsField = (UIComplexField)this.getChildField(rootField, "Avails", null);
        UIComplexField availField = (UIComplexField)this.getChildField(availsField, "Avail", null);
        UITimeField code1Field = (UITimeField)this.getChildField(availField, "TimeCodeOne", null);
        UITimeField code2Field = (UITimeField)this.getChildField(availField, "TimeCodeTwo", null);
        UITimeField code3Field = (UITimeField)this.getChildField(availField, "TimeCodeThree", null);
        UITimeField code4Field = (UITimeField)this.getChildField(availField, "TimeCodeFour", null);
        String code1Time = code1Field != null ? code1Field.getDisplayValue() : null;
        String code2Time = code2Field != null ? code2Field.getDisplayValue() : null;
        String code3Time = code3Field != null ? code3Field.getDisplayValue() : null;
        String string = code4Time = code4Field != null ? code4Field.getDisplayValue() : null;
        if (!(code1Time == null || code1Time.isEmpty() || code2Time == null || code2Time.isEmpty() || code3Time == null || code3Time.isEmpty() || code4Time == null || code4Time.isEmpty())) {
            this.timeCodeOneTextBox.setText(code1Time);
            this.timeCodeTwoTextBox.setText(code2Time);
            this.timeCodeThreeTextBox.setText(code3Time);
            this.timeCodeFourTextBox.setText(code4Time);
        }
        this.frameRate = (frameRateField = (UIStringField)this.getChildField(contentField = (UIComplexField)this.getChildField(rootField, "Content", null), "FrameRate", null)) != null ? Integer.parseInt(frameRateField.getDisplayValue()) : 0;
    }

    @Override
    public String getElapsedTimeHoursMinutesSecondsString(String timeLinePosition) {
        float val = Float.parseFloat(timeLinePosition);
        long posTimeInMilliseconds = (long)(val * 1000.0f);
        long frameTimeInMilliSec = posTimeInMilliseconds % 1000L;
        Date frameDate = TIME_DATE_FORMAT_AVAIL_TIME_CODE.parse("00:00:00:");
        frameDate.setTime(frameDate.getTime() + posTimeInMilliseconds);
        String posTimeString = TIME_DATE_FORMAT_AVAIL_TIME_CODE.format(frameDate);
        String frame = "00";
        if (this.frameRate > 0) {
            frame = NumberFormat.getFormat((String)"00").format((double)(frameTimeInMilliSec * (long)this.frameRate / 1000L));
        }
        return String.valueOf(posTimeString) + frame;
    }

    private <T extends UIField> T getChildField(UIComplexField parent, String childName, UIFieldDefinition fieldDefinition) {
        if (parent == null) {
            return null;
        }
        UIField field = parent.getChildren().getField(childName);
        if (field == null && fieldDefinition != null) {
            field = this.factory.createAssetField(fieldDefinition);
        }
        return (T)field;
    }

    private <T extends UIFieldDefinition> T getFieldDefinition(UIComplexFieldDefinition parent, String childName) {
        if (parent == null || parent.getChildren() == null) {
            return null;
        }
        for (UIFieldDefinition definition : parent.getChildren()) {
            if (!definition.getName().equals(childName)) continue;
            return (T)definition;
        }
        return null;
    }

    private void setFieldValue(UITimeField field, String value) {
        if (field != null) {
            field.setValue(value);
        }
    }
}

