/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.videoplayer;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.JWPlayerWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import java.util.Date;
import java.util.List;

public class VideoFfwdAndAudioControlPanel
extends HorizontalContainer {
    protected JWPlayerWidget player;
    protected ListBox audioListBox;
    protected TextBoxWidget timeCodeTextBox;
    protected Button playBtn;
    protected Button ffBtn;
    protected int duration = 0;
    protected static final DateTimeFormat FRAME_TIME_DATE_FORMAT = DateTimeFormat.getFormat((String)"HH:mm:ss.SSS");

    public VideoFfwdAndAudioControlPanel(JWPlayerWidget plyr, int duration) {
        this.player = plyr;
        this.duration = duration;
        this.playBtn = new Button("x 1");
        this.playBtn.removeStyleName("gwt-Button");
        this.playBtn.addStyleName("ebBtn");
        this.playBtn.setEnabled(false);
        this.playBtn.setVisible(false);
        this.playBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                VideoFfwdAndAudioControlPanel.this.ffBtn.setText("FF");
                VideoFfwdAndAudioControlPanel.this.playBtn.setEnabled(false);
                VideoFfwdAndAudioControlPanel.this.playBtn.setVisible(false);
                VideoFfwdAndAudioControlPanel.this.player.selectPlay();
            }
        });
        this.ffBtn = new Button("FF");
        this.ffBtn.removeStyleName("gwt-Button");
        this.ffBtn.addStyleName("ebBtn");
        this.ffBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                VideoFfwdAndAudioControlPanel.this.playBtn.setVisible(true);
                VideoFfwdAndAudioControlPanel.this.playBtn.setEnabled(true);
                VideoFfwdAndAudioControlPanel.this.ffBtn.setText("x " + (VideoFfwdAndAudioControlPanel.this.player.ff() + 1));
            }
        });
        this.audioListBox = new ListBox();
        this.audioListBox.setWidth("120px");
        this.audioListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int selectedIndex = VideoFfwdAndAudioControlPanel.this.audioListBox.getSelectedIndex();
                if (selectedIndex > -1) {
                    VideoFfwdAndAudioControlPanel.this.player.selectAudioTrack(selectedIndex);
                }
            }
        });
        this.timeCodeTextBox = new TextBoxWidget();
        this.timeCodeTextBox.setWidth("80px");
        LabelWidget audioLabel = new LabelWidget("Audio:");
        HorizontalPanel audioPanel = new HorizontalPanel();
        audioPanel.addStyleName("ButtonsPanel");
        audioPanel.addStyleName("VideoPreviewAudio");
        audioPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        audioPanel.add((Widget)audioLabel);
        audioPanel.add((Widget)this.audioListBox);
        HorizontalPanel buttonsPanel = new HorizontalPanel();
        buttonsPanel.addStyleName("ButtonsPanel");
        buttonsPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        buttonsPanel.add((Widget)this.playBtn);
        buttonsPanel.add((Widget)this.ffBtn);
        this.addStyleName("ButtonsPanel");
        this.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.setSpacing(5);
        this.add((Widget)this.timeCodeTextBox);
        this.add((Widget)buttonsPanel);
        this.add((Widget)audioPanel);
    }

    protected void onLoad() {
        super.onLoad();
        if (this.player.isVLC()) {
            this.player.addVlcCallbackHandler(this);
        }
    }

    public void setPlayer(JWPlayerWidget plyr) {
        this.player = plyr;
        this.player.addVlcCallbackHandler(this);
        this.refreshControls();
    }

    public void setDuration(int d) {
        this.duration = d;
    }

    public void refreshControls() {
        this.playBtn.setEnabled(false);
        this.playBtn.setVisible(false);
        this.ffBtn.setText("FF");
        this.ffBtn.setEnabled(false);
        this.timeCodeTextBox.setText("00:00:00.000");
        this.audioListBox.clear();
    }

    public void updateVideoOptions() {
        if (this.player.isVLC()) {
            String formattedTime = VideoFfwdAndAudioControlPanel.getElapsedTimeHoursMinutesSecondsString(this.getTimePosition());
            this.timeCodeTextBox.setText(formattedTime);
            List<String> l = this.player.getAudioTracks();
            if (this.audioListBox.getItemCount() != l.size()) {
                this.audioListBox.clear();
                for (String s : l) {
                    this.audioListBox.addItem(s);
                }
            }
            if (this.player.getMute() && !this.playBtn.isEnabled()) {
                this.audioListBox.setItemSelected(0, true);
            } else if (this.player.getPlayingTrack() < l.size()) {
                this.audioListBox.setItemSelected(this.player.getPlayingTrack(), true);
            } else {
                this.audioListBox.setItemSelected(1, true);
            }
        }
    }

    public void updateVideoFFControls(String newState) {
        if (this.player.isVLC()) {
            if (newState.equalsIgnoreCase("PAUSED")) {
                if (!this.playBtn.isVisible()) {
                    this.ffBtn.setEnabled(false);
                }
                String formattedTime = VideoFfwdAndAudioControlPanel.getElapsedTimeHoursMinutesSecondsString(this.getTimePosition());
                this.timeCodeTextBox.setText(formattedTime);
            } else if (newState.equalsIgnoreCase("PLAYING")) {
                this.ffBtn.setEnabled(true);
            } else if (newState.equalsIgnoreCase("ENDED")) {
                this.player.reset();
                this.playBtn.setEnabled(false);
                this.playBtn.setVisible(false);
                this.ffBtn.setText("FF");
                this.ffBtn.setEnabled(false);
                this.timeCodeTextBox.setText("00:00:00.000");
            }
        }
    }

    protected String getTimePosition() {
        float val;
        String timePosition = this.player.getPosition();
        if (this.player.isVLC() && (val = Float.parseFloat(timePosition)) == 0.0f && this.duration != 0) {
            timePosition = String.valueOf((float)this.duration * this.player.getVLCPos());
        }
        return timePosition;
    }

    public static String getElapsedTimeHoursMinutesSecondsString(String timeLinePosition) {
        float val = Float.parseFloat(timeLinePosition);
        long posTimeInMilliseconds = (long)(val * 1000.0f);
        Date frameDate = FRAME_TIME_DATE_FORMAT.parse("00:00:00.000");
        frameDate.setTime(frameDate.getTime() + posTimeInMilliseconds);
        String posTimeString = FRAME_TIME_DATE_FORMAT.format(frameDate);
        return posTimeString;
    }
}

