/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.videoplayer;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.tab.ErrorPanel;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIStringField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UITimeField;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.JWPlayerWidget;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.TimeCodePlayer;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.Validator;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.VideoFfwdAndAudioControlPanel;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.VideoPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class VideoLogicalClipPanel
extends VideoPanel {
    ButtonWidget markInButton;
    ButtonWidget markOutButton;
    TextBoxWidget markInTextBox;
    TextBoxWidget markOutTextBox;
    ErrorPanel errorMessagePanel;
    protected static final DateTimeFormat TIME_DATE_FORMAT_LOGICAL_CLIP = DateTimeFormat.getFormat((String)"HH:mm:ss");

    @Override
    void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.addStyleName("VideoLogicalClipPanel");
        this.mainContainer.setSpacing(10);
        this.fileListBox = this.createListBoxWidget();
        this.errorMessagePanel = new ErrorPanel();
        this.errorMessagePanel.setVisible(false);
        this.markInTextBox = new TextBoxWidget();
        this.markOutTextBox = new TextBoxWidget();
        this.markInButton = new ButtonWidget("Start Time");
        this.markInButton.removeStyleName("gwt-Button");
        this.markInButton.addStyleName("ebBtn");
        this.markInButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String formattedTime = VideoLogicalClipPanel.this.getElapsedTimeHoursMinutesSecondsString(VideoLogicalClipPanel.this.getPlayerPosition());
                VideoLogicalClipPanel.this.markInTextBox.setText(formattedTime);
            }
        });
        this.markOutButton = new ButtonWidget("End Time");
        this.markOutButton.removeStyleName("gwt-Button");
        this.markOutButton.addStyleName("ebBtn");
        this.markOutButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String formattedTime = VideoLogicalClipPanel.this.getElapsedTimeHoursMinutesSecondsString(VideoLogicalClipPanel.this.getPlayerPosition());
                VideoLogicalClipPanel.this.markOutTextBox.setText(formattedTime);
            }
        });
        HorizontalPanel hc = new HorizontalPanel();
        hc.add((Widget)this.markInButton);
        hc.add((Widget)new HTML("&nbsp; : &nbsp;"));
        hc.add((Widget)this.markInTextBox);
        hc.add((Widget)new HTML("&nbsp; &nbsp; &nbsp; &nbsp;"));
        hc.add((Widget)this.markOutButton);
        hc.add((Widget)new HTML("&nbsp; : &nbsp;"));
        hc.add((Widget)this.markOutTextBox);
        hc.addStyleName("ButtonsPanel1");
        HorizontalPanel buttonsPanel = new HorizontalPanel();
        buttonsPanel.addStyleName("cms_button_container");
        Button okButton = new Button("Done");
        okButton.removeStyleName("gwt-Button");
        okButton.addStyleName("ebBtn");
        okButton.addStyleName("ebBtn_color_green");
        okButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String markOutFrameTime;
                UIAsset logicalClipUIAsset = VideoLogicalClipPanel.this.assetInfo.getAsset();
                UIComplexField rootField = logicalClipUIAsset.getRootField();
                UIComplexField markField = (UIComplexField)rootField.getChildren().getField("Mark");
                UITimeField markInField = (UITimeField)markField.getChildren().getField("In");
                UITimeField markOutField = (UITimeField)markField.getChildren().getField("Out");
                Validator util = new Validator();
                String markInFrameTime = VideoLogicalClipPanel.this.markInTextBox.getText();
                if (!util.validateMarkInMarkOut(TIME_DATE_FORMAT_LOGICAL_CLIP, markInFrameTime, markOutFrameTime = VideoLogicalClipPanel.this.markOutTextBox.getText())) {
                    VideoLogicalClipPanel.this.handleValidationError(util.getMessage());
                    return;
                }
                markInField.setValue(markInFrameTime);
                markOutField.setValue(markOutFrameTime);
                VideoLogicalClipPanel.this.playerWidget.close();
                VideoLogicalClipPanel.this.assetPanel.redraw(VideoLogicalClipPanel.this.assetInfo);
            }
        });
        buttonsPanel.add((Widget)okButton);
        Button cancelButton = new Button("Cancel");
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                VideoLogicalClipPanel.this.playerWidget.close();
                VideoLogicalClipPanel.this.assetPanel.redraw();
            }
        });
        buttonsPanel.add((Widget)cancelButton);
        this.playerWidget = this.createPlayerWidget("");
        this.mainContainer.add((Widget)this.fileListBox);
        this.mainContainer.add((Widget)this.playerWidget);
        this.mainContainer.add((Widget)this.errorMessagePanel);
        if (JWPlayerWidget.isVLCAvailable()) {
            this.videoControls = new VideoFfwdAndAudioControlPanel(this.playerWidget, 0);
            this.mainContainer.add((Widget)this.videoControls);
        }
        this.mainContainer.add((Widget)hc);
        this.mainContainer.add((Widget)buttonsPanel);
        this.setWidget((Widget)this.mainContainer);
    }

    @Override
    protected JWPlayerWidget newPlayerInstance(int width, int height, String flashVersionString, Map<String, String> flashVars, Map<String, String> basicVars) {
        TimeCodePlayer player = new TimeCodePlayer(width, height, flashVersionString, flashVars, basicVars);
        ArrayList<ButtonWidget> buttons = new ArrayList<ButtonWidget>();
        buttons.add(this.markInButton);
        buttons.add(this.markOutButton);
        player.setButtons(buttons);
        return player;
    }

    void handleValidationError(String errMsg) {
        this.errorMessagePanel.setWidth("99%");
        this.errorMessagePanel.showErrorMessage(errMsg);
        this.errorMessagePanel.setVisible(true);
    }

    public void setAssetInfo(AssetTree.AssetInfo assetInfo) {
        this.assetInfo = assetInfo;
        if (!this.initialized) {
            this.initialize();
        } else {
            this.refreshView();
        }
    }

    @Override
    void refreshView() {
        this.errorMessagePanel.setVisible(false);
        if (this.assetInfo == null) {
            return;
        }
        UIAsset uiMovieAsset = this.assetInfo.getAsset().getParentAsset();
        this.fileListBox.clear();
        this.fileListBox.setWidth("500px");
        for (UIAssetFile file : uiMovieAsset.getFiles()) {
            UIAssetFileField field;
            String fieldValue;
            UIStringField stringField;
            String stringFieldValue;
            UIAssetFileField fileTypeField;
            UIAssetFileField encodeFormatField = file.getFields().get("/Fields/CustomFields/CustomField[@name=EncodeFormat]/@value");
            String encodeFormatFieldValue = null;
            if (encodeFormatField != null && encodeFormatField.getField() != null) {
                encodeFormatFieldValue = encodeFormatField.getField().getDisplayValue();
            }
            if ((fileTypeField = file.getFields().get("/Fields/Locator/Description/Text")) == null || String.valueOf(fileTypeField).isEmpty() || (stringFieldValue = (stringField = (UIStringField)fileTypeField.getField()).getDisplayValue()).equalsIgnoreCase("HISTORICAL") || (fieldValue = (field = file.getFields().get("/Fields/Locator/Uri")).getField().getDisplayValue()) == null || String.valueOf(fieldValue).isEmpty()) continue;
            String fileURI = String.valueOf(fieldValue);
            String fileEncodeFormat = "";
            fileEncodeFormat = encodeFormatFieldValue != null && !String.valueOf(encodeFormatFieldValue).isEmpty() ? String.valueOf(encodeFormatFieldValue) : fileURI.substring(fileURI.lastIndexOf(".") + 1);
            if (!JWPlayerWidget.isPlayable(fileEncodeFormat)) continue;
            this.fileListBox.addItem(String.valueOf(fileEncodeFormat.trim()) + ":" + fileURI);
        }
        if (this.fileListBox.getItemCount() > 0) {
            this.fileListBox.setSelectedIndex(0);
            this.refreshPlayer(this.fileListBox.getValue(0));
        }
        UIAsset logicalClipUIAsset = this.assetInfo.getAsset();
        UIComplexField rootField = logicalClipUIAsset.getRootField();
        UIComplexField markField = (UIComplexField)rootField.getChildren().getField("Mark");
        UITimeField markInField = (UITimeField)markField.getChildren().getField("In");
        UITimeField markOutField = (UITimeField)markField.getChildren().getField("Out");
        String markInTime = markInField.getDisplayValue();
        String markOutTime = markOutField.getDisplayValue();
        if (markInTime != null && !markInTime.isEmpty() && markOutTime != null && !markOutTime.isEmpty()) {
            this.markInTextBox.setText(markInTime);
            this.markOutTextBox.setText(markOutTime);
        }
    }

    @Override
    public String getElapsedTimeHoursMinutesSecondsString(String timeLinePosition) {
        float val = Float.parseFloat(timeLinePosition);
        long posTimeInMilliseconds = (long)(val * 1000.0f);
        Date frameDate = TIME_DATE_FORMAT_LOGICAL_CLIP.parse("00:00:00");
        frameDate.setTime(frameDate.getTime() + posTimeInMilliseconds);
        String posTimeString = TIME_DATE_FORMAT_LOGICAL_CLIP.format(frameDate);
        return posTimeString;
    }
}

