/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.videoplayer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.UIVideoPlayer;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UITimeField;
import com.tandbergtv.cms.portal.content.client.title.service.IVideoPlayerService;
import com.tandbergtv.cms.portal.content.client.title.service.IVideoPlayerServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetPanel;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.JWPlayerWidget;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.VideoFfwdAndAudioControlPanel;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class VideoPanel
extends SimpleContainer {
    protected VerticalContainer mainContainer;
    protected AssetPanel assetPanel;
    protected AssetTree.AssetInfo assetInfo;
    protected TitleView titleView;
    protected JWPlayerWidget playerWidget;
    protected ListBox fileListBox;
    protected VideoFfwdAndAudioControlPanel videoControls;
    protected int duration = 0;
    protected Map<String, String> basicVars = new HashMap<String, String>();
    protected Map<String, String> flashVars = new HashMap<String, String>();
    protected boolean initialized = false;
    protected static final String FILE_URI_XPATH = "/Fields/Locator/Uri";
    protected static final String FILE_ENCODEFORMAT_XPATH = "/Fields/CustomFields/CustomField[@name=EncodeFormat]/@value";
    protected static final String FILE_FILETYPE_XPATH = "/Fields/Locator/Description/Text";
    protected static final String FILE_TYPE_HISTORICAL = "HISTORICAL";
    protected static final DateTimeFormat FRAME_TIME_DATE_FORMAT = DateTimeFormat.getFormat((String)"HH:mm:ss.SSS");
    protected IVideoPlayerServiceAsync videoPlayerService = (IVideoPlayerServiceAsync)GWT.create(IVideoPlayerService.class);
    protected TitleViewMessages messages = (TitleViewMessages)GWT.create(TitleViewMessages.class);

    void initialize() {
        this.fetchPlayerParameters();
    }

    void fetchPlayerParameters() {
        final BusyIndicator busyIndicator = new BusyIndicator();
        busyIndicator.center();
        this.videoPlayerService.getSettings((AsyncCallback<UIVideoPlayer>)new NeptuneAsyncCallback<UIVideoPlayer>(){

            public void onNeptuneSuccess(UIVideoPlayer confSettings) {
                busyIndicator.hide();
                VideoPanel.this.basicVars = confSettings.getBasicVars();
                VideoPanel.this.flashVars = confSettings.getFlashVars();
                JWPlayerWidget.loadPlayableFormats(VideoPanel.this.basicVars);
                VideoPanel.this.initWidgets();
                VideoPanel.this.refreshView();
                VideoPanel.this.initialized = true;
            }

            public void onNeptuneFailure(Throwable caught) {
                busyIndicator.hide();
            }
        });
    }

    abstract void initWidgets();

    abstract void refreshView();

    protected ListBox createListBoxWidget() {
        final ListBox listBox = new ListBox();
        listBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int selectedIndex = listBox.getSelectedIndex();
                if (selectedIndex > -1) {
                    VideoPanel.this.refreshPlayer(listBox.getValue(selectedIndex));
                }
            }
        });
        return listBox;
    }

    protected JWPlayerWidget createPlayerWidget(String fileURI) {
        int width = 470;
        int height = 290;
        String confWidth = this.basicVars.get("width");
        String confHeight = this.basicVars.get("height");
        if (confWidth != null && confHeight != null) {
            width = Integer.parseInt(confWidth);
            height = Integer.parseInt(confHeight);
        }
        String minFlashVersionString = "9.0.124";
        if (this.basicVars.get("minflashversion") != null) {
            minFlashVersionString = this.basicVars.get("minflashversion");
        }
        if (fileURI != null) {
            String streamer = "";
            streamer = this.basicVars.get("streamer");
            if (streamer != null && streamer.length() > 0) {
                this.flashVars.put("file", String.valueOf(streamer) + fileURI);
            } else {
                this.flashVars.put("file", fileURI);
            }
            this.basicVars.put("file", fileURI);
        }
        this.flashVars.put("autostart", "false");
        JWPlayerWidget player = this.newPlayerInstance(width, height, minFlashVersionString, this.flashVars, this.basicVars);
        return player;
    }

    protected JWPlayerWidget newPlayerInstance(int width, int height, String flashVersionString, Map<String, String> flashVars, Map<String, String> basicVars) {
        JWPlayerWidget player = new JWPlayerWidget(width, height, flashVersionString, flashVars, basicVars);
        return player;
    }

    void refreshPlayer(String fileURI) {
        int index = 1;
        if (this.playerWidget != null) {
            index = this.mainContainer.getWidgetIndex((Widget)this.playerWidget);
            this.mainContainer.remove((Widget)this.playerWidget);
        }
        this.playerWidget = this.createPlayerWidget(fileURI);
        this.mainContainer.insert((Widget)this.playerWidget, index);
        if (JWPlayerWidget.isVLCAvailable()) {
            this.videoControls.setDuration(this.getDuration());
            this.videoControls.setPlayer(this.playerWidget);
        }
    }

    protected int getDuration() {
        UIComplexField f;
        UIAsset videoAsset = this.assetInfo.getAsset();
        if (videoAsset.getAssetType().equalsIgnoreCase("LogicalClip")) {
            videoAsset = this.assetInfo.getAsset().getParentAsset();
        }
        UIComplexField rootField = videoAsset.getRootField();
        this.duration = 0;
        if (rootField != null && (f = (UIComplexField)rootField.getChildren().getField("Duration")) != null) {
            UITimeField durationField = (UITimeField)f.getChildren().getField("Duration");
            String strDur = null;
            if (durationField != null && (strDur = durationField.getDisplayValue()) != null && !strDur.isEmpty()) {
                String[] parts = strDur.split(":");
                this.duration += Integer.parseInt(parts[0]) * 60 * 60;
                this.duration += Integer.parseInt(parts[1]) * 60;
                this.duration += Integer.parseInt(parts[2]);
            }
        }
        return this.duration;
    }

    protected String getPlayerPosition() {
        float val;
        String timePosition = this.playerWidget.getPosition();
        if (this.playerWidget.isVLC() && (val = Float.parseFloat(timePosition)) == 0.0f && this.duration != 0) {
            timePosition = String.valueOf((float)this.duration * this.playerWidget.getVLCPos());
        }
        return timePosition;
    }

    public String getElapsedTimeHoursMinutesSecondsString(String timeLinePosition) {
        float val = Float.parseFloat(timeLinePosition);
        long posTimeInMilliseconds = (long)(val * 1000.0f);
        Date frameDate = FRAME_TIME_DATE_FORMAT.parse("00:00:00.000");
        frameDate.setTime(frameDate.getTime() + posTimeInMilliseconds);
        String posTimeString = FRAME_TIME_DATE_FORMAT.format(frameDate);
        return posTimeString;
    }

    public AssetPanel getAssetPanel() {
        return this.assetPanel;
    }

    public void setAssetPanel(AssetPanel assetPanel) {
        this.assetPanel = assetPanel;
    }

    public void setTitleView(TitleView titleView) {
        this.titleView = titleView;
    }
}

