/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.title.view.videoplayer;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.tab.ErrorPanel;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIStringField;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.JWPlayerWidget;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.VideoFfwdAndAudioControlPanel;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.VideoPanel;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.InlineLabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class VideoSnapshotPanel
extends VideoPanel {
    FlowPanel requestSuccessMessagePanel;
    ErrorPanel requestErrorMessagePanel;
    ButtonWidget snapshotButton;
    private String SUCCESS_MESSAGE_STYLE1 = "content-TitleView-feedbackPopup";
    private String SUCCESS_MESSAGE_STYLE2 = "content-TitleView-feedbackLabel";

    @Override
    void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.addStyleName("VideoSnapshotPanel");
        this.mainContainer.setSpacing(10);
        this.requestSuccessMessagePanel = new FlowPanel();
        InlineLabelWidget activityViewLabel = new InlineLabelWidget(this.messages.activityTabName());
        activityViewLabel.addStyleName("table-data-link");
        activityViewLabel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                VideoSnapshotPanel.this.titleView.showTab("Activity");
            }
        });
        String msg = this.messages.snapshotImageProcessInitiatedText();
        InlineLabelWidget targetingInitiatedLabel1 = new InlineLabelWidget(msg);
        this.addSuccessStyleForLabel(targetingInitiatedLabel1);
        this.addSuccessStyleForLabel(activityViewLabel);
        this.requestSuccessMessagePanel.add((Widget)targetingInitiatedLabel1);
        this.requestSuccessMessagePanel.add((Widget)activityViewLabel);
        this.requestSuccessMessagePanel.setVisible(false);
        this.requestErrorMessagePanel = new ErrorPanel();
        this.requestErrorMessagePanel.setVisible(false);
        this.requestErrorMessagePanel.setWidth("99%");
        this.fileListBox = this.createListBoxWidget();
        this.snapshotButton = new ButtonWidget(this.messages.createSnapshotButtonText());
        this.snapshotButton.removeStyleName("gwt-Button");
        this.snapshotButton.addStyleName("ebBtn");
        this.snapshotButton.addStyleName("ebBtn_color_green");
        this.snapshotButton.addStyleName("create_button_icon");
        this.snapshotButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String selectedFile;
                String state = VideoSnapshotPanel.this.playerWidget.getState();
                if (!state.equals("PAUSED")) {
                    Window.alert((String)"Please pause the player first.");
                    return;
                }
                String formattedTime = VideoSnapshotPanel.this.getElapsedTimeHoursMinutesSecondsString(VideoSnapshotPanel.this.getPlayerPosition());
                UIAsset uiMovieAsset = VideoSnapshotPanel.this.assetInfo.getAsset();
                Long uiMovieAssetId = uiMovieAsset.getId();
                Long titleId = VideoSnapshotPanel.this.assetInfo.getInput().getTitleId();
                String providerId = VideoSnapshotPanel.this.assetInfo.getDefinition().getSpecification().getProviderId();
                int selectedIndex = VideoSnapshotPanel.this.fileListBox.getSelectedIndex();
                String fileURI = selectedFile = VideoSnapshotPanel.this.fileListBox.getValue(selectedIndex);
                int index = selectedFile.indexOf(":");
                if (index > 0) {
                    fileURI = selectedFile.substring(index + 1);
                }
                VideoSnapshotPanel.this.submitRequest(uiMovieAssetId, titleId, providerId, fileURI, formattedTime);
            }
        });
        Button okButton = new Button(this.messages.videoSnapshotOkButtonText());
        okButton.removeStyleName("gwt-Button");
        okButton.addStyleName("ebBtn");
        okButton.addStyleName("ebBtn_color_green");
        okButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                VideoSnapshotPanel.this.playerWidget.close();
                VideoSnapshotPanel.this.assetPanel.redraw();
            }
        });
        HorizontalPanel buttonsPanel = new HorizontalPanel();
        buttonsPanel.addStyleName("cms_button_container");
        buttonsPanel.add((Widget)okButton);
        buttonsPanel.add((Widget)this.snapshotButton);
        this.playerWidget = this.createPlayerWidget("");
        this.mainContainer.add((Widget)this.requestSuccessMessagePanel);
        this.mainContainer.add((Widget)this.requestErrorMessagePanel);
        this.mainContainer.add((Widget)this.fileListBox);
        this.mainContainer.add((Widget)this.playerWidget);
        if (JWPlayerWidget.isVLCAvailable()) {
            this.videoControls = new VideoFfwdAndAudioControlPanel(this.playerWidget, 0);
            this.mainContainer.add((Widget)this.videoControls);
        }
        this.mainContainer.add((Widget)buttonsPanel);
        this.setWidget((Widget)this.mainContainer);
    }

    private void addSuccessStyleForLabel(InlineLabelWidget labelWidget) {
        labelWidget.addStyleName(this.SUCCESS_MESSAGE_STYLE1);
        labelWidget.addStyleName(this.SUCCESS_MESSAGE_STYLE2);
    }

    public void setAssetInfo(AssetTree.AssetInfo assetInfo) {
        this.assetInfo = assetInfo;
        if (!this.initialized) {
            this.initialize();
        } else {
            this.refreshView();
        }
    }

    @Override
    void refreshView() {
        if (this.assetInfo == null) {
            return;
        }
        this.fileListBox.clear();
        this.fileListBox.setWidth("500px");
        UIAsset uiMovieAsset = this.assetInfo.getAsset();
        for (UIAssetFile file : uiMovieAsset.getFiles()) {
            UIAssetFileField field;
            String fieldValue;
            UIStringField stringField;
            String stringFieldValue;
            UIAssetFileField fileTypeField;
            UIAssetFileField encodeFormatField = file.getFields().get("/Fields/CustomFields/CustomField[@name=EncodeFormat]/@value");
            String encodeFormatFieldValue = null;
            if (encodeFormatField != null && encodeFormatField.getField() != null) {
                encodeFormatFieldValue = encodeFormatField.getField().getDisplayValue();
            }
            if ((fileTypeField = file.getFields().get("/Fields/Locator/Description/Text")) == null || String.valueOf(fileTypeField).isEmpty() || (stringFieldValue = (stringField = (UIStringField)fileTypeField.getField()).getDisplayValue()).equalsIgnoreCase("HISTORICAL") || (fieldValue = (field = file.getFields().get("/Fields/Locator/Uri")).getField().getDisplayValue()) == null || String.valueOf(fieldValue).isEmpty()) continue;
            String fileURI = String.valueOf(fieldValue);
            String fileEncodeFormat = "";
            fileEncodeFormat = encodeFormatFieldValue != null && !String.valueOf(encodeFormatFieldValue).isEmpty() ? String.valueOf(encodeFormatFieldValue) : fileURI.substring(fileURI.lastIndexOf(".") + 1);
            if (!JWPlayerWidget.isPlayable(fileEncodeFormat)) continue;
            this.fileListBox.addItem(String.valueOf(fileEncodeFormat.trim().toLowerCase()) + ":" + fileURI);
        }
        this.requestSuccessMessagePanel.setVisible(false);
        this.requestErrorMessagePanel.setVisible(false);
        if (this.fileListBox.getItemCount() > 0) {
            this.fileListBox.setSelectedIndex(0);
            this.refreshPlayer(this.fileListBox.getValue(0));
        }
    }

    void submitRequest(final Long assetId, Long titleId, String providerId, String fileURI, String timePosition) {
        final BusyIndicator busyIndicator = new BusyIndicator((Widget)this);
        busyIndicator.center();
        this.videoPlayerService.createImageFromVideoFile(assetId, titleId, providerId, fileURI, timePosition, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneSuccess(Void result) {
                busyIndicator.hide();
                VideoSnapshotPanel.this.handleSubmitRequestSuccess(assetId);
            }

            public void onNeptuneFailure(Throwable caught) {
                busyIndicator.hide();
                VideoSnapshotPanel.this.handleSubmitRequestFailure(caught);
            }
        });
    }

    void handleSubmitRequestSuccess(Long assetId) {
        this.requestSuccessMessagePanel.setVisible(true);
    }

    void handleSubmitRequestFailure(Throwable caught) {
        this.requestErrorMessagePanel.showErrorMessage(caught.getMessage());
        this.requestSuccessMessagePanel.setVisible(false);
        this.requestErrorMessagePanel.setVisible(true);
    }
}

