/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server;

import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;

public class SpecificationServiceImpl
implements SpecificationService,
NeptuneRemoteService {
    private IAssetSpecificationManager specManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);

    public String getRelativePath() {
        return "service/content/specService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public UiTable getTable(String tableName) {
        Table table = this.specManager.getTableConfiguration(tableName);
        return this.prepareUiTable(table);
    }

    private UiTable prepareUiTable(Table table) {
        UiTable uiTable = new UiTable();
        uiTable.setDefaultSortColumnName(table.getDefaultSortingColumn());
        uiTable.setDefaultSortingOrder(table.getDefaultSortingOrder());
        DataTypeMappingReader reader = DataTypeMappingReader.getInstance();
        for (Column col : table.getColumns()) {
            UiColumn uiCol = new UiColumn();
            uiCol.setDisplayName(col.getColumnName());
            boolean sortable = col.getSortingColumnName() != null;
            uiCol.setSortable(sortable);
            uiCol.setSelectedByDefault(col.isSelectedByDefault());
            uiCol.setIsMultiValued(col.isMultiValued());
            if (col.getColumnAttribute("TitleSection") != null) {
                uiCol.setSectionName(col.getColumnAttribute("TitleSection"));
                uiCol.setName(col.getParameter());
                uiCol.setFieldType(UIFieldType.ASSET);
                uiCol.setRootMetadata(false);
                if (col.getSortingProperty() != null && col.getSortingProperty().length() > 0) {
                    uiCol.setRootMetadata(true);
                }
                StringBuilder sb = new StringBuilder();
                StringBuilder currentNode = new StringBuilder();
                boolean inCondition = false;
                char[] cArray = uiCol.getName().toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (c == '/' && !inCondition) {
                        currentNode = new StringBuilder();
                        sb.append(c);
                    } else if (c == '[' && !currentNode.toString().equals("CustomField")) {
                        inCondition = true;
                    } else if (c == ']' && inCondition) {
                        inCondition = false;
                    } else if (!inCondition) {
                        currentNode.append(c);
                        sb.append(c);
                    }
                    ++n2;
                }
                String field = sb.toString();
                String dataType = reader.determineDataType(field);
                uiCol.setDataType(this.getColumnDataType(dataType));
            } else {
                uiCol.setName(col.getMethodName());
                UiColumn.DataType dataType = UiColumn.DataType.STRING;
                if (uiCol.getName().equals("id")) {
                    dataType = UiColumn.DataType.INTEGER;
                }
                if (uiCol.getName().equals("createDate")) {
                    dataType = UiColumn.DataType.DATE;
                }
                uiCol.setDataType(dataType);
                uiCol.setFieldType(UIFieldType.PMM_TITLE);
            }
            uiTable.addColumn(uiCol);
        }
        return uiTable;
    }

    private UiColumn.DataType getColumnDataType(String dataTypeValue) {
        UiColumn.DataType dataType = null;
        if ("boolean".equals(dataTypeValue)) {
            dataType = UiColumn.DataType.BOOLEAN;
        } else if ("date".equals(dataTypeValue)) {
            dataType = UiColumn.DataType.DATE;
        } else if ("float".equals(dataTypeValue)) {
            dataType = UiColumn.DataType.FLOAT;
        } else if ("integer".equals(dataTypeValue)) {
            dataType = UiColumn.DataType.INTEGER;
        } else if ("string".equals(dataTypeValue)) {
            dataType = UiColumn.DataType.STRING;
        } else if ("time".equals(dataTypeValue)) {
            dataType = UiColumn.DataType.TIME;
        }
        return dataType;
    }
}

