/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.contentclass;

import com.tandbergtv.cms.portal.content.client.contentclass.model.CCPValidationError;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConfMetadata;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import java.util.Collection;
import java.util.List;

public class CCPValidator {
    private static final int MAX_ERROR_COUNT = 5;
    private static final String CF_NAME_START = "[@name=";
    private UISpecification spec;
    private ContentClassMetadata ccMeta;

    public CCPValidator(ContentClass cc, UISpecification spec) {
        this.spec = spec;
        this.ccMeta = cc.getMetadata();
    }

    public void validate(ContentClassPartner partner, List<CCPValidationError> errors) {
        if (errors == null) {
            return;
        }
        if (partner == null) {
            return;
        }
        ContentClassMetadata partnerMeta = partner.getMetadata();
        if (partnerMeta == null) {
            return;
        }
        Collection partnerAssets = partnerMeta.getAssetList();
        if (partnerAssets == null) {
            return;
        }
        for (ContentClassAsset partnerAsset : partnerAssets) {
            String assetPath = partnerAsset.getPath();
            ContentClassAsset ccAsset = this.ccMeta == null ? null : this.ccMeta.getAsset(assetPath);
            Collection partnerFields = partnerAsset.getFieldList();
            if (partnerFields == null) continue;
            for (ContentClassField partnerField : partnerFields) {
                String fieldPath = partnerField.getPath();
                if (!this.reportError(ccAsset, fieldPath)) continue;
                if (errors.size() >= 5) {
                    return;
                }
                CCPValidationError error = new CCPValidationError();
                error.partnerId = partner.getProviderId();
                error.assetPath = assetPath;
                error.fieldPath = fieldPath;
                errors.add(error);
            }
        }
    }

    private boolean reportError(ContentClassAsset ccAsset, String fieldPath) {
        if (ccAsset == null || ccAsset.isDisabled()) {
            return true;
        }
        ContentClassField ccField = ccAsset.getField(fieldPath);
        if (ccField == null || ccField.isDisabled()) {
            return true;
        }
        String assetPath = ccAsset.getPath();
        if (fieldPath.startsWith("/Fields/CustomFields/")) {
            String cfGroupPath = this.getCFGroupPath(assetPath, fieldPath);
            ccField = ccAsset.getField(cfGroupPath);
            if (ccField == null || ccField.isDisabled()) {
                return true;
            }
        } else {
            String[] elements = fieldPath.split("/");
            if (elements != null && elements.length > 2) {
                StringBuilder bld = new StringBuilder("/Fields");
                int i = 2;
                while (i < elements.length - 1) {
                    bld.append("/" + elements[i]);
                    String parentFieldPath = bld.toString();
                    ccField = ccAsset.getField(parentFieldPath);
                    if (ccField == null || ccField.isDisabled()) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    String getCFGroupPath(String assetPath, String cfPath) {
        String cfName = this.getCFName(cfPath);
        if (cfName == null) {
            return null;
        }
        TitleConf asset = this.spec.findAssetByPath(assetPath);
        TitleConfMetadata md = asset.getTitleConfMetadata();
        String groupId = md.customFields.getGroupIdByFieldName(cfName);
        String groupPath = "/Fields/CustomFields;" + groupId;
        return groupPath;
    }

    String getCFName(String cfPath) {
        int idx = cfPath.indexOf(CF_NAME_START);
        if (idx < 0) {
            return null;
        }
        int start = idx + CF_NAME_START.length();
        int end = cfPath.indexOf(93, start);
        if (end <= start) {
            return null;
        }
        return cfPath.substring(start, end);
    }
}

