/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.contentclass;

import com.tandbergtv.cms.portal.content.client.contentclass.model.KeyValuePair;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassAsset;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassFieldGroup;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassOption;
import java.util.List;
import java.util.Set;

public class ContentClassFactory {
    public ContentClass createContentClass(UIContentClass uicc) {
        ContentClass cc = new ContentClass();
        cc.setId(uicc.getId());
        switch (uicc.getTypeId()) {
            case 0: {
                cc.setType(ContentClass.Type.Package);
                break;
            }
            case 1: {
                cc.setType(ContentClass.Type.Series);
                break;
            }
            case 2: {
                cc.setType(ContentClass.Type.Category);
                break;
            }
            case 3: {
                cc.setType(ContentClass.Type.Offer);
                break;
            }
            default: {
                cc.setType(ContentClass.Type.Package);
            }
        }
        cc.setName(uicc.getName());
        cc.setDescription(uicc.getDescription());
        cc.setDefault(uicc.isDefault());
        switch (uicc.getSpecialUsageId()) {
            case 1: {
                cc.setSpecialUsage(ContentClass.SpecialUsage.PreRoll);
                break;
            }
            case 2: {
                cc.setSpecialUsage(ContentClass.SpecialUsage.PostRoll);
                break;
            }
        }
        cc.setMetadata(this.createContentClassMetadata(uicc.getRootAsset()));
        return cc;
    }

    private ContentClassMetadata createContentClassMetadata(UIContentClassAsset rootUIAsset) {
        if (rootUIAsset == null) {
            return null;
        }
        ContentClassMetadata metadata = new ContentClassMetadata();
        this.addAssets(metadata, rootUIAsset);
        return metadata;
    }

    protected ContentClassField createField(UIContentClassField uiField) {
        Set<String> uiKeys;
        ContentClassField field = new ContentClassField(uiField.getPath());
        String strFieldType = uiField.getFieldType().toString();
        field.setFieldType(ContentClassField.FieldType.valueOf((String)strFieldType));
        field.setDisabled(Boolean.valueOf(uiField.isDisabled()));
        field.setHideInUIOnly(Boolean.valueOf(uiField.hideInUI()));
        field.setLocked(Boolean.valueOf(uiField.isLocked()));
        field.setRequired(Boolean.valueOf(uiField.isRequired()));
        field.setMin(uiField.getMin());
        field.setMax(uiField.getMax());
        field.setIncludeInBatch(Boolean.valueOf(uiField.isIncludeInBatch()));
        field.setAutofillable(Boolean.valueOf(uiField.isAutofillable()));
        field.setAutofillProvider(uiField.getAutofillProvider());
        field.setDisplayPattern(uiField.getDisplayFormat());
        field.setDefaultValue(uiField.getValue());
        field.setAttribute(Boolean.valueOf(uiField.isAttribute()));
        field.setRequired(Boolean.valueOf(uiField.isRequired()));
        List<KeyValuePair> uiOptions = uiField.getOptions();
        if (uiOptions != null && !uiOptions.isEmpty()) {
            for (KeyValuePair kvp : uiOptions) {
                field.addOption(new ContentClassOption(kvp.getValue(), kvp.getKey()));
            }
        }
        if ((uiKeys = uiField.getFilteredOptionKeys()) != null && !uiKeys.isEmpty()) {
            field.addDisabledOptionKeys(uiKeys);
        }
        return field;
    }

    private void addContentClassFields(ContentClassAsset asset, List<UIContentClassField> uiFields) {
        if (uiFields == null || uiFields.isEmpty()) {
            return;
        }
        for (UIContentClassField uiField : uiFields) {
            if (uiField instanceof UIContentClassFieldGroup) {
                UIContentClassFieldGroup uiGroup = (UIContentClassFieldGroup)uiField;
                ContentClassField field = this.createField(uiField);
                asset.addFieldAndParents(field);
                this.addContentClassFields(asset, uiGroup.getFields());
                continue;
            }
            if (!uiField.isEnabled() && !uiField.hasNonDefaultValues()) continue;
            ContentClassField field = this.createField(uiField);
            asset.addFieldAndParents(field);
        }
    }

    private ContentClassAsset createAsset(UIContentClassAsset uiAsset) {
        ContentClassAsset asset = new ContentClassAsset(uiAsset.getPath());
        asset.setDisabled(Boolean.valueOf(uiAsset.isDisabled()));
        asset.setMin(Integer.valueOf(uiAsset.getMin()));
        asset.setMax(Integer.valueOf(uiAsset.getMax()));
        asset.setBatchMin(Integer.valueOf(uiAsset.getBatchMin()));
        asset.setBatchMax(Integer.valueOf(uiAsset.getBatchMax()));
        asset.setRequiresFile(Boolean.valueOf(uiAsset.isRequiresFile()));
        asset.setHideFileView(Boolean.valueOf(uiAsset.isHideFileView()));
        return asset;
    }

    private void addAssets(ContentClassMetadata metadata, UIContentClassAsset uiAsset) {
        ContentClassAsset asset = this.createAsset(uiAsset);
        this.addContentClassFields(asset, uiAsset.getFields());
        metadata.addAsset(asset);
        List<UIContentClassAsset> children = uiAsset.getAssets();
        if (children != null && !children.isEmpty()) {
            for (UIContentClassAsset childAsset : children) {
                this.addAssets(metadata, childAsset);
            }
        }
    }
}

