/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.contentclass;

import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassAsset;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassFieldGroup;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassPartner;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import java.util.List;
import java.util.Set;

public class ContentClassPartnerFactory {
    public ContentClassPartner createContentClassPartner(UIContentClassPartner uiccp) {
        ContentClassPartner ccp = new ContentClassPartner(uiccp.getContentClassId(), uiccp.getPartnerId());
        ccp.setMetadata(this.createContentClassMetadata(uiccp.getRootAsset()));
        return ccp;
    }

    private ContentClassMetadata createContentClassMetadata(UIContentClassAsset rootUIAsset) {
        if (rootUIAsset == null) {
            return null;
        }
        ContentClassMetadata metadata = new ContentClassMetadata();
        this.addAssets(metadata, rootUIAsset);
        return metadata;
    }

    private ContentClassField createField(UIContentClassField uiField) {
        ContentClassField field = new ContentClassField(uiField.getPath());
        field.setLocked(Boolean.valueOf(uiField.isLocked()));
        field.setDefaultValue(uiField.getValue());
        field.setAttribute(Boolean.valueOf(uiField.isAttribute()));
        Set<String> uiKeys = uiField.getFilteredOptionKeys();
        if (uiKeys != null && !uiKeys.isEmpty()) {
            field.addDisabledOptionKeys(uiKeys);
        }
        return field;
    }

    private void addContentClassFields(ContentClassAsset asset, List<UIContentClassField> uiFields) {
        if (uiFields == null || uiFields.isEmpty()) {
            return;
        }
        for (UIContentClassField uiField : uiFields) {
            if (uiField instanceof UIContentClassFieldGroup) {
                UIContentClassFieldGroup uiGroup = (UIContentClassFieldGroup)uiField;
                this.addContentClassFields(asset, uiGroup.getFields());
                continue;
            }
            if (!uiField.hasNonDefaultPartnerValues()) continue;
            ContentClassField field = this.createField(uiField);
            asset.addField(field);
        }
    }

    private ContentClassAsset createAsset(UIContentClassAsset uiAsset) {
        ContentClassAsset asset = new ContentClassAsset(uiAsset.getPath());
        return asset;
    }

    private void addAssets(ContentClassMetadata metadata, UIContentClassAsset uiAsset) {
        List<UIContentClassAsset> children;
        ContentClassAsset asset = this.createAsset(uiAsset);
        this.addContentClassFields(asset, uiAsset.getFields());
        if (!asset.isEmpty()) {
            metadata.addAsset(asset);
        }
        if ((children = uiAsset.getAssets()) != null && !children.isEmpty()) {
            for (UIContentClassAsset childAsset : children) {
                this.addAssets(metadata, childAsset);
            }
        }
    }
}

