/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.contentclass;

import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.content.client.contentclass.model.CCPValidationError;
import com.tandbergtv.cms.portal.content.client.contentclass.model.SaveStatus;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassPartner;
import com.tandbergtv.cms.portal.content.client.contentclass.service.IContentClassViewService;
import com.tandbergtv.cms.portal.content.server.ServiceLocator;
import com.tandbergtv.cms.portal.content.server.contentclass.CCPValidator;
import com.tandbergtv.cms.portal.content.server.contentclass.ContentClassFactory;
import com.tandbergtv.cms.portal.content.server.contentclass.ContentClassPartnerFactory;
import com.tandbergtv.cms.portal.content.server.contentclass.UIContentClassBuilder;
import com.tandbergtv.cms.portal.content.server.contentclass.UIContentClassFactory;
import com.tandbergtv.cms.portal.content.server.contentclass.UIContentClassPartnerBuilder;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.cms.portal.ui.title.server.specification.IUIValueOptionProvider;
import com.tandbergtv.cms.portal.ui.title.server.specification.UIAssetSpecificationBuilder;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class ContentClassViewService
implements IContentClassViewService,
NeptuneRemoteService {
    private final IAssetSpecificationManager specificationManager = ServiceLocator.getService("AssetSpecificationManager", IAssetSpecificationManager.class);
    private final IContentClassService contentClassService = ServiceLocator.getService("ContentClassService", IContentClassService.class);
    private static Logger logger = Logger.getLogger(ContentClassViewService.class);

    public String getRelativePath() {
        return "service/content/contentclass/IContentClassViewService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public List<UIContentClass> deleteContentClassesById(Collection<Long> ids) throws NeptuneException {
        try {
            this.contentClassService.deleteContentClassesById(ids);
        }
        catch (Exception ex) {
            String msg = this.getCauseMessage(ex);
            if (msg != null && msg.contains("violates foreign key constraint")) {
                msg = ids.size() > 1 ? "Unable to delete selected content classes. Other entities such as a title or a partner are associated with at least one selected content class." : "Unable to delete selected content class. Other entities such as a title or a partner are associated with this content class.";
                throw new NeptuneException(msg);
            }
            throw new NeptuneException("Unable to delete content class. " + msg);
        }
        return this.getContentClassListWithoutMetadata();
    }

    @Override
    public UIContentClass getContentClassById(long contentClassId) throws NeptuneException {
        try {
            ContentClass contentClass = this.contentClassService.getContentClassById(contentClassId);
            if (contentClass == null) {
                throw new NeptuneException("Unable to get content class with id = " + contentClassId);
            }
            ContentClass.Type ccType = contentClass.getType();
            UISpecification.Type specType = ContentClass.Type.Series == ccType ? UISpecification.Type.SERIES : UISpecification.Type.PACKAGE;
            UISpecification spec = this.specificationManager.getUISpecification(specType);
            if (spec == null) {
                throw new NeptuneException("Unable to get UI spec");
            }
            TitleConf rootTitle = spec.getRootTitleConf();
            if (rootTitle == null) {
                throw new NeptuneException("Unable to get root asset definition for default spec");
            }
            UIContentClassBuilder builder = new UIContentClassBuilder(spec, contentClass);
            UIContentClass uiContentClass = builder.build();
            boolean isAssociatedWithTitle = this.contentClassService.contentClassAssociatedWithTitle(contentClassId);
            uiContentClass.setAssociatedWithTitle(isAssociatedWithTitle);
            return uiContentClass;
        }
        catch (ContentClassPersistenceException ex) {
            throw new NeptuneException("Unable to get content class with id " + contentClassId + ". " + this.getCauseMessage(ex));
        }
    }

    @Override
    public List<UIContentClass> getContentClassListWithoutMetadata() throws NeptuneException {
        List list;
        block4: {
            list = this.contentClassService.getAllContentClassesWithoutMetadata();
            if (list != null && !list.isEmpty()) break block4;
            return null;
        }
        try {
            ArrayList<UIContentClass> uiList = new ArrayList<UIContentClass>();
            for (ContentClass cc : list) {
                UIContentClass uiCc = UIContentClassFactory.createUIContentClassWithoutMetadata(cc);
                uiList.add(uiCc);
            }
            return uiList;
        }
        catch (Exception ex) {
            throw new NeptuneException("Unable to get a list of content classes. " + this.getCauseMessage(ex));
        }
    }

    @Override
    public UIContentClass getNewContentClass() throws NeptuneException {
        UISpecification spec = this.specificationManager.getUISpecification(UISpecification.Type.PACKAGE);
        if (spec == null) {
            throw new NeptuneException("Unable to get UI spec");
        }
        TitleConf rootTitle = spec.getRootTitleConf();
        if (rootTitle == null) {
            throw new NeptuneException("Unable to get root asset definition for default spec");
        }
        UIContentClassBuilder builder = new UIContentClassBuilder(spec);
        UIContentClass contentClass = builder.build();
        return contentClass;
    }

    private long findContentClassIdByName(String name) {
        try {
            return this.contentClassService.getContentClassIdByName(name);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    @Override
    public long saveContentClass(UIContentClass uiContentClass) throws NeptuneException {
        ContentClassFactory factory = new ContentClassFactory();
        ContentClass cc = factory.createContentClass(uiContentClass);
        try {
            long existingCCId = this.findContentClassIdByName(cc.getName());
            if (existingCCId != 0L && existingCCId != cc.getId()) {
                throw new NeptuneException("Content class with this name already exists.");
            }
            this.contentClassService.saveContentClass(cc);
            return cc.getId();
        }
        catch (Exception ex) {
            String msg = this.getCauseMessage(ex);
            throw new NeptuneException("Unable to save content class. " + msg);
        }
    }

    @Override
    public SaveStatus saveAndValidateContentClass(UIContentClass uiContentClass) throws NeptuneException {
        ContentClassFactory factory = new ContentClassFactory();
        ContentClass cc = factory.createContentClass(uiContentClass);
        try {
            long startTime = System.currentTimeMillis();
            SaveStatus status = new SaveStatus();
            long endTime = System.currentTimeMillis();
            logger.debug((Object)("time to saveStatus - time:" + (endTime - startTime) + ";ms"));
            startTime = System.currentTimeMillis();
            this.validatePartners(cc, status.errors);
            endTime = System.currentTimeMillis();
            logger.debug((Object)("time to validatePartner - time:" + (endTime - startTime) + ";ms"));
            if (status.errors == null || status.errors.isEmpty()) {
                long existingCCId = this.findContentClassIdByName(cc.getName());
                if (existingCCId != 0L && existingCCId != cc.getId()) {
                    throw new NeptuneException("Content class with this name already exists.");
                }
                startTime = System.currentTimeMillis();
                this.contentClassService.saveContentClass(cc);
                endTime = System.currentTimeMillis();
                logger.debug((Object)("time to saveContentClass - time:" + (endTime - startTime) + ";ms"));
                status.contentClassId = cc.getId();
            }
            return status;
        }
        catch (Exception ex) {
            String msg = this.getCauseMessage(ex);
            throw new NeptuneException("Unable to save content class. " + msg);
        }
    }

    private void validatePartners(ContentClass cc, List<CCPValidationError> errors) throws Exception {
        long startTime = System.currentTimeMillis();
        if (errors == null) {
            return;
        }
        ContentClassMetadata ccMeta = cc.getMetadata();
        if (ccMeta == null) {
            return;
        }
        long ccId = cc.getId();
        List list = this.contentClassService.getContentClassPartnersByContentClassId(ccId, false, true);
        if (list == null || list.isEmpty()) {
            return;
        }
        long endTime = System.currentTimeMillis();
        logger.debug((Object)("time to getContentClassPartnersByContentClassId - time:" + (endTime - startTime) + ";ms"));
        startTime = System.currentTimeMillis();
        UISpecification spec = null;
        spec = cc.getType() == ContentClass.Type.Series ? this.specificationManager.getUISpecification(UISpecification.Type.SERIES) : this.specificationManager.getUISpecification(UISpecification.Type.PACKAGE);
        endTime = System.currentTimeMillis();
        logger.debug((Object)("time to getUISpecification - time:" + (endTime - startTime) + ";ms"));
        startTime = System.currentTimeMillis();
        if (spec == null) {
            throw new NeptuneException("Unable to get UI spec");
        }
        CCPValidator validator = new CCPValidator(cc, spec);
        endTime = System.currentTimeMillis();
        logger.debug((Object)("time to CCPValidator - time:" + (endTime - startTime) + ";ms"));
        startTime = System.currentTimeMillis();
        for (ContentClassPartner ccp : list) {
            long loopStartTime = System.currentTimeMillis();
            ContentClassPartner partner = this.contentClassService.getContentClassPartner(ccId, ccp.getPartnerId(), false);
            long loopEndTime = System.currentTimeMillis();
            logger.debug((Object)("time to getContentClassPartner - time:" + (loopEndTime - loopStartTime) + ";ms"));
            loopStartTime = System.currentTimeMillis();
            validator.validate(partner, errors);
            loopEndTime = System.currentTimeMillis();
            logger.debug((Object)("time to validator.validate - time:" + (loopEndTime - loopStartTime) + ";ms"));
        }
        endTime = System.currentTimeMillis();
        logger.debug((Object)("time to validateContentClassPartner - time:" + (endTime - startTime) + ";ms"));
    }

    @Override
    public UIContentClassPartner getContentClassPartner(long contentClassId, long partnerId) throws NeptuneException {
        try {
            ContentClass contentClass = this.contentClassService.getContentClassById(contentClassId);
            if (contentClass == null) {
                throw new NeptuneException("Unable to get content class with id = " + contentClassId);
            }
            ContentClassPartner contentClassPartner = this.contentClassService.getContentClassPartner(contentClassId, partnerId, true);
            if (contentClassPartner == null) {
                throw new NeptuneException("Unable to get content class partner with id = " + partnerId);
            }
            ContentClass.Type ccType = contentClass.getType();
            UISpecification.Type specType = ContentClass.Type.Series == ccType ? UISpecification.Type.SERIES : UISpecification.Type.PACKAGE;
            UISpecification spec = this.specificationManager.getUISpecification(specType);
            if (spec == null) {
                throw new NeptuneException("Unable to get default spec");
            }
            TitleConf rootTitle = spec.getRootTitleConf();
            if (rootTitle == null) {
                throw new NeptuneException("Unable to get root asset definition for default spec");
            }
            UIContentClassPartnerBuilder builder = new UIContentClassPartnerBuilder(rootTitle, contentClass, contentClassPartner);
            UIContentClassPartner uiContentClassPartner = builder.build();
            return uiContentClassPartner;
        }
        catch (ContentClassPersistenceException ex) {
            throw new NeptuneException("Unable to get content class partner. " + this.getCauseMessage(ex));
        }
    }

    @Override
    public void saveContentClassPartner(UIContentClassPartner uiccp) throws NeptuneException {
        ContentClassPartnerFactory factory = new ContentClassPartnerFactory();
        ContentClassPartner ccp = factory.createContentClassPartner(uiccp);
        try {
            this.contentClassService.saveContentClassPartner(ccp);
        }
        catch (Exception ex) {
            throw new NeptuneException("Unable to save content class partner. " + this.getCauseMessage(ex));
        }
    }

    @Override
    public void deleteContentClassPartner(UIContentClassPartner uiccp) throws NeptuneException {
        ContentClassPartnerFactory factory = new ContentClassPartnerFactory();
        ContentClassPartner ccp = factory.createContentClassPartner(uiccp);
        try {
            this.contentClassService.deleteContentClassPartner(ccp);
        }
        catch (Exception ex) {
            throw new NeptuneException("Unable to delete content class partner. " + this.getCauseMessage(ex));
        }
    }

    @Override
    public UIAssetSpecification getContentClassSpec(long contentClassId) throws NeptuneException {
        if (contentClassId == 0L) {
            throw new NeptuneException("Invalid content class id: 0");
        }
        try {
            ContentClass cc = this.contentClassService.getContentClassById(contentClassId);
            if (cc == null) {
                throw new NeptuneException("Invalid content class id: " + contentClassId);
            }
            ContentClass.Type ccType = cc.getType();
            UISpecification.Type specType = ContentClass.Type.Series == ccType ? UISpecification.Type.SERIES : UISpecification.Type.PACKAGE;
            UISpecification spec = this.specificationManager.getUISpecification(specType);
            UIAssetSpecificationBuilder builder = new UIAssetSpecificationBuilder();
            UIAssetSpecification uiSpec = builder.build(spec, cc.getMetadata());
            uiSpec.setContentClassName(cc.getName());
            uiSpec.setContentClassTypeId(cc.getType().ordinal());
            uiSpec.setContentClassId(contentClassId);
            return uiSpec;
        }
        catch (ContentClassPersistenceException ex) {
            throw new NeptuneException(this.getCauseMessage(ex));
        }
    }

    @Override
    public UIAssetSpecification getContentClassSpec(long contentClassId, long partnerId) throws NeptuneException {
        if (contentClassId == 0L) {
            throw new NeptuneException("Invalid content class id: 0");
        }
        try {
            ContentClassPartner contentClassPartner = this.contentClassService.getMergedContentClassPartnerMetadataForView(contentClassId, partnerId);
            ContentClassMetadata ccMetadata = contentClassPartner.getMetadata();
            ContentClass.Type ccType = contentClassPartner.getContentClassType();
            UISpecification.Type specType = ContentClass.Type.Series == ccType ? UISpecification.Type.SERIES : UISpecification.Type.PACKAGE;
            UISpecification spec = this.specificationManager.getUISpecification(specType);
            UIAssetSpecificationBuilder builder = new UIAssetSpecificationBuilder();
            UIAssetSpecification uiSpec = builder.build(spec, ccMetadata);
            uiSpec.setContentClassName(contentClassPartner.getContentClassName());
            uiSpec.setContentClassTypeId(contentClassPartner.getContentClassType().ordinal());
            uiSpec.setContentClassId(contentClassId);
            uiSpec.setPartnerId(partnerId);
            uiSpec.setProviderId(contentClassPartner.getProviderId());
            return uiSpec;
        }
        catch (ContentClassPersistenceException ex) {
            throw new NeptuneException(this.getCauseMessage(ex));
        }
    }

    /*
     * Unable to fully structure code
     */
    private String getCauseMessage(Throwable t) {
        if (t != null) ** GOTO lbl4
        return "";
lbl-1000:
        // 1 sources

        {
            t = t.getCause();
lbl4:
            // 2 sources

            ** while (t.getCause() != null)
        }
lbl5:
        // 1 sources

        return t.getMessage();
    }

    private List<UIValueOption> loadOptions(String providerClass) {
        Object providerInstance = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = classLoader.loadClass(providerClass);
            providerInstance = clazz.newInstance();
        }
        catch (Exception e) {
            String msg = "Failed to load option provider class: " + providerClass;
            throw new RuntimeException(msg, e);
        }
        if (!(providerInstance instanceof IUIValueOptionProvider)) {
            String className = IUIValueOptionProvider.class.getName();
            String msg = "The option provider class: " + providerClass + " does not implement interface: " + className;
            throw new RuntimeException(msg);
        }
        IUIValueOptionProvider provider = providerInstance;
        return provider.getOptions();
    }
}

