/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.server.contentclass;

import com.tandbergtv.cms.portal.content.client.contentclass.model.KeyValuePair;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassAsset;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassFieldGroup;
import com.tandbergtv.cms.portal.content.server.contentclass.UIContentClassFactory;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.watchpoint.pmm.title.conf.AutofillProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomField;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.StringVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConfMetadata;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import java.util.List;

public class UIContentClassBuilder {
    private TitleConf rootConf;
    private ContentClass cc;
    private List<AutofillProvider> autofillProviders;
    private boolean isNewContentClass = true;

    public UIContentClassBuilder(UISpecification spec) {
        if (spec != null) {
            this.rootConf = spec.getRootTitleConf();
        }
        this.autofillProviders = spec.getAutofillProviders();
    }

    public UIContentClassBuilder(UISpecification spec, ContentClass cc) {
        this(spec);
        this.cc = cc;
        this.isNewContentClass = false;
    }

    public UIContentClass build() {
        UIContentClass uicc = this.cc == null ? new UIContentClass() : UIContentClassFactory.createUIContentClassWithoutMetadata(this.cc);
        uicc.setRootAsset(this.createRootAsset(this.rootConf, this.cc));
        uicc.setAutofillProviders(UIContentClassFactory.createAutofillProviders(this.autofillProviders));
        return uicc;
    }

    private UIContentClassAsset createRootAsset(TitleConf conf, ContentClass cc) {
        String assetPath = conf.getPath();
        ContentClassMetadata ccMeta = null;
        ContentClassAsset ccAsset = null;
        if (cc != null && cc.getMetadata() != null) {
            ccMeta = cc.getMetadata();
            ccAsset = ccMeta.getAsset(assetPath);
        }
        UIContentClassAsset uiAsset = UIContentClassFactory.createUIAsset(assetPath, ccAsset);
        uiAsset.setDisabled(false);
        uiAsset.setDisplayName(conf.getAlias());
        uiAsset.setMaxAllowed(conf.getMaxOccurs());
        uiAsset.setFields(this.createFields(conf, ccAsset));
        if (conf.hasChildren()) {
            this.addChildAssets(conf.getChildren(), uiAsset, ccMeta);
        }
        return uiAsset;
    }

    private void addChildAssets(List<TitleConf> list, UIContentClassAsset uiAsset, ContentClassMetadata ccMeta) {
        if (list != null) {
            for (TitleConf childDef : list) {
                String displayName = childDef.getAlias();
                String childPath = childDef.getPath();
                ContentClassAsset ccAsset = null;
                if (ccMeta != null) {
                    ccAsset = ccMeta.getAsset(childPath);
                }
                UIContentClassAsset childAsset = UIContentClassFactory.createUIAsset(childPath, ccAsset);
                childAsset.setDisplayName(displayName);
                childAsset.setMaxAllowed(childDef.getMaxOccurs());
                childAsset.setFields(this.createFields(childDef, ccAsset));
                uiAsset.addAsset(childAsset);
                if (!childDef.hasChildren()) continue;
                this.addChildAssets(childDef.getChildren(), childAsset, ccMeta);
            }
        }
    }

    private List<UIContentClassField> createFields(TitleConf tc, ContentClassAsset ccAsset) {
        TitleConfMetadata md = tc.getTitleConfMetadata();
        if (md.coreFields == null || md.coreFields.isEmpty()) {
            return null;
        }
        UIContentClassFieldGroup group = new UIContentClassFieldGroup();
        this.processChildFields(group, md.coreFields, ccAsset);
        this.addCustomFields(group, md.customFields.getGroups(), ccAsset);
        return group.getFields();
    }

    private void addCustomFields(UIContentClassFieldGroup group, List<CustomFieldGroup> cfGroups, ContentClassAsset ccAsset) {
        if (cfGroups == null || cfGroups.isEmpty()) {
            return;
        }
        for (CustomFieldGroup cfGroup : cfGroups) {
            if (cfGroups.isEmpty()) continue;
            UIContentClassFieldGroup uiGroup = this.createCustomFieldGroup(cfGroup, ccAsset);
            for (CustomField cf : cfGroup.fields) {
                UIContentClassField uiField = this.createCustomField(cf, ccAsset);
                uiGroup.getFields().add(uiField);
            }
            if (uiGroup.isEmpty()) continue;
            group.getFields().add(uiGroup);
        }
    }

    private UIContentClassFieldGroup createCustomFieldGroup(CustomFieldGroup cfGroup, ContentClassAsset ccAsset) {
        String xpath = "/Fields/CustomFields;" + cfGroup.groupId;
        UIContentClassFieldGroup uiGroup = new UIContentClassFieldGroup(xpath);
        uiGroup.setDisplayName(cfGroup.displayName);
        ContentClassField ccField = null;
        if (ccAsset != null) {
            ccField = ccAsset.getField(xpath);
        }
        if (ccField != null) {
            uiGroup.setDisabled(ccField.isDisabled());
            uiGroup.setMin(ccField.getMin());
            uiGroup.setMax(ccField.getMax());
        }
        return uiGroup;
    }

    private UIContentClassField createCustomField(CustomField cf, ContentClassAsset ccAsset) {
        if (cf == null) {
            return null;
        }
        String xpath = "/Fields/CustomFields/CustomField[@name=" + cf.name + "]/@value";
        UIContentClassField uiField = new UIContentClassField(xpath);
        uiField.setDataType(UIContentClassFactory.getDataType(cf));
        uiField.setDisplayName(cf.displayName);
        uiField.setAttribute(true);
        uiField.setMultiValue(cf.multiValue);
        uiField.setDisabled(true);
        if (cf.multiLine) {
            uiField.setFieldType(UIContentClassField.FieldType.TEXT_AREA);
        }
        ContentClassField ccField = null;
        if (ccAsset != null) {
            ccField = ccAsset.getField(xpath);
        }
        List<KeyValuePair> suggestedValues = UIContentClassFactory.createSuggestedValues(cf, ccField);
        uiField.setOptions(suggestedValues);
        uiField.setCanAddOptions(true);
        if (cf.dropDown) {
            if (cf.anyValueAllowed) {
                uiField.setFieldType(UIContentClassField.FieldType.COMBO_BOX);
            } else {
                uiField.setFieldType(UIContentClassField.FieldType.DROP_DOWN);
            }
        }
        if (ccField != null) {
            if (ccField.getFieldType() != null) {
                uiField.setFieldType(ccField.getFieldType().toString());
            }
            uiField.setValue(ccField.getDefaultValue());
            uiField.setLocked(ccField.isLocked());
            uiField.setDisabled(ccField.isDisabled());
            uiField.setHideInUI(ccField.hideInUIOnly());
            uiField.setRequired(ccField.isRequired());
            uiField.setFilteredOptionKeys(ccField.getDisabledOptionKeys());
            uiField.setMin(ccField.getMin());
            uiField.setMax(ccField.getMax());
            uiField.setIncludeInBatch(ccField.getIncludeInBatch());
            uiField.setAutofillable(ccField.isAutofillable());
            uiField.setAutofillProvider(ccField.getAutofillProvider());
            uiField.setDisplayFormat(ccField.getDisplayPattern());
        }
        return uiField;
    }

    private void processChildFields(UIContentClassFieldGroup group, List<Variable> children, ContentClassAsset ccAsset) {
        if (children == null || children.isEmpty()) {
            return;
        }
        for (Variable childVar : children) {
            if ("CustomFields".equalsIgnoreCase(childVar.getName())) continue;
            if (childVar instanceof ComplexVariable) {
                ComplexVariable complexVar = (ComplexVariable)childVar;
                if (complexVar.isShowCollapsed() && !complexVar.isMultiValue()) {
                    this.processChildFields(group, complexVar.getChildren(), ccAsset);
                    continue;
                }
                UIContentClassFieldGroup uiGroup = this.createFieldGroup((ComplexVariable)childVar, ccAsset, group.isReadOnly());
                if (uiGroup == null) continue;
                group.getFields().add(uiGroup);
                continue;
            }
            UIContentClassField uiField = this.createSimpleField((SimpleVariable)childVar, ccAsset, group.isReadOnly());
            if (uiField == null) continue;
            group.getFields().add(uiField);
        }
    }

    protected UIContentClassField createSimpleField(SimpleVariable var, ContentClassAsset ccAsset, boolean readOnly) {
        boolean multiline;
        if (var == null) {
            return null;
        }
        String path = var.getXPath();
        UIContentClassField uiField = new UIContentClassField(path);
        uiField.setDisplayName(var.getDisplayName());
        uiField.setDataType(UIContentClassFactory.getDataType((Variable)var));
        uiField.setMultiValue(var.isMultiValue());
        uiField.setAttribute(var.isAttribute());
        uiField.setDisabled(true);
        if (var instanceof StringVariable && (multiline = ((StringVariable)var).isLongFormat())) {
            uiField.setFieldType(UIContentClassField.FieldType.TEXT_AREA);
        }
        ContentClassField ccField = null;
        if (ccAsset != null) {
            ccField = ccAsset.getField(path);
        }
        List<KeyValuePair> suggestedValues = null;
        suggestedValues = this.isNewContentClass ? UIContentClassFactory.createSuggestedValuesNew(var) : UIContentClassFactory.createSuggestedValues(var, ccField);
        uiField.setOptions(suggestedValues);
        uiField.setCanAddOptions(var.getOptionProvider() == null);
        if (var.hasOptions()) {
            if (var.isAnyValueAllowed()) {
                uiField.setFieldType(UIContentClassField.FieldType.COMBO_BOX);
            } else {
                uiField.setFieldType(UIContentClassField.FieldType.DROP_DOWN);
            }
        }
        if (ccField != null) {
            if (ccField.getFieldType() != null) {
                uiField.setFieldType(ccField.getFieldType().toString());
            }
            uiField.setValue(ccField.getDefaultValue());
            uiField.setLocked(ccField.isLocked());
            uiField.setDisabled(ccField.isDisabled());
            uiField.setHideInUI(ccField.hideInUIOnly());
            uiField.setRequired(ccField.isRequired());
            uiField.setFilteredOptionKeys(ccField.getDisabledOptionKeys());
            uiField.setMin(ccField.getMin());
            uiField.setMax(ccField.getMax());
            uiField.setIncludeInBatch(ccField.getIncludeInBatch());
            uiField.setAutofillable(ccField.isAutofillable());
            uiField.setAutofillProvider(ccField.getAutofillProvider());
            uiField.setDisplayFormat(ccField.getDisplayPattern());
        }
        uiField.setReadOnly(readOnly);
        return uiField;
    }

    private UIContentClassFieldGroup createFieldGroup(ComplexVariable var, ContentClassAsset asset, boolean readOnly) {
        ContentClassField ccField;
        if (var == null) {
            return null;
        }
        UIContentClassFieldGroup group = new UIContentClassFieldGroup(var.getXPath());
        group.setDisplayName(var.getDisplayName());
        group.setMultiValue(var.isMultiValue());
        if (asset != null && (ccField = asset.getField(var.getXPath())) != null) {
            group.setDisabled(ccField.isDisabled());
            group.setMin(ccField.getMin());
            group.setMax(ccField.getMax());
        }
        group.setReadOnly(readOnly);
        this.processChildFields(group, var.getChildren(), asset);
        return group;
    }
}

